/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.codegen.CeylonFileObject;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.DiagnosticSource;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.SourceLanguage;

public class CeylonLog
extends Log {
    private int numCeylonAnalysisErrors;
    private int numCeylonCodegenException;
    private int numCeylonCodegenErroneous;
    private int numCeylonCodegenGarbage;
    private int numNonCeylonErrors;
    private SourceLanguage sourceLanguage;
    private StatusPrinter sp;

    public static Log instance(Context context) {
        Log instance = (Log)context.get(logKey);
        if (instance == null) {
            instance = new CeylonLog(context);
        }
        return instance;
    }

    public static void preRegister(Context context) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make(Context c) {
                return new CeylonLog(c);
            }
        });
    }

    protected CeylonLog(Context context) {
        super(context);
        this.sourceLanguage = SourceLanguage.instance(context);
        Options options = Options.instance(context);
        boolean isProgressPrinted = options.get(Option.CEYLONPROGRESS) != null && StatusPrinter.canPrint();
        this.sp = isProgressPrinted ? LanguageCompiler.getStatusPrinterInstance(context) : null;
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        JavaFileObject file;
        String messageKey = diagnostic.getCode();
        if (messageKey != null) {
            if (messageKey.startsWith("compiler.err.ceylon.codegen.exception")) {
                ++this.numCeylonCodegenException;
            } else if (messageKey.startsWith("compiler.err.ceylon.codegen.erroneous")) {
                ++this.numCeylonCodegenErroneous;
            } else if (messageKey.startsWith("compiler.err.ceylon")) {
                ++this.numCeylonAnalysisErrors;
            } else if (this.sourceLanguage.isCeylon()) {
                ++this.numCeylonCodegenGarbage;
            } else {
                ++this.numNonCeylonErrors;
            }
        } else if (this.sourceLanguage.isCeylon()) {
            ++this.numCeylonCodegenGarbage;
        } else {
            ++this.numNonCeylonErrors;
        }
        DiagnosticSource source = diagnostic.getDiagnosticSource();
        if (source != null && (file = source.getFile()) instanceof CeylonFileObject && diagnostic.getType() == JCDiagnostic.DiagnosticType.ERROR) {
            ((CeylonFileObject)file).addError(diagnostic);
        }
        super.report(diagnostic);
    }

    @Override
    public void note(JavaFileObject file, String key, Object ... args) {
    }

    @Override
    public void mandatoryNote(JavaFileObject file, String key, Object ... args) {
    }

    @Override
    public void warning(String key, Object ... args) {
        if ("big.major.version".equals(key)) {
            return;
        }
        super.warning(key, args);
    }

    public int getCeylonCodegenBugCount() {
        return this.numCeylonCodegenException + this.numCeylonCodegenErroneous;
    }

    public int getCeylonCodegenExceptionCount() {
        return this.numCeylonCodegenException;
    }

    public int getCeylonCodegenGarbageTreeCount() {
        return this.numCeylonCodegenGarbage;
    }

    public int getCeylonCodegenErroneousCount() {
        return this.numCeylonCodegenErroneous;
    }

    public int getNonCeylonErrorCount() {
        return this.numNonCeylonErrors;
    }

    public int getCeylonErrorCount() {
        return this.numCeylonAnalysisErrors;
    }

    @Override
    protected void writeDiagnostic(JCDiagnostic diag) {
        if (this.sp != null) {
            this.sp.clearLine();
        }
        super.writeDiagnostic(diag);
    }
}

