/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.wrapping;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Byte;
import ceylon.language.Character;
import ceylon.language.Collection;
import ceylon.language.Entry;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Set;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.wrapping.WrappedCeylonList;
import com.redhat.ceylon.compiler.java.wrapping.WrappedCeylonMap;
import com.redhat.ceylon.compiler.java.wrapping.WrappedCeylonSet;
import com.redhat.ceylon.compiler.java.wrapping.WrappedJavaList;
import com.redhat.ceylon.compiler.java.wrapping.WrappedJavaMap;
import com.redhat.ceylon.compiler.java.wrapping.WrappedJavaSet;
import com.redhat.ceylon.compiler.java.wrapping.Wrapping;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;

public class Wrappings {
    public static final Identity DEFINITE_IDENTITY = new Identity(false);
    public static final Identity MAYBE_IDENTITY = new Identity(true);
    public static final ToCeylonInteger TO_CEYLON_INTEGER = new ToCeylonInteger(false);
    public static final ToCeylonInteger TO_CEYLON_INTEGER_OR_NULL = new ToCeylonInteger(true);
    public static final ToCeylonFloat TO_CEYLON_FLOAT = new ToCeylonFloat(false);
    public static final ToCeylonFloat TO_CEYLON_FLOAT_OR_NULL = new ToCeylonFloat(true);
    public static final ToCeylonByte TO_CEYLON_BYTE = new ToCeylonByte(false);
    public static final ToCeylonByte TO_CEYLON_BYTE_OR_NULL = new ToCeylonByte(false);
    public static final ToCeylonBoolean TO_CEYLON_BOOLEAN = new ToCeylonBoolean(false);
    public static final ToCeylonBoolean TO_CEYLON_BOOLEAN_OR_NULL = new ToCeylonBoolean(true);
    public static final ToCeylonCharacter TO_CEYLON_CHARACTER = new ToCeylonCharacter(false);
    public static final ToCeylonCharacter TO_CEYLON_CHARACTER_OR_NULL = new ToCeylonCharacter(true);
    public static final ToCeylonString TO_CEYLON_STRING = new ToCeylonString(false);
    public static final ToCeylonString TO_CEYLON_STRING_OR_NULL = new ToCeylonString(true);

    static void checkNull(Object o, String msg) {
        if (o == null) {
            throw new AssertionError("null value present in wrapping" + (msg != null ? " " + msg : ""));
        }
    }

    static <Java, Ceylon> Wrapping<Java, Ceylon> elementMapping(TypeDescriptor $reified$Element) {
        TypeDescriptor.Class classDescriptor;
        boolean allowNull = false;
        if ($reified$Element.containsNull()) {
            allowNull = true;
            if ($reified$Element instanceof TypeDescriptor.Union && ((TypeDescriptor.Union)$reified$Element).getMembers().length == 2) {
                TypeDescriptor.Union union = (TypeDescriptor.Union)$reified$Element;
                if (union.getMembers()[0].containsNull()) {
                    $reified$Element = union.getMembers()[1];
                } else if (union.getMembers()[1].containsNull()) {
                    $reified$Element = union.getMembers()[0];
                }
            }
        }
        Wrapping<Long, Integer> elementWrapping = $reified$Element == Integer.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_INTEGER_OR_NULL : TO_CEYLON_INTEGER) : ($reified$Element == Float.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_FLOAT_OR_NULL : TO_CEYLON_FLOAT) : ($reified$Element == Byte.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_BYTE_OR_NULL : TO_CEYLON_BYTE) : ($reified$Element == Boolean.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_BOOLEAN_OR_NULL : TO_CEYLON_BOOLEAN) : ($reified$Element == Character.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_CHARACTER_OR_NULL : TO_CEYLON_CHARACTER) : ($reified$Element == ceylon.language.String.$TypeDescriptor$ ? (allowNull ? TO_CEYLON_STRING_OR_NULL : TO_CEYLON_STRING) : ($reified$Element instanceof TypeDescriptor.Class ? ((classDescriptor = (TypeDescriptor.Class)$reified$Element).getKlass() == ceylon.language.List.class ? Wrappings.toCeylonList(classDescriptor.getTypeArgument(0), allowNull) : (classDescriptor.getKlass() == Set.class ? Wrappings.toCeylonSet(classDescriptor.getTypeArgument(0), allowNull) : (classDescriptor.getKlass() == Map.class ? Wrappings.toCeylonMap(classDescriptor.getTypeArgument(0), classDescriptor.getTypeArgument(1), allowNull) : (allowNull ? MAYBE_IDENTITY : DEFINITE_IDENTITY)))) : (allowNull ? MAYBE_IDENTITY : DEFINITE_IDENTITY)))))));
        return elementWrapping;
    }

    static <JavaKey, JavaItem, CeylonKey, CeylonItem> Wrapping<Map.Entry<JavaKey, JavaItem>, Entry<CeylonKey, CeylonItem>> toCeylonEntry(final TypeDescriptor $reified$Key, final TypeDescriptor $reified$Item, final Wrapping<JavaKey, CeylonKey> keyWrapping, final Wrapping<JavaItem, CeylonItem> itemWrapping) {
        class ToCeylonEntry
        implements Wrapping<Map.Entry<JavaKey, JavaItem>, Entry<CeylonKey, CeylonItem>> {
            private static final long serialVersionUID = -8985242707013915308L;
            private final FromCeylonEntry<CeylonKey, CeylonItem, JavaKey, JavaItem> from;

            public ToCeylonEntry() {
                this.from = new FromCeylonEntry(this, keyWrapping.inverted(), itemWrapping.inverted());
            }

            @Override
            public Entry<CeylonKey, CeylonItem> wrap(Map.Entry<JavaKey, JavaItem> from) {
                return new Entry($reified$Key, $reified$Item, keyWrapping.wrap(from.getKey()), itemWrapping.wrap(from.getValue()));
            }

            @Override
            public Wrapping<Entry<CeylonKey, CeylonItem>, Map.Entry<JavaKey, JavaItem>> inverted() {
                return this.from;
            }
        }
        return new ToCeylonEntry();
    }

    public static <Java, Ceylon> Wrapping<List<Java>, ceylon.language.List<Ceylon>> toCeylonList(TypeDescriptor $reified$Element, boolean allowNull) {
        Wrapping<Java, Ceylon> elementWrapping = Wrappings.elementMapping($reified$Element);
        return new ToCeylonList<Java, Ceylon>($reified$Element, elementWrapping, allowNull);
    }

    public static <Java, Ceylon> Wrapping<java.util.Set<Java>, Set<Ceylon>> toCeylonSet(TypeDescriptor $reified$Element, boolean allowNull) {
        Wrapping<Java, Ceylon> elementWrapping = Wrappings.elementMapping($reified$Element);
        return new ToCeylonSet<Java, Ceylon>($reified$Element, elementWrapping, allowNull);
    }

    public static <JavaKey, JavaItem, CeylonKey, CeylonItem> Wrapping<java.util.Map<JavaKey, JavaItem>, Map<CeylonKey, CeylonItem>> toCeylonMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, boolean allowNull) {
        Wrapping keyWrapping = Wrappings.elementMapping($reified$Key);
        Wrapping itemWrapping = Wrappings.elementMapping($reified$Item.containsNull() ? $reified$Item : TypeDescriptor.union($reified$Item, Null.$TypeDescriptor$));
        return new ToCeylonMap($reified$Key, $reified$Item, keyWrapping, itemWrapping, allowNull);
    }

    static class FromCeylonMap<CeylonKey, CeylonItem, JavaKey, JavaItem>
    implements Wrapping<Map<CeylonKey, CeylonItem>, java.util.Map<JavaKey, JavaItem>> {
        private static final long serialVersionUID = -4156672676280526053L;
        private final TypeDescriptor $reified$Key;
        private final TypeDescriptor $reified$Item;
        private final ToCeylonMap<JavaKey, JavaItem, CeylonKey, CeylonItem> to;
        private final Wrapping<CeylonKey, JavaKey> keyWrapping;
        private final Wrapping<CeylonItem, JavaItem> itemWrapping;
        private final boolean allowNull;

        public FromCeylonMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, ToCeylonMap<JavaKey, JavaItem, CeylonKey, CeylonItem> to, Wrapping<CeylonKey, JavaKey> keyWrapping, Wrapping<CeylonItem, JavaItem> itemWrapping, boolean allowNull) {
            this.$reified$Key = $reified$Key;
            this.$reified$Item = $reified$Item;
            this.to = to;
            this.keyWrapping = keyWrapping;
            this.itemWrapping = itemWrapping;
            this.allowNull = allowNull;
        }

        @Override
        public java.util.Map<JavaKey, JavaItem> wrap(Map<CeylonKey, CeylonItem> from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Map into java.util.Map");
                }
                return null;
            }
            if (from instanceof WrappedJavaMap) {
                return ((WrappedJavaMap)from).unwrap();
            }
            return new WrappedCeylonMap<CeylonKey, CeylonItem, JavaKey, JavaItem>(this.$reified$Key, this.$reified$Item, from, this.keyWrapping, this.itemWrapping);
        }

        @Override
        public Wrapping<java.util.Map<JavaKey, JavaItem>, Map<CeylonKey, CeylonItem>> inverted() {
            return this.to;
        }
    }

    static class ToCeylonMap<JavaKey, JavaItem, CeylonKey, CeylonItem>
    implements Wrapping<java.util.Map<JavaKey, JavaItem>, Map<CeylonKey, CeylonItem>> {
        private static final long serialVersionUID = -1840889262296370101L;
        private final FromCeylonMap<CeylonKey, CeylonItem, JavaKey, JavaItem> from;
        private final TypeDescriptor $reified$Key;
        private final TypeDescriptor $reified$Item;
        private final Wrapping<JavaKey, CeylonKey> keyWrapping;
        private final Wrapping<JavaItem, CeylonItem> itemWrapping;
        private boolean allowNull;

        public ToCeylonMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Wrapping<JavaKey, CeylonKey> keyWrapping, Wrapping<JavaItem, CeylonItem> itemWrapping, boolean allowNull) {
            this.$reified$Key = $reified$Key;
            this.$reified$Item = $reified$Item;
            this.keyWrapping = keyWrapping;
            this.itemWrapping = itemWrapping;
            this.allowNull = allowNull;
            this.from = new FromCeylonMap<CeylonKey, CeylonItem, JavaKey, JavaItem>($reified$Key, $reified$Item, this, keyWrapping.inverted(), itemWrapping.inverted(), allowNull);
        }

        @Override
        public Map<CeylonKey, CeylonItem> wrap(java.util.Map<JavaKey, JavaItem> from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.util.Map into ceylon.language.Map");
                }
                return null;
            }
            if (from instanceof WrappedCeylonMap) {
                return ((WrappedCeylonMap)from).unwrap();
            }
            return new WrappedJavaMap<JavaKey, JavaItem, CeylonKey, CeylonItem>(this.$reified$Key, this.$reified$Item, from, this.keyWrapping, this.itemWrapping);
        }

        @Override
        public Wrapping<Map<CeylonKey, CeylonItem>, java.util.Map<JavaKey, JavaItem>> inverted() {
            return this.from;
        }
    }

    static class FromCeylonSet<Ceylon, Java>
    implements Wrapping<Set<Ceylon>, java.util.Set<Java>> {
        private static final long serialVersionUID = -5269048676830359439L;
        private final ToCeylonSet<Java, Ceylon> to;
        private final Wrapping<Ceylon, Java> elementWrapping;
        private final boolean allowNull;

        public FromCeylonSet(ToCeylonSet<Java, Ceylon> to, Wrapping<Ceylon, Java> elementWrapping, boolean allowNull) {
            this.to = to;
            this.elementWrapping = elementWrapping;
            this.allowNull = allowNull;
        }

        @Override
        public java.util.Set<Java> wrap(Set<Ceylon> from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Set into java.util.Set");
                }
                return null;
            }
            if (from instanceof WrappedJavaSet) {
                return ((WrappedJavaSet)from).unwrap();
            }
            return new WrappedCeylonSet<Ceylon, Java>(from, this.elementWrapping);
        }

        @Override
        public Wrapping<java.util.Set<Java>, Set<Ceylon>> inverted() {
            return this.to;
        }
    }

    static class ToCeylonSet<Java, Ceylon>
    implements Wrapping<java.util.Set<Java>, Set<Ceylon>> {
        private static final long serialVersionUID = -2127631972330618405L;
        private final FromCeylonSet<Ceylon, Java> from;
        private final TypeDescriptor $reified$Element;
        private final Wrapping<Java, Ceylon> elementWrapping;
        private final boolean allowNull;

        public ToCeylonSet(TypeDescriptor $reified$Element, Wrapping<Java, Ceylon> elementWrapping, boolean allowNull) {
            this.$reified$Element = $reified$Element;
            this.elementWrapping = elementWrapping;
            this.allowNull = allowNull;
            this.from = new FromCeylonSet<Ceylon, Java>(this, elementWrapping.inverted(), allowNull);
        }

        @Override
        public Set<Ceylon> wrap(java.util.Set<Java> from) {
            Collection unwrap;
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.util.Set into ceylon.language.Set");
                }
                return null;
            }
            if (from instanceof WrappedCeylonSet && (unwrap = ((WrappedCeylonSet)from).unwrap()) instanceof Set) {
                return (Set)unwrap;
            }
            return new WrappedJavaSet<Java, Ceylon>(this.$reified$Element, from, this.elementWrapping);
        }

        @Override
        public Wrapping<Set<Ceylon>, java.util.Set<Java>> inverted() {
            return this.from;
        }
    }

    static class FromCeylonList<Ceylon, Java>
    implements Wrapping<ceylon.language.List<Ceylon>, List<Java>> {
        private static final long serialVersionUID = -6243360806548129492L;
        private final ToCeylonList<Java, Ceylon> to;
        private final Wrapping<Ceylon, Java> elementWrapping;
        private final boolean allowNull;

        public FromCeylonList(ToCeylonList<Java, Ceylon> to, Wrapping<Ceylon, Java> elementWrapping, boolean allowNull) {
            this.to = to;
            this.elementWrapping = elementWrapping;
            this.allowNull = allowNull;
        }

        @Override
        public List<Java> wrap(ceylon.language.List<Ceylon> from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.List into java.util.List");
                }
                return null;
            }
            if (from instanceof WrappedJavaList) {
                return ((WrappedJavaList)from).unwrap();
            }
            return new WrappedCeylonList<Ceylon, Java>(from, this.elementWrapping);
        }

        @Override
        public Wrapping<List<Java>, ceylon.language.List<Ceylon>> inverted() {
            return this.to;
        }
    }

    static class ToCeylonList<Java, Ceylon>
    implements Wrapping<List<Java>, ceylon.language.List<Ceylon>> {
        private static final long serialVersionUID = 8713948240008574093L;
        private final FromCeylonList<Ceylon, Java> from;
        private TypeDescriptor $reified$Element;
        private Wrapping<Java, Ceylon> elementWrapping;
        private boolean allowNull;

        public ToCeylonList(TypeDescriptor $reified$Element, Wrapping<Java, Ceylon> elementWrapping, boolean allowNull) {
            this.$reified$Element = $reified$Element;
            this.elementWrapping = elementWrapping;
            this.allowNull = allowNull;
            this.from = new FromCeylonList<Ceylon, Java>(this, elementWrapping.inverted(), allowNull);
        }

        @Override
        public ceylon.language.List<Ceylon> wrap(List<Java> from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.util.List into ceylon.language.List");
                }
                return null;
            }
            if (from instanceof WrappedCeylonList) {
                return ((WrappedCeylonList)from).unwrap();
            }
            return new WrappedJavaList<Java, Ceylon>(this.$reified$Element, from, this.elementWrapping);
        }

        @Override
        public Wrapping<ceylon.language.List<Ceylon>, List<Java>> inverted() {
            return this.from;
        }
    }

    static class FromCeylonEntry<CeylonKey, CeylonItem, JavaKey, JavaItem>
    implements Wrapping<Entry<CeylonKey, CeylonItem>, Map.Entry<JavaKey, JavaItem>> {
        private static final long serialVersionUID = 3225748480205040653L;
        private final Wrapping<Map.Entry<JavaKey, JavaItem>, Entry<CeylonKey, CeylonItem>> from;
        private final Wrapping<CeylonKey, JavaKey> keyWrapping;
        private final Wrapping<CeylonItem, JavaItem> itemWrapping;

        public FromCeylonEntry(Wrapping<Map.Entry<JavaKey, JavaItem>, Entry<CeylonKey, CeylonItem>> from, Wrapping<CeylonKey, JavaKey> keyWrapping, Wrapping<CeylonItem, JavaItem> itemWrapping) {
            this.from = from;
            this.keyWrapping = keyWrapping;
            this.itemWrapping = itemWrapping;
        }

        @Override
        public Map.Entry<JavaKey, JavaItem> wrap(Entry<CeylonKey, CeylonItem> from) {
            return new AbstractMap.SimpleEntry<JavaKey, JavaItem>(this.keyWrapping.wrap(from.getKey()), this.itemWrapping.wrap(from.getItem()));
        }

        @Override
        public Wrapping<Map.Entry<JavaKey, JavaItem>, Entry<CeylonKey, CeylonItem>> inverted() {
            return this.from;
        }
    }

    static class FromCeylonString
    implements Wrapping<ceylon.language.String, String> {
        private static final long serialVersionUID = -2239577658438069244L;
        private final ToCeylonString to;
        private final boolean allowNull;

        public FromCeylonString(ToCeylonString to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public String wrap(ceylon.language.String from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.String into java.lang.String");
                }
                return null;
            }
            return from.value;
        }

        @Override
        public Wrapping<String, ceylon.language.String> inverted() {
            return this.to;
        }
    }

    static class ToCeylonString
    implements Wrapping<String, ceylon.language.String> {
        private static final long serialVersionUID = -454959661466022465L;
        private final FromCeylonString from;
        private final boolean allowNull;

        public ToCeylonString(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonString(this, allowNull);
        }

        @Override
        public ceylon.language.String wrap(String from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.String into ceylon.language.String");
                }
                return null;
            }
            return ceylon.language.String.instance(from);
        }

        @Override
        public Wrapping<ceylon.language.String, String> inverted() {
            return this.from;
        }
    }

    static class FromCeylonCharacter
    implements Wrapping<Character, java.lang.Integer> {
        private static final long serialVersionUID = 3285319452086713548L;
        private final ToCeylonCharacter to;
        private final boolean allowNull;

        public FromCeylonCharacter(ToCeylonCharacter to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public java.lang.Integer wrap(Character from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Character into java.lang.Character");
                }
                return null;
            }
            return from.codePoint;
        }

        @Override
        public Wrapping<java.lang.Integer, Character> inverted() {
            return this.to;
        }
    }

    static class ToCeylonCharacter
    implements Wrapping<java.lang.Integer, Character> {
        private static final long serialVersionUID = -8772225234908795616L;
        private final FromCeylonCharacter from;
        private final boolean allowNull;

        public ToCeylonCharacter(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonCharacter(this, allowNull);
        }

        @Override
        public Character wrap(java.lang.Integer from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.Character into ceylon.language.Character");
                }
                return null;
            }
            return Character.instance(from);
        }

        @Override
        public Wrapping<Character, java.lang.Integer> inverted() {
            return this.from;
        }
    }

    static class FromCeylonBoolean
    implements Wrapping<Boolean, java.lang.Boolean> {
        private static final long serialVersionUID = -5549339150429649814L;
        private final ToCeylonBoolean to;
        private final boolean allowNull;

        public FromCeylonBoolean(ToCeylonBoolean to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public java.lang.Boolean wrap(Boolean from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Boolean into java.lang.Boolean");
                }
                return null;
            }
            return from.booleanValue();
        }

        @Override
        public Wrapping<java.lang.Boolean, Boolean> inverted() {
            return this.to;
        }
    }

    static class ToCeylonBoolean
    implements Wrapping<java.lang.Boolean, Boolean> {
        private static final long serialVersionUID = -5753935452391992481L;
        private final FromCeylonBoolean from;
        private final boolean allowNull;

        public ToCeylonBoolean(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonBoolean(this, allowNull);
        }

        @Override
        public Boolean wrap(java.lang.Boolean from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.Boolean into ceylon.language.Boolean");
                }
                return null;
            }
            return Boolean.instance(from);
        }

        @Override
        public Wrapping<Boolean, java.lang.Boolean> inverted() {
            return this.from;
        }
    }

    static class FromCeylonByte
    implements Wrapping<Byte, java.lang.Byte> {
        private static final long serialVersionUID = 1122563983602166370L;
        private final ToCeylonByte to;
        private final boolean allowNull;

        public FromCeylonByte(ToCeylonByte to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public java.lang.Byte wrap(Byte from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Byte into java.lang.Byte");
                }
                return null;
            }
            return from.byteValue();
        }

        @Override
        public Wrapping<java.lang.Byte, Byte> inverted() {
            return this.to;
        }
    }

    static class ToCeylonByte
    implements Wrapping<java.lang.Byte, Byte> {
        private static final long serialVersionUID = 7612648551990554992L;
        private final FromCeylonByte from;
        private final boolean allowNull;

        public ToCeylonByte(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonByte(this, allowNull);
        }

        @Override
        public Byte wrap(java.lang.Byte from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.Byte into ceylon.language.Byte");
                }
                return null;
            }
            return Byte.instance(from);
        }

        @Override
        public Wrapping<Byte, java.lang.Byte> inverted() {
            return this.from;
        }
    }

    static class FromCeylonFloat
    implements Wrapping<Float, Double> {
        private static final long serialVersionUID = 3749821019398032894L;
        private final ToCeylonFloat to;
        private final boolean allowNull;

        public FromCeylonFloat(ToCeylonFloat to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public Double wrap(Float from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Float into java.lang.Double");
                }
                return null;
            }
            return from.doubleValue();
        }

        @Override
        public Wrapping<Double, Float> inverted() {
            return this.to;
        }
    }

    static class ToCeylonFloat
    implements Wrapping<Double, Float> {
        private static final long serialVersionUID = 6137133766421110316L;
        private final FromCeylonFloat from;
        private final boolean allowNull;

        public ToCeylonFloat(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonFloat(this, allowNull);
        }

        @Override
        public Float wrap(Double from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.Double into ceylon.language.Float");
                }
                return null;
            }
            return Float.instance(from);
        }

        @Override
        public Wrapping<Float, Double> inverted() {
            return this.from;
        }
    }

    static class FromCeylonInteger
    implements Wrapping<Integer, Long> {
        private static final long serialVersionUID = -8490990231904038975L;
        private final ToCeylonInteger to;
        private final boolean allowNull;

        public FromCeylonInteger(ToCeylonInteger to, boolean allowNull) {
            this.to = to;
            this.allowNull = allowNull;
        }

        @Override
        public Long wrap(Integer from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of ceylon.language.Integer into java.lang.Long");
                }
                return null;
            }
            return from.longValue();
        }

        @Override
        public Wrapping<Long, Integer> inverted() {
            return this.to;
        }
    }

    static class ToCeylonInteger
    implements Wrapping<Long, Integer> {
        private static final long serialVersionUID = -8545077172446381771L;
        private final FromCeylonInteger from;
        private final boolean allowNull;

        public ToCeylonInteger(boolean allowNull) {
            this.allowNull = allowNull;
            this.from = new FromCeylonInteger(this, allowNull);
        }

        @Override
        public Integer wrap(Long from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, "of java.lang.Long into ceylon.language.Integer");
                }
                return null;
            }
            return Integer.instance(from);
        }

        @Override
        public Wrapping<Integer, Long> inverted() {
            return this.from;
        }
    }

    static class Identity<From>
    implements Wrapping<From, From> {
        private static final long serialVersionUID = -7765082682145106763L;
        private final boolean allowNull;

        Identity(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public From wrap(From from) {
            if (from == null) {
                if (!this.allowNull) {
                    Wrappings.checkNull(from, null);
                }
                return null;
            }
            return from;
        }

        @Override
        public Wrapping<From, From> inverted() {
            return this;
        }
    }
}

