/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AssemblyRepositoryBuilder;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Rest;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.RepoUsingTool;
import com.redhat.ceylon.compiler.js.CeylonRunJsException;
import com.redhat.ceylon.compiler.js.CeylonRunJsMessages;
import com.redhat.ceylon.compiler.js.loader.JsModuleSourceMapper;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

@Summary(value="Executes a Ceylon program on Node.js")
@Description(value="Executes the ceylon program specified as the `module` argument. The `module` may optionally include a version.")
@RemainingSections(value="## Compile flags\n\nThe `--compile` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n\n\n## Configuration file\n\nThe run-js tool accepts the following option from the Ceylon configuration file: `runtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute the `com.example.foobar` module:\n\n    ceylon run-js com.example.foobar/1.0.0")
public class CeylonRunJsTool
extends RepoUsingTool {
    private String module;
    private File assembly;
    private String func;
    private String compileFlags;
    private String exepath;
    private List<String> args;
    private PrintStream output;
    private boolean debug;

    private static String findNodeInPath(String path) {
        if (path != null) {
            String[] paths;
            for (String p : paths = path.split(File.pathSeparator)) {
                String d = p.endsWith(File.separator) ? p : p + File.separator;
                String np = d + "node";
                if (CeylonRunJsTool.isExe(np)) {
                    return np;
                }
                np = d + "node.exe";
                if (CeylonRunJsTool.isExe(np)) {
                    return np;
                }
                np = d + "nodejs";
                if (CeylonRunJsTool.isExe(np)) {
                    return np;
                }
                np = d + "nodejs.exe";
                if (!CeylonRunJsTool.isExe(np)) continue;
                return np;
            }
        }
        return null;
    }

    public static String findNode() {
        String path = CeylonRunJsTool.getNodeExe();
        if (path != null && !path.isEmpty() && CeylonRunJsTool.isExe(path)) {
            return path;
        }
        String winpath = CeylonRunJsTool.findNodeInPath(System.getenv("PATH"));
        if (winpath != null) {
            return winpath;
        }
        String errmsg = "Could not find 'node' executable. Please install Node.js (from http://nodejs.org).\nMake sure the path to the node executable is included in your PATH environment variable.\nIf you have node installed in a non-standard location, you can either set the environment variable\nNODE_EXE or the JVM system property 'ceylon.command.node' with the full path to the node executable.";
        throw new CeylonRunJsException(errmsg);
    }

    private static boolean isExe(String p) {
        File f = new File(p);
        return f.exists() && f.canExecute();
    }

    public CeylonRunJsTool() {
        super(CeylonRunJsMessages.RESOURCE_BUNDLE);
    }

    public void setThrowOnError(boolean throwOnError) {
    }

    public void setOutput(PrintStream value) {
        this.output = value;
    }

    @OptionArgument(argumentName="debug")
    @Description(value="Shows more detailed output in case of errors.")
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @OptionArgument(longName="run", argumentName="toplevel")
    @Description(value="Specifies the fully qualified name of a toplevel method or class to run. The indicated declaration must be shared by the `module` and have no parameters. The format is: `qualified.package.name::classOrMethodName` with `::` acting as separator between the package name and the toplevel class or method name. (default: `module.name::run`)")
    public void setRun(String func) {
        this.func = func;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setCompile(String compile) {
        this.compileFlags = compile;
    }

    @Argument(argumentName="module", multiplicity="?", order=1)
    public void setModuleVersion(String moduleVersion) {
        this.module = moduleVersion;
    }

    @OptionArgument
    @Description(value="Specifies the path to a Ceylon Assembly file that should be executed")
    public void setAssembly(File assembly) {
        this.assembly = assembly;
    }

    @Rest
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @OptionArgument(argumentName="node-exe")
    @Description(value="The path to the Node.js executable. Will be searched in standard locations if not specified.")
    public void setNodeExe(String path) {
        this.exepath = path;
    }

    private static String getNodePath() {
        return CeylonRunJsTool.getFromEnv("NODE_PATH", "node.path");
    }

    private static String getNodeExe() {
        return CeylonRunJsTool.getFromEnv("NODE_EXE", "ceylon.command.node");
    }

    private static String getCeylonRepo() {
        return System.getProperty("ceylon.system.repo");
    }

    private static String getFromEnv(String env, String prop) {
        String path = System.getProperty(prop);
        if (path != null) {
            return path;
        }
        return System.getenv(env);
    }

    private ProcessBuilder buildProcess(String module, String version2, String func, List<String> args, String exepath, List<File> repos, PrintStream output) {
        ProcessBuilder proc;
        boolean isDefault;
        String node;
        String string = node = exepath == null ? CeylonRunJsTool.findNode() : exepath;
        if (exepath != null && !CeylonRunJsTool.isExe(exepath)) {
            throw new CeylonRunJsException("Specified Node.js executable is invalid.");
        }
        if (func.startsWith("::")) {
            func = func.substring(2);
        } else if (func.indexOf(46) > 0 || func.indexOf("::") > 0) {
            if (func.contains("::")) {
                func = func.replace("::", ".");
            }
            if (func.startsWith(module)) {
                func = func.substring(module.length() + 1);
            }
            if (func.indexOf(46) > 0) {
                StringBuilder fsb = new StringBuilder();
                int lastDot = func.lastIndexOf(46);
                fsb.append(func.substring(lastDot + 1)).append('$');
                fsb.append(func.substring(0, lastDot).replaceAll("\\.", "\\$"));
                func = fsb.toString();
            }
        }
        if (JsIdentifierNames.isReservedWord(func)) {
            func = "$_" + func;
        }
        String moduleString = (isDefault = ModuleUtil.isDefaultModule(module)) ? module : module + "/" + version2;
        String overrideRequire = "function $$ceylon$require(a,b,c){return b(c[0].substr(0,16)=='ceylon/language/'?'ceylon/language/1.3.2/ceylon.language-1.3.2'+(c[0].substr(-6)=='-model'?'-model':''):c[0]);};";
        String eval = String.format("if(typeof setTimeout==='function'){setTimeout(function(){},50)};function $$ceylon$require(a,b,c){return b(c[0].substr(0,16)=='ceylon/language/'?'ceylon/language/1.3.2/ceylon.language-1.3.2'+(c[0].substr(-6)=='-model'?'-model':''):c[0]);};var __entry_point__=require('%s%s/%s%s').%s;if (__entry_point__===undefined){console.log('The specified method \"%s\" does not exist or is not shared in the %s module');process.exit(1);}else __entry_point__();", module.replace(".", "/"), isDefault ? "" : "/" + version2, module, isDefault ? "" : "-" + version2, func, func, moduleString);
        ProcessBuilder versionProc = new ProcessBuilder(Arrays.asList(node, "-v"));
        try {
            String[] versionParts;
            Process versionProcess = versionProc.start();
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(versionProcess.getInputStream()));
            String nodeVersion = lineReader.readLine();
            versionProcess.destroy();
            if (nodeVersion.charAt(0) == 'v') {
                nodeVersion = nodeVersion.substring(1);
            }
            if ((versionParts = nodeVersion.split("\\.")).length > 1 && Integer.parseInt(versionParts[0], 10) == 0 && Integer.parseInt(versionParts[1], 10) < 8) {
                System.out.println("Be warned, old timer: JavaScript code generated by the Ceylon compiler will most likely not run on Node.js versions older than 0.8");
                System.out.println();
            }
        }
        catch (IOException | NumberFormatException ex) {
            System.out.println("Cannot determine Node.js version; you should be using 0.8 or above");
        }
        if (args != null && !args.isEmpty()) {
            ArrayList<String> newargs = new ArrayList<String>(args.size() + 4);
            newargs.add(node);
            newargs.add("-e");
            newargs.add(eval);
            newargs.add("dummy");
            newargs.addAll(args);
            proc = new ProcessBuilder(newargs.toArray(new String[0]));
        } else {
            proc = new ProcessBuilder(node, "-e", eval);
        }
        StringBuilder nodePath = new StringBuilder();
        CeylonRunJsTool.appendToNodePath(nodePath, CeylonRunJsTool.getNodePath());
        for (File repo : repos) {
            CeylonRunJsTool.appendToNodePath(nodePath, repo.getPath());
        }
        if (this.debug) {
            System.out.println("NODE_PATH=" + nodePath);
        }
        proc.environment().put("NODE_PATH", nodePath.toString());
        if (output != null) {
            proc.redirectErrorStream();
        }
        return proc;
    }

    private static String appendToNodePath(StringBuilder nodePath, String repo) {
        if (repo == null || repo.isEmpty()) {
            return "";
        }
        if (nodePath.length() > 0) {
            nodePath.append(File.pathSeparator);
        }
        nodePath.append(repo);
        return repo;
    }

    private List<Object> getDependencies(File jsmod) throws IOException {
        Map<String, Object> model = JsModuleSourceMapper.loadJsonModel(jsmod);
        if (model == null) {
            return Collections.emptyList();
        }
        List deps = (List)model.get("$mod-deps");
        return deps;
    }

    protected void loadDependencies(List<File> repos, RepositoryManager repoman, File jsmod, Set<String> loaded) throws IOException {
        List<Object> deps = this.getDependencies(jsmod);
        if (deps == null) {
            return;
        }
        for (Object dep : deps) {
            String modvers;
            String depname;
            boolean optional = false;
            if (dep instanceof String) {
                depname = (String)dep;
            } else {
                Map depmap = (Map)dep;
                depname = depmap.get("path").toString();
                optional = new Integer(1).equals(depmap.get("opt"));
            }
            if (loaded.contains(depname)) continue;
            loaded.add(depname);
            int idx = depname.indexOf(47);
            String modname = depname.substring(0, idx);
            File other = this.getArtifact(repoman, modname, modvers = depname.substring(idx + 1), optional);
            if (other == null) continue;
            File f = this.getRepoDir(modname, other);
            if (!repos.contains(f)) {
                repos.add(f);
            }
            this.loadDependencies(repos, repoman, other, loaded);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
        if (this.assembly != null) {
            String mfRun;
            this.compileFlags = "never";
            JarFile jar = JarUtils.validJar(this.assembly);
            if (jar == null) throw new IllegalArgumentException("The file specified by '--assembly' is not a valid Ceylon Assembly");
            Manifest manifest = jar.getManifest();
            if (manifest == null) throw new IllegalArgumentException("The Assembly does not have a manifest");
            if (this.repos == null) {
                this.repos = new ArrayList(1);
            }
            this.repos.add(0, new URI("assembly:" + this.assembly.getPath()));
            String mfMainMod = manifest.getMainAttributes().getValue("X-Ceylon-Assembly-Main-Module");
            if (mfMainMod == null) {
                throw new IllegalArgumentException("Assembly manifest is missing required attribute 'X-Ceylon-Assembly-Main-Module'");
            }
            if (this.module != null) {
                this.args.add(0, this.module);
            }
            this.module = mfMainMod;
            String mfOverrides = manifest.getMainAttributes().getValue("X-Ceylon-Assembly-Overrides");
            if (mfOverrides != null) {
                File assemblyFolder = AssemblyRepositoryBuilder.registerAssembly(this.assembly);
                File ovrFile = new File(assemblyFolder, mfOverrides);
                this.overrides = ovrFile.getPath();
            }
            if ((mfRun = manifest.getMainAttributes().getValue("X-Ceylon-Assembly-Run")) != null) {
                this.func = mfRun;
            }
        }
        if (this.module != null) return;
        this.module = DefaultToolOptions.getRunToolModule(Backend.JavaScript);
        if (this.module == null) throw new IllegalArgumentException("Missing required argument 'module' to command 'run'");
        if (this.func == null) {
            this.func = DefaultToolOptions.getRunToolRun(Backend.JavaScript);
        }
        if (this.args != null && !this.args.isEmpty()) return;
        this.args = DefaultToolOptions.getRunToolArgs(Backend.JavaScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        String version2;
        String modname;
        boolean isDefault;
        if (this.systemRepo == null) {
            this.systemRepo = CeylonRunJsTool.getCeylonRepo();
        }
        if (isDefault = ModuleUtil.isDefaultModule(this.module)) {
            modname = this.module;
            version2 = "";
        } else {
            version2 = ModuleUtil.moduleVersion(this.module);
            modname = ModuleUtil.moduleName(this.module);
        }
        this.compileFlags = this.processCompileFlags(this.compileFlags, DefaultToolOptions.getRunToolCompileFlags(Backend.JavaScript));
        version2 = this.checkModuleVersionsOrShowSuggestions(modname, version2, ModuleQuery.Type.JS, null, null, 10, 0, this.compileFlags);
        if (version2 == null) {
            return;
        }
        File jsmod = this.getArtifact(this.getRepositoryManager(), modname, version2, false);
        ArrayList<File> localRepos = new ArrayList<File>();
        for (CmrRepository r : this.getRepositoryManager().getRepositories()) {
            File f;
            if (r.getRoot().isRemote() || localRepos.contains(f = new File(r.getDisplayString()))) continue;
            localRepos.add(f);
        }
        File rd = this.getRepoDir(modname, jsmod);
        if (!localRepos.contains(rd)) {
            localRepos.add(rd);
        }
        HashSet<String> loadedDependencies = new HashSet<String>();
        loadedDependencies.add(this.module);
        this.loadDependencies(localRepos, this.getRepositoryManager(), jsmod, loadedDependencies);
        this.customizeDependencies(localRepos, this.getRepositoryManager(), loadedDependencies);
        this.func = this.func != null ? this.func : "run";
        ProcessBuilder proc = this.buildProcess(modname, version2, this.func, this.args, this.exepath, localRepos, this.output);
        final Process nodeProcess = proc.start();
        new ReadStream(nodeProcess.getInputStream(), this.output == null ? System.out : this.output).start();
        if (this.output == null) {
            new ReadErrorStream(nodeProcess.getErrorStream(), System.err, this.debug).start();
        }
        Thread stopThread = new Thread(){

            @Override
            public void run() {
                try {
                    nodeProcess.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        try {
            try {
                Runtime.getRuntime().addShutdownHook(stopThread);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int exitCode = nodeProcess.waitFor();
            if (exitCode != 0) {
                if (exitCode == 11) {
                    exitCode = 2;
                }
                throw new CeylonRunJsException("Node process exited with non-zero exit code: " + exitCode, exitCode);
            }
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(stopThread);
            }
            catch (Throwable throwable) {}
        }
    }

    protected File getArtifact(RepositoryManager repoman, String modName, String modVersion, boolean optional) {
        int colonIdx = modName.indexOf(58);
        String namespace = null;
        if (colonIdx > 0) {
            namespace = modName.substring(0, colonIdx);
            modName = modName.substring(colonIdx + 1);
        }
        ArtifactContext ac = new ArtifactContext(namespace, modName, modVersion, ".js", "-model.js", "module-resources");
        ac.setIgnoreDependencies(true);
        ac.setThrowErrorIfMissing(false);
        List<ArtifactResult> results = repoman.getArtifactResults(ac);
        ArtifactResult code = this.getArtifactType(results, ".js");
        ArtifactResult model = this.getArtifactType(results, "-model.js");
        if (code == null || model == null) {
            if (optional) {
                return null;
            }
            if (code != null && "npm".equals(namespace)) {
                return null;
            }
            throw new CeylonRunJsException("Cannot find module " + ModuleUtil.makeModuleName(modName, modVersion) + " in specified module repositories");
        }
        return model.artifact();
    }

    protected ArtifactResult getArtifactType(List<ArtifactResult> results, String suffix) {
        for (ArtifactResult r : results) {
            String s = ArtifactContext.getSuffixFromFilename(r.artifact().getName());
            if (!s.equals(suffix)) continue;
            return r;
        }
        return null;
    }

    protected File getRepoDir(String modname, File file) {
        int count = modname.split("\\.").length + 1;
        if (!ModuleUtil.isDefaultModule(modname)) {
            ++count;
        }
        for (int i = 0; i < count; ++i) {
            file = file.getParentFile();
        }
        return file;
    }

    protected void customizeDependencies(List<File> localRepos, RepositoryManager repoman, Set<String> loadedDependencies) throws IOException {
    }

    public static class ReadErrorStream
    extends Thread {
        protected final BufferedReader in;
        protected final PrintStream out;
        protected final byte[] buf = new byte[16384];
        protected boolean printing = true;
        protected boolean debug = false;

        public ReadErrorStream(InputStream from, PrintStream to, boolean debug) {
            this.in = new BufferedReader(new InputStreamReader(from));
            this.out = to;
            this.debug = debug;
        }

        @Override
        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    if (line.trim().startsWith("throw ")) {
                        this.printing = this.debug;
                    } else if (line.startsWith("Error: Cannot find module ")) {
                        this.out.println(line);
                        this.printing = this.debug;
                    } else if (!this.printing) {
                        boolean bl = this.printing = !line.isEmpty() && !line.startsWith("    at ") || this.debug;
                    }
                    if (this.printing) {
                        this.out.println(line);
                    }
                    line = this.in.readLine();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(this.out);
            }
        }
    }

    public static class ReadStream
    extends Thread {
        protected final InputStream in;
        protected final PrintStream out;
        protected final byte[] buf = new byte[16384];

        public ReadStream(InputStream from, PrintStream to) {
            this.in = from;
            this.out = to;
        }

        @Override
        public void run() {
            try {
                int count = this.in.read(this.buf);
                while (count > 0) {
                    this.out.write(this.buf, 0, count);
                    count = this.in.read(this.buf);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(this.out);
            }
        }
    }
}

