/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.Destructurer;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.ConditionScope;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConditionGenerator {
    public static final String ASSERTFUNC = "asrt$(";
    private final GenerateJsVisitor gen;
    private final JsIdentifierNames names;
    private final Set<Declaration> directAccess;

    ConditionGenerator(GenerateJsVisitor owner, JsIdentifierNames names, Set<Declaration> directDeclarations) {
        this.gen = owner;
        this.names = names;
        this.directAccess = directDeclarations;
    }

    List<VarHolder> gatherVariables(Tree.ConditionList conditions, boolean output, boolean forAssert) {
        ArrayList<VarHolder> vars = new ArrayList<VarHolder>();
        boolean first = true;
        for (Tree.Condition cond : conditions.getConditions()) {
            Tree.Variable variable = null;
            Tree.Destructure destruct = null;
            if (cond instanceof Tree.ExistsOrNonemptyCondition) {
                if (((Tree.ExistsOrNonemptyCondition)cond).getVariable() instanceof Tree.Variable) {
                    variable = (Tree.Variable)((Tree.ExistsOrNonemptyCondition)cond).getVariable();
                } else if (((Tree.ExistsOrNonemptyCondition)cond).getVariable() instanceof Tree.Destructure) {
                    destruct = (Tree.Destructure)((Tree.ExistsOrNonemptyCondition)cond).getVariable();
                }
            } else if (cond instanceof Tree.IsCondition) {
                variable = ((Tree.IsCondition)cond).getVariable();
            } else if (!(cond instanceof Tree.BooleanCondition)) {
                cond.addUnexpectedError("No support for conditions of type " + cond.getClass().getSimpleName(), Backend.JavaScript);
                return null;
            }
            if (variable != null) {
                Tree.Term variableRHS = variable.getSpecifierExpression().getExpression().getTerm();
                Value vdecl = variable.getDeclarationModel();
                String varName = this.names.name(vdecl);
                boolean member = ModelUtil.getRealScope(vdecl.getContainer()) instanceof ClassOrInterface;
                if (member) {
                    if (vdecl.getScope() instanceof ConditionScope) {
                        vdecl.setContainer(ModelUtil.getRealScope(vdecl.getContainer()));
                        varName = this.names.name(vdecl);
                    }
                } else if (output) {
                    if (first) {
                        first = false;
                        this.gen.out("var ", new String[0]);
                    } else {
                        this.gen.out(",", new String[0]);
                    }
                    this.gen.out(varName, new String[0]);
                }
                vars.add(new VarHolder(variable, variableRHS, varName, member));
                continue;
            }
            if (destruct == null) continue;
            Destructurer d = new Destructurer(destruct.getPattern(), null, this.directAccess, "", first, forAssert);
            for (Tree.Variable v : d.getVariables()) {
                if (!output) continue;
                String vname = this.names.name(v.getDeclarationModel());
                if (first) {
                    first = false;
                    this.gen.out("var ", vname);
                    continue;
                }
                this.gen.out(",", vname);
            }
            VarHolder vh = new VarHolder(destruct, null, null, false);
            vh.vars = d.getVariables();
            vars.add(vh);
        }
        if (output && !first) {
            this.gen.endLine(true);
        }
        return vars;
    }

    void outputVariables(List<VarHolder> vars) {
        boolean first = true;
        for (VarHolder vh : vars) {
            if (vh.name != null) {
                if (first) {
                    this.gen.out("var ", vh.name);
                    first = false;
                    continue;
                }
                this.gen.out(",", vh.name);
                continue;
            }
            if (vh.destr == null || vh.vars == null) continue;
            for (Tree.Variable v : vh.vars) {
                String vname = this.names.name(v.getDeclarationModel());
                if (first) {
                    this.gen.out("var ", vname);
                    first = false;
                    continue;
                }
                this.gen.out(",", vname);
            }
        }
        if (!first) {
            this.gen.endLine(true);
        }
    }

    List<VarHolder> specialConditionsAndBlock(Tree.ConditionList conditions, Tree.Block block, String keyword, boolean forAssert) {
        List<VarHolder> vars = this.gatherVariables(conditions, true, forAssert);
        this.specialConditions(vars, conditions, keyword, forAssert);
        if (block != null) {
            this.gen.encloseBlockInFunction(block, true, this.getCaptured(vars));
        }
        return vars;
    }

    void specialConditions(List<VarHolder> vars, Tree.ConditionList conditions, String keyword, boolean forAssert) {
        if (!keyword.isEmpty()) {
            this.gen.out(keyword, "(");
        }
        boolean first = true;
        Iterator<VarHolder> ivars = vars.iterator();
        for (Tree.Condition cond : conditions.getConditions()) {
            if (first) {
                first = false;
            } else {
                this.gen.out("&&", new String[0]);
            }
            if (cond instanceof Tree.BooleanCondition) {
                cond.visit(this.gen);
                continue;
            }
            VarHolder vh = ivars.next();
            if (vh.destr == null) {
                if (vh.member) {
                    String cname = this.gen.getNames().self((ClassOrInterface)ModelUtil.getRealScope(vh.var.getDeclarationModel().getContainer()));
                    this.specialConditionCheck(cond, vh.term, cname + "." + vh.name, forAssert);
                    continue;
                }
                this.specialConditionCheck(cond, vh.term, vh.name, forAssert);
                this.directAccess.add(vh.var.getDeclarationModel());
                continue;
            }
            this.destructureCondition(cond, vh, forAssert);
        }
        if (!keyword.isEmpty()) {
            this.gen.out(")", new String[0]);
        }
    }

    private void specialConditionCheck(Tree.Condition condition, Tree.Term variableRHS, String varName, boolean forAssert) {
        if (condition instanceof Tree.ExistsOrNonemptyCondition) {
            if (((Tree.ExistsOrNonemptyCondition)condition).getNot()) {
                this.gen.out("!", new String[0]);
            }
            if (condition instanceof Tree.NonemptyCondition) {
                this.gen.out(this.gen.getClAlias(), "ne$(");
            } else {
                this.gen.out(this.gen.getClAlias(), "nn$(");
            }
            this.specialConditionRHS(variableRHS, varName);
            this.gen.out(")", new String[0]);
        } else {
            Tree.Type type = ((Tree.IsCondition)condition).getType();
            this.gen.generateIsOfType(variableRHS, null, type.getTypeModel(), varName, ((Tree.IsCondition)condition).getNot(), forAssert);
        }
    }

    void specialConditionRHS(Tree.Term variableRHS, String varName) {
        if (varName == null) {
            if (variableRHS != null) {
                variableRHS.visit(this.gen);
            }
        } else {
            this.gen.out("(", varName, "=");
            variableRHS.visit(this.gen);
            this.gen.out(")", new String[0]);
        }
    }

    void specialConditionRHS(String variableRHS, String varName) {
        if (varName == null) {
            this.gen.out(variableRHS, new String[0]);
        } else {
            this.gen.out("(", varName, "=");
            this.gen.out(variableRHS, new String[0]);
            this.gen.out(")", new String[0]);
        }
    }

    void generateIf(Tree.IfStatement that) {
        Tree.IfClause ifClause = that.getIfClause();
        Tree.Block ifBlock = ifClause.getBlock();
        Tree.ElseClause anoserque = that.getElseClause();
        List<VarHolder> vars = this.specialConditionsAndBlock(ifClause.getConditionList(), ifBlock, "if", false);
        if (anoserque != null) {
            Value elseDec;
            Tree.Variable elsevar = anoserque.getVariable();
            Value value = elseDec = elsevar != null ? elsevar.getDeclarationModel() : null;
            if (elsevar != null) {
                for (VarHolder vh : vars) {
                    if (!vh.var.getDeclarationModel().getName().equals(elseDec.getName())) continue;
                    this.names.forceName(elseDec, vh.name);
                    this.directAccess.add(elseDec);
                    break;
                }
            }
            this.gen.out("else", new String[0]);
            this.gen.encloseBlockInFunction(anoserque.getBlock(), true, elseDec != null && elseDec.isCaptured() ? Collections.singleton(elseDec) : null);
            if (elseDec != null) {
                this.directAccess.remove(elseDec);
                this.names.forceName(elseDec, null);
            }
        }
        for (VarHolder v : vars) {
            v.forget();
        }
    }

    void generateIfExpression(Tree.IfExpression that, boolean nested) {
        Tree.Variable elsevar;
        List<VarHolder> vars = this.gatherVariables(that.getIfClause().getConditionList(), false, false);
        Tree.ElseClause anoserque = that.getElseClause();
        Tree.Variable variable = elsevar = anoserque == null ? null : anoserque.getVariable();
        if (elsevar != null) {
            Value elseval = elsevar.getDeclarationModel();
            for (VarHolder vh : vars) {
                if (vh.var == null || !vh.var.getDeclarationModel().getName().equals(elseval.getName())) continue;
                this.names.forceName(elseval, vh.name);
                this.directAccess.add(elseval);
                break;
            }
        }
        if (vars.isEmpty()) {
            if (nested) {
                this.gen.out(" return ", new String[0]);
            } else {
                this.gen.out("(", new String[0]);
            }
            this.specialConditions(vars, that.getIfClause().getConditionList(), "", false);
            this.gen.out("?", new String[0]);
            that.getIfClause().getExpression().visit(this.gen);
            this.gen.out(":", new String[0]);
            if (anoserque == null) {
                this.gen.out("null;", new String[0]);
            } else {
                anoserque.getExpression().visit(this.gen);
            }
            if (!nested) {
                this.gen.out(")", new String[0]);
            }
        } else {
            boolean thenIf;
            if (nested) {
                this.gen.out("{", new String[0]);
            } else {
                this.gen.out("function(){", new String[0]);
            }
            this.outputVariables(vars);
            this.specialConditions(vars, that.getIfClause().getConditionList(), "if", false);
            this.gen.out("return ", new String[0]);
            that.getIfClause().getExpression().visit(this.gen);
            for (VarHolder v : vars) {
                v.forget();
            }
            boolean bl = thenIf = anoserque != null && anoserque.getExpression().getTerm() instanceof Tree.IfExpression;
            if (thenIf) {
                this.gen.out(";else", new String[0]);
            } else {
                this.gen.out(";else return ", new String[0]);
            }
            if (anoserque == null) {
                this.gen.out("null;", new String[0]);
            } else if (thenIf) {
                this.generateIfExpression((Tree.IfExpression)anoserque.getExpression().getTerm(), true);
            } else {
                anoserque.getExpression().visit(this.gen);
            }
            if (nested) {
                this.gen.out("}", new String[0]);
            } else {
                this.gen.out("}()", new String[0]);
            }
        }
        if (elsevar != null) {
            this.directAccess.remove(elsevar.getDeclarationModel());
            this.names.forceName(elsevar.getDeclarationModel(), null);
        }
    }

    void generateWhile(Tree.WhileStatement that) {
        Tree.WhileClause whileClause = that.getWhileClause();
        List<VarHolder> vars = this.specialConditionsAndBlock(whileClause.getConditionList(), whileClause.getBlock(), "while", false);
        for (VarHolder v : vars) {
            v.forget();
        }
    }

    private void generateSwitch(Tree.SwitchClause clause, Tree.SwitchCaseList cases, SwitchGen sgen) {
        Tree.Expression expr;
        String expvar;
        if (clause.getSwitched().getExpression() == null) {
            expvar = this.names.name(clause.getSwitched().getVariable().getDeclarationModel());
            expr = clause.getSwitched().getVariable().getSpecifierExpression().getExpression();
            this.directAccess.add(clause.getSwitched().getVariable().getDeclarationModel());
        } else {
            expr = clause.getSwitched().getExpression();
            expvar = this.names.createTempVariable();
        }
        sgen.gen1(expvar, expr);
        boolean first = true;
        for (Tree.CaseClause cc : cases.getCaseClauses()) {
            if (!first) {
                this.gen.out("else ", new String[0]);
            }
            this.caseClause(cc, expvar, expr.getTerm());
            first = false;
        }
        Tree.ElseClause anoserque = cases.getElseClause();
        if (anoserque == null) {
            if (this.gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(expr.getTypeModel())) {
                this.gen.out("else throw ", this.gen.getClAlias(), "Exception('Ceylon switch over unknown type does not cover all cases')");
            } else {
                this.gen.out("else throw ", this.gen.getClAlias(), "Exception('Supposedly exhaustive switch was not exhaustive')");
            }
        } else {
            Tree.Variable elsevar = anoserque.getVariable();
            if (elsevar != null) {
                this.directAccess.add(elsevar.getDeclarationModel());
                this.names.forceName(elsevar.getDeclarationModel(), expvar);
            }
            sgen.gen2(anoserque);
            if (elsevar != null) {
                this.directAccess.remove(elsevar.getDeclarationModel());
                this.names.forceName(elsevar.getDeclarationModel(), null);
            }
        }
        sgen.gen3(expr);
        if (clause.getSwitched().getExpression() == null) {
            this.directAccess.remove(clause.getSwitched().getVariable().getDeclarationModel());
        }
    }

    void switchStatement(Tree.SwitchStatement that) {
        this.generateSwitch(that.getSwitchClause(), that.getSwitchCaseList(), new SwitchGen(){

            @Override
            public void gen1(String expvar, Tree.Expression expr) {
                ConditionGenerator.this.gen.out("var ", expvar, "=");
                expr.visit(ConditionGenerator.this.gen);
                ConditionGenerator.this.gen.endLine(true);
            }

            @Override
            public void gen2(Tree.ElseClause anoserque) {
                ConditionGenerator.this.gen.out("else", new String[0]);
                anoserque.getBlock().visit(ConditionGenerator.this.gen);
            }

            @Override
            public void gen3(Tree.Expression expr) {
            }
        });
    }

    void switchExpression(Tree.SwitchExpression that) {
        this.generateSwitch(that.getSwitchClause(), that.getSwitchCaseList(), new SwitchGen(){

            @Override
            public void gen1(String expvar, Tree.Expression expr) {
                ConditionGenerator.this.gen.out("function(", expvar, "){");
            }

            @Override
            public void gen2(Tree.ElseClause anoserque) {
                ConditionGenerator.this.gen.out("else return ", new String[0]);
                anoserque.getExpression().visit(ConditionGenerator.this.gen);
            }

            @Override
            public void gen3(Tree.Expression expr) {
                ConditionGenerator.this.gen.out("}(", new String[0]);
                expr.visit(ConditionGenerator.this.gen);
                ConditionGenerator.this.gen.out(")", new String[0]);
            }
        });
    }

    private void caseClause(Tree.CaseClause cc, String expvar, Tree.Term switchTerm) {
        this.gen.out("if(", new String[0]);
        Tree.CaseItem item = cc.getCaseItem();
        Tree.Variable caseVar = null;
        Value caseDec = null;
        if (item instanceof Tree.IsCase) {
            Tree.IsCase isCaseItem = (Tree.IsCase)item;
            this.gen.generateIsOfType(item, expvar, isCaseItem.getType().getTypeModel(), null, false, false);
            caseVar = isCaseItem.getVariable();
            if (caseVar != null) {
                caseDec = caseVar.getDeclarationModel();
                this.directAccess.add(caseDec);
                this.names.forceName(caseDec, expvar);
            }
        } else if (item instanceof Tree.SatisfiesCase) {
            item.addError("case(satisfies) not yet supported", Backend.JavaScript);
            this.gen.out("true", new String[0]);
        } else if (item instanceof Tree.MatchCase) {
            boolean isNull = switchTerm.getTypeModel().covers(switchTerm.getUnit().getNullType());
            boolean first = true;
            for (Tree.Expression exp : ((Tree.MatchCase)item).getExpressionList().getExpressions()) {
                Tree.Term term;
                if (!first) {
                    this.gen.out(" || ", new String[0]);
                }
                if ((term = exp.getTerm()) instanceof Tree.StringLiteral || term instanceof Tree.NaturalLiteral) {
                    if (isNull) {
                        this.gen.out(this.gen.getClAlias(), "nn$(", expvar, ")&&");
                    }
                    exp.visit(this.gen);
                    this.gen.out(".equals(", expvar, ")");
                } else if (ModelUtil.isTypeUnknown(switchTerm.getTypeModel())) {
                    this.gen.out(expvar, "===");
                    if (!this.gen.isNaturalLiteral(term)) {
                        exp.visit(this.gen);
                    }
                } else if (term instanceof Tree.Literal) {
                    if (switchTerm.getUnit().isOptionalType(switchTerm.getTypeModel())) {
                        this.gen.out(expvar, "!==null&&");
                    }
                    this.gen.out(expvar, ".equals(");
                    exp.visit(this.gen);
                    this.gen.out(")", new String[0]);
                } else if (term instanceof Tree.Tuple) {
                    if (((Tree.Tuple)term).getSequencedArgument() == null) {
                        this.gen.out(expvar, "===", this.gen.getClAlias(), "empty()");
                    } else {
                        this.gen.out(this.gen.getClAlias(), "is$(", expvar, ",{t:", this.gen.getClAlias(), "Tuple})&&", expvar, ".equals(");
                        exp.visit(this.gen);
                        this.gen.out(")", new String[0]);
                    }
                } else {
                    this.gen.out(expvar, "===");
                    exp.visit(this.gen);
                }
                first = false;
            }
        } else {
            cc.addUnexpectedError("support for case of type " + cc.getClass().getSimpleName() + " not yet implemented", Backend.JavaScript);
        }
        this.gen.out(")", new String[0]);
        if (cc.getBlock() == null) {
            this.gen.out("return ", new String[0]);
            cc.getExpression().visit(this.gen);
            this.gen.out(";", new String[0]);
        } else {
            this.gen.out(" ", new String[0]);
            Set<Value> cap = caseDec != null && caseDec.isCaptured() ? Collections.singleton(caseDec) : null;
            this.gen.encloseBlockInFunction(cc.getBlock(), true, cap);
        }
        if (caseDec != null) {
            this.directAccess.remove(caseDec);
            this.names.forceName(caseDec, null);
        }
    }

    void destructureCondition(Tree.Condition cond, VarHolder vh, boolean forAssert) {
        String expvar = this.names.createTempVariable();
        this.gen.out("function(", expvar, "){if(");
        if (cond instanceof Tree.ExistsCondition) {
            if (!((Tree.ExistsCondition)cond).getNot()) {
                this.gen.out("!", new String[0]);
            }
            this.gen.out(this.gen.getClAlias(), "nn$(", expvar, "))return false;");
        } else if (cond instanceof Tree.NonemptyCondition) {
            if (!((Tree.NonemptyCondition)cond).getNot()) {
                this.gen.out("!", new String[0]);
            }
            this.gen.out(this.gen.getClAlias(), "ne$(", expvar, "))return false;");
        } else {
            Tree.Type type = ((Tree.IsCondition)cond).getType();
            this.gen.generateIsOfType(null, expvar, type.getTypeModel(), null, ((Tree.IsCondition)cond).getNot(), forAssert);
            this.gen.out(")return false;", new String[0]);
        }
        this.gen.out("return(", new String[0]);
        Destructurer d = new Destructurer(vh.destr.getPattern(), this.gen, this.directAccess, expvar, true, forAssert);
        this.gen.out(",true);}(", new String[0]);
        vh.destr.getSpecifierExpression().visit(this.gen);
        this.gen.out(")", new String[0]);
        vh.vars = d.getVariables();
        vh.captured = d.getCapturedValues();
    }

    Set<Value> getCaptured(List<VarHolder> vars) {
        HashSet<Value> caps = new HashSet<Value>(3);
        for (VarHolder vh : vars) {
            Set<Value> c2 = vh.getCaptured();
            if (c2 == null || c2.isEmpty()) continue;
            caps.addAll(c2);
        }
        return caps;
    }

    private static interface SwitchGen {
        public void gen1(String var1, Tree.Expression var2);

        public void gen2(Tree.ElseClause var1);

        public void gen3(Tree.Expression var1);
    }

    class VarHolder {
        final Tree.Variable var;
        final Tree.Term term;
        final String name;
        final Tree.Destructure destr;
        Set<Tree.Variable> vars;
        Set<Value> captured;
        final boolean member;

        private VarHolder(Tree.Statement st, Tree.Term rhs, String varName, boolean member) {
            if (st instanceof Tree.Variable) {
                this.var = (Tree.Variable)st;
                this.destr = null;
                if (this.var.getDeclarationModel() != null && this.var.getDeclarationModel().isCaptured()) {
                    this.captured = Collections.singleton(this.var.getDeclarationModel());
                }
            } else {
                this.var = null;
                this.destr = (Tree.Destructure)st;
            }
            this.term = rhs;
            if (st.getScope() instanceof Tree.Assertion && st.getScope().getContainer() instanceof ClassOrInterface) {
                this.name = ConditionGenerator.this.gen.getNames().self((ClassOrInterface)st.getScope().getContainer()) + "." + varName;
                if (this.var != null) {
                    ConditionGenerator.this.names.forceName(this.var.getDeclarationModel(), this.name);
                }
            } else {
                this.name = varName;
            }
            this.member = member;
        }

        void forget() {
            if (this.var != null) {
                ConditionGenerator.this.directAccess.remove(this.var.getDeclarationModel());
                ConditionGenerator.this.names.forceName(this.var.getDeclarationModel(), null);
            } else if (this.vars != null) {
                for (Tree.Variable v : this.vars) {
                    ConditionGenerator.this.directAccess.remove(v.getDeclarationModel());
                    ConditionGenerator.this.names.forceName(v.getDeclarationModel(), null);
                }
            }
        }

        public Set<Value> getCaptured() {
            return this.captured;
        }

        public String toString() {
            if (this.var != null) {
                return "VarHolder(" + this.var.getDeclarationModel() + ")";
            }
            if (this.vars != null) {
                StringBuilder sb = new StringBuilder();
                for (Tree.Variable v : this.vars) {
                    if (sb.length() == 0) {
                        sb.append("VarHolder[");
                    } else {
                        sb.append(",");
                    }
                    sb.append(v.getDeclarationModel());
                }
                sb.append("]");
                return sb.toString();
            }
            return "VarHolder[???]";
        }
    }
}

