/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.TypeGenerator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.ArrayList;
import java.util.List;

public class Constructors {
    static void classConstructor(Tree.Constructor that, Tree.ClassDefinition cdef, List<Tree.Constructor> constructors, GenerateJsVisitor gen) {
        gen.comment(that);
        Constructor d = TypeUtils.getConstructor(that.getDeclarationModel());
        Class container = cdef.getDeclarationModel();
        String fullName = gen.getNames().name(container) + gen.getNames().constructorSeparator(d) + gen.getNames().name(d);
        if (!TypeUtils.isNativeExternal(d) || !gen.stitchNative(d, that)) {
            Constructors.generateConstructor(that, cdef, constructors, fullName, gen);
        }
        gen.out(fullName, ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)d, that.getAnnotationList(), gen);
        gen.endLine(true);
        gen.out(gen.getNames().name(container), ".", fullName, "=", fullName);
        gen.endLine(true);
        if (gen.outerSelf(container)) {
            gen.out(".", fullName, "=", fullName);
            gen.endLine(true);
        }
    }

    private static void generateConstructor(Tree.Constructor that, Tree.ClassDefinition cdef, List<Tree.Constructor> constructors, String fullName, GenerateJsVisitor gen) {
        boolean callAbstract;
        ParameterList superplist;
        Constructor d = TypeUtils.getConstructor(that.getDeclarationModel());
        Class container = cdef.getDeclarationModel();
        Tree.DelegatedConstructor delcons = that.getDelegatedConstructor();
        if (delcons == null) {
            Object superdec = null;
            superplist = null;
            callAbstract = false;
        } else {
            TypeDeclaration superdec = delcons.getType().getDeclarationModel();
            callAbstract = superdec instanceof Class ? superdec == container : ((Constructor)superdec).getContainer() == container;
            superplist = superdec instanceof Class ? ((Class)superdec).getParameterList() : ((Constructor)superdec).getFirstParameterList();
        }
        gen.out("function ", fullName, "$$a");
        boolean withTargs = TypeGenerator.generateParameters(cdef.getTypeParameterList(), that.getParameterList(), container, gen);
        String me = gen.getNames().self(container);
        gen.beginBlock();
        gen.initParameters(that.getParameterList(), container, null);
        if (delcons != null) {
            TypeGenerator.callSuperclass(delcons.getType(), delcons.getInvocationExpression(), container, superplist, that, callAbstract, null, gen);
        }
        gen.generateConstructorStatements(that, Constructors.classStatementsBetweenConstructors(cdef, delcons, that, gen));
        gen.out("return ", me, ";");
        gen.endBlockNewLine(true);
        gen.out("function ", fullName);
        TypeGenerator.generateParameters(cdef.getTypeParameterList(), that.getParameterList(), container, gen);
        gen.beginBlock();
        if (!d.isAbstract()) {
            gen.out("$init$", gen.getNames().name(container), "();");
            gen.endLine();
            gen.declareSelf(container);
            gen.referenceOuter(container);
        }
        gen.initParameters(that.getParameterList(), container, null);
        if (!d.isAbstract()) {
            gen.out(gen.getNames().name(container), "$$c(");
            if (withTargs) {
                gen.out("$$targs$$,", new String[0]);
            }
            gen.out(me, ");");
            gen.endLine();
        }
        gen.out(fullName, "$$a");
        TypeGenerator.generateParameters(cdef.getTypeParameterList(), that.getParameterList(), container, gen);
        gen.endLine(true);
        if (d.isNative()) {
            gen.stitchConstructorHelper(cdef, "_cons_before");
        }
        gen.visitStatements(Constructors.classStatementsAfterConstructor(cdef, that));
        if (d.isNative()) {
            gen.stitchConstructorHelper(cdef, "_cons_after");
        }
        gen.out("return ", me, ";");
        gen.endBlockNewLine(true);
    }

    static List<? extends Tree.Statement> classStatementsBetweenConstructors(Tree.ClassDefinition cdef, Tree.DelegatedConstructor dc, Tree.Declaration c2, GenerateJsVisitor gen) {
        List<Tree.Statement> origs = cdef.getClassBody().getStatements();
        if (NativeUtil.isForBackend(cdef.getDeclarationModel(), Backend.JavaScript)) {
            Tree.Declaration nh = gen.getNativeHeader(cdef.getDeclarationModel());
            if (nh == null && NativeUtil.hasNativeMembers(cdef.getDeclarationModel())) {
                nh = cdef;
            }
            origs = NativeUtil.mergeStatements(cdef.getClassBody(), nh, Backend.JavaScript);
        }
        ArrayList<Tree.Statement> stmts = new ArrayList<Tree.Statement>(origs.size());
        Tree.Constructor c1 = null;
        if (dc != null) {
            TypeDeclaration xtd = (TypeDeclaration)((Tree.ExtendedTypeExpression)dc.getInvocationExpression().getPrimary()).getDeclaration();
            if (xtd instanceof Class && xtd == cdef.getDeclarationModel()) {
                for (Tree.Statement st : origs) {
                    if (!(st instanceof Tree.Constructor) || ((Tree.Constructor)st).getDeclarationModel().getName() != null) continue;
                    c1 = (Tree.Constructor)st;
                    break;
                }
            } else {
                for (Tree.Statement st : origs) {
                    if (!(st instanceof Tree.Constructor) || TypeUtils.getConstructor(((Tree.Constructor)st).getDeclarationModel()) != xtd) continue;
                    c1 = (Tree.Constructor)st;
                    break;
                }
            }
        }
        boolean go = false;
        for (Tree.Statement st : origs) {
            if (st == c1 || c1 == null) {
                go = true;
            }
            if (st == c2) {
                if (c2 instanceof Tree.Constructor) {
                    stmts.addAll(((Tree.Constructor)c2).getBlock().getStatements());
                } else if (c2 instanceof Tree.Enumerated) {
                    stmts.addAll(((Tree.Enumerated)c2).getBlock().getStatements());
                }
                return stmts;
            }
            if (!go || st instanceof Tree.Constructor) continue;
            stmts.add(st);
        }
        return null;
    }

    static List<? extends Tree.Statement> classStatementsAfterConstructor(Tree.ClassDefinition cdef, Tree.Declaration cnstr) {
        ArrayList<Tree.Statement> stmts = new ArrayList<Tree.Statement>(cdef.getClassBody().getStatements().size());
        boolean go = false;
        for (Tree.Statement st : cdef.getClassBody().getStatements()) {
            if (st == cnstr) {
                go = true;
                continue;
            }
            if (!go || st instanceof Tree.Constructor) continue;
            stmts.add(st);
        }
        return stmts;
    }
}

