/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.compiler.js.DiagnosticListener;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.parser.RecognitionError;
import com.redhat.ceylon.compiler.typechecker.tree.AnalysisMessage;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.UnexpectedError;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ErrorCollectingVisitor
extends Visitor {
    private TypeChecker tc;
    private List<PositionedMessage> analErrors = new ArrayList<PositionedMessage>();
    private List<PositionedMessage> recogErrors = new ArrayList<PositionedMessage>();

    public ErrorCollectingVisitor(TypeChecker tc) {
        this.tc = tc;
    }

    public int getErrorCount() {
        int errCount = 0;
        for (PositionedMessage pm : this.analErrors) {
            if (!(pm.message instanceof AnalysisError) && !(pm.message instanceof UnexpectedError)) continue;
            ++errCount;
        }
        return errCount;
    }

    public Set<Message> getErrors() {
        LinkedHashSet<Message> result = new LinkedHashSet<Message>();
        if (!this.recogErrors.isEmpty()) {
            for (PositionedMessage pm : this.recogErrors) {
                result.add(pm.message);
            }
        } else {
            for (PositionedMessage pm : this.analErrors) {
                result.add(pm.message);
            }
        }
        return result;
    }

    public void clear() {
        this.recogErrors.clear();
        this.analErrors.clear();
    }

    private void addErrors(Node that) {
        for (Message m : that.getErrors()) {
            if (m instanceof AnalysisMessage) {
                this.analErrors.add(new PositionedMessage((AnalysisMessage)m));
                continue;
            }
            this.recogErrors.add(new PositionedMessage(that, (RecognitionError)m));
        }
    }

    @Override
    public void visitAny(Node that) {
        super.visitAny(that);
        this.addErrors(that);
    }

    @Override
    public void visit(Tree.Declaration that) {
        if (TreeUtil.isForBackend(that.getAnnotationList(), Backend.JavaScript, that.getUnit()) || TreeUtil.isForBackend(that.getAnnotationList(), Backend.Header, that.getUnit())) {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        if (TreeUtil.isForBackend(that.getAnnotationList(), Backend.JavaScript, that.getUnit()) || TreeUtil.isForBackend(that.getAnnotationList(), Backend.Header, that.getUnit())) {
            super.visit(that);
        } else {
            this.addErrors(that);
        }
    }

    @Override
    public void visit(Tree.ImportModule that) {
        if (TreeUtil.isForBackend(that.getAnnotationList(), Backend.JavaScript, that.getUnit()) || TreeUtil.isForBackend(that.getAnnotationList(), Backend.Header, that.getUnit())) {
            super.visit(that);
        }
    }

    public int printErrors(boolean printWarnings, boolean printCount) throws IOException {
        return this.printErrors(new OutputStreamWriter(System.out), null, printWarnings, printCount);
    }

    public int printErrors(Writer out, DiagnosticListener diagnosticListener, boolean printWarnings, boolean printCount) throws IOException {
        int warnings = 0;
        int count = 0;
        List<PositionedMessage> errors = !this.recogErrors.isEmpty() ? this.recogErrors : this.analErrors;
        for (PositionedMessage pm : errors) {
            Message err = pm.message;
            if (err instanceof UsageWarning && (!printWarnings || ((UsageWarning)err).isSuppressed())) continue;
            Node node = TreeUtil.getIdentifyingNode(pm.node);
            int line = err.getLine();
            int position = -1;
            if (err instanceof AnalysisMessage) {
                if (node != null && node.getToken() != null) {
                    position = node.getToken().getCharPositionInLine();
                }
            } else if (err instanceof RecognitionError) {
                position = ((RecognitionError)err).getCharacterInLine();
            }
            String fileName = node.getUnit() != null ? node.getUnit().getFullPath() : "unknown";
            out.write(OSUtil.color(fileName, OSUtil.Color.blue));
            out.write(":");
            out.write(String.format("%d", line));
            out.write(": ");
            if (err instanceof UsageWarning) {
                out.write(OSUtil.color("warning", OSUtil.Color.yellow));
                ++warnings;
            } else {
                out.write(OSUtil.color("error", OSUtil.Color.red));
                ++count;
            }
            out.write(": ");
            out.write(err.getMessage());
            out.write(System.lineSeparator());
            String ln = this.getErrorSourceLine(pm);
            if (ln != null) {
                out.write(ln);
                out.write(System.lineSeparator());
                out.write(this.getErrorMarkerLine(position));
                out.write(System.lineSeparator());
            }
            if (diagnosticListener == null) continue;
            File file = null;
            boolean warning = err instanceof UsageWarning;
            if (node.getUnit() != null && node.getUnit().getFullPath() != null) {
                file = new File(node.getUnit().getFullPath()).getAbsoluteFile();
            }
            if (position != -1) {
                ++position;
            }
            if (warning) {
                diagnosticListener.warning(file, line, position, err.getMessage());
                continue;
            }
            diagnosticListener.error(file, line, position, err.getMessage());
        }
        if (printCount) {
            if (count > 0) {
                out.write(String.format("%d %s%n", count, count == 1 ? "error" : "errors"));
            }
            if (warnings > 0) {
                out.write(String.format("%d %s%n", warnings, warnings == 1 ? "warning" : "warnings"));
            }
        }
        out.flush();
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getErrorSourceLine(PositionedMessage pm) {
        if (pm.node.getUnit() == null) return null;
        int lineNr = pm.message.getLine();
        File file = new File(pm.node.getUnit().getFullPath());
        VirtualFile vfile = this.tc.getContext().getVfs().getFromFile(file);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(vfile.getInputStream()));){
            String line;
            do {
                if ((line = br.readLine()) == null) return null;
            } while (--lineNr > 0);
            String string = line;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getErrorMarkerLine(int position) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < position; ++i) {
            str.append(" ");
        }
        str.append("^");
        return str.toString();
    }

    public static class PositionedMessage {
        public Node node;
        public Message message;

        PositionedMessage(Node that, RecognitionError err) {
            this.node = that;
            this.message = err;
        }

        PositionedMessage(AnalysisMessage msg) {
            this.node = msg.getTreeNode();
            this.message = msg;
        }
    }
}

