/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.BmeGenerator;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.Map;

public class Operators {
    static void unwrappedNumberOrTerm(Tree.Term term, boolean wrapFloat, GenerateJsVisitor gen) {
        if (term instanceof Tree.NaturalLiteral) {
            gen.out("(", Long.toString(gen.parseNaturalLiteral((Tree.NaturalLiteral)term, false)), ")");
        } else if (term instanceof Tree.FloatLiteral) {
            if (wrapFloat) {
                gen.out(gen.getClAlias(), "Float(", term.getText(), ")");
            } else {
                gen.out("(", term.getText(), ")");
            }
        } else {
            gen.box(term);
        }
    }

    static void simpleBinaryOp(Tree.BinaryOperatorExpression exp, String before, String op, String after, GenerateJsVisitor gen) {
        if (before != null) {
            gen.out(before, new String[0]);
        }
        if (op.charAt(0) != '.' && exp.getLeftTerm() instanceof Tree.NaturalLiteral) {
            gen.out("(", Long.toString(gen.parseNaturalLiteral((Tree.NaturalLiteral)exp.getLeftTerm(), false)), ")");
        } else {
            Operators.unwrappedNumberOrTerm(exp.getLeftTerm(), ".divided(".equals(op), gen);
        }
        gen.out(op, new String[0]);
        Operators.unwrappedNumberOrTerm(exp.getRightTerm(), ".divided(".equals(op), gen);
        if (after != null) {
            gen.out(after, new String[0]);
        }
    }

    static void genericBinaryOp(Tree.BinaryOperatorExpression exp, String op, Map<TypeParameter, Type> targs, Map<TypeParameter, SiteVariance> overrides, GenerateJsVisitor gen) {
        if (op.charAt(0) != '.' && exp.getLeftTerm() instanceof Tree.NaturalLiteral) {
            gen.out(Long.toString(gen.parseNaturalLiteral((Tree.NaturalLiteral)exp.getLeftTerm(), false)), new String[0]);
        } else {
            gen.box(exp.getLeftTerm());
        }
        gen.out(op, new String[0]);
        if (exp.getRightTerm() instanceof Tree.NaturalLiteral) {
            gen.out(Long.toString(gen.parseNaturalLiteral((Tree.NaturalLiteral)exp.getRightTerm(), false)), new String[0]);
        } else {
            gen.box(exp.getRightTerm());
        }
        if (targs != null) {
            gen.out(",", new String[0]);
            TypeUtils.printTypeArguments(exp, targs, gen, false, overrides);
        }
        gen.out(")", new String[0]);
    }

    static void unaryOp(Tree.UnaryOperatorExpression exp, String before, String after, GenerateJsVisitor gen) {
        if (before != null) {
            gen.out(before, new String[0]);
        }
        if ((after == null || after.charAt(0) != '.') && exp.getTerm() instanceof Tree.NaturalLiteral) {
            gen.out(Long.toString(gen.parseNaturalLiteral((Tree.NaturalLiteral)exp.getTerm(), false)), new String[0]);
        } else {
            int boxTypeLeft = gen.boxStart(exp.getTerm());
            exp.getTerm().visit(gen);
            if (boxTypeLeft == 4) {
                gen.out("/*TODO: callable targs 9*/", new String[0]);
            }
            gen.boxUnboxEnd(boxTypeLeft);
        }
        if (after != null) {
            gen.out(after, new String[0]);
        }
    }

    static void prefixIncrementOrDecrement(Tree.Term term, String functionName, GenerateJsVisitor gen) {
        if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            boolean simpleSetter = gen.hasSimpleGetterSetter(bme.getDeclaration());
            String getMember = gen.memberAccess(bme, null);
            String applyFunc = String.format("%s.%s", getMember, functionName);
            gen.out("(", new String[0]);
            BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)bme, applyFunc, null, gen);
            if (!simpleSetter) {
                gen.out(",", getMember);
            }
            gen.out(")", new String[0]);
        } else if (term instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression qme = (Tree.QualifiedMemberExpression)term;
            String primaryVar = gen.createRetainedTempVar();
            String getMember = gen.memberAccess(qme, primaryVar);
            String applyFunc = String.format("%s.%s", getMember, functionName);
            gen.out("(", primaryVar, "=");
            qme.getPrimary().visit(gen);
            gen.out(",", new String[0]);
            BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)qme, applyFunc, primaryVar, gen);
            if (!gen.hasSimpleGetterSetter(qme.getDeclaration())) {
                gen.out(",", getMember);
            }
            gen.out(")", new String[0]);
        }
    }

    static void postfixIncrementOrDecrement(Tree.Term term, String functionName, GenerateJsVisitor gen) {
        if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            if (bme.getDeclaration() == null && gen.isInDynamicBlock()) {
                gen.out(bme.getIdentifier().getText(), "successor".equals(functionName) ? "++" : "--");
                return;
            }
            String oldValueVar = gen.createRetainedTempVar();
            String applyFunc = String.format("%s.%s", oldValueVar, functionName);
            gen.out("(", oldValueVar, "=", gen.memberAccess(bme, null), ",");
            BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)bme, applyFunc, null, gen);
            gen.out(",", oldValueVar, ")");
        } else if (term instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression qme = (Tree.QualifiedMemberExpression)term;
            if (qme.getDeclaration() == null && gen.isInDynamicBlock()) {
                gen.out(qme.getIdentifier().getText(), "successor".equals(functionName) ? "++" : "--");
                return;
            }
            String primaryVar = gen.createRetainedTempVar();
            String oldValueVar = gen.createRetainedTempVar();
            String applyFunc = String.format("%s.%s", oldValueVar, functionName);
            gen.out("(", primaryVar, "=");
            qme.getPrimary().visit(gen);
            gen.out(",", oldValueVar, "=", gen.memberAccess(qme, primaryVar), ",");
            BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)qme, applyFunc, primaryVar, gen);
            gen.out(",", oldValueVar, ")");
        }
    }

    static void indexOp(Tree.IndexExpression that, GenerateJsVisitor gen) {
        that.getPrimary().visit(gen);
        Tree.ElementOrRange eor = that.getElementOrRange();
        if (eor instanceof Tree.Element) {
            String _end;
            Tree.Expression _elemexpr = ((Tree.Element)eor).getExpression();
            if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getPrimary().getTypeModel())) {
                gen.out("[", new String[0]);
                _end = "]";
            } else {
                gen.out(".$_get(", new String[0]);
                _end = ")";
            }
            if (!gen.isNaturalLiteral(_elemexpr.getTerm())) {
                _elemexpr.visit(gen);
            }
            gen.out(_end, new String[0]);
        } else {
            Tree.ElementRange er = (Tree.ElementRange)eor;
            Tree.Expression sexpr = er.getLength();
            if (sexpr == null) {
                if (er.getLowerBound() == null) {
                    gen.out(".spanTo(", new String[0]);
                } else if (er.getUpperBound() == null) {
                    gen.out(".spanFrom(", new String[0]);
                } else {
                    gen.out(".span(", new String[0]);
                }
            } else {
                gen.out(".measure(", new String[0]);
            }
            if (er.getLowerBound() != null) {
                if (!gen.isNaturalLiteral(er.getLowerBound().getTerm())) {
                    er.getLowerBound().visit(gen);
                }
                if (er.getUpperBound() != null || sexpr != null) {
                    gen.out(",", new String[0]);
                }
            }
            if (er.getUpperBound() != null) {
                if (!gen.isNaturalLiteral(er.getUpperBound().getTerm())) {
                    er.getUpperBound().visit(gen);
                }
            } else if (sexpr != null) {
                sexpr.visit(gen);
            }
            gen.out(")", new String[0]);
        }
    }

    static void segmentOrRange(Tree.BinaryOperatorExpression that, String op, String typeArgumentName, GenerateJsVisitor gen) {
        Tree.Term left = that.getLeftTerm();
        Tree.Term right = that.getRightTerm();
        gen.out(gen.getClAlias(), op, "(");
        left.visit(gen);
        gen.out(",", new String[0]);
        right.visit(gen);
        gen.out(",{", typeArgumentName, "$", op, ":");
        TypeUtils.typeNameOrList(that, ModelUtil.unionType(left.getTypeModel(), right.getTypeModel(), that.getUnit()), gen, false);
        gen.out("})", new String[0]);
    }

    static void withinOp(Tree.WithinOp that, GenerateJsVisitor gen) {
        String ttmp = gen.getNames().createTempVariable();
        gen.out("(", ttmp, "=");
        gen.box(that.getTerm());
        gen.out(",", new String[0]);
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getTerm().getTypeModel())) {
            String tmpl = gen.getNames().createTempVariable();
            String tmpu = gen.getNames().createTempVariable();
            gen.out(tmpl, "=");
            gen.box(that.getLowerBound().getTerm());
            gen.out(",", tmpu, "=");
            gen.box(that.getUpperBound().getTerm());
            gen.out(",(", gen.getClAlias(), "nn$(", ttmp, ")&&");
            if (that.getLowerBound() instanceof Tree.OpenBound) {
                gen.out(ttmp, ".largerThan&&", ttmp, ".largerThan(", tmpl, ")||", ttmp, ">", tmpl, ")");
            } else {
                gen.out(ttmp, ".notSmallerThan&&", ttmp, ".notSmallerThan(", tmpl, ")||", ttmp, ">=", tmpl, ")");
            }
            gen.out("&&(", gen.getClAlias(), "nn$(", ttmp, ")&&");
            if (that.getUpperBound() instanceof Tree.OpenBound) {
                gen.out(ttmp, ".smallerThan&&", ttmp, ".smallerThan(", tmpu, ")||", ttmp, "<", tmpu, ")");
            } else {
                gen.out(ttmp, ".notLargerThan&&", ttmp, ".notLargerThan(", tmpu, ")||", ttmp, "<=", tmpu, ")");
            }
        } else {
            if (that.getLowerBound() instanceof Tree.OpenBound) {
                gen.out(ttmp, ".largerThan(");
            } else {
                gen.out(ttmp, ".notSmallerThan(");
            }
            gen.box(that.getLowerBound().getTerm());
            gen.out(")&&", new String[0]);
            if (that.getUpperBound() instanceof Tree.OpenBound) {
                gen.out(ttmp, ".smallerThan(");
            } else {
                gen.out(ttmp, ".notLargerThan(");
            }
            gen.box(that.getUpperBound().getTerm());
            gen.out(")", new String[0]);
        }
        gen.out(")", new String[0]);
    }

    static void largeAs(Tree.LargeAsOp that, GenerateJsVisitor gen) {
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "notSmallerThan", ">=", null, gen);
        } else {
            boolean usenat = gen.canUseNativeComparator(that.getLeftTerm(), that.getRightTerm());
            if (usenat) {
                Operators.simpleBinaryOp(that, "(", ">=", ")", gen);
            } else {
                Operators.simpleBinaryOp(that, null, ".notSmallerThan(", ")", gen);
            }
        }
    }

    static void smallAs(Tree.SmallAsOp that, GenerateJsVisitor gen) {
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "notLargerThan", "<=", null, gen);
        } else {
            boolean usenat = gen.canUseNativeComparator(that.getLeftTerm(), that.getRightTerm());
            if (usenat) {
                Operators.simpleBinaryOp(that, "(", "<=", ")", gen);
            } else {
                Operators.simpleBinaryOp(that, null, ".notLargerThan(", ")", gen);
            }
        }
    }

    static void larger(Tree.LargerOp that, GenerateJsVisitor gen) {
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "largerThan", ">", null, gen);
        } else {
            boolean usenat = gen.canUseNativeComparator(that.getLeftTerm(), that.getRightTerm());
            if (usenat) {
                Operators.simpleBinaryOp(that, "(", ">", ")", gen);
            } else {
                Operators.simpleBinaryOp(that, null, ".largerThan(", ")", gen);
            }
        }
    }

    static void smaller(Tree.SmallerOp that, GenerateJsVisitor gen) {
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "smallerThan", "<", null, gen);
        } else {
            boolean usenat = gen.canUseNativeComparator(that.getLeftTerm(), that.getRightTerm());
            if (usenat) {
                Operators.simpleBinaryOp(that, "(", "<", ")", gen);
            } else {
                Operators.simpleBinaryOp(that, null, ".smallerThan(", ")", gen);
            }
        }
    }

    static void notEqual(Tree.NotEqualOp that, GenerateJsVisitor gen) {
        gen.out("!", new String[0]);
        Operators.builtInBinaryOp(that, "$eq$", gen);
    }

    static void equal(Tree.EqualOp that, GenerateJsVisitor gen) {
        if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.builtInBinaryOp(that, "$eq$", gen);
        } else {
            boolean usenat = gen.canUseNativeComparator(that.getLeftTerm(), that.getRightTerm());
            if (usenat) {
                gen.out("(", new String[0]);
                that.getLeftTerm().visit(gen);
                gen.out("==", new String[0]);
                that.getRightTerm().visit(gen);
                gen.out(")", new String[0]);
            } else {
                Operators.builtInBinaryOp(that, "$eq$", gen);
            }
        }
    }

    static void builtInBinaryOp(Tree.BinaryOperatorExpression that, String builtInOp, GenerateJsVisitor gen) {
        gen.out(gen.getClAlias(), builtInOp, "(");
        gen.box(that.getLeftTerm());
        gen.out(",", new String[0]);
        gen.box(that.getRightTerm());
        gen.out(")", new String[0]);
    }

    static void nativeBinaryOp(Tree.BinaryOperatorExpression that, String method, String op, String post, GenerateJsVisitor gen) {
        String ltmp = gen.getNames().createTempVariable();
        String rtmp = gen.getNames().createTempVariable();
        gen.out("(", ltmp, "=");
        gen.box(that.getLeftTerm());
        gen.out(",", rtmp, "=");
        gen.box(that.getRightTerm());
        gen.out(",(", gen.getClAlias(), "nn$(", ltmp, ")&&", ltmp, ".", method, "&&", ltmp, ".", method, "(", rtmp, ")");
        if (post != null) {
            gen.out(post, new String[0]);
        }
        gen.out(")||", ltmp, op, rtmp, ")");
    }

    static void neg(Tree.NegativeOp that, GenerateJsVisitor gen) {
        Tree.Term term = that.getTerm();
        if (term instanceof Tree.Expression) {
            term = ((Tree.Expression)term).getTerm();
        }
        if (term instanceof Tree.NaturalLiteral) {
            long t = gen.parseNaturalLiteral((Tree.NaturalLiteral)term, true);
            gen.out("(", Long.toString(t), ")");
            return;
        }
        Type d = term.getTypeModel();
        boolean useMinus = d != null && d.isSubtypeOf(that.getUnit().getIntegerType()) || gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(d);
        Operators.unaryOp(that, useMinus ? "(-" : null, useMinus ? ")" : ".negated", gen);
    }

    static void generateSafeOp(Tree.QualifiedMemberOrTypeExpression that, GenerateJsVisitor gen) {
        boolean isMethod = that.getDeclaration() instanceof Function;
        String lhsVar = gen.createRetainedTempVar();
        gen.out("(", lhsVar, "=");
        gen.supervisit(that);
        gen.out(",", new String[0]);
        if (isMethod) {
            gen.out(gen.getClAlias(), "jsc$3(", lhsVar, ",");
        }
        gen.out(gen.getClAlias(), "nn$(", lhsVar, ")?");
        if (isMethod && !((Function)that.getDeclaration()).getTypeParameters().isEmpty()) {
            BmeGenerator.printGenericMethodReference(gen, that, lhsVar, gen.memberAccess(that, lhsVar));
        } else {
            gen.out(gen.memberAccess(that, lhsVar), new String[0]);
        }
        gen.out(":null)", new String[0]);
        if (isMethod) {
            gen.out(")", new String[0]);
        }
    }
}

