/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SerializationHelper {
    static void addSerializer(Node node, Class d, GenerateJsVisitor gen) {
    }

    private static void serializeGetter(Node that, String typename, Class owner, List<Value> vals, Class supertype, GenerateJsVisitor gen) {
        gen.out(typename, ".ser$get$=function(ref,o){");
        if (!vals.isEmpty()) {
            gen.out("var n=ref.attribute.qualifiedName;", new String[0]);
        }
        boolean first = true;
        for (Value v : vals) {
            if (first) {
                first = false;
            } else {
                gen.out("else ", new String[0]);
            }
            String vname = SerializationHelper.name(owner, v, gen);
            gen.out("if(n==='", v.getQualifiedNameString(), "')return o.", vname);
            if (v.isLate()) {
                gen.out("===undefined?", gen.getClAlias(), "uninitializedLateValue$serialization():o.", vname);
            }
            gen.endLine(true);
        }
        if (!first) {
            gen.out("else ", new String[0]);
        }
        if (supertype != null) {
            gen.out("return ", new String[0]);
            gen.qualify(that, supertype);
            gen.out(gen.getNames().name(supertype), ".ser$get$(ref,o);");
        } else {
            gen.out("throw new TypeError('unknown attribute');", new String[0]);
        }
        gen.endBlockNewLine(true);
    }

    private static void serializeSetter(Node that, String typename, Class owner, List<Value> vals, Class supertype, GenerateJsVisitor gen) {
        gen.out(typename, ".ser$set$=function(ref,o,i){", "if(!", gen.getClAlias(), "is$(ref,{t:", gen.getClAlias(), "Member$serialization}))", "throw ", gen.getClAlias(), "AssertionError('unexpected reachable reference');");
        if (!vals.isEmpty()) {
            gen.out("var n=ref.attribute.qualifiedName;", new String[0]);
        }
        gen.endLine();
        boolean first = true;
        for (Value v : vals) {
            if (first) {
                first = false;
            } else {
                gen.out("else ", new String[0]);
            }
            gen.out("if(n==='", v.getQualifiedNameString(), "')");
            if (v.isLate()) {
                gen.out("{if (i!==", gen.getClAlias(), "uninitializedLateValue$serialization())");
            }
            gen.out("o.", SerializationHelper.name(owner, v, gen), "=i;");
            if (v.isLate()) {
                gen.out("}", new String[0]);
            }
            gen.endLine();
        }
        if (!first) {
            gen.out("else ", new String[0]);
        }
        if (supertype != null) {
            gen.qualify(that, supertype);
            gen.out(gen.getNames().name(supertype), ".ser$get$(ref,o,i);");
        } else {
            gen.out("throw new TypeError('unknown attribute');", new String[0]);
        }
        gen.endBlockNewLine(true);
    }

    private static void serializeRefs(Node that, String typename, Class owner, List<Value> vals, Class supertype, GenerateJsVisitor gen) {
        if (supertype == null) {
            gen.out(typename, ".ser$refs$=function(o){return [");
        } else {
            gen.out(typename, ".ser$refs$=function(o){var a=");
            gen.qualify(that, supertype);
            gen.out(gen.getNames().name(supertype), ".ser$refs$(o);a.push(");
        }
        boolean first = true;
        String pkgname = owner.getUnit().getPackage().getNameAsString();
        for (Value v : vals) {
            if (first) {
                first = false;
            } else {
                gen.out(",", new String[0]);
            }
            gen.out(gen.getClAlias(), "MemberImpl$impl(", gen.getClAlias(), "OpenValue$jsint(", gen.getClAlias(), "lmp$(ex$,'", "ceylon.language".equals(pkgname) ? "$" : pkgname, "'),o.", gen.getNames().getter(v, true), "))");
        }
        if (supertype == null) {
            gen.out("];", new String[0]);
        } else {
            gen.out(");return a;", new String[0]);
        }
        gen.endBlockNewLine(true);
    }

    static void addDeserializer(Node that, Class d, GenerateJsVisitor gen) {
        String cmodel = gen.getNames().createTempVariable();
        String ni = gen.getNames().self(d);
        String typename = gen.getNames().name(d);
        gen.out(typename, ".inst$$=function(", cmodel, ")");
        gen.beginBlock();
        if (d.isMember()) {
            gen.out("/*TODO getOuterInstance*/", new String[0]);
        }
        gen.out("var ", ni, "=new ", gen.getNames().name(d), ".$$;");
        gen.endLine();
        boolean first = true;
        for (TypeParameter tp : d.getTypeParameters()) {
            if (first) {
                gen.out(gen.getClAlias(), "set_type_args(", ni, ",{");
                first = false;
            } else {
                gen.out(",", new String[0]);
            }
            gen.out(tp.getName(), "$", d.getName(), ":", cmodel, ".$$targs$$.Type$Class.a.", tp.getName(), "$", d.getName());
        }
        if (!first) {
            gen.out("});", new String[0]);
            gen.endLine();
        }
        SerializationHelper.setDeserializedTypeArguments(d, d.getExtendedType(), true, that, ni, gen, new HashSet<TypeDeclaration>());
        gen.out("return ", ni, ";");
        gen.endBlockNewLine(true);
        List<Value> vals = SerializationHelper.serializableValues(d);
        Class supertype = d.getExtendedType() != null && d.getExtendedType().getDeclaration() != null && d.getExtendedType().getDeclaration() instanceof Class && ((Class)d.getExtendedType().getDeclaration()).isSerializable() ? (Class)d.getExtendedType().getDeclaration() : null;
        SerializationHelper.serializeGetter(that, typename, d, vals, supertype, gen);
        SerializationHelper.serializeSetter(that, typename, d, vals, supertype, gen);
        SerializationHelper.serializeRefs(that, typename, d, vals, supertype, gen);
    }

    private static void setDeserializedTypeArguments(Class root, Type pt, boolean first, Node that, String ni, GenerateJsVisitor gen, Set<TypeDeclaration> decs) {
        if (pt == null) {
            return;
        }
        boolean start = decs.isEmpty();
        List<Type> sats = start ? root.getSatisfiedTypes() : pt.getSatisfiedTypes();
        decs.add(root);
        while (pt != null && !root.getUnit().getBasicDeclaration().equals(pt.getDeclaration())) {
            if (!decs.contains(pt.getDeclaration())) {
                for (Map.Entry entry : pt.getTypeArguments().entrySet()) {
                    if (first) {
                        gen.out(gen.getClAlias(), "set_type_args(", ni, ",{");
                        first = false;
                    } else {
                        gen.out(",", new String[0]);
                    }
                    gen.out(((TypeParameter)entry.getKey()).getName(), "$", pt.getDeclaration().getName(), ":");
                    TypeUtils.typeNameOrList(that, (Type)entry.getValue(), gen, false);
                }
                decs.add(pt.getDeclaration());
                SerializationHelper.setDeserializedTypeArguments(root, pt, first, that, ni, gen, decs);
            }
            pt = pt.getExtendedType();
        }
        for (Type type : sats) {
            if (!decs.contains(type.getDeclaration())) {
                for (Map.Entry<TypeParameter, Type> tp : type.getTypeArguments().entrySet()) {
                    if (first) {
                        gen.out(gen.getClAlias(), "set_type_args(", ni, ",{");
                        first = false;
                    } else {
                        gen.out(",", new String[0]);
                    }
                    gen.out(tp.getKey().getName(), "$", type.getDeclaration().getName(), ":");
                    TypeUtils.typeNameOrList(that, tp.getValue(), gen, false);
                }
                decs.add(type.getDeclaration());
            }
            SerializationHelper.setDeserializedTypeArguments(root, type, first, that, ni, gen, decs);
        }
        if (!first && start) {
            gen.out("});", new String[0]);
            gen.endLine();
        }
    }

    static List<Value> serializableValues(Class d) {
        ArrayList<Value> vals = new ArrayList<Value>();
        for (Declaration m : d.getMembers()) {
            Value v;
            if (m.isFormal() || !(m instanceof Value) || m.isSetter() || !m.isCaptured() && !m.isShared() || (v = (Value)m).isTransient()) continue;
            vals.add(v);
        }
        return vals;
    }

    static String name(Class d, Value v, GenerateJsVisitor gen) {
        if (v.isParameter()) {
            return gen.getNames().name(d.getParameter(v.getName())) + "_";
        }
        return v.isLate() || v.isCaptured() ? gen.getNames().name(v) + "_" : gen.getNames().privateName(v);
    }
}

