/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.AttributeGenerator;
import com.redhat.ceylon.compiler.js.ClassGenerator;
import com.redhat.ceylon.compiler.js.Constructors;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.TypeGenerator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Singletons {
    static void defineObject(Node that, Value d, List<Type> sats, Tree.SimpleType superType, Tree.InvocationExpression superCall, Tree.Body body, Tree.AnnotationList annots, GenerateJsVisitor gen, GenerateJsVisitor.InitDeferrer initDeferrer) {
        List<Tree.Statement> stmts;
        Value natd;
        boolean addToPrototype = gen.opts.isOptimize() && d != null && d.isClassOrInterfaceMember();
        boolean isObjExpr = that instanceof Tree.ObjectExpression;
        TypeDeclaration _td = isObjExpr ? ((Tree.ObjectExpression)that).getAnonymousClass() : d.getTypeDeclaration();
        Class c = (Class)(_td instanceof Constructor ? _td.getContainer() : _td);
        String className = gen.getNames().name(c);
        String objectName = gen.getNames().name(d);
        String selfName = gen.getNames().self(c);
        Value value = natd = d == null ? null : (Value)ModelUtil.getNativeDeclaration((Declaration)d, Backend.JavaScript);
        if (that instanceof Tree.Declaration) {
            if (NativeUtil.isNativeHeader((Tree.Declaration)that) && natd != null) {
                gen.saveNativeHeader((Tree.Declaration)that);
                return;
            }
            if (!NativeUtil.isForBackend((Tree.Declaration)that, Backend.JavaScript) && !NativeUtil.isHeaderWithoutBackend((Tree.Declaration)that, Backend.JavaScript)) {
                return;
            }
        }
        if (d != null && NativeUtil.isForBackend(d, Backend.JavaScript)) {
            Tree.Declaration nh = gen.getNativeHeader(d);
            if (nh == null && NativeUtil.hasNativeMembers(c) && that instanceof Tree.Declaration) {
                nh = (Tree.Declaration)that;
            }
            stmts = NativeUtil.mergeStatements(body, nh, Backend.JavaScript);
        } else {
            stmts = body.getStatements();
        }
        HashMap<TypeParameter, Type> targs = new HashMap<TypeParameter, Type>();
        if (sats != null) {
            for (Type st : sats) {
                Map<TypeParameter, Type> stargs = st.getTypeArguments();
                if (stargs == null || stargs.isEmpty()) continue;
                targs.putAll(stargs);
            }
        }
        gen.out("function ", className, targs.isEmpty() ? "()" : "($$targs$$)");
        gen.beginBlock();
        if (isObjExpr) {
            gen.out("var ", selfName, "=new ", className, ".$$;");
            ClassOrInterface coi = ModelUtil.getContainingClassOrInterface(c.getContainer());
            if (coi != null) {
                gen.out(selfName, ".outer$=", gen.getNames().self(coi));
                gen.endLine(true);
            }
        } else {
            if (c.isMember() && !d.isStatic()) {
                gen.initSelf(that);
            }
            gen.instantiateSelf(c);
            gen.referenceOuter(c);
        }
        ArrayList<Declaration> superDecs = new ArrayList<Declaration>();
        if (!gen.opts.isOptimize()) {
            GenerateJsVisitor.SuperVisitor superv = new GenerateJsVisitor.SuperVisitor(superDecs);
            for (Tree.Statement st : stmts) {
                st.visit(superv);
            }
        }
        if (!targs.isEmpty()) {
            gen.out(selfName, ".$$targs$$=$$targs$$");
            gen.endLine(true);
        }
        TypeGenerator.callSupertypes(sats, superType, c, that, superDecs, superCall, superType == null ? null : ((Class)c.getExtendedType().getDeclaration()).getParameterList(), gen);
        gen.visitStatements(stmts);
        gen.out("return ", selfName, ";");
        gen.endBlock();
        gen.out(";", className, ".$crtmm$=");
        TypeUtils.encodeForRuntime(that, c, gen);
        gen.endLine(true);
        TypeGenerator.initializeType(that, gen, initDeferrer);
        String objvar = (addToPrototype ? "this." : "") + gen.getNames().createTempVariable();
        if (d != null && !addToPrototype) {
            gen.out("var ", objvar);
            if (AttributeGenerator.defineAsProperty(d)) {
                gen.out("=", className, "(");
                if (!targs.isEmpty()) {
                    TypeUtils.printTypeArguments(that, targs, gen, false, null);
                }
                gen.out(")", new String[0]);
            }
            gen.endLine(true);
        }
        if (d != null && AttributeGenerator.defineAsProperty(d)) {
            gen.out(gen.getClAlias(), "atr$(");
            gen.outerSelf(d);
            gen.out(",'", objectName, "',function(){return ");
            if (addToPrototype) {
                gen.out("this.", gen.getNames().privateName(d));
            } else {
                gen.out(objvar, new String[0]);
            }
            gen.out(";},undefined,", new String[0]);
            TypeUtils.encodeForRuntime(that, (Declaration)d, annots, gen);
            gen.out(")", new String[0]);
            gen.endLine(true);
        } else if (d != null) {
            String objectGetterName = gen.getNames().getter(d, false);
            gen.out("function ", objectGetterName, "()");
            gen.beginBlock();
            String oname = gen.getNames().objectName(c);
            gen.out("if(", objvar, "===", gen.getClAlias(), "INIT$)");
            gen.generateThrow(gen.getClAlias() + "InitializationError", "Cyclic initialization trying to read the value of '" + d.getName() + "' before it was set", that);
            gen.endLine(true);
            gen.out("if(", objvar, "===undefined){", objvar, "=", gen.getClAlias(), "INIT$;", objvar, "=$init$", oname);
            if (!oname.endsWith("()")) {
                gen.out("()", new String[0]);
            }
            gen.out("(", new String[0]);
            if (!targs.isEmpty()) {
                TypeUtils.printTypeArguments(that, targs, gen, false, null);
            }
            gen.out(");", objvar, ".$crtmm$=", objectGetterName, ".$crtmm$;}");
            gen.endLine();
            gen.out("return ", objvar, ";");
            gen.endBlockNewLine();
            if (addToPrototype || d.isShared()) {
                gen.outerSelf(d);
                gen.out(".", objectGetterName, "=", objectGetterName);
                gen.endLine(true);
            }
            if (!d.isToplevel() && gen.outerSelf(d)) {
                gen.out(".", new String[0]);
            }
            gen.out(objectGetterName, ".$crtmm$=");
            TypeUtils.encodeForRuntime(that, (Declaration)d, annots, gen);
            gen.endLine(true);
            gen.out(gen.getNames().getter(c, true), "=", objectGetterName);
            gen.endLine(true);
            if (d.isToplevel()) {
                String objectGetterNameMM = gen.getNames().getter(d, true);
                gen.out("ex$.", objectGetterNameMM, "=", objectGetterNameMM);
                gen.endLine(true);
            }
        } else if (isObjExpr) {
            gen.out("return ", className, "();");
        }
    }

    static void objectDefinition(Tree.ObjectDefinition that, GenerateJsVisitor gen, GenerateJsVisitor.InitDeferrer initDeferrer) {
        Tree.SatisfiedTypes sts = that.getSatisfiedTypes();
        Tree.ExtendedType et = that.getExtendedType();
        Singletons.defineObject(that, that.getDeclarationModel(), sts == null ? null : TypeUtils.getTypes(sts.getTypes()), et == null ? null : et.getType(), et == null ? null : et.getInvocationExpression(), that.getClassBody(), that.getAnnotationList(), gen, initDeferrer);
        if (!that.getDeclarationModel().isToplevel() && !that.getDeclarationModel().isClassOrInterfaceMember()) {
            gen.out(gen.getNames().objectName(that.getDeclarationModel()), "();");
        }
    }

    static void valueConstructor(Tree.ClassDefinition cdef, Tree.Enumerated that, GenerateJsVisitor gen) {
        Value d = that.getDeclarationModel();
        Constructor c = that.getEnumerated();
        Tree.DelegatedConstructor dc = that.getDelegatedConstructor();
        TypeDeclaration td = (TypeDeclaration)c.getContainer();
        String objvar = gen.getNames().createTempVariable();
        String selfvar = gen.getNames().self(td);
        String typevar = gen.getNames().name(td);
        String singvar = gen.getNames().name(d);
        boolean nested = cdef.getDeclarationModel().isClassOrInterfaceMember();
        String constructorName = typevar + gen.getNames().constructorSeparator(c) + singvar;
        gen.out(nested ? "this." : "var ", objvar, "=undefined;function ", constructorName, "(){if(", nested ? "this." : "", objvar, "===undefined){");
        if (dc == null) {
            gen.out("$init$", typevar, "();");
        }
        if (nested) {
            gen.out("var ", selfvar, "=");
        } else {
            gen.out(objvar, "=");
        }
        gen.out("new ", typevar, ".$$;");
        if (td.isClassOrInterfaceMember()) {
            gen.out(nested ? selfvar : objvar, ".outer$=this;");
        }
        if (dc != null) {
            Tree.InvocationExpression invoke = dc.getInvocationExpression();
            invoke.getPrimary().visit(gen);
            gen.out("(", new String[0]);
            gen.getInvoker().generatePositionalArguments(invoke.getPrimary(), invoke.getPositionalArgumentList(), invoke.getPositionalArgumentList().getPositionalArguments(), false, false);
            if (!invoke.getPositionalArgumentList().getPositionalArguments().isEmpty()) {
                gen.out(",", new String[0]);
            }
            if (!dc.getType().getTypeModel().getTypeArguments().isEmpty()) {
                TypeUtils.printTypeArguments(dc, dc.getType().getTypeModel().getTypeArguments(), gen, false, dc.getType().getTypeModel().getVarianceOverrides());
                gen.out(",", new String[0]);
            }
            gen.out(nested ? selfvar : objvar, ")");
            gen.endLine(true);
        }
        if (!nested) {
            gen.out("var ", selfvar, "=", objvar, ";");
        }
        ClassGenerator.addFunctionTypeArguments(cdef.getDeclarationModel(), objvar, gen);
        ClassGenerator.callSupertypes(cdef, cdef.getDeclarationModel(), typevar, gen);
        List<? extends Tree.Statement> stmts = Constructors.classStatementsBetweenConstructors(cdef, null, that, gen);
        if (!stmts.isEmpty()) {
            gen.generateConstructorStatements(that, stmts);
        }
        if (!(stmts = Constructors.classStatementsAfterConstructor(cdef, that)).isEmpty()) {
            gen.visitStatements(stmts);
        }
        if (nested) {
            gen.out("this.", objvar, "=", selfvar, ";");
        }
        gen.out("}return ", nested ? "this." : "", objvar, ";};", constructorName, ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), gen);
        gen.out(";", new String[0]);
        if (td.isClassOrInterfaceMember()) {
            gen.outerSelf(td);
            gen.out(".", constructorName, "=", constructorName, ";");
        } else if (td.isShared()) {
            gen.out("ex$.", constructorName, "=", constructorName, ";");
        }
        gen.out(gen.getNames().name(td), ".", constructorName, "=", constructorName);
        gen.endLine(true);
    }
}

