/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.js.loader.JsonModule;
import com.redhat.ceylon.compiler.js.loader.JsonPackage;
import com.redhat.ceylon.compiler.js.loader.LazyPackage;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.Arrays;
import java.util.List;

public class JsModuleManager
extends ModuleManager {
    public JsModuleManager(Context context, String encoding) {
    }

    @Override
    public Iterable<String> getSearchedArtifactExtensions() {
        return Arrays.asList("js");
    }

    @Override
    public Backends getSupportedBackends() {
        return Backend.JavaScript.asSet();
    }

    @Override
    protected Module createModule(List<String> moduleName, String version2) {
        JsonModule module = new JsonModule();
        module.setName(moduleName);
        module.setVersion(version2);
        Unit u = new Unit();
        u.setFilename("module.ceylon");
        u.setFullPath(moduleName + "/" + version2);
        module.setUnit(u);
        JsonModule dep = (JsonModule)this.findLoadedModule("ceylon.language", null);
        if (!module.isDefaultModule() && !module.isLanguageModule()) {
            if (dep == null) {
                dep = (JsonModule)this.getModules().getLanguageModule();
            }
            ModuleImport imp = new ModuleImport(null, dep, false, false);
            module.addImport(imp);
            module.setLanguageModule(dep);
        }
        return module;
    }

    @Override
    public Package createPackage(String pkgName, Module module) {
        Package pkg;
        if (module != null && module == this.getModules().getDefaultModule() && (pkg = module.getDirectPackage(pkgName)) != null) {
            return pkg;
        }
        pkg = new JsonPackage(pkgName);
        List<String> name = pkgName.isEmpty() ? Arrays.asList("") : JsModuleManager.splitModuleName(pkgName);
        ((LazyPackage)pkg).setName(name);
        if (module != null) {
            module.getPackages().add(pkg);
            ((JsonPackage)pkg).setModule(module);
        }
        return pkg;
    }
}

