/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.loader.JsonModule;
import com.redhat.ceylon.compiler.js.loader.LazyPackage;
import com.redhat.ceylon.compiler.js.loader.MetamodelGenerator;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.InterfaceAlias;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonPackage
extends LazyPackage {
    private static final Map<String, Object> idobj = new HashMap<String, Object>();
    private static final Map<String, Object> objclass = new HashMap<String, Object>();
    private static final Map<String, Object> voidclass = new HashMap<String, Object>();
    private Map<String, Object> model;
    private final String pkgname;
    private boolean loaded = false;
    private final Unit u2 = new Unit();
    private NothingType nothing = new NothingType(this.u2);
    private UnknownType unknown = new UnknownType(this.u2);
    boolean inLoadIfNecessary = false;

    public JsonPackage(String pkgname) {
        this.pkgname = pkgname;
        this.setName(ModuleManager.splitModuleName(pkgname));
    }

    @Override
    protected void loadIfNecessary() {
        if (!this.inLoadIfNecessary && !this.loaded && null != this.model) {
            this.inLoadIfNecessary = true;
            this.loadDeclarations();
            this.inLoadIfNecessary = false;
        }
    }

    @Override
    public void setModule(Module module) {
        if (module instanceof JsonModule && this.model == null) {
            this.model = ((JsonModule)module).getModelForPackage(this.getNameAsString());
            this.u2.setPackage(this);
            this.u2.setFilename("");
            this.u2.setFullPath("");
            this.u2.setRelativePath("");
            this.addUnit(this.u2);
            if (this.model != null) {
                Object pkgAnns;
                if (this.model.get("$pkg-pa") != null) {
                    int bits = (Integer)this.model.remove("$pkg-pa");
                    this.setShared(JsonPackage.hasAnnotationBit(bits, "shared"));
                }
                if ((pkgAnns = this.model.remove("$pkg-anns")) instanceof List) {
                    JsonPackage.setNewAnnotations(this.getAnnotations(), (List)pkgAnns);
                } else if (pkgAnns instanceof Map) {
                    JsonPackage.setOldAnnotations(this.getAnnotations(), (Map)pkgAnns);
                } else if (pkgAnns != null) {
                    throw new IllegalArgumentException("Annotations should be a List (new format) or a Map (old format)");
                }
            }
            if (module.getLanguageModule() == module && "ceylon.language".equals(this.pkgname)) {
                module.setAvailable(true);
            }
        }
        super.setModule(module);
    }

    Map<String, Object> getModel() {
        return this.model;
    }

    private void loadDeclarations() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (!this.isShared()) {
            this.setShared(this.model.remove("$pkg-shared") != null);
        }
        for (Map.Entry<String, Object> e : this.model.entrySet()) {
            TypeDeclaration td;
            String k = e.getKey();
            if (k.startsWith("$pkg-")) continue;
            Map m = (Map)e.getValue();
            if (m.get("mt") instanceof String) {
                String metatype = (String)m.get("mt");
                if ("c".equals(metatype)) {
                    this.refineMembers(this.loadClass(e.getKey(), m, this, null));
                    continue;
                }
                if ("i".equals(metatype)) {
                    this.refineMembers(this.loadInterface(e.getKey(), m, this, null));
                    continue;
                }
                if (metatype.equals("a") || metatype.equals("g")) {
                    this.loadAttribute(k, m, this, null);
                    continue;
                }
                if (metatype.equals("m")) {
                    this.loadMethod(k, m, this, null);
                    continue;
                }
                if (metatype.equals("o")) {
                    this.refineMembers((Class)this.loadObject(k, m, this, null));
                    continue;
                }
                if (!metatype.equals("als")) continue;
                this.loadTypeAlias(k, m, this, null);
                continue;
            }
            if (m.get("mt") == null) {
                throw new IllegalArgumentException("Missing metatype from entry " + m + " under " + e.getKey());
            }
            if (m.get("mt") instanceof ClassOrInterface) {
                this.refineMembers((ClassOrInterface)m.get("mt"));
                continue;
            }
            if (!(m.get("mt") instanceof Value) || (td = ((Value)m.get("mt")).getTypeDeclaration()) == null) continue;
            this.refineMembers((ClassOrInterface)td);
        }
    }

    Class loadClass(String name, Map<String, Object> m, Scope parent, List<TypeParameter> existing) {
        Map cdefs;
        Class cls;
        m.remove("nm");
        if (m.get("mt") instanceof Class) {
            cls = (Class)m.get("mt");
            if (m.size() <= 3) {
                return cls;
            }
        } else {
            cls = m.containsKey("$alias") ? new ClassAlias() : new Class();
            cls.setAbstract(m.remove("abstract") != null);
            cls.setAnonymous(m.remove("$anon") != null);
            cls.setDynamic(m.remove("dyn") != null);
            cls.setContainer(parent);
            cls.setScope(parent);
            cls.setName(name);
            cls.setUnit(this.u2);
            if (parent == this) {
                this.u2.addDeclaration(cls);
            }
            parent.addMember(cls);
            m.put("mt", cls);
            this.setAnnotations(cls, (Integer)m.remove("pa"), m.remove("an"));
        }
        List<TypeParameter> tparms = this.parseTypeParameters((List)m.remove("tp"), cls, existing);
        List<TypeParameter> allparms = JsonPackage.merge(tparms, existing);
        if (m.containsKey("st")) {
            for (TypeParameter typeParameter : tparms) {
                if (!typeParameter.getName().equals(m.get("st"))) continue;
                cls.setSelfType(typeParameter.getType());
            }
        }
        if (!(this.isLanguagePackage() && ("Nothing".equals(name) || "Anything".equals(name)) || cls.getExtendedType() != null)) {
            if (m.containsKey("super")) {
                Type father = this.getTypeFromJson((Map)m.get("super"), parent instanceof Declaration ? (Declaration)((Object)parent) : null, allparms);
                if (father != null) {
                    m.remove("super");
                    cls.setExtendedType(father);
                }
            } else {
                cls.setExtendedType(this.getTypeFromJson(idobj, parent instanceof Declaration ? (Declaration)((Object)parent) : null, allparms));
            }
        }
        if (cls instanceof ClassAlias) {
            ClassAlias ca = (ClassAlias)cls;
            if (m.containsKey("co")) {
                String string = (String)m.get("co");
                Function ctorFn = (Function)ca.getExtendedType().getDeclaration().getDirectMember(string, null, false);
                ca.setConstructor(ctorFn.getType().getDeclaration());
            } else {
                ca.setConstructor(ca.getExtendedType().getDeclaration());
            }
        }
        if (m.containsKey("$cn")) {
            Map constructors = (Map)m.remove("$cn");
            for (Map.Entry cons : constructors.entrySet()) {
                Constructor cnst = new Constructor();
                cnst.setName("$def".equals(cons.getKey()) ? null : (String)cons.getKey());
                cnst.setContainer(cls);
                cnst.setScope(cls);
                cnst.setUnit(cls.getUnit());
                cnst.setExtendedType(cls.getType());
                cnst.setDynamic(((Map)cons.getValue()).remove("dyn") != null);
                this.setAnnotations(cnst, (Integer)((Map)cons.getValue()).remove("pa"), ((Map)cons.getValue()).remove("an"));
                List modelPlist = (List)((Map)cons.getValue()).remove("ps");
                cls.addMember(cnst);
                if (modelPlist == null) {
                    cls.setEnumerated(true);
                    Value cv = new Value();
                    cv.setName(cnst.getName());
                    cv.setType(cnst.getType());
                    cv.setContainer(cls);
                    cv.setScope(cls);
                    cv.setUnit(cls.getUnit());
                    cv.setVisibleScope(cls.getVisibleScope());
                    cv.setShared(cls.isShared());
                    cv.setDeprecated(cls.isDeprecated());
                    cls.addMember(cv);
                } else {
                    cls.setConstructors(true);
                    ParameterList plist = this.parseParameters(modelPlist, cnst, allparms);
                    cnst.addParameterList(plist);
                    plist.setNamedParametersSupported(true);
                    Function cf = new Function();
                    cf.setName(cnst.getName());
                    Type ft = cnst.appliedType(cnst.getExtendedType(), Collections.emptyList());
                    cf.setType(ft);
                    cf.addParameterList(plist);
                    cf.setContainer(cls);
                    cf.setScope(cls);
                    cf.setUnit(cls.getUnit());
                    cf.setVisibleScope(cnst.getVisibleScope());
                    cf.setShared(cnst.isShared());
                    cf.setDeprecated(cnst.isDeprecated());
                    cf.setDynamic(cnst.isDynamic());
                    cls.addMember(cf);
                }
                if (!((Map)cons.getValue()).containsKey("$tsenum")) continue;
                cnst.setTypescriptEnum((String)((Map)cons.getValue()).get("$tsenum"));
            }
        } else {
            ParameterList plist = this.parseParameters((List)m.remove("ps"), cls, allparms);
            plist.setNamedParametersSupported(true);
            cls.setParameterList(plist);
        }
        if (m.containsKey("of") && cls.getCaseTypes() == null) {
            cls.setCaseTypes(this.parseTypeList((List)m.get("of"), allparms));
            m.remove("of");
        }
        if (m.containsKey("sts")) {
            List stypes = (List)m.remove("sts");
            cls.setSatisfiedTypes(this.parseTypeList(stypes, allparms));
        }
        if (m.containsKey("$o")) {
            for (Map.Entry entry : ((Map)m.get("$o")).entrySet()) {
                this.loadObject((String)entry.getKey(), (Map)entry.getValue(), cls, allparms);
            }
            m.remove("$o");
        }
        this.addAttributesAndMethods(m, cls, allparms);
        if (m.containsKey("$i")) {
            cdefs = (Map)m.get("$i");
            for (Map.Entry cdef : cdefs.entrySet()) {
                this.loadInterface((String)cdef.getKey(), (Map)cdef.getValue(), cls, allparms);
            }
            m.remove("$i");
        }
        if (m.containsKey("$c")) {
            cdefs = (Map)m.get("$c");
            for (Map.Entry cdef : cdefs.entrySet()) {
                this.loadClass((String)cdef.getKey(), (Map)cdef.getValue(), cls, allparms);
            }
            m.remove("$c");
        }
        if (cls.isDynamic() && (this.getModule().getJsMajor() < 9 || this.getModule().getJsMajor() == 9 && this.getModule().getJsMinor() < 1)) {
            cls.makeMembersDynamic();
        }
        return cls;
    }

    private void addAttributesAndMethods(Map<String, Object> m, Declaration d, List<TypeParameter> tparms) {
        Map sub = (Map)m.get("$at");
        if (sub != null) {
            for (Map.Entry e : sub.entrySet()) {
                if (d.getDirectMember((String)e.getKey(), null, false) != null || !"als".equals(((Map)e.getValue()).get("mt"))) continue;
                d.getMembers().add(this.loadTypeAlias((String)e.getKey(), (Map)e.getValue(), (Scope)((Object)d), tparms));
            }
            for (Map.Entry e : sub.entrySet()) {
                if (d.getDirectMember((String)e.getKey(), null, false) != null || "als".equals(((Map)e.getValue()).get("mt"))) continue;
                d.getMembers().add(this.loadAttribute((String)e.getKey(), (Map)e.getValue(), (Scope)((Object)d), tparms));
            }
        }
        if ((sub = (Map)m.get("$m")) != null) {
            for (Map.Entry e : sub.entrySet()) {
                if (d.getDirectMember((String)e.getKey(), null, false) != null) continue;
                d.getMembers().add(this.loadMethod((String)e.getKey(), (Map)e.getValue(), (Scope)((Object)d), tparms));
            }
        }
    }

    private List<Type> parseTypeList(List<Map<String, Object>> types, List<TypeParameter> typeParams) {
        ArrayList<Type> ts = new ArrayList<Type>(types.size());
        for (Map<String, Object> st : types) {
            ts.add(this.getTypeFromJson(st, null, typeParams));
        }
        return ts;
    }

    private List<TypeParameter> parseTypeParameters(List<Map<String, Object>> typeParams, Declaration container, List<TypeParameter> existing) {
        if (typeParams == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeParameter> allparms = new ArrayList<TypeParameter>((existing == null ? 0 : existing.size()) + typeParams.size());
        if (existing != null && !existing.isEmpty()) {
            allparms.addAll(existing);
        }
        ArrayList<TypeParameter> tparms = new ArrayList<TypeParameter>(typeParams.size());
        for (Map<String, Object> tp : typeParams) {
            Declaration maybe = tp.get("mt") instanceof TypeParameter ? (TypeParameter)tp.get("mt") : container.getDirectMember((String)tp.get("nm"), null, false);
            if (maybe instanceof TypeParameter) {
                allparms.add((TypeParameter)maybe);
                tparms.add((TypeParameter)maybe);
                tp.put("mt", maybe);
                continue;
            }
            TypeParameter tparm = new TypeParameter();
            tparm.setUnit(container.getUnit());
            tparm.setDeclaration(container);
            container.getMembers().add(tparm);
            if (tp.containsKey("nm")) {
                tparm.setName((String)tp.get("nm"));
            } else if (!tp.containsKey("l")) {
                throw new IllegalArgumentException("Invalid type parameter map " + tp);
            }
            String variance = (String)tp.get("dv");
            if ("out".equals(variance)) {
                tparm.setCovariant(true);
            } else if ("in".equals(variance)) {
                tparm.setContravariant(true);
            }
            if (container instanceof Scope) {
                Scope scope = (Scope)((Object)container);
                tparm.setContainer(scope);
                tparm.setScope(scope);
            }
            tparm.setDefaulted(tp.containsKey("def"));
            tparms.add(tparm);
            allparms.add(tparm);
            tp.put("mt", tparm);
        }
        if (container instanceof Generic) {
            ((Generic)((Object)container)).setTypeParameters(tparms);
        }
        for (Map<String, Object> tp : typeParams) {
            TypeParameter tparm = (TypeParameter)tp.get("mt");
            if (tparm.getExtendedType() == null) {
                Type subtype;
                if (tp.containsKey("pk")) {
                    subtype = this.getTypeFromJson(tp, container, allparms);
                    tparm.setExtendedType(subtype);
                } else if (tp.containsKey("l")) {
                    if (!"u".equals(tp.get("comp")) && !"i".equals(tp.get("comp"))) {
                        throw new IllegalArgumentException("Only union or intersection types are allowed as 'comp'");
                    }
                    subtype = this.getTypeFromJson(tp, container, allparms);
                    tparm.setName(subtype.asString());
                    tparm.setExtendedType(subtype);
                } else {
                    tparm.setExtendedType(this.getTypeFromJson(voidclass, container, null));
                }
            }
            if (tparm.isDefaulted()) {
                Map deftype = (Map)tp.get("def");
                tparm.setDefaultTypeArgument(this.getTypeFromJson(deftype, container, existing));
            }
            if (tp.containsKey("sts")) {
                List stypes = (List)tp.get("sts");
                tparm.setSatisfiedTypes(this.parseTypeList(stypes, allparms));
                tparm.setConstrained(true);
                continue;
            }
            if (!tp.containsKey("of")) continue;
            List oftype = (List)tp.get("of");
            tparm.setCaseTypes(this.parseTypeList(oftype, allparms));
            tparm.setConstrained(true);
        }
        return tparms;
    }

    private ParameterList parseParameters(List<Map<String, Object>> params, Declaration owner, List<TypeParameter> typeParameters) {
        ParameterList plist = new ParameterList();
        if (params != null) {
            for (Map<String, Object> p : params) {
                Parameter param = new Parameter();
                String paramtype = (String)p.get("$pt");
                param.setHidden(p.containsKey("$hdn"));
                param.setName((String)p.get("nm"));
                param.setDeclaration(owner);
                param.setDefaulted(p.containsKey("def"));
                param.setSequenced(p.containsKey("seq"));
                param.setAtLeastOne(p.containsKey("$min1"));
                if (paramtype == null || "v".equals(paramtype)) {
                    Value _v = new Value();
                    param.setModel(_v);
                } else if ("f".equals(paramtype)) {
                    List paramLists = (List)p.get("ps");
                    Function _m = new Function();
                    param.setModel(_m);
                    if (paramLists == null) {
                        _m.addParameterList(new ParameterList());
                    } else {
                        boolean first = true;
                        for (List subplist : paramLists) {
                            ParameterList _params = this.parseParameters(subplist, _m, typeParameters);
                            if (first) {
                                first = false;
                            } else {
                                _params.setNamedParametersSupported(false);
                            }
                            _m.addParameterList(_params);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Unknown parameter type " + paramtype);
                }
                FunctionOrValue paramModel = param.getModel();
                if (paramModel != null) {
                    paramModel.setInitializerParameter(param);
                    paramModel.setName(param.getName());
                    paramModel.setUnit(this.u2);
                    if (owner instanceof Scope) {
                        Scope scope = (Scope)((Object)owner);
                        paramModel.setContainer(scope);
                        paramModel.setScope(scope);
                    }
                    if (p.get("$t") instanceof Map) {
                        Map ktype = (Map)p.get("$t");
                        paramModel.setType(this.getTypeFromJson(ktype, owner, typeParameters));
                    } else {
                        for (TypeParameter tp : typeParameters) {
                            if (!tp.getName().equals(p.get("$t"))) continue;
                            paramModel.setType(tp.getType());
                        }
                    }
                    this.setAnnotations(paramModel, (Integer)p.remove("pa"), p.remove("an"));
                }
                plist.getParameters().add(param);
            }
        }
        return plist;
    }

    Function loadMethod(String name, Map<String, Object> m, Scope parent, List<TypeParameter> existing) {
        Function md = new Function();
        md.setName(name);
        m.remove("nm");
        md.setContainer(parent);
        md.setScope(parent);
        this.setAnnotations(md, (Integer)m.remove("pa"), m.remove("an"));
        md.setUnit(this.u2);
        if (parent == this) {
            this.u2.addDeclaration(md);
            this.addMember(null);
        }
        if (m.containsKey("$ff")) {
            int flags = (Integer)m.remove("$ff");
            md.setDeclaredVoid((flags & 1) > 0);
            md.setDeferred((flags & 2) > 0);
        }
        md.setDynamic(m.remove("dyn") != null);
        List<TypeParameter> tparms = this.parseTypeParameters((List)m.get("tp"), md, existing);
        List<TypeParameter> allparms = JsonPackage.merge(tparms, existing);
        md.setType(this.getTypeFromJson((Map)m.remove("$t"), parent instanceof Declaration ? (Declaration)((Object)parent) : null, allparms));
        List paramLists = (List)m.remove("ps");
        if (paramLists == null) {
            md.addParameterList(new ParameterList());
        } else {
            boolean first = true;
            for (List plist : paramLists) {
                ParameterList _params = this.parseParameters(plist, md, allparms);
                _params.setNamedParametersSupported(first);
                first = false;
                md.addParameterList(_params);
                for (Parameter p : _params.getParameters()) {
                    md.addMember(p.getModel());
                }
            }
        }
        return md;
    }

    FunctionOrValue loadAttribute(String name, Map<String, Object> m, Scope parent, List<TypeParameter> typeParameters) {
        String metatype = (String)m.get("mt");
        Value d = new Value();
        d.setTransient("g".equals(metatype));
        d.setName(name);
        d.setContainer(parent);
        d.setScope(parent);
        d.setUnit(this.u2);
        if (parent == this) {
            this.u2.addDeclaration(d);
            this.addMember(null);
        }
        this.setAnnotations(d, (Integer)m.remove("pa"), m.remove("an"));
        d.setDynamic(m.remove("dyn") != null);
        if (m.containsKey("var")) {
            d.setVariable(true);
        }
        Map ktype = (Map)m.get("$t");
        d.setType(this.getTypeFromJson(ktype, parent instanceof Declaration ? (Declaration)((Object)parent) : null, typeParameters));
        Map smap = (Map)m.remove("$set");
        if (smap != null) {
            Setter s = new Setter();
            s.setName(name);
            s.setContainer(parent);
            s.setScope(parent);
            s.setUnit(this.u2);
            s.setGetter(d);
            d.setSetter(s);
            if (parent == this) {
                this.u2.addDeclaration(s);
                this.addMember(null);
            }
            this.setAnnotations(s, (Integer)smap.remove("pa"), smap.remove("an"));
            s.setType(d.getType());
        }
        return d;
    }

    private void refineMembers(ClassOrInterface coi) {
        for (Declaration d : coi.getMembers()) {
            if (d.isActual()) {
                Declaration refined = coi.getRefinedMember(d.getName(), ModelUtil.getSignature(d), ModelUtil.isVariadic(d));
                if (refined == null) {
                    refined = d;
                }
                d.setRefinedDeclaration(refined);
            }
            if (!(d instanceof ClassOrInterface)) continue;
            this.refineMembers((ClassOrInterface)d);
        }
    }

    Interface loadInterface(String name, Map<String, Object> m, Scope parent, List<TypeParameter> existing) {
        Map cdefs;
        Interface t;
        m.remove("nm");
        if (m.get("mt") instanceof Interface) {
            t = (Interface)m.get("mt");
            if (m.size() <= 3) {
                return t;
            }
        } else {
            t = m.containsKey("$alias") ? new InterfaceAlias() : new Interface();
            t.setContainer(parent);
            t.setScope(parent);
            t.setName(name);
            t.setUnit(this.u2);
            if (parent == this) {
                this.u2.addDeclaration(t);
            }
            parent.addMember(t);
            m.put("mt", t);
            this.setAnnotations(t, (Integer)m.remove("pa"), m.remove("an"));
        }
        if (m.remove("dyn") != null) {
            t.setDynamic(true);
        }
        List<TypeParameter> tparms = t.getTypeParameters();
        List listOfMaps = (List)m.get("tp");
        if (listOfMaps != null && (tparms == null || tparms.size() < listOfMaps.size())) {
            tparms = this.parseTypeParameters(listOfMaps, t, existing);
            m.remove("tp");
        }
        List<TypeParameter> allparms = JsonPackage.merge(tparms, existing);
        if (t.getExtendedType() == null) {
            if (t.isAlias()) {
                t.setExtendedType(this.getTypeFromJson((Map)m.remove("$alias"), parent instanceof Declaration ? (Declaration)((Object)parent) : null, allparms));
            } else {
                t.setExtendedType(this.getTypeFromJson(objclass, parent instanceof Declaration ? (Declaration)((Object)parent) : null, null));
            }
        }
        if (m.containsKey("st")) {
            for (TypeParameter _tp : tparms) {
                if (!_tp.getName().equals(m.get("st"))) continue;
                t.setSelfType(_tp.getType());
                _tp.setSelfTypedDeclaration(t);
            }
            m.remove("st");
        }
        if (m.containsKey("of") && t.getCaseTypes() == null) {
            t.setCaseTypes(this.parseTypeList((List)m.remove("of"), allparms));
        }
        if (m.containsKey("sts")) {
            for (Type s : this.parseTypeList((List)m.remove("sts"), allparms)) {
                t.getSatisfiedTypes().add(s);
            }
        }
        this.addAttributesAndMethods(m, t, allparms);
        if (m.containsKey("$i")) {
            cdefs = (Map)m.remove("$i");
            for (Map.Entry cdef : cdefs.entrySet()) {
                this.loadInterface((String)cdef.getKey(), (Map)cdef.getValue(), t, allparms);
            }
        }
        if (m.containsKey("$c")) {
            cdefs = (Map)m.remove("$c");
            for (Map.Entry cdef : cdefs.entrySet()) {
                this.loadClass((String)cdef.getKey(), (Map)cdef.getValue(), t, allparms);
            }
        }
        if (t.isDynamic() && (this.getModule().getJsMajor() < 9 || this.getModule().getJsMajor() == 9 && this.getModule().getJsMinor() < 1)) {
            t.makeMembersDynamic();
        }
        return t;
    }

    TypeDeclaration loadObject(String name, Map<String, Object> m, Scope parent, List<TypeParameter> existing) {
        Value obj;
        if (m.get("mt") instanceof Value) {
            obj = (Value)m.get("mt");
        } else {
            obj = new Value();
            m.put("mt", obj);
            obj.setName(name);
            obj.setContainer(parent);
            obj.setScope(parent);
            obj.setUnit(this.u2);
            Class type = new Class();
            type.setName(name);
            type.setAnonymous(true);
            type.setUnit(this.u2);
            type.setContainer(parent);
            type.setScope(parent);
            if (parent == this) {
                this.u2.addDeclaration(obj);
                this.u2.addDeclaration(type);
            }
            parent.addMember(obj);
            obj.setType(type.getType());
            this.setAnnotations(obj, (Integer)m.get("pa"), m.get("an"));
            this.setAnnotations(obj.getTypeDeclaration(), (Integer)m.remove("pa"), m.remove("an"));
            if (type.getExtendedType() == null) {
                if (m.containsKey("super")) {
                    type.setExtendedType(this.getTypeFromJson((Map)m.remove("super"), parent instanceof Declaration ? (Declaration)((Object)parent) : null, existing));
                } else {
                    type.setExtendedType(this.getTypeFromJson(idobj, parent instanceof Declaration ? (Declaration)((Object)parent) : null, existing));
                }
            }
            if (m.containsKey("sts")) {
                List stypes = (List)m.remove("sts");
                type.setSatisfiedTypes(this.parseTypeList(stypes, existing));
            }
            if (m.containsKey("$i")) {
                for (Map.Entry inner : ((Map)m.remove("$i")).entrySet()) {
                    this.loadInterface((String)inner.getKey(), (Map)inner.getValue(), type, existing);
                }
            }
            if (m.containsKey("$c")) {
                for (Map.Entry inner : ((Map)m.remove("$c")).entrySet()) {
                    this.loadClass((String)inner.getKey(), (Map)inner.getValue(), type, existing);
                }
            }
            if (m.containsKey("$o")) {
                for (Map.Entry inner : ((Map)m.remove("$o")).entrySet()) {
                    this.loadObject((String)inner.getKey(), (Map)inner.getValue(), type, existing);
                }
            }
            this.addAttributesAndMethods(m, type, existing);
        }
        return obj.getTypeDeclaration();
    }

    private TypeAlias loadTypeAlias(String name, Map<String, Object> m, Scope parent, List<TypeParameter> existing) {
        List<TypeParameter> tparms;
        List listOfMaps;
        TypeAlias alias;
        if (m.get("mt") instanceof TypeAlias) {
            alias = (TypeAlias)m.get("mt");
            if (m.size() == 1) {
                return alias;
            }
        } else {
            Declaration maybe = parent.getDirectMember(name, null, false);
            if (maybe == null) {
                alias = new TypeAlias();
                alias.setContainer(parent);
                alias.setScope(parent);
                alias.setName(name);
                alias.setUnit(this.u2);
                this.setAnnotations(alias, (Integer)m.remove("pa"), m.remove("an"));
                m.put("mt", alias);
            } else if (maybe instanceof TypeAlias) {
                alias = (TypeAlias)maybe;
            } else {
                throw new IllegalStateException(maybe + " should be an TypeAlias");
            }
        }
        if ((listOfMaps = (List)m.get("tp")) != null && alias.getTypeParameters().size() < listOfMaps.size()) {
            tparms = this.parseTypeParameters(listOfMaps, alias, existing);
            alias.setTypeParameters(tparms);
        } else {
            tparms = alias.getTypeParameters();
        }
        List<TypeParameter> allparms = JsonPackage.merge(tparms, existing);
        if (alias.getExtendedType() == null) {
            alias.setExtendedType(this.getTypeFromJson((Map)m.get("$alias"), parent instanceof Declaration ? (Declaration)((Object)parent) : null, allparms));
        }
        if (m.containsKey("st")) {
            for (TypeParameter _tp : tparms) {
                if (!_tp.getName().equals(m.get("st"))) continue;
                alias.setSelfType(_tp.getType());
            }
        }
        if (m.containsKey("of")) {
            alias.setCaseTypes(this.parseTypeList((List)m.remove("of"), allparms));
        }
        if (m.containsKey("sts")) {
            List stypes = (List)m.remove("sts");
            alias.setSatisfiedTypes(this.parseTypeList(stypes, allparms));
        }
        m.clear();
        m.put("mt", alias);
        if (parent == this) {
            this.u2.addDeclaration(alias);
        }
        parent.addMember(alias);
        return alias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type getTypeFromJson(Map<String, Object> m, Declaration container, List<TypeParameter> typeParams) {
        Type newType;
        String tname;
        TypeDeclaration td = null;
        if (m.get("mt") instanceof TypeDeclaration && (td = (TypeDeclaration)m.get("mt")) instanceof ClassOrInterface && td.getUnit().getPackage() instanceof JsonPackage) {
            ((JsonPackage)td.getUnit().getPackage()).load(td.getName(), typeParams);
        }
        if ("$U".equals(tname = (String)m.get("nm"))) {
            m.put("mt", this.unknown);
            return this.unknown.getType();
        }
        if (td == null && m.containsKey("comp")) {
            List tmaps = (List)m.get("l");
            ArrayList<Type> types = new ArrayList<Type>(tmaps.size());
            if ("u".equals(m.get("comp"))) {
                UnionType ut = new UnionType(this.u2);
                for (Map tmap : tmaps) {
                    types.add(this.getTypeFromJson(tmap, container, typeParams));
                }
                ut.setCaseTypes(types);
                td = ut;
            } else {
                if (!"i".equals(m.get("comp"))) throw new IllegalArgumentException("Invalid composite type '" + m.get("comp") + "'");
                IntersectionType it = new IntersectionType(this.u2);
                for (Map tmap : tmaps) {
                    types.add(this.getTypeFromJson(tmap, container, typeParams));
                }
                it.setSatisfiedTypes(types);
                td = it;
            }
        } else if (td == null) {
            String pname = (String)m.get("pk");
            if (pname == null) {
                List<TypeParameter> containerTypeParameters = container instanceof Constructor ? ((Generic)((Object)container.getContainer())).getTypeParameters() : (container instanceof Generic ? ((Generic)((Object)container)).getTypeParameters() : null);
                if (containerTypeParameters != null) {
                    for (TypeParameter typeParam : containerTypeParameters) {
                        if (!typeParam.getName().equals(tname)) continue;
                        td = typeParam;
                    }
                }
                if (td == null && typeParams != null) {
                    for (TypeParameter typeParam : typeParams) {
                        if (!typeParam.getName().equals(tname)) continue;
                        td = typeParam;
                    }
                }
            } else {
                String level1;
                Package rp;
                String mname = (String)m.get("md");
                if ("$".equals(mname)) {
                    mname = "ceylon.language";
                }
                if ("$".equals(pname) || "ceylon.language".equals(pname)) {
                    rp = this.isLanguagePackage() ? this : this.getModule().getLanguageModule().getDirectPackage("ceylon.language");
                } else if (mname == null) {
                    if (".".equals(pname)) {
                        rp = this;
                        if (container instanceof TypeDeclaration && tname.equals(container.getName())) {
                            td = (TypeDeclaration)container;
                        }
                    } else {
                        rp = this.getModule().getDirectPackage(pname);
                    }
                } else {
                    rp = this.getModule().getPackage(pname);
                }
                if (rp == null) {
                    throw new CompilerErrorException("Package not found: " + pname);
                }
                if (rp != this && rp instanceof JsonPackage && !((JsonPackage)rp).loaded) {
                    ((JsonPackage)rp).loadIfNecessary();
                }
                boolean nested = tname.indexOf(46) > 0;
                String string = level1 = nested ? tname.substring(0, tname.indexOf(46)) : tname;
                if (rp != null && !nested) {
                    Declaration d = rp.getDirectMember(tname, null, false);
                    if (d instanceof TypeDeclaration) {
                        td = (TypeDeclaration)d;
                        if (td.isTuple()) {
                            if (m.containsKey("l")) {
                                List elemaps = (List)m.get("l");
                                ArrayList<Type> elems = new ArrayList<Type>(elemaps.size());
                                for (Map elem : elemaps) {
                                    elems.add(this.getTypeFromJson(elem, container, typeParams));
                                }
                                Type tail = (Type)elems.get(elems.size() - 1);
                                if ((tail.isSequence() || tail.isSequential()) && !tail.isTuple() && !tail.isEmpty()) {
                                    elems.remove(elems.size() - 1);
                                    return this.u2.getTupleType(elems, tail, -1);
                                } else {
                                    tail = null;
                                }
                                return this.u2.getTupleType(elems, tail, -1);
                            }
                            if (m.containsKey("count")) {
                                Map elem = (Map)m.get("$t");
                                Object[] elems = new Type[((Integer)m.remove("count")).intValue()];
                                Arrays.fill(elems, this.getTypeFromJson(elem, container, typeParams));
                                return this.u2.getTupleType(Arrays.asList(elems), null, -1);
                            }
                        }
                    } else if (d instanceof FunctionOrValue) {
                        td = ((FunctionOrValue)d).getTypeDeclaration();
                    }
                }
                if (td == null && rp instanceof JsonPackage) {
                    td = nested ? ((JsonPackage)rp).loadNestedType(tname, typeParams) : (TypeDeclaration)((JsonPackage)rp).load(tname, typeParams);
                }
                if (nested && td == null) {
                    for (Declaration d : rp.getMembers()) {
                        if (!(d instanceof TypeDeclaration) || !level1.equals(d.getName())) continue;
                        td = (TypeDeclaration)d;
                    }
                    String[] path = tname.split("\\.");
                    for (int i = 1; i < path.length; ++i) {
                        td = (TypeDeclaration)td.getDirectMember(path[i], null, false);
                    }
                }
            }
        }
        if ((newType = this.loadTypeArguments(m, td, container, typeParams)) != null) {
            return newType;
        }
        List modelParms = (List)m.get("tp");
        if (td != null && modelParms != null) {
            HashMap<TypeParameter, Type> concretes = new HashMap<TypeParameter, Type>();
            HashMap<TypeParameter, SiteVariance> variances = null;
            if (td.getTypeParameters().size() < modelParms.size() && td.getUnit().getPackage() == this) {
                this.parseTypeParameters(modelParms, td, null);
            }
            Iterator<TypeParameter> viter = td.getTypeParameters().iterator();
            for (Map ptparm : modelParms) {
                Integer usv;
                TypeParameter _cparm = viter.next();
                if (ptparm.containsKey("pk") || ptparm.containsKey("l")) {
                    Type _pt = this.getTypeFromJson(ptparm, container, typeParams);
                    concretes.put(_cparm, _pt);
                } else if (ptparm.containsKey("nm") && typeParams != null) {
                    for (TypeParameter typeParam : typeParams) {
                        if (!typeParam.getName().equals(ptparm.get("nm"))) continue;
                        concretes.put(_cparm, typeParam.getType());
                    }
                }
                if ((usv = (Integer)ptparm.get("uv")) == null) continue;
                if (variances == null) {
                    variances = new HashMap<TypeParameter, SiteVariance>();
                }
                variances.put(_cparm, SiteVariance.values()[usv]);
            }
            if (!concretes.isEmpty()) {
                return td.getType().substitute(concretes, variances);
            }
        }
        if (td != null) return td.getType();
        try {
            throw new IllegalArgumentException(String.format("Couldn't find type %s::%s for %s in %s<%s> (FROM pkg %s)", m.get("pk"), m.get("nm"), m.get("md"), m, typeParams, this.getNameAsString()));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return td.getType();
    }

    Type loadTypeArguments(Map<String, Object> m, TypeDeclaration td, Declaration container, List<TypeParameter> typeParams) {
        if (td == null) {
            return null;
        }
        Map targs = (Map)m.get("ta");
        if (targs == null) {
            return null;
        }
        HashMap<TypeParameter, Type> concretes = new HashMap<TypeParameter, Type>(targs.size());
        HashMap<TypeParameter, SiteVariance> variances = null;
        Declaration d = td;
        while (d != null) {
            if (d instanceof Generic) {
                for (TypeParameter tparm : ((Generic)((Object)d)).getTypeParameters()) {
                    Integer usv;
                    Map targMap = (Map)targs.get(MetamodelGenerator.partiallyQualifiedName(d) + "." + tparm.getName());
                    if (targMap == null) continue;
                    if (targMap.containsKey("pk") || targMap.containsKey("l")) {
                        Type _pt = this.getTypeFromJson(targMap, container, typeParams);
                        concretes.put(tparm, _pt);
                    } else if (targMap.containsKey("nm") && typeParams != null) {
                        for (TypeParameter typeParam : typeParams) {
                            if (!typeParam.getName().equals(targMap.get("nm"))) continue;
                            concretes.put(tparm, typeParam.getType());
                        }
                    }
                    if ((usv = (Integer)targMap.get("uv")) == null) continue;
                    if (variances == null) {
                        variances = new HashMap<TypeParameter, SiteVariance>();
                    }
                    variances.put(tparm, SiteVariance.values()[usv]);
                }
            }
            d = ModelUtil.getContainingDeclaration(d);
        }
        if (!concretes.isEmpty()) {
            return td.getType().substitute(concretes, variances);
        }
        return null;
    }

    Declaration load(String name, List<TypeParameter> existing) {
        if (this.model == null) {
            throw new IllegalStateException("No model available to load " + this.getNameAsString() + "::" + name);
        }
        Map map = (Map)this.model.get(name);
        if (map == null) {
            if ("Nothing".equals(name)) {
                if (this.isLanguagePackage()) {
                    return this.nothing;
                }
                if (this.getModule().getJsMajor() < 9 || this.getModule().getJsMajor() == 9 && this.getModule().getJsMinor() < 1) {
                    return this.nothing;
                }
            } else if ("$U".equals(name)) {
                return this.unknown;
            }
            throw new IllegalStateException("Cannot find " + this.pkgname + "::" + name + " in " + this.model.keySet());
        }
        Object metatype = map.get("mt");
        if (metatype == null) {
            throw new IllegalArgumentException("Missing metatype from entry " + map);
        }
        if (metatype.equals("a") || metatype.equals("g")) {
            return this.loadAttribute(name, map, this, null);
        }
        if (metatype.equals("c") || metatype instanceof Class) {
            return this.loadClass(name, map, this, existing);
        }
        if (metatype.equals("i") || metatype instanceof Interface) {
            return this.loadInterface(name, map, this, existing);
        }
        if (metatype.equals("m")) {
            return this.loadMethod(name, map, this, existing);
        }
        if (metatype.equals("o") || metatype instanceof Value) {
            return this.loadObject(name, map, this, existing);
        }
        if (metatype.equals("als") || metatype instanceof TypeAlias) {
            return this.loadTypeAlias(name, map, this, existing);
        }
        System.out.println("WTF is this shit " + map);
        return null;
    }

    public static boolean hasAnnotationBit(int bits, String annotationName) {
        int idx = MetamodelGenerator.annotationBits.indexOf(annotationName);
        if (idx < 0) {
            return false;
        }
        return (bits & 1 << idx) > 0;
    }

    private void setBitAnnotations(Declaration d, int bits) {
        d.setShared(JsonPackage.hasAnnotationBit(bits, "shared"));
        d.setActual(JsonPackage.hasAnnotationBit(bits, "actual"));
        d.setFormal(JsonPackage.hasAnnotationBit(bits, "formal"));
        d.setDefault(JsonPackage.hasAnnotationBit(bits, "default"));
        d.setNativeBackends(JsonPackage.hasAnnotationBit(bits, "native") ? Backend.JavaScript.asSet() : Backends.ANY);
        d.setAnnotation(JsonPackage.hasAnnotationBit(bits, "annotation"));
        d.setStatic(JsonPackage.hasAnnotationBit(bits, "static"));
        if (JsonPackage.hasAnnotationBit(bits, "sealed")) {
            ((TypeDeclaration)d).setSealed(true);
        }
        if (d instanceof Class) {
            ((Class)d).setFinal(JsonPackage.hasAnnotationBit(bits, "final"));
            ((Class)d).setAbstract(JsonPackage.hasAnnotationBit(bits, "abstract"));
        } else if (d instanceof Constructor) {
            ((Constructor)d).setAbstract(JsonPackage.hasAnnotationBit(bits, "abstract"));
        }
        if (JsonPackage.hasAnnotationBit(bits, "late")) {
            ((Value)d).setLate(true);
        }
        if (JsonPackage.hasAnnotationBit(bits, "variable")) {
            ((Value)d).setVariable(true);
        }
    }

    private void setAnnotations(Declaration d, Integer bits, Object anns) {
        if (bits != null) {
            this.setBitAnnotations(d, bits);
        }
        if (anns == null) {
            return;
        }
        if (anns instanceof List) {
            JsonPackage.setNewAnnotations(d.getAnnotations(), (List)anns);
        } else if (anns instanceof Map) {
            JsonPackage.setOldAnnotations(d.getAnnotations(), (Map)anns);
        } else {
            throw new IllegalArgumentException("Annotations should be a List (new format) or a Map (old format)");
        }
    }

    static void setNewAnnotations(List<Annotation> existing, List<Map<String, List<String>>> anns) {
        for (Map<String, List<String>> a : anns) {
            String name = a.keySet().iterator().next();
            Annotation ann = new Annotation();
            ann.setName(name);
            for (String arg : a.get(name)) {
                ann.addPositionalArgument(arg);
            }
            existing.add(ann);
        }
    }

    static void setOldAnnotations(List<Annotation> existing, Map<String, List<String>> m) {
        for (Map.Entry<String, List<String>> e : m.entrySet()) {
            String name = e.getKey();
            Annotation ann = new Annotation();
            ann.setName(name);
            for (String arg : e.getValue()) {
                ann.addPositionalArgument(arg);
            }
            existing.add(ann);
        }
    }

    private TypeDeclaration loadNestedType(String fqn, List<TypeParameter> typeParams) {
        try {
            String[] path = fqn.split("\\.");
            Map typeMap = (Map)this.model.get(path[0]);
            if (!(typeMap.get("mt") instanceof TypeDeclaration)) {
                this.load(path[0], typeParams);
            }
            TypeDeclaration td = (TypeDeclaration)typeMap.get("mt");
            for (int i = 1; i < path.length; ++i) {
                Declaration member;
                TypeDeclaration child;
                Map subtypes = (Map)typeMap.get("$i");
                Map childMap = null;
                int type = 0;
                if (subtypes != null) {
                    childMap = (Map)subtypes.get(path[i]);
                    type = 1;
                }
                if (childMap == null && (subtypes = (Map)typeMap.get("$c")) != null) {
                    childMap = (Map)subtypes.get(path[i]);
                    type = 2;
                }
                if ((child = (member = td.getDirectMember(path[i], null, false)) instanceof Value && ((Value)member).getTypeDeclaration() instanceof Constructor ? ((Value)member).getTypeDeclaration().getExtendedType().getDeclaration() : (TypeDeclaration)member) == null) {
                    switch (type) {
                        case 1: {
                            child = this.loadInterface(path[i], childMap, td, typeParams);
                            break;
                        }
                        case 2: {
                            child = this.loadClass(path[i], childMap, td, typeParams);
                        }
                    }
                }
                td = child;
            }
            return td;
        }
        catch (RuntimeException x) {
            throw new RuntimeException("Failed to load inner type " + fqn + " in package " + this.getQualifiedNameString(), x);
        }
    }

    public static List<TypeParameter> merge(List<TypeParameter> l1, List<TypeParameter> l2) {
        int size = (l1 == null ? 0 : l1.size()) + (l2 == null ? 0 : l2.size());
        ArrayList<TypeParameter> merged = new ArrayList<TypeParameter>(size);
        HashSet<String> names = new HashSet<String>();
        if (l1 != null) {
            for (TypeParameter t : l1) {
                merged.add(t);
                names.add(t.getName());
            }
        }
        if (l2 != null) {
            for (TypeParameter t : l2) {
                if (names.contains(t.getName())) continue;
                merged.add(t);
            }
        }
        return merged;
    }

    static {
        idobj.put("nm", "Basic");
        idobj.put("pk", "ceylon.language");
        idobj.put("md", "ceylon.language");
        objclass.put("nm", "Object");
        objclass.put("pk", "ceylon.language");
        objclass.put("md", "ceylon.language");
        voidclass.put("nm", "Anything");
        voidclass.put("pk", "ceylon.language");
        voidclass.put("md", "ceylon.language");
    }
}

