/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashMap;
import java.util.Map;

public class LocalDeclarationVisitor
extends Visitor {
    private Map<String, Integer> localNames;
    private String prefix;

    private void visitLocalDecl(Tree.Declaration that) {
        this.visitLocalDeclarationModel(that.getDeclarationModel());
    }

    private void visitLocalDecl(Tree.TypedArgument that) {
        this.visitLocalDeclarationModel(that.getDeclarationModel());
    }

    private void visitLocalDecl(Tree.ObjectExpression that) {
        this.visitLocalDeclarationModel(that.getAnonymousClass());
    }

    public static boolean isTopLevelObjectExpressionType(Declaration model) {
        return model instanceof Class && model.isAnonymous() && model.isToplevel() && !model.isNamed();
    }

    private void visitLocalDeclarationModel(Declaration model) {
        if (!(model == null || !LocalDeclarationVisitor.isTopLevelObjectExpressionType(model) && (model.isToplevel() || model.isMember()) || model instanceof Function && model.isParameter() || this.localNames == null)) {
            Integer counter = this.localNames.get(model.getName());
            counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
            this.localNames.put(model.getName(), counter);
            String qualifier = this.prefix != null ? this.prefix + counter.toString() : counter.toString();
            model.setQualifier(qualifier);
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        this.visitLocalDecl(that);
        super.visit(that);
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        ClassOrInterface model = that.getDeclarationModel();
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = null;
        if (model != null && !model.isAlias()) {
            oldLocalNames = this.localNames;
            this.localNames = new HashMap<String, Integer>();
        }
        super.visit(that);
        if (model != null && !model.isAlias()) {
            this.localNames = oldLocalNames;
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        this.visitLocalDecl(that);
        Class c = that.getAnonymousClass();
        Value v = that.getDeclarationModel();
        if (c != null && v != null) {
            c.setQualifier(v.getQualifier());
        }
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        this.visitLocalDecl(that);
        Class c = that.getAnonymousClass();
        Value v = that.getDeclarationModel();
        if (c != null && v != null) {
            c.setQualifier(v.getQualifier());
        }
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        this.visitLocalDecl(that);
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Map<String, Integer> oldLocalNames = this.localNames;
        this.localNames = new HashMap<String, Integer>();
        super.visit(that);
        this.localNames = oldLocalNames;
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        Value model = that.getDeclarationModel();
        if (model != null && model.isToplevel()) {
            Map<String, Integer> oldLocalNames = this.localNames;
            String oldPrefix = this.prefix;
            this.localNames = new HashMap<String, Integer>();
            this.prefix = "1" + model.getName() + "$";
            super.visit(that);
            this.localNames = oldLocalNames;
            this.prefix = oldPrefix;
        } else {
            super.visit(that);
        }
    }
}

