/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleHelper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.io.ClosableVirtualFile;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class ModuleSourceMapper {
    JdkProvider defaultJdkProvider = new JdkProvider();
    private final LinkedList<Package> packageStack = new LinkedList();
    private Module currentModule;
    private final Map<ModuleImport, WeakHashMap<Node, Object>> moduleImportToNode = new HashMap<ModuleImport, WeakHashMap<Node, Object>>();
    private Map<List<String>, Set<String>> topLevelErrorsPerModuleName = new HashMap<List<String>, Set<String>>();
    private Map<Module, Node> moduleToNode = new TreeMap<Module, Node>();
    private ModuleManager moduleManager;
    private Context context;
    private Modules modules;
    private HashSet<String> reportedModuleConflictErrors = new HashSet();
    private HashSet<String> reportedModuleConflictWarnings = new HashSet();
    private static Object PRESENT = new Object();

    public ModuleSourceMapper(Context context, ModuleManager moduleManager) {
        this.context = context;
        this.moduleManager = moduleManager;
        this.modules = context.getModules();
    }

    public void initCoreModules() {
        this.moduleManager.initCoreModules(this.modules);
        this.packageStack.clear();
        this.packageStack.addLast(this.modules.getDefaultModule().getPackages().get(0));
    }

    public void push(String path) {
        this.createPackageAndAddToModule(path);
    }

    public void pop() {
        this.removeLastPackageAndModuleIfNecessary();
    }

    public Package getCurrentPackage() {
        return this.packageStack.peekLast();
    }

    public void visitModuleFile() {
        if (this.currentModule == null) {
            Package currentPkg = this.packageStack.peekLast();
            List<String> moduleName = currentPkg.getName();
            this.currentModule = this.moduleManager.getOrCreateModule(moduleName, null);
            if (this.currentModule != null) {
                this.currentModule.setAvailable(true);
                Package pkg = this.currentModule.getDirectPackage(currentPkg.getNameAsString());
                if (pkg == null) {
                    this.moduleManager.bindPackageToModule(currentPkg, this.currentModule);
                } else {
                    this.packageStack.pollLast();
                    this.packageStack.addLast(pkg);
                }
            } else {
                this.addErrorToModule(new ArrayList<String>(), "module may not be defined at the top level of the hierarchy");
            }
        } else {
            StringBuilder error = new StringBuilder("two modules within the same hierarchy: '");
            error.append(ModelUtil.formatPath(this.currentModule.getName())).append("' and '").append(ModelUtil.formatPath(this.packageStack.peekLast().getName())).append("'");
            this.addErrorToModule(this.currentModule.getName(), error.toString());
            this.addErrorToModule(this.packageStack.peekLast().getName(), error.toString());
        }
    }

    private void createPackageAndAddToModule(String path) {
        Package lastPkg = this.packageStack.peekLast();
        List<String> parentName = lastPkg.getName();
        ArrayList<String> name = new ArrayList<String>(parentName.size() + 1);
        name.addAll(parentName);
        name.add(path);
        Package pkg = this.moduleManager.createPackage(ModelUtil.formatPath(name), this.currentModule != null ? this.currentModule : this.modules.getDefaultModule());
        this.packageStack.addLast(pkg);
    }

    private void removeLastPackageAndModuleIfNecessary() {
        boolean moveAboveModuleLevel;
        this.packageStack.pollLast();
        boolean bl = moveAboveModuleLevel = this.currentModule != null && this.currentModule.getName().size() > this.packageStack.size() - 1;
        if (moveAboveModuleLevel) {
            this.currentModule = null;
        }
    }

    public void addModuleDependencyDefinition(ModuleImport moduleImport, Node definition) {
        WeakHashMap<Node, Object> moduleDepDefinition = this.moduleImportToNode.get(moduleImport);
        if (moduleDepDefinition == null) {
            moduleDepDefinition = new WeakHashMap();
            this.moduleImportToNode.put(moduleImport, moduleDepDefinition);
        }
        moduleDepDefinition.put(definition, PRESENT);
    }

    public void attachErrorToDependencyDeclaration(ModuleImport moduleImport, List<Module> dependencyTree, String error, boolean isError) {
        if (!this.attachErrorToDependencyDeclaration(moduleImport, error, isError)) {
            if (dependencyTree.size() >= 2) {
                Module rootModule = dependencyTree.get(0);
                Module originalImportedModule = dependencyTree.get(1);
                for (ModuleImport imp : rootModule.getImports()) {
                    if (imp.getModule() != originalImportedModule) continue;
                    if (!this.attachErrorToDependencyDeclaration(imp, error, isError)) break;
                    return;
                }
            }
            System.err.println("This might be a type checker bug, please report. \nExpecting to add missing dependency error on non present definition: " + error);
        }
    }

    protected boolean attachErrorToDependencyDeclaration(ModuleImport moduleImport, String error, boolean isError) {
        WeakHashMap<Node, Object> moduleDepError = this.moduleImportToNode.get(moduleImport);
        if (moduleDepError != null) {
            for (Node definition : moduleDepError.keySet()) {
                definition.addError(new ModuleDependencyAnalysisError(definition, error, isError));
            }
            return true;
        }
        return false;
    }

    public Iterable<ModuleImport> retrieveModuleImports(Module module) {
        ArrayList<ModuleImport> imports = new ArrayList<ModuleImport>();
        for (ModuleImport imp : this.moduleImportToNode.keySet()) {
            if (imp.getModule() != module) continue;
            imports.add(imp);
        }
        return imports;
    }

    public Iterable<Tree.ImportModule> retrieveModuleImportNodes(Module module) {
        ArrayList<Tree.ImportModule> nodes = new ArrayList<Tree.ImportModule>();
        for (ModuleImport imp : module.getImports()) {
            WeakHashMap<Node, Object> moduleDepDefinition = this.moduleImportToNode.get(imp);
            if (moduleDepDefinition == null) continue;
            for (Node node : moduleDepDefinition.keySet()) {
                if (!(node instanceof Tree.ImportModule)) continue;
                nodes.add((Tree.ImportModule)node);
            }
        }
        return nodes;
    }

    public Module getModuleForNode(Node importNode) {
        for (ModuleImport imp : this.moduleImportToNode.keySet()) {
            WeakHashMap<Node, Object> moduleDepDefinition = this.moduleImportToNode.get(imp);
            if (moduleDepDefinition == null) continue;
            for (Node node : moduleDepDefinition.keySet()) {
                if (node != importNode) continue;
                return imp.getModule();
            }
        }
        return null;
    }

    public void attachErrorToModuleImport(ModuleImport moduleImport, String error) {
        WeakHashMap<Node, Object> errors = this.moduleImportToNode.get(moduleImport);
        if (errors != null) {
            for (Node definition : errors.keySet()) {
                definition.addError(new ModuleDependencyAnalysisError(definition, error));
            }
        }
    }

    public void attachErrorToOriginalModuleImport(Module module, String error) {
        if (this.getCompiledModules().contains(module)) {
            this.addErrorToModule(module, error);
        } else {
            for (Map.Entry<ModuleImport, WeakHashMap<Node, Object>> entry : this.moduleImportToNode.entrySet()) {
                if (entry.getKey().getModule() != module) continue;
                for (Node definition : entry.getValue().keySet()) {
                    definition.addError(new ModuleDependencyAnalysisError(definition, error));
                }
            }
        }
    }

    public void addErrorToModule(Module module, String error) {
        Node node = this.moduleToNode.get(module);
        if (node != null) {
            node.addError(new ModuleDependencyAnalysisError(node, error));
        } else {
            System.err.println("This is a type checker bug, please report. \nExpecting to add error on non present module node: " + module.toString() + ". Error " + error);
        }
    }

    public void addConflictingModuleWarningToModule(String moduleName, Module module, Warning warningType, String error) {
        if (this.reportedModuleConflictWarnings.add(moduleName)) {
            this.addWarningToModule(module, warningType, error);
        }
    }

    public void addWarningToModule(Module module, Warning warningType, String error) {
        Node node = this.moduleToNode.get(module);
        if (node != null) {
            node.addUsageWarning(warningType, error);
        } else {
            System.err.println("This is a type checker bug, please report. \nExpecting to add error on non present module node: " + module.toString() + ". Error " + error);
        }
    }

    protected void addConflictingModuleErrorToModule(String moduleName, Module module, String error) {
        if (this.reportedModuleConflictErrors.add(moduleName)) {
            this.addErrorToModule(module, error);
        }
    }

    protected void addErrorToModule(List<String> moduleName, String error) {
        Set<String> errors = this.topLevelErrorsPerModuleName.get(moduleName);
        if (errors == null) {
            errors = new HashSet<String>();
            this.topLevelErrorsPerModuleName.put(moduleName, errors);
        }
        errors.add(error);
    }

    public void addLinkBetweenModuleAndNode(Module module, Tree.ModuleDescriptor descriptor) {
        Set<String> errors = this.topLevelErrorsPerModuleName.get(module.getName());
        if (errors != null) {
            for (String error : errors) {
                descriptor.addError(new ModuleDependencyAnalysisError(descriptor, error));
            }
            errors.clear();
        }
        this.moduleToNode.put(module, descriptor);
    }

    public Set<Module> getCompiledModules() {
        return this.moduleToNode.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveModule(ArtifactResult artifact, Module module, ModuleImport moduleImport, LinkedList<Module> dependencyTree, List<PhasedUnits> phasedUnitsOfDependencies, boolean forCompiledModule) {
        ArtifactContext artifactContext = new ArtifactContext(null, module.getNameAsString(), module.getVersion(), ".src");
        RepositoryManager repositoryManager = this.context.getRepositoryManager();
        Exception exceptionOnGetArtifact = null;
        ArtifactResult sourceArtifact = null;
        try {
            sourceArtifact = repositoryManager.getArtifactResult(artifactContext);
        }
        catch (Exception e) {
            exceptionOnGetArtifact = e;
        }
        if (sourceArtifact == null) {
            ModuleHelper.buildErrorOnMissingArtifact(artifactContext, module, moduleImport, dependencyTree, exceptionOnGetArtifact, this, true);
        } else {
            PhasedUnits modulePhasedUnits = this.createPhasedUnits();
            try (ClosableVirtualFile virtualArtifact = null;){
                virtualArtifact = this.context.getVfs().getFromZipFile(sourceArtifact.artifact());
                modulePhasedUnits.parseUnit(virtualArtifact);
                modulePhasedUnits.visitModules();
                this.addToPhasedUnitsOfDependencies(modulePhasedUnits, phasedUnitsOfDependencies, module);
            }
        }
    }

    protected void addToPhasedUnitsOfDependencies(PhasedUnits modulePhasedUnits, List<PhasedUnits> phasedUnitsOfDependencies, Module module) {
        phasedUnitsOfDependencies.add(modulePhasedUnits);
    }

    protected PhasedUnits createPhasedUnits() {
        return new PhasedUnits(this.context);
    }

    protected ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    protected Context getContext() {
        return this.context;
    }

    public Module getJdkModule() {
        return null;
    }

    public Module getJdkProviderModule() {
        return null;
    }

    public JdkProvider getJdkProvider() {
        return this.defaultJdkProvider;
    }

    public void preResolveDependenciesIfRequired(RepositoryManager repositoryManager) {
    }

    public static class ModuleDependencyAnalysisError
    extends AnalysisError {
        private boolean isError = true;

        public ModuleDependencyAnalysisError(Node treeNode, String message, int code) {
            super(treeNode, message, code);
        }

        public ModuleDependencyAnalysisError(Node treeNode, String message, int code, Backend backend) {
            super(treeNode, message, code, backend);
        }

        public ModuleDependencyAnalysisError(Node treeNode, String message) {
            super(treeNode, message);
        }

        public ModuleDependencyAnalysisError(Node treeNode, String message, boolean isError) {
            super(treeNode, message);
            this.isError = isError;
        }

        public ModuleDependencyAnalysisError(Node treeNode, String message, Backend backend) {
            super(treeNode, message, backend);
        }

        @Override
        public boolean isWarning() {
            return !this.isError;
        }
    }
}

