/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;

public class SelfReferenceVisitor
extends Visitor {
    private final TypeDeclaration typeDeclaration;
    private Tree.Statement lastExecutableStatement;
    private boolean declarationSection = false;
    private int nestedLevel = -1;
    private boolean defaultArgument;
    private boolean inCaseTypesList;
    private boolean inExtends;

    public SelfReferenceVisitor(TypeDeclaration td) {
        this.typeDeclaration = td;
    }

    private Declaration resolveTypeAliases(Declaration member) {
        if (member instanceof TypeDeclaration) {
            TypeDeclaration superclass = (TypeDeclaration)member;
            while (superclass != null && superclass.isAlias()) {
                Type et = superclass.getExtendedType();
                superclass = et == null ? null : et.getDeclaration();
            }
            member = superclass;
        }
        return member;
    }

    private void visitExtendedType(Tree.ExtendedTypeExpression that) {
        Declaration member;
        Tree.QualifiedType qt;
        Scope scope = that.getScope();
        CustomTree.ExtendedTypeExpression ete = (CustomTree.ExtendedTypeExpression)that;
        Tree.SimpleType type = ete.getType();
        if (type instanceof Tree.QualifiedType && (qt = (Tree.QualifiedType)type).getOuterType() instanceof Tree.SuperType) {
            scope = scope.getContainer();
        }
        if ((member = this.resolveTypeAliases(that.getDeclaration())) != null && !member.isStatic() && this.isInherited(scope, member)) {
            Declaration container = (Declaration)((Object)member.getContainer());
            that.addError("inherited member class may not be extended in initializer of '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is inherited by '" + this.typeDeclaration.getName() + "' from '" + container.getName() + "'");
        }
    }

    private void checkReference(Tree.MemberOrTypeExpression that) {
        Declaration member = this.resolveTypeAliases(that.getDeclaration());
        if (member != null) {
            if (this.isInheritingValueConstructor(that, member)) {
                Declaration container = (Declaration)((Object)member.getContainer());
                if (container.equals(this.typeDeclaration)) {
                    that.addError("value constructor '" + member.getName() + "' may not be used in initializer of class '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is a value constructor of '" + container.getName() + "'");
                } else {
                    that.addError("value constructor '" + member.getName() + "' may not be used in initializer of superclass '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is a value constructor of '" + container.getName() + "', which inherits '" + this.typeDeclaration.getName() + "'");
                }
            } else if (this.isInheritingAnonymousClass(member)) {
                if (member.equals(this.typeDeclaration)) {
                    that.addError("anonymous class '" + member.getName() + "' may not be used in its own initializer: '" + member.getName() + "' is an anonymous class");
                } else {
                    that.addError("anonymous class '" + member.getName() + "' may not be used in initializer of superclass '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is an anonymous class that inherits '" + this.typeDeclaration.getName() + "'");
                }
            }
        }
    }

    private void checkMemberReference(Tree.MemberOrTypeExpression that) {
        Declaration member = this.resolveTypeAliases(that.getDeclaration());
        if (member != null && !member.isStatic() && this.isInherited(that.getScope(), member)) {
            Declaration container = (Declaration)((Object)member.getContainer());
            if (this.inExtends) {
                that.addError("inherited member may not be used in extends clause of '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is inherited by '" + this.typeDeclaration.getName() + "' from '" + container.getName() + "'");
            } else if (!member.isJava()) {
                that.addError("inherited member may not be used in initializer of '" + this.typeDeclaration.getName() + "': '" + member.getName() + "' is inherited by '" + this.typeDeclaration.getName() + "' from '" + container.getName() + "'");
            }
        }
    }

    private boolean isInheritingValueConstructor(Tree.Primary that, Declaration member) {
        if (member instanceof Value) {
            return this.inInitializer() && !this.inCaseTypesList && ModelUtil.isConstructor(member) && ((TypeDeclaration)member.getContainer()).inherits(this.typeDeclaration);
        }
        return false;
    }

    private boolean isInheritingAnonymousClass(Declaration member) {
        if (member instanceof Value) {
            Value value = (Value)member;
            if (this.inInitializer() && !this.inCaseTypesList) {
                TypeDeclaration vtd = value.getTypeDeclaration();
                return vtd != null && vtd.isObjectClass() && vtd.inherits(this.typeDeclaration);
            }
            return false;
        }
        return false;
    }

    private boolean isInherited(Scope scope, Declaration member) {
        return this.inInitializer() && scope.getInheritingDeclaration(member) == this.typeDeclaration;
    }

    @Override
    public void visit(Tree.CaseTypes that) {
        this.inCaseTypesList = true;
        super.visit(that);
        this.inCaseTypesList = false;
    }

    @Override
    public void visit(Tree.AnnotationList that) {
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        this.inExtends = true;
        super.visit(that);
        this.inExtends = false;
    }

    @Override
    public void visit(Tree.ExtendedTypeExpression that) {
        super.visit(that);
        this.visitExtendedType(that);
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        this.checkMemberReference(that);
        this.checkReference(that);
    }

    @Override
    public void visit(Tree.BaseTypeExpression that) {
        super.visit(that);
        this.checkMemberReference(that);
        this.checkReference(that);
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        super.visit(that);
        if (this.isSelfReference(that.getPrimary())) {
            this.checkMemberReference(that);
        }
        this.checkReference(that);
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression that) {
        super.visit(that);
        if (this.isSelfReference(that.getPrimary())) {
            this.checkMemberReference(that);
        }
        this.checkReference(that);
    }

    private boolean isSelfReference(Tree.Term that) {
        Tree.Term term = TreeUtil.eliminateParensAndWidening(that);
        return this.directlyInBody() && (term instanceof Tree.This || term instanceof Tree.Super) || this.directlyInNestedBody() && that instanceof Tree.Outer;
    }

    @Override
    public void visit(Tree.IsCondition that) {
        Tree.SpecifierExpression se;
        Tree.Variable v;
        super.visit(that);
        if (this.inBody() && (v = that.getVariable()) != null && (se = v.getSpecifierExpression()) != null) {
            Tree.Term term = se.getExpression().getTerm();
            if (this.directlyInBody() && term instanceof Tree.Super) {
                term.addError("narrows 'super': '" + this.typeDeclaration.getName() + "'");
            } else if (this.mayNotLeakThis() && term instanceof Tree.This) {
                term.addError("narrows 'this' in initializer: '" + this.typeDeclaration.getName() + "'");
            } else if (this.mayNotLeakOuter() && term instanceof Tree.Outer) {
                term.addError("narrows 'outer' in initializer: '" + this.typeDeclaration.getName() + "'");
            }
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (that.getAnonymousClass() == this.typeDeclaration) {
            this.nestedLevel = 0;
            super.visit(that);
            this.nestedLevel = -1;
        } else if (this.inBody()) {
            ++this.nestedLevel;
            super.visit(that);
            --this.nestedLevel;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        if (that.getAnonymousClass() == this.typeDeclaration) {
            this.nestedLevel = 0;
            super.visit(that);
            this.nestedLevel = -1;
        } else if (this.inBody()) {
            ++this.nestedLevel;
            super.visit(that);
            --this.nestedLevel;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        if (that.getAnonymousClass() == this.typeDeclaration) {
            this.nestedLevel = 0;
            super.visit(that);
            this.nestedLevel = -1;
        } else if (this.inBody()) {
            ++this.nestedLevel;
            super.visit(that);
            --this.nestedLevel;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.TypeDeclaration that) {
        if (that.getDeclarationModel() == this.typeDeclaration) {
            this.nestedLevel = 0;
            this.declarationSection = false;
            super.visit(that);
            this.nestedLevel = -1;
        } else if (this.inBody()) {
            ++this.nestedLevel;
            super.visit(that);
            --this.nestedLevel;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.InterfaceBody that) {
        if (this.directlyInBody()) {
            this.declarationSection = true;
            this.lastExecutableStatement = null;
            super.visit(that);
            this.declarationSection = false;
        } else {
            super.visit(that);
        }
    }

    private boolean directlyInBody() {
        return this.nestedLevel == 0;
    }

    @Override
    public void visit(Tree.ClassBody that) {
        if (this.directlyInBody()) {
            Tree.Statement les = AnalyzerUtil.getLastExecutableStatement(that);
            this.declarationSection = les == null;
            this.lastExecutableStatement = les;
            super.visit(that);
            this.lastExecutableStatement = null;
            this.declarationSection = false;
        } else {
            super.visit(that);
        }
    }

    boolean mayNotLeakThis() {
        return !this.declarationSection && this.directlyInBody();
    }

    boolean mayNotLeakOuter() {
        return !this.declarationSection && this.directlyInNestedBody();
    }

    private boolean directlyInNestedBody() {
        return this.nestedLevel == 1;
    }

    private boolean inBody() {
        return this.nestedLevel >= 0;
    }

    private boolean inInitializer() {
        return this.inBody() && !this.declarationSection;
    }

    @Override
    public void visit(Tree.Statement that) {
        super.visit(that);
        if (this.inBody()) {
            this.declarationSection = this.declarationSection || that == this.lastExecutableStatement;
        }
    }

    private void checkSelfReference(Node that, Tree.Term term) {
        Tree.QualifiedMemberExpression qme;
        TypedDeclaration td;
        Tree.BaseMemberExpression bme;
        Declaration declaration;
        Tree.Term t = TreeUtil.eliminateParensAndWidening(term);
        if (this.directlyInBody() && t instanceof Tree.Super) {
            that.addError("leaks 'super' reference: '" + this.typeDeclaration.getName() + "'");
        }
        if (this.mayNotLeakThis() && t instanceof Tree.This) {
            that.addError("leaks 'this' reference in initializer: '" + this.typeDeclaration.getName() + "'");
        }
        if (this.mayNotLeakOuter() && t instanceof Tree.Outer) {
            that.addError("leaks 'outer' reference in initializer: '" + this.typeDeclaration.getName() + "'");
        }
        if (this.typeDeclaration.isObjectClass() && this.mayNotLeakAnonymousClass() && t instanceof Tree.BaseMemberExpression && (declaration = (bme = (Tree.BaseMemberExpression)t).getDeclaration()) instanceof TypedDeclaration && (td = (TypedDeclaration)declaration).getTypeDeclaration() == this.typeDeclaration) {
            that.addError("anonymous class leaks self reference in initializer: '" + this.typeDeclaration.getName() + "'");
        }
        if (this.typeDeclaration.isObjectClass() && this.mayNotLeakAnonymousClass() && t instanceof Tree.QualifiedMemberExpression && (qme = (Tree.QualifiedMemberExpression)t).getPrimary() instanceof Tree.Outer && (declaration = qme.getDeclaration()) instanceof TypedDeclaration && (td = (TypedDeclaration)declaration).getTypeDeclaration() == this.typeDeclaration) {
            that.addError("anonymous class leaks self reference in initializer: '" + this.typeDeclaration.getName() + "'");
        }
    }

    boolean mayNotLeakAnonymousClass() {
        return !this.declarationSection && this.inBody();
    }

    @Override
    public void visit(Tree.Parameter that) {
        boolean oda = this.defaultArgument;
        this.defaultArgument = true;
        super.visit(that);
        this.defaultArgument = oda;
    }

    @Override
    public void visit(Tree.Super that) {
        super.visit(that);
        if (this.defaultArgument) {
            that.addError("reference to super from default argument expression");
        }
    }

    @Override
    public void visit(Tree.Return that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null && this.inBody()) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.Throw that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null && this.inBody()) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null && this.inBody()) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.SpecifierOrInitializerExpression that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null && this.inBody()) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        if (this.inBody()) {
            FunctionOrValue fov;
            Tree.MemberOrTypeExpression mte;
            Declaration d;
            Tree.Expression e;
            Tree.Term lt = that.getBaseMemberExpression();
            Tree.SpecifierExpression se = that.getSpecifierExpression();
            if (lt instanceof Tree.MemberOrTypeExpression && se != null && (e = se.getExpression()) != null && e.getTerm() instanceof Tree.This && (d = (mte = (Tree.MemberOrTypeExpression)lt).getDeclaration()) instanceof FunctionOrValue && (fov = (FunctionOrValue)d).isLate()) {
                lt.visit(this);
                return;
            }
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AssignmentOp that) {
        super.visit(that);
        if (this.inBody()) {
            FunctionOrValue fov;
            Tree.MemberOrTypeExpression mte;
            Declaration d;
            Tree.Term lt = that.getLeftTerm();
            Tree.Term rt = that.getRightTerm();
            if (lt instanceof Tree.MemberOrTypeExpression && rt instanceof Tree.This && (d = (mte = (Tree.MemberOrTypeExpression)lt).getDeclaration()) instanceof FunctionOrValue && (fov = (FunctionOrValue)d).isLate()) {
                return;
            }
            this.checkSelfReference(that, rt);
        }
    }

    @Override
    public void visit(Tree.BinaryOperatorExpression that) {
        super.visit(that);
        if (this.inBody() && !(that instanceof Tree.AssignmentOp)) {
            this.checkSelfReference(that, that.getLeftTerm());
            this.checkSelfReference(that, that.getRightTerm());
        }
    }

    @Override
    public void visit(Tree.UnaryOperatorExpression that) {
        super.visit(that);
        if (this.inBody() && !(that instanceof Tree.OfOp)) {
            this.checkSelfReference(that, that.getTerm());
        }
    }

    @Override
    public void visit(Tree.IndexExpression that) {
        super.visit(that);
        if (this.inBody()) {
            this.checkSelfReference(that, that.getPrimary());
        }
    }

    @Override
    public void visit(Tree.Element that) {
        super.visit(that);
        if (this.inBody()) {
            this.checkSelfReference(that, that.getExpression());
        }
    }

    @Override
    public void visit(Tree.ElementRange that) {
        super.visit(that);
        if (this.inBody()) {
            this.checkSelfReference(that, that.getLowerBound());
            this.checkSelfReference(that, that.getUpperBound());
            this.checkSelfReference(that, that.getLength());
        }
    }

    @Override
    public void visit(Tree.WithinOp that) {
        super.visit(that);
        if (this.inBody()) {
            this.checkSelfReference(that, that.getTerm());
            this.checkSelfReference(that, that.getLowerBound());
            this.checkSelfReference(that, that.getUpperBound());
        }
    }

    @Override
    public void visit(Tree.ExpressionComprehensionClause that) {
        Tree.Expression e;
        super.visit(that);
        if (this.inBody() && (e = that.getExpression()) != null) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.ListedArgument that) {
        Tree.Expression e;
        super.visit(that);
        if (this.inBody() && (e = that.getExpression()) != null) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.SpreadArgument that) {
        Tree.Expression e;
        super.visit(that);
        if (this.inBody() && (e = that.getExpression()) != null) {
            this.checkSelfReference(that, e.getTerm());
        }
    }

    @Override
    public void visit(Tree.StringTemplate that) {
        super.visit(that);
        if (this.inBody()) {
            for (Tree.Expression e : that.getExpressions()) {
                if (e == null) continue;
                this.checkSelfReference(e, e.getTerm());
            }
        }
    }
}

