/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AliasVisitor;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.DecidabilityException;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SupertypeVisitor
extends Visitor {
    private boolean displayErrors;

    public SupertypeVisitor(boolean displayErrors) {
        this.displayErrors = displayErrors;
    }

    private boolean checkSupertypeVariance(Type type, TypeDeclaration d, Node node) {
        List<TypeDeclaration> errors = type.resolveAliases().checkDecidability();
        if (this.displayErrors) {
            for (TypeDeclaration td : errors) {
                Unit unit = node.getUnit();
                node.addError("type with contravariant type parameter '" + td.getName() + "' appears in contravariant or invariant location in supertype: '" + type.asString(unit) + "'");
            }
        }
        return !errors.isEmpty();
    }

    private void checkForUndecidability(Tree.ExtendedType etn, Tree.SatisfiedTypes stn, TypeDeclaration type, Tree.TypeDeclaration that) {
        TypeDeclaration td;
        Type t;
        Tree.SimpleType et;
        boolean errors = false;
        if (stn != null) {
            for (Tree.StaticType st : stn.getTypes()) {
                TypeDeclaration td2;
                Type t2 = st.getTypeModel();
                if (t2 == null || (td2 = t2.getDeclaration()) instanceof UnknownType || td2 instanceof TypeAlias) continue;
                if (td2 == type) {
                    this.brokenSatisfiedType(type, st, null);
                    errors = true;
                    continue;
                }
                List<TypeDeclaration> list = t2.isRecursiveRawTypeDefinition(Collections.singleton(type));
                if (list.isEmpty()) continue;
                this.brokenSatisfiedType(type, st, list);
                errors = true;
            }
        }
        if (etn != null && (et = etn.getType()) != null && (t = et.getTypeModel()) != null && !((td = t.getDeclaration()) instanceof UnknownType) && !(td instanceof TypeAlias)) {
            if (td == type) {
                this.brokenExtendedType(type, et, null);
                errors = true;
            } else {
                List<TypeDeclaration> list = t.isRecursiveRawTypeDefinition(Collections.singleton(type));
                if (!list.isEmpty()) {
                    this.brokenExtendedType(type, et, list);
                    errors = true;
                }
            }
        }
        if (!errors) {
            Type t3;
            Tree.SimpleType et2;
            Unit unit = type.getUnit();
            ArrayList<Type> list = new ArrayList<Type>();
            try {
                List<Type> supertypes = type.getType().getSupertypes();
                for (Type st : supertypes) {
                    ModelUtil.addToIntersection(list, st, unit);
                }
                ModelUtil.canonicalIntersection(list, unit);
            }
            catch (DecidabilityException re) {
                this.brokenHierarchy(type, that, unit);
                return;
            }
            try {
                type.getType().getUnionOfCases();
            }
            catch (DecidabilityException re) {
                this.brokenSelfType(type, that);
            }
            if (stn != null) {
                for (Tree.StaticType st : stn.getTypes()) {
                    Type t4 = st.getTypeModel();
                    if (t4 == null || !this.checkSupertypeVariance(t4, type, st)) continue;
                    type.getSatisfiedTypes().remove(t4);
                    type.clearProducedTypeCache();
                }
            }
            if (etn != null && (et2 = etn.getType()) != null && (t3 = et2.getTypeModel()) != null && this.checkSupertypeVariance(t3, type, et2)) {
                type.setExtendedType(unit.getBasicType());
                type.clearProducedTypeCache();
            }
        }
    }

    private void brokenSelfType(TypeDeclaration type, Tree.TypeDeclaration that) {
        if (this.displayErrors) {
            that.addError("inheritance hierarchy is undecidable: coverage analysis did not terminate for '" + type.getName() + "'");
        }
        type.getCaseTypes().clear();
        type.clearProducedTypeCache();
    }

    private void brokenHierarchy(TypeDeclaration type, Tree.TypeDeclaration that, Unit unit) {
        if (this.displayErrors) {
            that.addError("inheritance hierarchy is undecidable: could not canonicalize the intersection of all supertypes of '" + type.getName() + "'");
        }
        type.getSatisfiedTypes().clear();
        type.setExtendedType(unit.getBasicType());
        type.clearProducedTypeCache();
    }

    private void brokenExtendedType(TypeDeclaration d, Tree.StaticType et, List<TypeDeclaration> list) {
        if (this.displayErrors) {
            et.addError(this.message(d, list));
        }
        Type pt = et.getTypeModel();
        et.setTypeModel(null);
        d.setExtendedType(et.getUnit().getBasicType());
        d.addBrokenSupertype(pt);
        d.clearProducedTypeCache();
    }

    private void brokenSatisfiedType(TypeDeclaration d, Tree.StaticType st, List<TypeDeclaration> list) {
        if (this.displayErrors) {
            st.addError(this.message(d, list));
        }
        Type pt = st.getTypeModel();
        st.setTypeModel(null);
        d.getSatisfiedTypes().remove(pt);
        d.addBrokenSupertype(pt);
        d.clearProducedTypeCache();
    }

    private String message(TypeDeclaration d, List<TypeDeclaration> list) {
        return list == null ? "inheritance is circular: '" + d.getName() + "' inherits itself" : "inheritance is circular: definition of '" + d.getName() + "' is recursive, involving " + AliasVisitor.typeList(list);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        super.visit(that);
        this.checkForUndecidability(that.getExtendedType(), that.getSatisfiedTypes(), that.getDeclarationModel(), that);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        super.visit(that);
        this.checkForUndecidability(null, that.getSatisfiedTypes(), that.getDeclarationModel(), that);
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        super.visit(that);
        this.checkForUndecidability(null, that.getSatisfiedTypes(), that.getDeclarationModel(), that);
    }
}

