/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io.impl;

import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.Helper;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipFileVirtualFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ZipFolderVirtualFile
implements VirtualFile {
    private final String name;
    private final String path;
    private final String entryName;
    private final List<VirtualFile> children = new ArrayList<VirtualFile>();

    public ZipFolderVirtualFile(String entryName, String rootPath) {
        this.name = Helper.getSimpleName(entryName);
        this.entryName = entryName;
        String tempPath = rootPath + "!/" + entryName;
        this.path = tempPath.endsWith("/") ? tempPath.substring(0, tempPath.length() - 1) : tempPath;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRelativePath(VirtualFile ancestor) {
        if (ancestor instanceof ZipFolderVirtualFile) {
            if (this.getPath().equals(ancestor.getPath())) {
                return "";
            }
            if (this.getPath().startsWith(ancestor.getPath() + "/")) {
                return this.getPath().substring(ancestor.getPath().length() + 1);
            }
        } else if (ancestor instanceof ZipFileVirtualFile) {
            if (this.getPath().equals(ancestor.getPath())) {
                return "";
            }
            if (this.getPath().startsWith(ancestor.getPath() + "!/")) {
                return this.getPath().substring(ancestor.getPath().length() + 2);
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        throw new IllegalStateException("Cannot call getInputStream() on a directory: " + this.getPath());
    }

    public List<VirtualFile> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(VirtualFile file) {
        this.children.add(file);
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ZipFolderVirtualFile");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualFile) {
            return ((VirtualFile)obj).getPath().equals(this.getPath());
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(VirtualFile o) {
        return this.getPath().compareTo(o.getPath());
    }
}

