/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.tree;

import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.tree.Walker;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;

public class Tree {

    public static class IfComprehensionClause
    extends InitialComprehensionClause {
        private ConditionList conditionList;
        private ComprehensionClause comprehensionClause;

        public IfComprehensionClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIfComprehensionClause(visitor, this);
        }

        public ConditionList getConditionList() {
            return this.conditionList;
        }

        public void setConditionList(ConditionList node) {
            this.conditionList = node;
            this.connect(node);
        }

        public ComprehensionClause getComprehensionClause() {
            return this.comprehensionClause;
        }

        public void setComprehensionClause(ComprehensionClause node) {
            this.comprehensionClause = node;
            this.connect(node);
        }
    }

    public static class ForComprehensionClause
    extends InitialComprehensionClause {
        private ForIterator forIterator;
        private ComprehensionClause comprehensionClause;

        public ForComprehensionClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkForComprehensionClause(visitor, this);
        }

        public ForIterator getForIterator() {
            return this.forIterator;
        }

        public void setForIterator(ForIterator node) {
            this.forIterator = node;
            this.connect(node);
        }

        public ComprehensionClause getComprehensionClause() {
            return this.comprehensionClause;
        }

        public void setComprehensionClause(ComprehensionClause node) {
            this.comprehensionClause = node;
            this.connect(node);
        }
    }

    public static class ExpressionComprehensionClause
    extends ComprehensionClause {
        private Expression expression;

        public ExpressionComprehensionClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExpressionComprehensionClause(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static abstract class InitialComprehensionClause
    extends ComprehensionClause {
        public InitialComprehensionClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInitialComprehensionClause(visitor, this);
        }
    }

    public static abstract class ComprehensionClause
    extends ControlClause {
        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        private com.redhat.ceylon.model.typechecker.model.Type firstTypeModel;
        private boolean possiblyEmpty;

        public ComprehensionClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkComprehensionClause(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() {
            return this.typeModel;
        }

        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.typeModel = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Type getFirstTypeModel() {
            return this.firstTypeModel;
        }

        public void setFirstTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.firstTypeModel = value;
        }

        public boolean getPossiblyEmpty() {
            return this.possiblyEmpty;
        }

        public void setPossiblyEmpty(boolean value) {
            this.possiblyEmpty = value;
        }
    }

    public static class Comprehension
    extends PositionalArgument {
        private InitialComprehensionClause initialComprehensionClause;

        public Comprehension(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkComprehension(visitor, this);
        }

        public InitialComprehensionClause getInitialComprehensionClause() {
            return this.initialComprehensionClause;
        }

        public void setInitialComprehensionClause(InitialComprehensionClause node) {
            this.initialComprehensionClause = node;
            this.connect(node);
        }
    }

    public static class Identifier
    extends Node {
        public Identifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIdentifier(visitor, this);
        }
    }

    public static class AnnotationList
    extends Node {
        private AnonymousAnnotation anonymousAnnotation;
        private List<Annotation> annotations = new ArrayList<Annotation>(3);

        public AnnotationList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnnotationList(visitor, this);
        }

        public AnonymousAnnotation getAnonymousAnnotation() {
            return this.anonymousAnnotation;
        }

        public void setAnonymousAnnotation(AnonymousAnnotation node) {
            this.anonymousAnnotation = node;
            this.connect(node);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public void addAnnotation(Annotation node) {
            this.annotations.add(node);
            this.connect(node);
        }
    }

    public static class AnonymousAnnotation
    extends Node {
        private StringLiteral stringLiteral;
        private StringTemplate stringTemplate;

        public AnonymousAnnotation(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnonymousAnnotation(visitor, this);
        }

        public StringLiteral getStringLiteral() {
            return this.stringLiteral;
        }

        public void setStringLiteral(StringLiteral node) {
            this.stringLiteral = node;
            this.connect(node);
        }

        public StringTemplate getStringTemplate() {
            return this.stringTemplate;
        }

        public void setStringTemplate(StringTemplate node) {
            this.stringTemplate = node;
            this.connect(node);
        }
    }

    public static class Annotation
    extends InvocationExpression {
        public Annotation(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnnotation(visitor, this);
        }
    }

    public static class StringTemplate
    extends Atom {
        private List<StringLiteral> stringLiterals = new ArrayList<StringLiteral>(3);
        private List<Expression> expressions = new ArrayList<Expression>(3);

        public StringTemplate(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStringTemplate(visitor, this);
        }

        public List<StringLiteral> getStringLiterals() {
            return this.stringLiterals;
        }

        public void addStringLiteral(StringLiteral node) {
            this.stringLiterals.add(node);
            this.connect(node);
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public void addExpression(Expression node) {
            this.expressions.add(node);
            this.connect(node);
        }
    }

    public static class Dynamic
    extends Atom {
        private NamedArgumentList namedArgumentList;

        public Dynamic(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDynamic(visitor, this);
        }

        public NamedArgumentList getNamedArgumentList() {
            return this.namedArgumentList;
        }

        public void setNamedArgumentList(NamedArgumentList node) {
            this.namedArgumentList = node;
            this.connect(node);
        }
    }

    public static class Tuple
    extends Atom {
        private SequencedArgument sequencedArgument;

        public Tuple(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTuple(visitor, this);
        }

        public SequencedArgument getSequencedArgument() {
            return this.sequencedArgument;
        }

        public void setSequencedArgument(SequencedArgument node) {
            this.sequencedArgument = node;
            this.connect(node);
        }
    }

    public static class SequenceEnumeration
    extends Atom {
        private SequencedArgument sequencedArgument;
        private List<Statement> statements = new ArrayList<Statement>(3);

        public SequenceEnumeration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSequenceEnumeration(visitor, this);
        }

        public SequencedArgument getSequencedArgument() {
            return this.sequencedArgument;
        }

        public void setSequencedArgument(SequencedArgument node) {
            this.sequencedArgument = node;
            this.connect(node);
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public void addStatement(Statement node) {
            this.statements.add(node);
            this.connect(node);
        }
    }

    public static class Super
    extends SelfExpression {
        public Super(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSuper(visitor, this);
        }
    }

    public static class This
    extends SelfExpression {
        public This(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkThis(visitor, this);
        }
    }

    public static abstract class SelfExpression
    extends Atom {
        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;

        public SelfExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSelfExpression(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) {
            this.declarationModel = value;
        }
    }

    public static class DocLink
    extends Node {
        private Module module;
        private com.redhat.ceylon.model.typechecker.model.Package pkg;
        private com.redhat.ceylon.model.typechecker.model.Declaration base;
        private List<com.redhat.ceylon.model.typechecker.model.Declaration> qualified;

        public DocLink(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDocLink(visitor, this);
        }

        public Module getModule() {
            return this.module;
        }

        public void setModule(Module value) {
            this.module = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Package getPkg() {
            return this.pkg;
        }

        public void setPkg(com.redhat.ceylon.model.typechecker.model.Package value) {
            this.pkg = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Declaration getBase() {
            return this.base;
        }

        public void setBase(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.base = value;
        }

        public List<com.redhat.ceylon.model.typechecker.model.Declaration> getQualified() {
            return this.qualified;
        }

        public void setQualified(List<com.redhat.ceylon.model.typechecker.model.Declaration> value) {
            this.qualified = value;
        }
    }

    public static class QuotedLiteral
    extends Literal {
        public QuotedLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQuotedLiteral(visitor, this);
        }
    }

    public static class StringLiteral
    extends Literal {
        private List<DocLink> docLinks = new ArrayList<DocLink>(3);

        public StringLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStringLiteral(visitor, this);
        }

        public List<DocLink> getDocLinks() {
            return this.docLinks;
        }

        public void addDocLink(DocLink node) {
            this.docLinks.add(node);
            this.connect(node);
        }
    }

    public static class CharLiteral
    extends Literal {
        public CharLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCharLiteral(visitor, this);
        }
    }

    public static class FloatLiteral
    extends Literal {
        public FloatLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFloatLiteral(visitor, this);
        }
    }

    public static class NaturalLiteral
    extends Literal {
        public NaturalLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNaturalLiteral(visitor, this);
        }
    }

    public static abstract class Literal
    extends Atom {
        public Literal(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLiteral(visitor, this);
        }
    }

    public static abstract class Atom
    extends Primary {
        public Atom(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAtom(visitor, this);
        }
    }

    public static class InitializerExpression
    extends SpecifierOrInitializerExpression {
        public InitializerExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInitializerExpression(visitor, this);
        }
    }

    public static class LazySpecifierExpression
    extends SpecifierExpression {
        public LazySpecifierExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLazySpecifierExpression(visitor, this);
        }
    }

    public static class SpecifierExpression
    extends SpecifierOrInitializerExpression {
        public SpecifierExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpecifierExpression(visitor, this);
        }
    }

    public static abstract class SpecifierOrInitializerExpression
    extends Node {
        private Expression expression;

        public SpecifierOrInitializerExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpecifierOrInitializerExpression(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class ObjectArgument
    extends TypedArgument {
        private ExtendedType extendedType;
        private SatisfiedTypes satisfiedTypes;
        private ClassBody classBody;
        private Value declarationModel;
        private Class anonymousClass;

        public ObjectArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkObjectArgument(visitor, this);
        }

        public ExtendedType getExtendedType() {
            return this.extendedType;
        }

        public void setExtendedType(ExtendedType node) {
            this.extendedType = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public ClassBody getClassBody() {
            return this.classBody;
        }

        public void setClassBody(ClassBody node) {
            this.classBody = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }

        public Class getAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(Class value) {
            this.anonymousClass = value;
        }
    }

    public static class AttributeArgument
    extends TypedArgument {
        private Block block;
        private SpecifierExpression specifierExpression;
        private Value declarationModel;

        public AttributeArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAttributeArgument(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }
    }

    public static class MethodArgument
    extends TypedArgument {
        private TypeParameterList typeParameterList;
        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        private Block block;
        private SpecifierExpression specifierExpression;
        private Function declarationModel;

        public MethodArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMethodArgument(visitor, this);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        public List<ParameterList> getParameterLists() {
            return this.parameterLists;
        }

        public void addParameterList(ParameterList node) {
            this.parameterLists.add(node);
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        @Override
        public Function getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Function value) {
            this.declarationModel = value;
        }
    }

    public static abstract class TypedArgument
    extends NamedArgument {
        private Type type;

        public TypedArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypedArgument(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public abstract com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclarationModel();
    }

    public static class SpecifiedArgument
    extends NamedArgument {
        private SpecifierExpression specifierExpression;

        public SpecifiedArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpecifiedArgument(visitor, this);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }
    }

    public static abstract class NamedArgument
    extends StatementOrArgument {
        private Identifier identifier;
        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;

        public NamedArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNamedArgument(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() {
            return this.parameter;
        }

        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) {
            this.parameter = value;
        }
    }

    public static class SwitchExpression
    extends Term {
        private SwitchClause switchClause;
        private SwitchCaseList switchCaseList;

        public SwitchExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSwitchExpression(visitor, this);
        }

        public SwitchClause getSwitchClause() {
            return this.switchClause;
        }

        public void setSwitchClause(SwitchClause node) {
            this.switchClause = node;
            this.connect(node);
        }

        public SwitchCaseList getSwitchCaseList() {
            return this.switchCaseList;
        }

        public void setSwitchCaseList(SwitchCaseList node) {
            this.switchCaseList = node;
            this.connect(node);
        }
    }

    public static class IfExpression
    extends Term {
        private IfClause ifClause;
        private ElseClause elseClause;

        public IfExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIfExpression(visitor, this);
        }

        public IfClause getIfClause() {
            return this.ifClause;
        }

        public void setIfClause(IfClause node) {
            this.ifClause = node;
            this.connect(node);
        }

        public ElseClause getElseClause() {
            return this.elseClause;
        }

        public void setElseClause(ElseClause node) {
            this.elseClause = node;
            this.connect(node);
        }
    }

    public static class ObjectExpression
    extends Primary {
        private ExtendedType extendedType;
        private SatisfiedTypes satisfiedTypes;
        private ClassBody classBody;
        private Class anonymousClass;

        public ObjectExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkObjectExpression(visitor, this);
        }

        public ExtendedType getExtendedType() {
            return this.extendedType;
        }

        public void setExtendedType(ExtendedType node) {
            this.extendedType = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public ClassBody getClassBody() {
            return this.classBody;
        }

        public void setClassBody(ClassBody node) {
            this.classBody = node;
            this.connect(node);
        }

        public Class getAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(Class value) {
            this.anonymousClass = value;
        }
    }

    public static class FunctionArgument
    extends Term {
        private Type type;
        private TypeParameterList typeParameterList;
        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        private TypeConstraintList typeConstraintList;
        private Expression expression;
        private Block block;
        private Function declarationModel;

        public FunctionArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFunctionArgument(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        public List<ParameterList> getParameterLists() {
            return this.parameterLists;
        }

        public void addParameterList(ParameterList node) {
            this.parameterLists.add(node);
            this.connect(node);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public Function getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Function value) {
            this.declarationModel = value;
        }
    }

    public static class SpreadArgument
    extends PositionalArgument {
        private Expression expression;

        public SpreadArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpreadArgument(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class ListedArgument
    extends PositionalArgument {
        private Expression expression;

        public ListedArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkListedArgument(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static abstract class PositionalArgument
    extends Node {
        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;

        public PositionalArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPositionalArgument(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() {
            return this.typeModel;
        }

        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.typeModel = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() {
            return this.parameter;
        }

        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) {
            this.parameter = value;
        }
    }

    public static class PositionalArgumentList
    extends ArgumentList {
        private List<PositionalArgument> positionalArguments = new ArrayList<PositionalArgument>(3);

        public PositionalArgumentList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPositionalArgumentList(visitor, this);
        }

        public List<PositionalArgument> getPositionalArguments() {
            return this.positionalArguments;
        }

        public void addPositionalArgument(PositionalArgument node) {
            this.positionalArguments.add(node);
            this.connect(node);
        }
    }

    public static class SequencedArgument
    extends StatementOrArgument {
        private List<PositionalArgument> positionalArguments = new ArrayList<PositionalArgument>(3);
        private com.redhat.ceylon.model.typechecker.model.Parameter parameter;

        public SequencedArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSequencedArgument(visitor, this);
        }

        public List<PositionalArgument> getPositionalArguments() {
            return this.positionalArguments;
        }

        public void addPositionalArgument(PositionalArgument node) {
            this.positionalArguments.add(node);
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.Parameter getParameter() {
            return this.parameter;
        }

        public void setParameter(com.redhat.ceylon.model.typechecker.model.Parameter value) {
            this.parameter = value;
        }
    }

    public static class NamedArgumentList
    extends ArgumentList {
        private List<NamedArgument> namedArguments = new ArrayList<NamedArgument>(3);
        private SequencedArgument sequencedArgument;
        private com.redhat.ceylon.model.typechecker.model.NamedArgumentList namedArgumentList;

        public NamedArgumentList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNamedArgumentList(visitor, this);
        }

        public List<NamedArgument> getNamedArguments() {
            return this.namedArguments;
        }

        public void addNamedArgument(NamedArgument node) {
            this.namedArguments.add(node);
            this.connect(node);
        }

        public SequencedArgument getSequencedArgument() {
            return this.sequencedArgument;
        }

        public void setSequencedArgument(SequencedArgument node) {
            this.sequencedArgument = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.NamedArgumentList getNamedArgumentList() {
            return this.namedArgumentList;
        }

        public void setNamedArgumentList(com.redhat.ceylon.model.typechecker.model.NamedArgumentList value) {
            this.namedArgumentList = value;
        }
    }

    public static abstract class ArgumentList
    extends Node {
        public ArgumentList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkArgumentList(visitor, this);
        }
    }

    public static class Package
    extends Atom {
        private boolean qualifier;

        public Package(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPackage(visitor, this);
        }

        public boolean getQualifier() {
            return this.qualifier;
        }

        public void setQualifier(boolean value) {
            this.qualifier = value;
        }
    }

    public static class Outer
    extends Atom {
        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;

        public Outer(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOuter(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) {
            this.declarationModel = value;
        }
    }

    public static class ElementRange
    extends ElementOrRange {
        private Expression lowerBound;
        private Expression upperBound;
        private Expression length;

        public ElementRange(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkElementRange(visitor, this);
        }

        public Expression getLowerBound() {
            return this.lowerBound;
        }

        public void setLowerBound(Expression node) {
            this.lowerBound = node;
            this.connect(node);
        }

        public Expression getUpperBound() {
            return this.upperBound;
        }

        public void setUpperBound(Expression node) {
            this.upperBound = node;
            this.connect(node);
        }

        public Expression getLength() {
            return this.length;
        }

        public void setLength(Expression node) {
            this.length = node;
            this.connect(node);
        }
    }

    public static class Element
    extends ElementOrRange {
        private Expression expression;

        public Element(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkElement(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static abstract class ElementOrRange
    extends Node {
        public ElementOrRange(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkElementOrRange(visitor, this);
        }
    }

    public static class IndexExpression
    extends PostfixExpression {
        private ElementOrRange elementOrRange;
        private boolean assigned;

        public IndexExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIndexExpression(visitor, this);
        }

        public ElementOrRange getElementOrRange() {
            return this.elementOrRange;
        }

        public void setElementOrRange(ElementOrRange node) {
            this.elementOrRange = node;
            this.connect(node);
        }

        public boolean getAssigned() {
            return this.assigned;
        }

        public void setAssigned(boolean value) {
            this.assigned = value;
        }
    }

    public static class SpreadOp
    extends MemberOperator {
        public SpreadOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpreadOp(visitor, this);
        }
    }

    public static class SafeMemberOp
    extends MemberOperator {
        public SafeMemberOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSafeMemberOp(visitor, this);
        }
    }

    public static class MemberOp
    extends MemberOperator {
        public MemberOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMemberOp(visitor, this);
        }
    }

    public static abstract class MemberOperator
    extends Node {
        public MemberOperator(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMemberOperator(visitor, this);
        }
    }

    public static class QualifiedTypeExpression
    extends QualifiedMemberOrTypeExpression {
        public QualifiedTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQualifiedTypeExpression(visitor, this);
        }
    }

    public static class QualifiedMemberExpression
    extends QualifiedMemberOrTypeExpression {
        public QualifiedMemberExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQualifiedMemberExpression(visitor, this);
        }
    }

    public static abstract class QualifiedMemberOrTypeExpression
    extends StaticMemberOrTypeExpression {
        private Primary primary;
        private MemberOperator memberOperator;

        public QualifiedMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQualifiedMemberOrTypeExpression(visitor, this);
        }

        public Primary getPrimary() {
            return this.primary;
        }

        public void setPrimary(Primary node) {
            this.primary = node;
            this.connect(node);
        }

        public MemberOperator getMemberOperator() {
            return this.memberOperator;
        }

        public void setMemberOperator(MemberOperator node) {
            this.memberOperator = node;
            this.connect(node);
        }
    }

    public static class BaseTypeExpression
    extends BaseMemberOrTypeExpression {
        public BaseTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBaseTypeExpression(visitor, this);
        }
    }

    public static class BaseMemberExpression
    extends BaseMemberOrTypeExpression {
        public BaseMemberExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBaseMemberExpression(visitor, this);
        }
    }

    public static abstract class BaseMemberOrTypeExpression
    extends StaticMemberOrTypeExpression {
        public BaseMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBaseMemberOrTypeExpression(visitor, this);
        }
    }

    public static abstract class StaticMemberOrTypeExpression
    extends MemberOrTypeExpression {
        private Identifier identifier;
        private TypeArguments typeArguments;
        private TypedReference targetParameter;
        private com.redhat.ceylon.model.typechecker.model.Type parameterType;

        public StaticMemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStaticMemberOrTypeExpression(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public TypeArguments getTypeArguments() {
            return this.typeArguments;
        }

        public void setTypeArguments(TypeArguments node) {
            this.typeArguments = node;
            this.connect(node);
        }

        public TypedReference getTargetParameter() {
            return this.targetParameter;
        }

        public void setTargetParameter(TypedReference value) {
            this.targetParameter = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Type getParameterType() {
            return this.parameterType;
        }

        public void setParameterType(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.parameterType = value;
        }
    }

    public static class ExtendedTypeExpression
    extends MemberOrTypeExpression {
        public ExtendedTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExtendedTypeExpression(visitor, this);
        }
    }

    public static abstract class MemberOrTypeExpression
    extends Primary {
        private Reference target;
        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;
        private List<com.redhat.ceylon.model.typechecker.model.Type> signature;
        private boolean ellipsis;
        private boolean directlyInvoked;
        private boolean indirectlyInvoked;
        private boolean assigned;
        private boolean staticMethodReference;
        private boolean staticMethodReferencePrimary;

        public MemberOrTypeExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMemberOrTypeExpression(visitor, this);
        }

        public Reference getTarget() {
            return this.target;
        }

        public void setTarget(Reference value) {
            this.target = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.declaration = value;
        }

        public List<com.redhat.ceylon.model.typechecker.model.Type> getSignature() {
            return this.signature;
        }

        public void setSignature(List<com.redhat.ceylon.model.typechecker.model.Type> value) {
            this.signature = value;
        }

        public boolean getEllipsis() {
            return this.ellipsis;
        }

        public void setEllipsis(boolean value) {
            this.ellipsis = value;
        }

        public boolean getDirectlyInvoked() {
            return this.directlyInvoked;
        }

        public void setDirectlyInvoked(boolean value) {
            this.directlyInvoked = value;
        }

        public boolean getIndirectlyInvoked() {
            return this.indirectlyInvoked;
        }

        public void setIndirectlyInvoked(boolean value) {
            this.indirectlyInvoked = value;
        }

        public boolean getAssigned() {
            return this.assigned;
        }

        public void setAssigned(boolean value) {
            this.assigned = value;
        }

        public boolean getStaticMethodReference() {
            return this.staticMethodReference;
        }

        public void setStaticMethodReference(boolean value) {
            this.staticMethodReference = value;
        }

        public boolean getStaticMethodReferencePrimary() {
            return this.staticMethodReferencePrimary;
        }

        public void setStaticMethodReferencePrimary(boolean value) {
            this.staticMethodReferencePrimary = value;
        }
    }

    public static class ParameterizedExpression
    extends Primary {
        private Primary primary;
        private TypeParameterList typeParameterList;
        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        private boolean leftTerm;

        public ParameterizedExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkParameterizedExpression(visitor, this);
        }

        public Primary getPrimary() {
            return this.primary;
        }

        public void setPrimary(Primary node) {
            this.primary = node;
            this.connect(node);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        public List<ParameterList> getParameterLists() {
            return this.parameterLists;
        }

        public void addParameterList(ParameterList node) {
            this.parameterLists.add(node);
            this.connect(node);
        }

        public boolean getLeftTerm() {
            return this.leftTerm;
        }

        public void setLeftTerm(boolean value) {
            this.leftTerm = value;
        }
    }

    public static class InvocationExpression
    extends PostfixExpression {
        private PositionalArgumentList positionalArgumentList;
        private NamedArgumentList namedArgumentList;

        public InvocationExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInvocationExpression(visitor, this);
        }

        public PositionalArgumentList getPositionalArgumentList() {
            return this.positionalArgumentList;
        }

        public void setPositionalArgumentList(PositionalArgumentList node) {
            this.positionalArgumentList = node;
            this.connect(node);
        }

        public NamedArgumentList getNamedArgumentList() {
            return this.namedArgumentList;
        }

        public void setNamedArgumentList(NamedArgumentList node) {
            this.namedArgumentList = node;
            this.connect(node);
        }
    }

    public static abstract class PostfixExpression
    extends Primary {
        private Primary primary;

        public PostfixExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPostfixExpression(visitor, this);
        }

        public Primary getPrimary() {
            return this.primary;
        }

        public void setPrimary(Primary node) {
            this.primary = node;
            this.connect(node);
        }
    }

    public static abstract class Primary
    extends Term {
        public Primary(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPrimary(visitor, this);
        }
    }

    public static class ParExpression
    extends Expression {
        public ParExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkParExpression(visitor, this);
        }
    }

    public static class Expression
    extends Atom {
        private Term term;

        public Expression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExpression(visitor, this);
        }

        public Term getTerm() {
            return this.term;
        }

        public void setTerm(Term node) {
            this.term = node;
            this.connect(node);
        }
    }

    public static class ExpressionList
    extends Node {
        private List<Expression> expressions = new ArrayList<Expression>(3);

        public ExpressionList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExpressionList(visitor, this);
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public void addExpression(Expression node) {
            this.expressions.add(node);
            this.connect(node);
        }
    }

    public static class PostfixDecrementOp
    extends PostfixOperatorExpression {
        public PostfixDecrementOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPostfixDecrementOp(visitor, this);
        }
    }

    public static class PostfixIncrementOp
    extends PostfixOperatorExpression {
        public PostfixIncrementOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPostfixIncrementOp(visitor, this);
        }
    }

    public static abstract class PostfixOperatorExpression
    extends UnaryOperatorExpression {
        public PostfixOperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPostfixOperatorExpression(visitor, this);
        }
    }

    public static class DecrementOp
    extends PrefixOperatorExpression {
        public DecrementOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDecrementOp(visitor, this);
        }
    }

    public static class IncrementOp
    extends PrefixOperatorExpression {
        public IncrementOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIncrementOp(visitor, this);
        }
    }

    public static abstract class PrefixOperatorExpression
    extends UnaryOperatorExpression {
        public PrefixOperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPrefixOperatorExpression(visitor, this);
        }
    }

    public static class OfOp
    extends TypeOperatorExpression {
        public OfOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOfOp(visitor, this);
        }
    }

    public static class Extends
    extends TypeOperatorExpression {
        public Extends(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExtends(visitor, this);
        }
    }

    public static class Satisfies
    extends TypeOperatorExpression {
        public Satisfies(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSatisfies(visitor, this);
        }
    }

    public static class IsOp
    extends TypeOperatorExpression {
        public IsOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIsOp(visitor, this);
        }
    }

    public static abstract class TypeOperatorExpression
    extends UnaryOperatorExpression {
        private Type type;

        public TypeOperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeOperatorExpression(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class PositiveOp
    extends UnaryOperatorExpression {
        public PositiveOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPositiveOp(visitor, this);
        }
    }

    public static class NegativeOp
    extends UnaryOperatorExpression {
        public NegativeOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNegativeOp(visitor, this);
        }
    }

    public static class Nonempty
    extends UnaryOperatorExpression {
        public Nonempty(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNonempty(visitor, this);
        }
    }

    public static class Exists
    extends UnaryOperatorExpression {
        public Exists(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExists(visitor, this);
        }
    }

    public static class NotOp
    extends UnaryOperatorExpression {
        public NotOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNotOp(visitor, this);
        }
    }

    public static abstract class UnaryOperatorExpression
    extends OperatorExpression {
        private Term term;

        public UnaryOperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkUnaryOperatorExpression(visitor, this);
        }

        public Term getTerm() {
            return this.term;
        }

        public void setTerm(Term node) {
            this.term = node;
            this.connect(node);
        }
    }

    public static class InOp
    extends BinaryOperatorExpression {
        public InOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInOp(visitor, this);
        }
    }

    public static class CompareOp
    extends BinaryOperatorExpression {
        public CompareOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCompareOp(visitor, this);
        }
    }

    public static class SegmentOp
    extends BinaryOperatorExpression {
        public SegmentOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSegmentOp(visitor, this);
        }
    }

    public static class RangeOp
    extends BinaryOperatorExpression {
        public RangeOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkRangeOp(visitor, this);
        }
    }

    public static class EntryOp
    extends BinaryOperatorExpression {
        public EntryOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkEntryOp(visitor, this);
        }
    }

    public static class IdenticalOp
    extends BinaryOperatorExpression {
        public IdenticalOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIdenticalOp(visitor, this);
        }
    }

    public static class ThenOp
    extends BinaryOperatorExpression {
        public ThenOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkThenOp(visitor, this);
        }
    }

    public static class DefaultOp
    extends BinaryOperatorExpression {
        public DefaultOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDefaultOp(visitor, this);
        }
    }

    public static class WithinOp
    extends OperatorExpression {
        private Bound upperBound;
        private Bound lowerBound;
        private Term term;

        public WithinOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkWithinOp(visitor, this);
        }

        public Bound getUpperBound() {
            return this.upperBound;
        }

        public void setUpperBound(Bound node) {
            this.upperBound = node;
            this.connect(node);
        }

        public Bound getLowerBound() {
            return this.lowerBound;
        }

        public void setLowerBound(Bound node) {
            this.lowerBound = node;
            this.connect(node);
        }

        public Term getTerm() {
            return this.term;
        }

        public void setTerm(Term node) {
            this.term = node;
            this.connect(node);
        }
    }

    public static class ClosedBound
    extends Bound {
        public ClosedBound(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClosedBound(visitor, this);
        }
    }

    public static class OpenBound
    extends Bound {
        public OpenBound(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOpenBound(visitor, this);
        }
    }

    public static abstract class Bound
    extends Term {
        private Term term;

        public Bound(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBound(visitor, this);
        }

        public Term getTerm() {
            return this.term;
        }

        public void setTerm(Term node) {
            this.term = node;
            this.connect(node);
        }
    }

    public static class ScaleOp
    extends BinaryOperatorExpression {
        public ScaleOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkScaleOp(visitor, this);
        }
    }

    public static class SmallAsOp
    extends ComparisonOp {
        public SmallAsOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSmallAsOp(visitor, this);
        }
    }

    public static class LargeAsOp
    extends ComparisonOp {
        public LargeAsOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLargeAsOp(visitor, this);
        }
    }

    public static class SmallerOp
    extends ComparisonOp {
        public SmallerOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSmallerOp(visitor, this);
        }
    }

    public static class LargerOp
    extends ComparisonOp {
        public LargerOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLargerOp(visitor, this);
        }
    }

    public static abstract class ComparisonOp
    extends BinaryOperatorExpression {
        public ComparisonOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkComparisonOp(visitor, this);
        }
    }

    public static class NotEqualOp
    extends EqualityOp {
        public NotEqualOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNotEqualOp(visitor, this);
        }
    }

    public static class EqualOp
    extends EqualityOp {
        public EqualOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkEqualOp(visitor, this);
        }
    }

    public static abstract class EqualityOp
    extends BinaryOperatorExpression {
        public EqualityOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkEqualityOp(visitor, this);
        }
    }

    public static class ComplementOp
    extends BitwiseOp {
        public ComplementOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkComplementOp(visitor, this);
        }
    }

    public static class UnionOp
    extends BitwiseOp {
        public UnionOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkUnionOp(visitor, this);
        }
    }

    public static class IntersectionOp
    extends BitwiseOp {
        public IntersectionOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIntersectionOp(visitor, this);
        }
    }

    public static abstract class BitwiseOp
    extends BinaryOperatorExpression {
        public BitwiseOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBitwiseOp(visitor, this);
        }
    }

    public static class OrOp
    extends LogicalOp {
        public OrOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOrOp(visitor, this);
        }
    }

    public static class AndOp
    extends LogicalOp {
        public AndOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAndOp(visitor, this);
        }
    }

    public static abstract class LogicalOp
    extends BinaryOperatorExpression {
        public LogicalOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLogicalOp(visitor, this);
        }
    }

    public static class OrAssignOp
    extends LogicalAssignmentOp {
        public OrAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOrAssignOp(visitor, this);
        }
    }

    public static class AndAssignOp
    extends LogicalAssignmentOp {
        public AndAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAndAssignOp(visitor, this);
        }
    }

    public static abstract class LogicalAssignmentOp
    extends AssignmentOp {
        public LogicalAssignmentOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLogicalAssignmentOp(visitor, this);
        }
    }

    public static class ComplementAssignOp
    extends BitwiseAssignmentOp {
        public ComplementAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkComplementAssignOp(visitor, this);
        }
    }

    public static class UnionAssignOp
    extends BitwiseAssignmentOp {
        public UnionAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkUnionAssignOp(visitor, this);
        }
    }

    public static class IntersectAssignOp
    extends BitwiseAssignmentOp {
        public IntersectAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIntersectAssignOp(visitor, this);
        }
    }

    public static abstract class BitwiseAssignmentOp
    extends AssignmentOp {
        public BitwiseAssignmentOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBitwiseAssignmentOp(visitor, this);
        }
    }

    public static class RemainderAssignOp
    extends ArithmeticAssignmentOp {
        public RemainderAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkRemainderAssignOp(visitor, this);
        }
    }

    public static class DivideAssignOp
    extends ArithmeticAssignmentOp {
        public DivideAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDivideAssignOp(visitor, this);
        }
    }

    public static class MultiplyAssignOp
    extends ArithmeticAssignmentOp {
        public MultiplyAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMultiplyAssignOp(visitor, this);
        }
    }

    public static class SubtractAssignOp
    extends ArithmeticAssignmentOp {
        public SubtractAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSubtractAssignOp(visitor, this);
        }
    }

    public static class AddAssignOp
    extends ArithmeticAssignmentOp {
        public AddAssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAddAssignOp(visitor, this);
        }
    }

    public static abstract class ArithmeticAssignmentOp
    extends AssignmentOp {
        public ArithmeticAssignmentOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkArithmeticAssignmentOp(visitor, this);
        }
    }

    public static class AssignOp
    extends AssignmentOp {
        public AssignOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAssignOp(visitor, this);
        }
    }

    public static abstract class AssignmentOp
    extends BinaryOperatorExpression {
        public AssignmentOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAssignmentOp(visitor, this);
        }
    }

    public static class RemainderOp
    extends ArithmeticOp {
        public RemainderOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkRemainderOp(visitor, this);
        }
    }

    public static class PowerOp
    extends ArithmeticOp {
        public PowerOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPowerOp(visitor, this);
        }
    }

    public static class QuotientOp
    extends ArithmeticOp {
        public QuotientOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQuotientOp(visitor, this);
        }
    }

    public static class ProductOp
    extends ArithmeticOp {
        public ProductOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkProductOp(visitor, this);
        }
    }

    public static class DifferenceOp
    extends ArithmeticOp {
        public DifferenceOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDifferenceOp(visitor, this);
        }
    }

    public static class SumOp
    extends ArithmeticOp {
        public SumOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSumOp(visitor, this);
        }
    }

    public static abstract class ArithmeticOp
    extends BinaryOperatorExpression {
        public ArithmeticOp(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkArithmeticOp(visitor, this);
        }
    }

    public static abstract class BinaryOperatorExpression
    extends OperatorExpression {
        private Term leftTerm;
        private Term rightTerm;

        public BinaryOperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBinaryOperatorExpression(visitor, this);
        }

        public Term getLeftTerm() {
            return this.leftTerm;
        }

        public void setLeftTerm(Term node) {
            this.leftTerm = node;
            this.connect(node);
        }

        public Term getRightTerm() {
            return this.rightTerm;
        }

        public void setRightTerm(Term node) {
            this.rightTerm = node;
            this.connect(node);
        }
    }

    public static abstract class OperatorExpression
    extends Term {
        public OperatorExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOperatorExpression(visitor, this);
        }
    }

    public static abstract class Term
    extends Node {
        private com.redhat.ceylon.model.typechecker.model.Type typeModel;
        private boolean unboxed;
        private boolean typeErased;
        private boolean untrustedType;
        private boolean small;

        public Term(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTerm(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() {
            return this.typeModel;
        }

        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.typeModel = value;
        }

        public boolean getUnboxed() {
            return this.unboxed;
        }

        public void setUnboxed(boolean value) {
            this.unboxed = value;
        }

        public boolean getTypeErased() {
            return this.typeErased;
        }

        public void setTypeErased(boolean value) {
            this.typeErased = value;
        }

        public boolean getUntrustedType() {
            return this.untrustedType;
        }

        public void setUntrustedType(boolean value) {
            this.untrustedType = value;
        }

        public boolean getSmall() {
            return this.small;
        }

        public void setSmall(boolean value) {
            this.small = value;
        }
    }

    public static class Variable
    extends TypedDeclaration {
        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        private SpecifierExpression specifierExpression;
        private Value declarationModel;

        public Variable(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkVariable(visitor, this);
        }

        public List<ParameterList> getParameterLists() {
            return this.parameterLists;
        }

        public void addParameterList(ParameterList node) {
            this.parameterLists.add(node);
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }
    }

    public static class SatisfiesCondition
    extends Condition {
        private Type type;
        private Identifier identifier;

        public SatisfiesCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSatisfiesCondition(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }
    }

    public static class IsCondition
    extends Condition {
        private Type type;
        private Variable variable;
        private boolean not;

        public IsCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIsCondition(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }

        public boolean getNot() {
            return this.not;
        }

        public void setNot(boolean value) {
            this.not = value;
        }
    }

    public static class NonemptyCondition
    extends ExistsOrNonemptyCondition {
        public NonemptyCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNonemptyCondition(visitor, this);
        }
    }

    public static class ExistsCondition
    extends ExistsOrNonemptyCondition {
        public ExistsCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExistsCondition(visitor, this);
        }
    }

    public static abstract class ExistsOrNonemptyCondition
    extends Condition {
        private Statement variable;
        private Expression brokenExpression;
        private boolean not;

        public ExistsOrNonemptyCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExistsOrNonemptyCondition(visitor, this);
        }

        public Statement getVariable() {
            return this.variable;
        }

        public void setVariable(Statement node) {
            this.variable = node;
            this.connect(node);
        }

        public Expression getBrokenExpression() {
            return this.brokenExpression;
        }

        public void setBrokenExpression(Expression node) {
            this.brokenExpression = node;
            this.connect(node);
        }

        public boolean getNot() {
            return this.not;
        }

        public void setNot(boolean value) {
            this.not = value;
        }
    }

    public static class BooleanCondition
    extends Condition {
        private Expression expression;

        public BooleanCondition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBooleanCondition(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static abstract class Condition
    extends Node {
        private boolean assertion;

        public Condition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCondition(visitor, this);
        }

        public boolean getAssertion() {
            return this.assertion;
        }

        public void setAssertion(boolean value) {
            this.assertion = value;
        }
    }

    public static class ConditionList
    extends Node {
        private List<Condition> conditions = new ArrayList<Condition>(3);

        public ConditionList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkConditionList(visitor, this);
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public void addCondition(Condition node) {
            this.conditions.add(node);
            this.connect(node);
        }
    }

    public static class WhileClause
    extends ControlClause {
        private ConditionList conditionList;
        private Block block;

        public WhileClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkWhileClause(visitor, this);
        }

        public ConditionList getConditionList() {
            return this.conditionList;
        }

        public void setConditionList(ConditionList node) {
            this.conditionList = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class WhileStatement
    extends ControlStatement {
        private WhileClause whileClause;

        public WhileStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkWhileStatement(visitor, this);
        }

        public WhileClause getWhileClause() {
            return this.whileClause;
        }

        public void setWhileClause(WhileClause node) {
            this.whileClause = node;
            this.connect(node);
        }
    }

    public static class PatternIterator
    extends ForIterator {
        private Pattern pattern;

        public PatternIterator(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPatternIterator(visitor, this);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern node) {
            this.pattern = node;
            this.connect(node);
        }
    }

    public static class ValueIterator
    extends ForIterator {
        private Variable variable;

        public ValueIterator(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkValueIterator(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }
    }

    public static class ForIterator
    extends StatementOrArgument {
        private SpecifierExpression specifierExpression;

        public ForIterator(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkForIterator(visitor, this);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }
    }

    public static class ForClause
    extends ControlClause {
        private ForIterator forIterator;
        private Block block;

        public ForClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkForClause(visitor, this);
        }

        public ForIterator getForIterator() {
            return this.forIterator;
        }

        public void setForIterator(ForIterator node) {
            this.forIterator = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class ForStatement
    extends ControlStatement {
        private ForClause forClause;
        private ElseClause elseClause;
        private boolean exits;

        public ForStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkForStatement(visitor, this);
        }

        public ForClause getForClause() {
            return this.forClause;
        }

        public void setForClause(ForClause node) {
            this.forClause = node;
            this.connect(node);
        }

        public ElseClause getElseClause() {
            return this.elseClause;
        }

        public void setElseClause(ElseClause node) {
            this.elseClause = node;
            this.connect(node);
        }

        public boolean getExits() {
            return this.exits;
        }

        public void setExits(boolean value) {
            this.exits = value;
        }
    }

    public static class CatchVariable
    extends Node {
        private Variable variable;

        public CatchVariable(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCatchVariable(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }
    }

    public static class Resource
    extends Node {
        private Variable variable;
        private Expression expression;

        public Resource(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkResource(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class ResourceList
    extends Node {
        private List<Resource> resources = new ArrayList<Resource>(3);

        public ResourceList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkResourceList(visitor, this);
        }

        public List<Resource> getResources() {
            return this.resources;
        }

        public void addResource(Resource node) {
            this.resources.add(node);
            this.connect(node);
        }
    }

    public static class FinallyClause
    extends ControlClause {
        private Block block;

        public FinallyClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFinallyClause(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class CatchClause
    extends ControlClause {
        private CatchVariable catchVariable;
        private Block block;

        public CatchClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCatchClause(visitor, this);
        }

        public CatchVariable getCatchVariable() {
            return this.catchVariable;
        }

        public void setCatchVariable(CatchVariable node) {
            this.catchVariable = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class TryClause
    extends ControlClause {
        private ResourceList resourceList;
        private Block block;

        public TryClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTryClause(visitor, this);
        }

        public ResourceList getResourceList() {
            return this.resourceList;
        }

        public void setResourceList(ResourceList node) {
            this.resourceList = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class TryCatchStatement
    extends ControlStatement {
        private TryClause tryClause;
        private List<CatchClause> catchClauses = new ArrayList<CatchClause>(3);
        private FinallyClause finallyClause;

        public TryCatchStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTryCatchStatement(visitor, this);
        }

        public TryClause getTryClause() {
            return this.tryClause;
        }

        public void setTryClause(TryClause node) {
            this.tryClause = node;
            this.connect(node);
        }

        public List<CatchClause> getCatchClauses() {
            return this.catchClauses;
        }

        public void addCatchClause(CatchClause node) {
            this.catchClauses.add(node);
            this.connect(node);
        }

        public FinallyClause getFinallyClause() {
            return this.finallyClause;
        }

        public void setFinallyClause(FinallyClause node) {
            this.finallyClause = node;
            this.connect(node);
        }
    }

    public static class SatisfiesCase
    extends CaseItem {
        private Type type;

        public SatisfiesCase(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSatisfiesCase(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class PatternCase
    extends CaseItem {
        private Pattern pattern;

        public PatternCase(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPatternCase(visitor, this);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern node) {
            this.pattern = node;
            this.connect(node);
        }
    }

    public static class IsCase
    extends CaseItem {
        private Type type;
        private Variable variable;

        public IsCase(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIsCase(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }
    }

    public static class MatchCase
    extends CaseItem {
        private ExpressionList expressionList;

        public MatchCase(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMatchCase(visitor, this);
        }

        public ExpressionList getExpressionList() {
            return this.expressionList;
        }

        public void setExpressionList(ExpressionList node) {
            this.expressionList = node;
            this.connect(node);
        }
    }

    public static class CaseItem
    extends Node {
        public CaseItem(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCaseItem(visitor, this);
        }
    }

    public static class CaseClause
    extends ControlClause {
        private CaseItem caseItem;
        private Block block;
        private Expression expression;

        public CaseClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCaseClause(visitor, this);
        }

        public CaseItem getCaseItem() {
            return this.caseItem;
        }

        public void setCaseItem(CaseItem node) {
            this.caseItem = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class SwitchCaseList
    extends Node {
        private List<CaseClause> caseClauses = new ArrayList<CaseClause>(3);
        private ElseClause elseClause;

        public SwitchCaseList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSwitchCaseList(visitor, this);
        }

        public List<CaseClause> getCaseClauses() {
            return this.caseClauses;
        }

        public void addCaseClause(CaseClause node) {
            this.caseClauses.add(node);
            this.connect(node);
        }

        public ElseClause getElseClause() {
            return this.elseClause;
        }

        public void setElseClause(ElseClause node) {
            this.elseClause = node;
            this.connect(node);
        }
    }

    public static class Switched
    extends Node {
        private Variable variable;
        private Expression expression;

        public Switched(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSwitched(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class SwitchClause
    extends Node {
        private Switched switched;

        public SwitchClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSwitchClause(visitor, this);
        }

        public Switched getSwitched() {
            return this.switched;
        }

        public void setSwitched(Switched node) {
            this.switched = node;
            this.connect(node);
        }
    }

    public static class SwitchStatement
    extends ControlStatement {
        private SwitchClause switchClause;
        private SwitchCaseList switchCaseList;
        private ControlBlock controlBlock;

        public SwitchStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSwitchStatement(visitor, this);
        }

        public SwitchClause getSwitchClause() {
            return this.switchClause;
        }

        public void setSwitchClause(SwitchClause node) {
            this.switchClause = node;
            this.connect(node);
        }

        public SwitchCaseList getSwitchCaseList() {
            return this.switchCaseList;
        }

        public void setSwitchCaseList(SwitchCaseList node) {
            this.switchCaseList = node;
            this.connect(node);
        }

        public ControlBlock getControlBlock() {
            return this.controlBlock;
        }

        public void setControlBlock(ControlBlock value) {
            this.controlBlock = value;
        }
    }

    public static class ElseClause
    extends ControlClause {
        private Variable variable;
        private Block block;
        private Expression expression;

        public ElseClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkElseClause(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class IfClause
    extends ControlClause {
        private ConditionList conditionList;
        private Block block;
        private Expression expression;

        public IfClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIfClause(visitor, this);
        }

        public ConditionList getConditionList() {
            return this.conditionList;
        }

        public void setConditionList(ConditionList node) {
            this.conditionList = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class IfStatement
    extends ControlStatement {
        private IfClause ifClause;
        private ElseClause elseClause;

        public IfStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIfStatement(visitor, this);
        }

        public IfClause getIfClause() {
            return this.ifClause;
        }

        public void setIfClause(IfClause node) {
            this.ifClause = node;
            this.connect(node);
        }

        public ElseClause getElseClause() {
            return this.elseClause;
        }

        public void setElseClause(ElseClause node) {
            this.elseClause = node;
            this.connect(node);
        }
    }

    public static class LetClause
    extends ControlClause {
        private List<Statement> variables = new ArrayList<Statement>(3);
        private Expression expression;

        public LetClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLetClause(visitor, this);
        }

        public List<Statement> getVariables() {
            return this.variables;
        }

        public void addVariable(Statement node) {
            this.variables.add(node);
            this.connect(node);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class LetExpression
    extends Term {
        private LetClause letClause;

        public LetExpression(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLetExpression(visitor, this);
        }

        public LetClause getLetClause() {
            return this.letClause;
        }

        public void setLetClause(LetClause node) {
            this.letClause = node;
            this.connect(node);
        }
    }

    public static class DynamicClause
    extends ControlClause {
        private Block block;

        public DynamicClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDynamicClause(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class DynamicStatement
    extends ControlStatement {
        private DynamicClause dynamicClause;

        public DynamicStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDynamicStatement(visitor, this);
        }

        public DynamicClause getDynamicClause() {
            return this.dynamicClause;
        }

        public void setDynamicClause(DynamicClause node) {
            this.dynamicClause = node;
            this.connect(node);
        }
    }

    public static class ControlClause
    extends Node {
        private ControlBlock controlBlock;

        public ControlClause(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkControlClause(visitor, this);
        }

        public ControlBlock getControlBlock() {
            return this.controlBlock;
        }

        public void setControlBlock(ControlBlock value) {
            this.controlBlock = value;
        }
    }

    public static class ControlStatement
    extends ExecutableStatement {
        public ControlStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkControlStatement(visitor, this);
        }
    }

    public static class Destructure
    extends ExecutableStatement {
        private ValueModifier type;
        private Pattern pattern;
        private SpecifierExpression specifierExpression;
        private boolean patternCase;

        public Destructure(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDestructure(visitor, this);
        }

        public ValueModifier getType() {
            return this.type;
        }

        public void setType(ValueModifier node) {
            this.type = node;
            this.connect(node);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern node) {
            this.pattern = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        public boolean getPatternCase() {
            return this.patternCase;
        }

        public void setPatternCase(boolean value) {
            this.patternCase = value;
        }
    }

    public static class KeyValuePattern
    extends Pattern {
        private Pattern key;
        private Pattern value;

        public KeyValuePattern(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkKeyValuePattern(visitor, this);
        }

        public Pattern getKey() {
            return this.key;
        }

        public void setKey(Pattern node) {
            this.key = node;
            this.connect(node);
        }

        public Pattern getValue() {
            return this.value;
        }

        public void setValue(Pattern node) {
            this.value = node;
            this.connect(node);
        }
    }

    public static class TuplePattern
    extends Pattern {
        private List<Pattern> patterns = new ArrayList<Pattern>(3);

        public TuplePattern(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTuplePattern(visitor, this);
        }

        public List<Pattern> getPatterns() {
            return this.patterns;
        }

        public void addPattern(Pattern node) {
            this.patterns.add(node);
            this.connect(node);
        }
    }

    public static class VariablePattern
    extends Pattern {
        private Variable variable;

        public VariablePattern(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkVariablePattern(visitor, this);
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable node) {
            this.variable = node;
            this.connect(node);
        }
    }

    public static abstract class Pattern
    extends Node {
        public Pattern(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPattern(visitor, this);
        }
    }

    public static class ExpressionStatement
    extends ExecutableStatement {
        private Expression expression;

        public ExpressionStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExpressionStatement(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class SpecifierStatement
    extends ExecutableStatement {
        private Term baseMemberExpression;
        private SpecifierExpression specifierExpression;
        private com.redhat.ceylon.model.typechecker.model.TypedDeclaration declaration;
        private boolean refinement;
        private com.redhat.ceylon.model.typechecker.model.TypedDeclaration refined;

        public SpecifierStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpecifierStatement(visitor, this);
        }

        public Term getBaseMemberExpression() {
            return this.baseMemberExpression;
        }

        public void setBaseMemberExpression(Term node) {
            this.baseMemberExpression = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.TypedDeclaration value) {
            this.declaration = value;
        }

        public boolean getRefinement() {
            return this.refinement;
        }

        public void setRefinement(boolean value) {
            this.refinement = value;
        }

        public com.redhat.ceylon.model.typechecker.model.TypedDeclaration getRefined() {
            return this.refined;
        }

        public void setRefined(com.redhat.ceylon.model.typechecker.model.TypedDeclaration value) {
            this.refined = value;
        }
    }

    public static class Assertion
    extends ExecutableStatement {
        private AnnotationList annotationList;
        private ConditionList conditionList;

        public Assertion(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAssertion(visitor, this);
        }

        public AnnotationList getAnnotationList() {
            return this.annotationList;
        }

        public void setAnnotationList(AnnotationList node) {
            this.annotationList = node;
            this.connect(node);
        }

        public ConditionList getConditionList() {
            return this.conditionList;
        }

        public void setConditionList(ConditionList node) {
            this.conditionList = node;
            this.connect(node);
        }
    }

    public static abstract class ExecutableStatement
    extends Statement {
        public ExecutableStatement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExecutableStatement(visitor, this);
        }
    }

    public static class CompilerAnnotation
    extends Node {
        private Identifier identifier;
        private StringLiteral stringLiteral;

        public CompilerAnnotation(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCompilerAnnotation(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public StringLiteral getStringLiteral() {
            return this.stringLiteral;
        }

        public void setStringLiteral(StringLiteral node) {
            this.stringLiteral = node;
            this.connect(node);
        }
    }

    public static abstract class Statement
    extends StatementOrArgument {
        public Statement(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStatement(visitor, this);
        }
    }

    public static abstract class StatementOrArgument
    extends Node {
        private List<CompilerAnnotation> compilerAnnotations = new ArrayList<CompilerAnnotation>(3);

        public StatementOrArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStatementOrArgument(visitor, this);
        }

        public List<CompilerAnnotation> getCompilerAnnotations() {
            return this.compilerAnnotations;
        }

        public void addCompilerAnnotation(CompilerAnnotation node) {
            this.compilerAnnotations.add(node);
            this.connect(node);
        }
    }

    public static class Break
    extends Directive {
        public Break(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBreak(visitor, this);
        }
    }

    public static class Continue
    extends Directive {
        public Continue(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkContinue(visitor, this);
        }
    }

    public static class Throw
    extends Directive {
        private Expression expression;

        public Throw(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkThrow(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }
    }

    public static class Return
    extends Directive {
        private Expression expression;
        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;

        public Return(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkReturn(visitor, this);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression node) {
            this.expression = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.declaration = value;
        }
    }

    public static abstract class Directive
    extends ExecutableStatement {
        public Directive(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDirective(visitor, this);
        }
    }

    public static class SpreadType
    extends Type {
        private Type type;

        public SpreadType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSpreadType(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class DefaultedType
    extends Type {
        private Type type;

        public DefaultedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDefaultedType(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class SequencedType
    extends Type {
        private Type type;
        private boolean atLeastOne;

        public SequencedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSequencedType(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public boolean getAtLeastOne() {
            return this.atLeastOne;
        }

        public void setAtLeastOne(boolean value) {
            this.atLeastOne = value;
        }
    }

    public static class InferredTypeArguments
    extends TypeArguments {
        public InferredTypeArguments(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInferredTypeArguments(visitor, this);
        }
    }

    public static class TypeArgumentList
    extends TypeArguments {
        private List<Type> types = new ArrayList<Type>(3);

        public TypeArgumentList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeArgumentList(visitor, this);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public void addType(Type node) {
            this.types.add(node);
            this.connect(node);
        }
    }

    public static class TypeArguments
    extends Node {
        private List<com.redhat.ceylon.model.typechecker.model.Type> typeModels;

        public TypeArguments(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeArguments(visitor, this);
        }

        public List<com.redhat.ceylon.model.typechecker.model.Type> getTypeModels() {
            return this.typeModels;
        }

        public void setTypeModels(List<com.redhat.ceylon.model.typechecker.model.Type> value) {
            this.typeModels = value;
        }
    }

    public static class SyntheticVariable
    extends ValueModifier {
        public SyntheticVariable(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSyntheticVariable(visitor, this);
        }
    }

    public static class FunctionModifier
    extends LocalModifier {
        public FunctionModifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFunctionModifier(visitor, this);
        }
    }

    public static class ValueModifier
    extends LocalModifier {
        public ValueModifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkValueModifier(visitor, this);
        }
    }

    public static abstract class LocalModifier
    extends Type {
        public LocalModifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkLocalModifier(visitor, this);
        }
    }

    public static class DynamicModifier
    extends Type {
        public DynamicModifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDynamicModifier(visitor, this);
        }
    }

    public static class PackageLiteral
    extends MetaLiteral {
        private ImportPath importPath;

        public PackageLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPackageLiteral(visitor, this);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }
    }

    public static class ModuleLiteral
    extends MetaLiteral {
        private ImportPath importPath;

        public ModuleLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkModuleLiteral(visitor, this);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }
    }

    public static class FunctionLiteral
    extends MemberLiteral {
        public FunctionLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFunctionLiteral(visitor, this);
        }
    }

    public static class ValueLiteral
    extends MemberLiteral {
        public ValueLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkValueLiteral(visitor, this);
        }
    }

    public static class TypeParameterLiteral
    extends TypeLiteral {
        public TypeParameterLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeParameterLiteral(visitor, this);
        }
    }

    public static class AliasLiteral
    extends TypeLiteral {
        public AliasLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAliasLiteral(visitor, this);
        }
    }

    public static class InterfaceLiteral
    extends TypeLiteral {
        public InterfaceLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInterfaceLiteral(visitor, this);
        }
    }

    public static class NewLiteral
    extends TypeLiteral {
        public NewLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkNewLiteral(visitor, this);
        }
    }

    public static class ClassLiteral
    extends TypeLiteral {
        public ClassLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassLiteral(visitor, this);
        }
    }

    public static class MemberLiteral
    extends MetaLiteral {
        private StaticType type;
        private Identifier identifier;
        private TypeArgumentList typeArgumentList;
        private boolean packageQualified;
        private Reference target;

        public MemberLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMemberLiteral(visitor, this);
        }

        public StaticType getType() {
            return this.type;
        }

        public void setType(StaticType node) {
            this.type = node;
            this.connect(node);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public TypeArgumentList getTypeArgumentList() {
            return this.typeArgumentList;
        }

        public void setTypeArgumentList(TypeArgumentList node) {
            this.typeArgumentList = node;
            this.connect(node);
        }

        public boolean getPackageQualified() {
            return this.packageQualified;
        }

        public void setPackageQualified(boolean value) {
            this.packageQualified = value;
        }

        public Reference getTarget() {
            return this.target;
        }

        public void setTarget(Reference value) {
            this.target = value;
        }
    }

    public static class TypeLiteral
    extends MetaLiteral {
        private StaticType type;

        public TypeLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeLiteral(visitor, this);
        }

        public StaticType getType() {
            return this.type;
        }

        public void setType(StaticType node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static abstract class MetaLiteral
    extends Primary {
        private boolean wantsDeclaration;
        private boolean broken;
        private com.redhat.ceylon.model.typechecker.model.Declaration declaration;

        public MetaLiteral(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMetaLiteral(visitor, this);
        }

        public boolean getWantsDeclaration() {
            return this.wantsDeclaration;
        }

        public void setWantsDeclaration(boolean value) {
            this.wantsDeclaration = value;
        }

        public boolean getBroken() {
            return this.broken;
        }

        public void setBroken(boolean value) {
            this.broken = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.declaration = value;
        }
    }

    public static class SuperType
    extends StaticType {
        public SuperType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSuperType(visitor, this);
        }
    }

    public static class TypeConstructor
    extends StaticType {
        private TypeParameterList typeParameterList;
        private Type type;
        private TypeConstraintList typeConstraintList;
        private TypeAlias declarationModel;

        public TypeConstructor(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeConstructor(visitor, this);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        public TypeAlias getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(TypeAlias value) {
            this.declarationModel = value;
        }
    }

    public static class EntryType
    extends StaticType {
        private StaticType keyType;
        private StaticType valueType;

        public EntryType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkEntryType(visitor, this);
        }

        public StaticType getKeyType() {
            return this.keyType;
        }

        public void setKeyType(StaticType node) {
            this.keyType = node;
            this.connect(node);
        }

        public StaticType getValueType() {
            return this.valueType;
        }

        public void setValueType(StaticType node) {
            this.valueType = node;
            this.connect(node);
        }
    }

    public static class FunctionType
    extends StaticType {
        private StaticType returnType;
        private List<Type> argumentTypes = new ArrayList<Type>(3);

        public FunctionType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFunctionType(visitor, this);
        }

        public StaticType getReturnType() {
            return this.returnType;
        }

        public void setReturnType(StaticType node) {
            this.returnType = node;
            this.connect(node);
        }

        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        public void addArgumentType(Type node) {
            this.argumentTypes.add(node);
            this.connect(node);
        }
    }

    public static class TupleType
    extends StaticType {
        private List<Type> elementTypes = new ArrayList<Type>(3);

        public TupleType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTupleType(visitor, this);
        }

        public List<Type> getElementTypes() {
            return this.elementTypes;
        }

        public void addElementType(Type node) {
            this.elementTypes.add(node);
            this.connect(node);
        }
    }

    public static class OptionalType
    extends StaticType {
        private StaticType definiteType;

        public OptionalType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkOptionalType(visitor, this);
        }

        public StaticType getDefiniteType() {
            return this.definiteType;
        }

        public void setDefiniteType(StaticType node) {
            this.definiteType = node;
            this.connect(node);
        }
    }

    public static class IterableType
    extends StaticType {
        private Type elementType;

        public IterableType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIterableType(visitor, this);
        }

        public Type getElementType() {
            return this.elementType;
        }

        public void setElementType(Type node) {
            this.elementType = node;
            this.connect(node);
        }
    }

    public static class SequenceType
    extends StaticType {
        private StaticType elementType;
        private NaturalLiteral length;

        public SequenceType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSequenceType(visitor, this);
        }

        public StaticType getElementType() {
            return this.elementType;
        }

        public void setElementType(StaticType node) {
            this.elementType = node;
            this.connect(node);
        }

        public NaturalLiteral getLength() {
            return this.length;
        }

        public void setLength(NaturalLiteral node) {
            this.length = node;
            this.connect(node);
        }
    }

    public static class IntersectionType
    extends StaticType {
        private List<StaticType> staticTypes = new ArrayList<StaticType>(3);

        public IntersectionType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkIntersectionType(visitor, this);
        }

        public List<StaticType> getStaticTypes() {
            return this.staticTypes;
        }

        public void addStaticType(StaticType node) {
            this.staticTypes.add(node);
            this.connect(node);
        }
    }

    public static class UnionType
    extends StaticType {
        private List<StaticType> staticTypes = new ArrayList<StaticType>(3);

        public UnionType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkUnionType(visitor, this);
        }

        public List<StaticType> getStaticTypes() {
            return this.staticTypes;
        }

        public void addStaticType(StaticType node) {
            this.staticTypes.add(node);
            this.connect(node);
        }
    }

    public static class QualifiedType
    extends SimpleType {
        private StaticType outerType;

        public QualifiedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkQualifiedType(visitor, this);
        }

        public StaticType getOuterType() {
            return this.outerType;
        }

        public void setOuterType(StaticType node) {
            this.outerType = node;
            this.connect(node);
        }
    }

    public static class BaseType
    extends SimpleType {
        private boolean packageQualified;

        public BaseType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBaseType(visitor, this);
        }

        public boolean getPackageQualified() {
            return this.packageQualified;
        }

        public void setPackageQualified(boolean value) {
            this.packageQualified = value;
        }
    }

    public static abstract class SimpleType
    extends StaticType {
        private Identifier identifier;
        private TypeArgumentList typeArgumentList;
        private com.redhat.ceylon.model.typechecker.model.TypeDeclaration declarationModel;
        private boolean inherited;

        public SimpleType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSimpleType(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public TypeArgumentList getTypeArgumentList() {
            return this.typeArgumentList;
        }

        public void setTypeArgumentList(TypeArgumentList node) {
            this.typeArgumentList = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.TypeDeclaration value) {
            this.declarationModel = value;
        }

        public boolean getInherited() {
            return this.inherited;
        }

        public void setInherited(boolean value) {
            this.inherited = value;
        }
    }

    public static class GroupedType
    extends StaticType {
        private StaticType type;

        public GroupedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkGroupedType(visitor, this);
        }

        public StaticType getType() {
            return this.type;
        }

        public void setType(StaticType node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static abstract class StaticType
    extends Type {
        private TypeVariance typeVariance;
        private boolean staticTypePrimary;
        private boolean metamodel;

        public StaticType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkStaticType(visitor, this);
        }

        public TypeVariance getTypeVariance() {
            return this.typeVariance;
        }

        public void setTypeVariance(TypeVariance node) {
            this.typeVariance = node;
            this.connect(node);
        }

        public boolean getStaticTypePrimary() {
            return this.staticTypePrimary;
        }

        public void setStaticTypePrimary(boolean value) {
            this.staticTypePrimary = value;
        }

        public boolean getMetamodel() {
            return this.metamodel;
        }

        public void setMetamodel(boolean value) {
            this.metamodel = value;
        }
    }

    public static abstract class Type
    extends Node {
        private com.redhat.ceylon.model.typechecker.model.Type typeModel;

        public Type(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkType(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.Type getTypeModel() {
            return this.typeModel;
        }

        public void setTypeModel(com.redhat.ceylon.model.typechecker.model.Type value) {
            this.typeModel = value;
        }
    }

    public static class InterfaceBody
    extends Body {
        public InterfaceBody(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInterfaceBody(visitor, this);
        }
    }

    public static class ClassBody
    extends Body {
        public ClassBody(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassBody(visitor, this);
        }
    }

    public static class Block
    extends Body {
        private boolean definitelyReturns;

        public Block(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBlock(visitor, this);
        }

        public boolean getDefinitelyReturns() {
            return this.definitelyReturns;
        }

        public void setDefinitelyReturns(boolean value) {
            this.definitelyReturns = value;
        }
    }

    public static abstract class Body
    extends Node {
        private ImportList importList;
        private List<Statement> statements = new ArrayList<Statement>(3);

        public Body(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkBody(visitor, this);
        }

        public ImportList getImportList() {
            return this.importList;
        }

        public void setImportList(ImportList node) {
            this.importList = node;
            this.connect(node);
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public void addStatement(Statement node) {
            this.statements.add(node);
            this.connect(node);
        }
    }

    public static class TypeVariance
    extends Node {
        public TypeVariance(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeVariance(visitor, this);
        }
    }

    public static class TypeParameterDeclaration
    extends Declaration {
        private TypeVariance typeVariance;
        private TypeSpecifier typeSpecifier;
        private TypeParameter declarationModel;

        public TypeParameterDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeParameterDeclaration(visitor, this);
        }

        public TypeVariance getTypeVariance() {
            return this.typeVariance;
        }

        public void setTypeVariance(TypeVariance node) {
            this.typeVariance = node;
            this.connect(node);
        }

        public TypeSpecifier getTypeSpecifier() {
            return this.typeSpecifier;
        }

        public void setTypeSpecifier(TypeSpecifier node) {
            this.typeSpecifier = node;
            this.connect(node);
        }

        @Override
        public TypeParameter getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(TypeParameter value) {
            this.declarationModel = value;
        }
    }

    public static class TypeParameterList
    extends Node {
        private List<TypeParameterDeclaration> typeParameterDeclarations = new ArrayList<TypeParameterDeclaration>(3);

        public TypeParameterList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeParameterList(visitor, this);
        }

        public List<TypeParameterDeclaration> getTypeParameterDeclarations() {
            return this.typeParameterDeclarations;
        }

        public void addTypeParameterDeclaration(TypeParameterDeclaration node) {
            this.typeParameterDeclarations.add(node);
            this.connect(node);
        }
    }

    public static class PatternParameter
    extends Parameter {
        private Pattern pattern;

        public PatternParameter(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPatternParameter(visitor, this);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern node) {
            this.pattern = node;
            this.connect(node);
        }
    }

    public static class InitializerParameter
    extends Parameter {
        private Identifier identifier;
        private SpecifierExpression specifierExpression;

        public InitializerParameter(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInitializerParameter(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }
    }

    public static class FunctionalParameterDeclaration
    extends ParameterDeclaration {
        public FunctionalParameterDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkFunctionalParameterDeclaration(visitor, this);
        }
    }

    public static class ValueParameterDeclaration
    extends ParameterDeclaration {
        public ValueParameterDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkValueParameterDeclaration(visitor, this);
        }
    }

    public static abstract class ParameterDeclaration
    extends Parameter {
        private TypedDeclaration typedDeclaration;

        public ParameterDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkParameterDeclaration(visitor, this);
        }

        public TypedDeclaration getTypedDeclaration() {
            return this.typedDeclaration;
        }

        public void setTypedDeclaration(TypedDeclaration node) {
            this.typedDeclaration = node;
            this.connect(node);
        }
    }

    public static abstract class Parameter
    extends Node {
        private com.redhat.ceylon.model.typechecker.model.Parameter parameterModel;

        public Parameter(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkParameter(visitor, this);
        }

        public com.redhat.ceylon.model.typechecker.model.Parameter getParameterModel() {
            return this.parameterModel;
        }

        public void setParameterModel(com.redhat.ceylon.model.typechecker.model.Parameter value) {
            this.parameterModel = value;
        }
    }

    public static class ParameterList
    extends Node {
        private List<Parameter> parameters = new ArrayList<Parameter>(3);
        private com.redhat.ceylon.model.typechecker.model.ParameterList model;

        public ParameterList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkParameterList(visitor, this);
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void addParameter(Parameter node) {
            this.parameters.add(node);
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.ParameterList getModel() {
            return this.model;
        }

        public void setModel(com.redhat.ceylon.model.typechecker.model.ParameterList value) {
            this.model = value;
        }
    }

    public static class ObjectDefinition
    extends TypedDeclaration {
        private ExtendedType extendedType;
        private SatisfiedTypes satisfiedTypes;
        private ClassBody classBody;
        private Value declarationModel;
        private Class anonymousClass;

        public ObjectDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkObjectDefinition(visitor, this);
        }

        public ExtendedType getExtendedType() {
            return this.extendedType;
        }

        public void setExtendedType(ExtendedType node) {
            this.extendedType = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public ClassBody getClassBody() {
            return this.classBody;
        }

        public void setClassBody(ClassBody node) {
            this.classBody = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }

        public Class getAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(Class value) {
            this.anonymousClass = value;
        }
    }

    public static class VoidModifier
    extends Type {
        public VoidModifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkVoidModifier(visitor, this);
        }
    }

    public static class MethodDeclaration
    extends AnyMethod {
        private SpecifierExpression specifierExpression;

        public MethodDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMethodDeclaration(visitor, this);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }
    }

    public static class MethodDefinition
    extends AnyMethod {
        private Block block;

        public MethodDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMethodDefinition(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }
    }

    public static class AnyMethod
    extends TypedDeclaration {
        private TypeParameterList typeParameterList;
        private List<ParameterList> parameterLists = new ArrayList<ParameterList>(3);
        private TypeConstraintList typeConstraintList;
        private Function declarationModel;

        public AnyMethod(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnyMethod(visitor, this);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        public List<ParameterList> getParameterLists() {
            return this.parameterLists;
        }

        public void addParameterList(ParameterList node) {
            this.parameterLists.add(node);
            this.connect(node);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        @Override
        public Function getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Function value) {
            this.declarationModel = value;
        }
    }

    public static class AttributeSetterDefinition
    extends TypedDeclaration {
        private Block block;
        private SpecifierExpression specifierExpression;
        private Setter declarationModel;

        public AttributeSetterDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAttributeSetterDefinition(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        public SpecifierExpression getSpecifierExpression() {
            return this.specifierExpression;
        }

        public void setSpecifierExpression(SpecifierExpression node) {
            this.specifierExpression = node;
            this.connect(node);
        }

        @Override
        public Setter getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Setter value) {
            this.declarationModel = value;
        }
    }

    public static class AttributeGetterDefinition
    extends AnyAttribute {
        private Block block;
        private Value declarationModel;

        public AttributeGetterDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAttributeGetterDefinition(visitor, this);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }
    }

    public static class AttributeDeclaration
    extends AnyAttribute {
        private SpecifierOrInitializerExpression specifierOrInitializerExpression;
        private Value declarationModel;

        public AttributeDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAttributeDeclaration(visitor, this);
        }

        public SpecifierOrInitializerExpression getSpecifierOrInitializerExpression() {
            return this.specifierOrInitializerExpression;
        }

        public void setSpecifierOrInitializerExpression(SpecifierOrInitializerExpression node) {
            this.specifierOrInitializerExpression = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }
    }

    public static abstract class AnyAttribute
    extends TypedDeclaration {
        public AnyAttribute(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnyAttribute(visitor, this);
        }
    }

    public static abstract class TypedDeclaration
    extends Declaration {
        private Type type;

        public TypedDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypedDeclaration(visitor, this);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type node) {
            this.type = node;
            this.connect(node);
        }

        @Override
        public abstract com.redhat.ceylon.model.typechecker.model.TypedDeclaration getDeclarationModel();
    }

    public static class InterfaceDeclaration
    extends AnyInterface {
        private TypeSpecifier typeSpecifier;

        public InterfaceDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInterfaceDeclaration(visitor, this);
        }

        public TypeSpecifier getTypeSpecifier() {
            return this.typeSpecifier;
        }

        public void setTypeSpecifier(TypeSpecifier node) {
            this.typeSpecifier = node;
            this.connect(node);
        }
    }

    public static class InterfaceDefinition
    extends AnyInterface {
        private InterfaceBody interfaceBody;
        private boolean dynamic;

        public InterfaceDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkInterfaceDefinition(visitor, this);
        }

        public InterfaceBody getInterfaceBody() {
            return this.interfaceBody;
        }

        public void setInterfaceBody(InterfaceBody node) {
            this.interfaceBody = node;
            this.connect(node);
        }

        public boolean getDynamic() {
            return this.dynamic;
        }

        public void setDynamic(boolean value) {
            this.dynamic = value;
        }
    }

    public static class AnyInterface
    extends ClassOrInterface {
        private CaseTypes caseTypes;
        private SatisfiedTypes satisfiedTypes;
        private TypeConstraintList typeConstraintList;
        private Interface declarationModel;

        public AnyInterface(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnyInterface(visitor, this);
        }

        public CaseTypes getCaseTypes() {
            return this.caseTypes;
        }

        public void setCaseTypes(CaseTypes node) {
            this.caseTypes = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        @Override
        public Interface getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Interface value) {
            this.declarationModel = value;
        }
    }

    public static class ClassDeclaration
    extends AnyClass {
        private ClassSpecifier classSpecifier;

        public ClassDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassDeclaration(visitor, this);
        }

        public ClassSpecifier getClassSpecifier() {
            return this.classSpecifier;
        }

        public void setClassSpecifier(ClassSpecifier node) {
            this.classSpecifier = node;
            this.connect(node);
        }
    }

    public static class DelegatedConstructor
    extends Node {
        private SimpleType type;
        private InvocationExpression invocationExpression;

        public DelegatedConstructor(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDelegatedConstructor(visitor, this);
        }

        public SimpleType getType() {
            return this.type;
        }

        public void setType(SimpleType node) {
            this.type = node;
            this.connect(node);
        }

        public InvocationExpression getInvocationExpression() {
            return this.invocationExpression;
        }

        public void setInvocationExpression(InvocationExpression node) {
            this.invocationExpression = node;
            this.connect(node);
        }
    }

    public static class Constructor
    extends Declaration {
        private ParameterList parameterList;
        private DelegatedConstructor delegatedConstructor;
        private Block block;
        private Function declarationModel;
        private com.redhat.ceylon.model.typechecker.model.Constructor constructor;

        public Constructor(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkConstructor(visitor, this);
        }

        public ParameterList getParameterList() {
            return this.parameterList;
        }

        public void setParameterList(ParameterList node) {
            this.parameterList = node;
            this.connect(node);
        }

        public DelegatedConstructor getDelegatedConstructor() {
            return this.delegatedConstructor;
        }

        public void setDelegatedConstructor(DelegatedConstructor node) {
            this.delegatedConstructor = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        @Override
        public Function getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Function value) {
            this.declarationModel = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Constructor getConstructor() {
            return this.constructor;
        }

        public void setConstructor(com.redhat.ceylon.model.typechecker.model.Constructor value) {
            this.constructor = value;
        }
    }

    public static class Enumerated
    extends Declaration {
        private DelegatedConstructor delegatedConstructor;
        private Block block;
        private Value declarationModel;
        private com.redhat.ceylon.model.typechecker.model.Constructor enumerated;

        public Enumerated(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkEnumerated(visitor, this);
        }

        public DelegatedConstructor getDelegatedConstructor() {
            return this.delegatedConstructor;
        }

        public void setDelegatedConstructor(DelegatedConstructor node) {
            this.delegatedConstructor = node;
            this.connect(node);
        }

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block node) {
            this.block = node;
            this.connect(node);
        }

        @Override
        public Value getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Value value) {
            this.declarationModel = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Constructor getEnumerated() {
            return this.enumerated;
        }

        public void setEnumerated(com.redhat.ceylon.model.typechecker.model.Constructor value) {
            this.enumerated = value;
        }
    }

    public static class ClassDefinition
    extends AnyClass {
        private ClassBody classBody;

        public ClassDefinition(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassDefinition(visitor, this);
        }

        public ClassBody getClassBody() {
            return this.classBody;
        }

        public void setClassBody(ClassBody node) {
            this.classBody = node;
            this.connect(node);
        }
    }

    public static class AnyClass
    extends ClassOrInterface {
        private ParameterList parameterList;
        private CaseTypes caseTypes;
        private ExtendedType extendedType;
        private SatisfiedTypes satisfiedTypes;
        private TypeConstraintList typeConstraintList;
        private Class declarationModel;

        public AnyClass(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAnyClass(visitor, this);
        }

        public ParameterList getParameterList() {
            return this.parameterList;
        }

        public void setParameterList(ParameterList node) {
            this.parameterList = node;
            this.connect(node);
        }

        public CaseTypes getCaseTypes() {
            return this.caseTypes;
        }

        public void setCaseTypes(CaseTypes node) {
            this.caseTypes = node;
            this.connect(node);
        }

        public ExtendedType getExtendedType() {
            return this.extendedType;
        }

        public void setExtendedType(ExtendedType node) {
            this.extendedType = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        @Override
        public Class getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(Class value) {
            this.declarationModel = value;
        }
    }

    public static class ClassSpecifier
    extends Node {
        private SimpleType type;
        private InvocationExpression invocationExpression;

        public ClassSpecifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassSpecifier(visitor, this);
        }

        public SimpleType getType() {
            return this.type;
        }

        public void setType(SimpleType node) {
            this.type = node;
            this.connect(node);
        }

        public InvocationExpression getInvocationExpression() {
            return this.invocationExpression;
        }

        public void setInvocationExpression(InvocationExpression node) {
            this.invocationExpression = node;
            this.connect(node);
        }
    }

    public static class DefaultTypeArgument
    extends TypeSpecifier {
        public DefaultTypeArgument(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDefaultTypeArgument(visitor, this);
        }
    }

    public static class TypeSpecifier
    extends Node {
        private StaticType type;

        public TypeSpecifier(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeSpecifier(visitor, this);
        }

        public StaticType getType() {
            return this.type;
        }

        public void setType(StaticType node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class TypeConstraint
    extends TypeDeclaration {
        private CaseTypes caseTypes;
        private SatisfiedTypes satisfiedTypes;
        private AbstractedType abstractedType;
        private TypeParameter declarationModel;

        public TypeConstraint(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeConstraint(visitor, this);
        }

        public CaseTypes getCaseTypes() {
            return this.caseTypes;
        }

        public void setCaseTypes(CaseTypes node) {
            this.caseTypes = node;
            this.connect(node);
        }

        public SatisfiedTypes getSatisfiedTypes() {
            return this.satisfiedTypes;
        }

        public void setSatisfiedTypes(SatisfiedTypes node) {
            this.satisfiedTypes = node;
            this.connect(node);
        }

        public AbstractedType getAbstractedType() {
            return this.abstractedType;
        }

        public void setAbstractedType(AbstractedType node) {
            this.abstractedType = node;
            this.connect(node);
        }

        @Override
        public TypeParameter getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(TypeParameter value) {
            this.declarationModel = value;
        }
    }

    public static class TypeConstraintList
    extends Node {
        private List<TypeConstraint> typeConstraints = new ArrayList<TypeConstraint>(3);

        public TypeConstraintList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeConstraintList(visitor, this);
        }

        public List<TypeConstraint> getTypeConstraints() {
            return this.typeConstraints;
        }

        public void addTypeConstraint(TypeConstraint node) {
            this.typeConstraints.add(node);
            this.connect(node);
        }
    }

    public static class ExtendedType
    extends Node {
        private SimpleType type;
        private InvocationExpression invocationExpression;

        public ExtendedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkExtendedType(visitor, this);
        }

        public SimpleType getType() {
            return this.type;
        }

        public void setType(SimpleType node) {
            this.type = node;
            this.connect(node);
        }

        public InvocationExpression getInvocationExpression() {
            return this.invocationExpression;
        }

        public void setInvocationExpression(InvocationExpression node) {
            this.invocationExpression = node;
            this.connect(node);
        }
    }

    public static class CaseTypes
    extends Node {
        private List<StaticType> types = new ArrayList<StaticType>(3);
        private List<BaseMemberExpression> baseMemberExpressions = new ArrayList<BaseMemberExpression>(3);

        public CaseTypes(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCaseTypes(visitor, this);
        }

        public List<StaticType> getTypes() {
            return this.types;
        }

        public void addType(StaticType node) {
            this.types.add(node);
            this.connect(node);
        }

        public List<BaseMemberExpression> getBaseMemberExpressions() {
            return this.baseMemberExpressions;
        }

        public void addBaseMemberExpression(BaseMemberExpression node) {
            this.baseMemberExpressions.add(node);
            this.connect(node);
        }
    }

    public static class AbstractedType
    extends Node {
        private StaticType type;

        public AbstractedType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAbstractedType(visitor, this);
        }

        public StaticType getType() {
            return this.type;
        }

        public void setType(StaticType node) {
            this.type = node;
            this.connect(node);
        }
    }

    public static class SatisfiedTypes
    extends Node {
        private List<StaticType> types = new ArrayList<StaticType>(3);

        public SatisfiedTypes(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkSatisfiedTypes(visitor, this);
        }

        public List<StaticType> getTypes() {
            return this.types;
        }

        public void addType(StaticType node) {
            this.types.add(node);
            this.connect(node);
        }
    }

    public static class TypeAliasDeclaration
    extends TypeDeclaration {
        private TypeConstraintList typeConstraintList;
        private TypeSpecifier typeSpecifier;
        private TypeAlias declarationModel;

        public TypeAliasDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeAliasDeclaration(visitor, this);
        }

        public TypeConstraintList getTypeConstraintList() {
            return this.typeConstraintList;
        }

        public void setTypeConstraintList(TypeConstraintList node) {
            this.typeConstraintList = node;
            this.connect(node);
        }

        public TypeSpecifier getTypeSpecifier() {
            return this.typeSpecifier;
        }

        public void setTypeSpecifier(TypeSpecifier node) {
            this.typeSpecifier = node;
            this.connect(node);
        }

        @Override
        public TypeAlias getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(TypeAlias value) {
            this.declarationModel = value;
        }
    }

    public static abstract class ClassOrInterface
    extends TypeDeclaration {
        public ClassOrInterface(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkClassOrInterface(visitor, this);
        }

        @Override
        public abstract com.redhat.ceylon.model.typechecker.model.ClassOrInterface getDeclarationModel();
    }

    public static abstract class TypeDeclaration
    extends Declaration {
        private TypeParameterList typeParameterList;

        public TypeDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkTypeDeclaration(visitor, this);
        }

        public TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }

        public void setTypeParameterList(TypeParameterList node) {
            this.typeParameterList = node;
            this.connect(node);
        }

        @Override
        public abstract com.redhat.ceylon.model.typechecker.model.TypeDeclaration getDeclarationModel();
    }

    public static class MissingDeclaration
    extends Declaration {
        private com.redhat.ceylon.model.typechecker.model.Declaration declarationModel;

        public MissingDeclaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkMissingDeclaration(visitor, this);
        }

        @Override
        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.declarationModel = value;
        }
    }

    public static abstract class Declaration
    extends Statement {
        private AnnotationList annotationList;
        private Identifier identifier;

        public Declaration(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkDeclaration(visitor, this);
        }

        public AnnotationList getAnnotationList() {
            return this.annotationList;
        }

        public void setAnnotationList(AnnotationList node) {
            this.annotationList = node;
            this.connect(node);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public abstract com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel();
    }

    public static class ImportWildcard
    extends Node {
        public ImportWildcard(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportWildcard(visitor, this);
        }
    }

    public static class Alias
    extends Node {
        private Identifier identifier;

        public Alias(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkAlias(visitor, this);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }
    }

    public static class ImportType
    extends ImportMemberOrType {
        public ImportType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportType(visitor, this);
        }
    }

    public static class ImportMember
    extends ImportMemberOrType {
        public ImportMember(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportMember(visitor, this);
        }
    }

    public static class ImportMemberOrType
    extends StatementOrArgument {
        private Alias alias;
        private Identifier identifier;
        private ImportMemberOrTypeList importMemberOrTypeList;
        private com.redhat.ceylon.model.typechecker.model.Declaration declarationModel;
        private com.redhat.ceylon.model.typechecker.model.Import importModel;

        public ImportMemberOrType(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportMemberOrType(visitor, this);
        }

        public Alias getAlias() {
            return this.alias;
        }

        public void setAlias(Alias node) {
            this.alias = node;
            this.connect(node);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier node) {
            this.identifier = node;
            this.connect(node);
        }

        public ImportMemberOrTypeList getImportMemberOrTypeList() {
            return this.importMemberOrTypeList;
        }

        public void setImportMemberOrTypeList(ImportMemberOrTypeList node) {
            this.importMemberOrTypeList = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.Declaration getDeclarationModel() {
            return this.declarationModel;
        }

        public void setDeclarationModel(com.redhat.ceylon.model.typechecker.model.Declaration value) {
            this.declarationModel = value;
        }

        public com.redhat.ceylon.model.typechecker.model.Import getImportModel() {
            return this.importModel;
        }

        public void setImportModel(com.redhat.ceylon.model.typechecker.model.Import value) {
            this.importModel = value;
        }
    }

    public static class ImportMemberOrTypeList
    extends Node {
        private List<ImportMemberOrType> importMemberOrTypes = new ArrayList<ImportMemberOrType>(3);
        private ImportWildcard importWildcard;
        private com.redhat.ceylon.model.typechecker.model.ImportList importList;

        public ImportMemberOrTypeList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportMemberOrTypeList(visitor, this);
        }

        public List<ImportMemberOrType> getImportMemberOrTypes() {
            return this.importMemberOrTypes;
        }

        public void addImportMemberOrType(ImportMemberOrType node) {
            this.importMemberOrTypes.add(node);
            this.connect(node);
        }

        public ImportWildcard getImportWildcard() {
            return this.importWildcard;
        }

        public void setImportWildcard(ImportWildcard node) {
            this.importWildcard = node;
            this.connect(node);
        }

        public com.redhat.ceylon.model.typechecker.model.ImportList getImportList() {
            return this.importList;
        }

        public void setImportList(com.redhat.ceylon.model.typechecker.model.ImportList value) {
            this.importList = value;
        }
    }

    public static class ImportPath
    extends Node {
        private List<Identifier> identifiers = new ArrayList<Identifier>(3);
        private Referenceable model;

        public ImportPath(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportPath(visitor, this);
        }

        public List<Identifier> getIdentifiers() {
            return this.identifiers;
        }

        public void addIdentifier(Identifier node) {
            this.identifiers.add(node);
            this.connect(node);
        }

        public Referenceable getModel() {
            return this.model;
        }

        public void setModel(Referenceable value) {
            this.model = value;
        }
    }

    public static class Import
    extends StatementOrArgument {
        private ImportPath importPath;
        private ImportMemberOrTypeList importMemberOrTypeList;

        public Import(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImport(visitor, this);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }

        public ImportMemberOrTypeList getImportMemberOrTypeList() {
            return this.importMemberOrTypeList;
        }

        public void setImportMemberOrTypeList(ImportMemberOrTypeList node) {
            this.importMemberOrTypeList = node;
            this.connect(node);
        }
    }

    public static class ImportList
    extends Node {
        private List<Import> imports = new ArrayList<Import>(3);

        public ImportList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportList(visitor, this);
        }

        public List<Import> getImports() {
            return this.imports;
        }

        public void addImport(Import node) {
            this.imports.add(node);
            this.connect(node);
        }
    }

    public static class ImportModule
    extends StatementOrArgument {
        private AnnotationList annotationList;
        private Identifier namespace;
        private ImportPath importPath;
        private QuotedLiteral quotedLiteral;
        private QuotedLiteral artifact;
        private QuotedLiteral version;
        private String name;

        public ImportModule(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportModule(visitor, this);
        }

        public AnnotationList getAnnotationList() {
            return this.annotationList;
        }

        public void setAnnotationList(AnnotationList node) {
            this.annotationList = node;
            this.connect(node);
        }

        public Identifier getNamespace() {
            return this.namespace;
        }

        public void setNamespace(Identifier node) {
            this.namespace = node;
            this.connect(node);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }

        public QuotedLiteral getQuotedLiteral() {
            return this.quotedLiteral;
        }

        public void setQuotedLiteral(QuotedLiteral node) {
            this.quotedLiteral = node;
            this.connect(node);
        }

        public QuotedLiteral getArtifact() {
            return this.artifact;
        }

        public void setArtifact(QuotedLiteral node) {
            this.artifact = node;
            this.connect(node);
        }

        public QuotedLiteral getVersion() {
            return this.version;
        }

        public void setVersion(QuotedLiteral node) {
            this.version = node;
            this.connect(node);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }
    }

    public static class ImportModuleList
    extends Node {
        private List<ImportModule> importModules = new ArrayList<ImportModule>(3);

        public ImportModuleList(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkImportModuleList(visitor, this);
        }

        public List<ImportModule> getImportModules() {
            return this.importModules;
        }

        public void addImportModule(ImportModule node) {
            this.importModules.add(node);
            this.connect(node);
        }
    }

    public static class PackageDescriptor
    extends StatementOrArgument {
        private AnnotationList annotationList;
        private ImportPath importPath;

        public PackageDescriptor(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkPackageDescriptor(visitor, this);
        }

        public AnnotationList getAnnotationList() {
            return this.annotationList;
        }

        public void setAnnotationList(AnnotationList node) {
            this.annotationList = node;
            this.connect(node);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }
    }

    public static class ModuleDescriptor
    extends StatementOrArgument {
        private AnnotationList annotationList;
        private ImportPath importPath;
        private Identifier namespace;
        private ImportPath groupImportPath;
        private QuotedLiteral groupQuotedLiteral;
        private QuotedLiteral artifact;
        private QuotedLiteral version;
        private ImportModuleList importModuleList;

        public ModuleDescriptor(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkModuleDescriptor(visitor, this);
        }

        public AnnotationList getAnnotationList() {
            return this.annotationList;
        }

        public void setAnnotationList(AnnotationList node) {
            this.annotationList = node;
            this.connect(node);
        }

        public ImportPath getImportPath() {
            return this.importPath;
        }

        public void setImportPath(ImportPath node) {
            this.importPath = node;
            this.connect(node);
        }

        public Identifier getNamespace() {
            return this.namespace;
        }

        public void setNamespace(Identifier node) {
            this.namespace = node;
            this.connect(node);
        }

        public ImportPath getGroupImportPath() {
            return this.groupImportPath;
        }

        public void setGroupImportPath(ImportPath node) {
            this.groupImportPath = node;
            this.connect(node);
        }

        public QuotedLiteral getGroupQuotedLiteral() {
            return this.groupQuotedLiteral;
        }

        public void setGroupQuotedLiteral(QuotedLiteral node) {
            this.groupQuotedLiteral = node;
            this.connect(node);
        }

        public QuotedLiteral getArtifact() {
            return this.artifact;
        }

        public void setArtifact(QuotedLiteral node) {
            this.artifact = node;
            this.connect(node);
        }

        public QuotedLiteral getVersion() {
            return this.version;
        }

        public void setVersion(QuotedLiteral node) {
            this.version = node;
            this.connect(node);
        }

        public ImportModuleList getImportModuleList() {
            return this.importModuleList;
        }

        public void setImportModuleList(ImportModuleList node) {
            this.importModuleList = node;
            this.connect(node);
        }
    }

    public static class CompilationUnit
    extends Node {
        private List<CompilerAnnotation> compilerAnnotations = new ArrayList<CompilerAnnotation>(3);
        private ImportList importList;
        private List<ModuleDescriptor> moduleDescriptors = new ArrayList<ModuleDescriptor>(3);
        private List<PackageDescriptor> packageDescriptors = new ArrayList<PackageDescriptor>(3);
        private List<Declaration> declarations = new ArrayList<Declaration>(3);
        private boolean literalsProcessed;

        public CompilationUnit(Token token) {
            super(token);
        }

        @Override
        public void visit(Visitor visitor) {
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                visitor.handleException(e, this);
            }
        }

        @Override
        public void visitChildren(Visitor visitor) {
            Walker.walkCompilationUnit(visitor, this);
        }

        public List<CompilerAnnotation> getCompilerAnnotations() {
            return this.compilerAnnotations;
        }

        public void addCompilerAnnotation(CompilerAnnotation node) {
            this.compilerAnnotations.add(node);
            this.connect(node);
        }

        public ImportList getImportList() {
            return this.importList;
        }

        public void setImportList(ImportList node) {
            this.importList = node;
            this.connect(node);
        }

        public List<ModuleDescriptor> getModuleDescriptors() {
            return this.moduleDescriptors;
        }

        public void addModuleDescriptor(ModuleDescriptor node) {
            this.moduleDescriptors.add(node);
            this.connect(node);
        }

        public List<PackageDescriptor> getPackageDescriptors() {
            return this.packageDescriptors;
        }

        public void addPackageDescriptor(PackageDescriptor node) {
            this.packageDescriptors.add(node);
            this.connect(node);
        }

        public List<Declaration> getDeclarations() {
            return this.declarations;
        }

        public void addDeclaration(Declaration node) {
            this.declarations.add(node);
            this.connect(node);
        }

        public boolean getLiteralsProcessed() {
            return this.literalsProcessed;
        }

        public void setLiteralsProcessed(boolean value) {
            this.literalsProcessed = value;
        }
    }
}

