/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.Set;

public class ReferenceCounter
extends Visitor {
    private Set<Declaration> referencedDeclarations = new HashSet<Declaration>();

    void referenced(Declaration d) {
        Setter setter;
        this.referencedDeclarations.add(d);
        if (d instanceof Value && (setter = ((Value)d).getSetter()) != null) {
            this.referencedDeclarations.add(setter);
        }
    }

    boolean isReferenced(Declaration d) {
        for (Declaration rd : this.referencedDeclarations) {
            Scope container = rd.getContainer();
            if (container == null || !container.equals(d.getContainer()) || !rd.getName().equals(d.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Tree.MemberOrTypeExpression that) {
        super.visit(that);
        Declaration d = that.getDeclaration();
        if (d != null) {
            this.referenced(d);
        }
    }

    @Override
    public void visit(Tree.SimpleType that) {
        super.visit(that);
        TypeDeclaration t = that.getDeclarationModel();
        if (t != null && !(t instanceof UnionType) && !(t instanceof IntersectionType)) {
            this.referenced(t);
        }
    }

    @Override
    public void visit(Tree.MemberLiteral that) {
        super.visit(that);
        Declaration d = that.getDeclaration();
        if (d != null) {
            this.referenced(d);
        }
    }

    @Override
    public void visit(Tree.DocLink that) {
        super.visit(that);
        Declaration d = that.getBase();
        if (d != null) {
            this.referenced(d);
        }
    }
}

