/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.AnnotationDefault_attribute;
import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.BootstrapMethods_attribute;
import com.redhat.ceylon.langtools.classfile.CharacterRangeTable_attribute;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.Code_attribute;
import com.redhat.ceylon.langtools.classfile.CompilationID_attribute;
import com.redhat.ceylon.langtools.classfile.ConcealedPackages_attribute;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantValue_attribute;
import com.redhat.ceylon.langtools.classfile.DefaultAttribute;
import com.redhat.ceylon.langtools.classfile.Deprecated_attribute;
import com.redhat.ceylon.langtools.classfile.Descriptor;
import com.redhat.ceylon.langtools.classfile.EnclosingMethod_attribute;
import com.redhat.ceylon.langtools.classfile.Exceptions_attribute;
import com.redhat.ceylon.langtools.classfile.Field;
import com.redhat.ceylon.langtools.classfile.InnerClasses_attribute;
import com.redhat.ceylon.langtools.classfile.LineNumberTable_attribute;
import com.redhat.ceylon.langtools.classfile.LocalVariableTable_attribute;
import com.redhat.ceylon.langtools.classfile.LocalVariableTypeTable_attribute;
import com.redhat.ceylon.langtools.classfile.MainClass_attribute;
import com.redhat.ceylon.langtools.classfile.Method;
import com.redhat.ceylon.langtools.classfile.MethodParameters_attribute;
import com.redhat.ceylon.langtools.classfile.Module_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeInvisibleAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeInvisibleParameterAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeInvisibleTypeAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleTypeAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.Signature_attribute;
import com.redhat.ceylon.langtools.classfile.SourceDebugExtension_attribute;
import com.redhat.ceylon.langtools.classfile.SourceFile_attribute;
import com.redhat.ceylon.langtools.classfile.SourceID_attribute;
import com.redhat.ceylon.langtools.classfile.StackMapTable_attribute;
import com.redhat.ceylon.langtools.classfile.StackMap_attribute;
import com.redhat.ceylon.langtools.classfile.Synthetic_attribute;
import com.redhat.ceylon.langtools.classfile.TypeAnnotation;
import com.redhat.ceylon.langtools.classfile.Version_attribute;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ClassWriter {
    protected ClassFile classFile;
    protected ClassOutputStream out;
    protected AttributeWriter attributeWriter = new AttributeWriter();
    protected ConstantPoolWriter constantPoolWriter = new ConstantPoolWriter();

    public ClassWriter() {
        this.out = new ClassOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ClassFile classFile, File f) throws IOException {
        try (FileOutputStream f_out = new FileOutputStream(f);){
            this.write(classFile, f_out);
        }
    }

    public void write(ClassFile classFile, OutputStream s) throws IOException {
        this.classFile = classFile;
        this.out.reset();
        this.write();
        this.out.writeTo(s);
    }

    protected void write() throws IOException {
        this.writeHeader();
        this.writeConstantPool();
        this.writeAccessFlags(this.classFile.access_flags);
        this.writeClassInfo();
        this.writeFields();
        this.writeMethods();
        this.writeAttributes(this.classFile.attributes);
    }

    protected void writeHeader() {
        this.out.writeInt(this.classFile.magic);
        this.out.writeShort(this.classFile.minor_version);
        this.out.writeShort(this.classFile.major_version);
    }

    protected void writeAccessFlags(AccessFlags flags) {
        this.out.writeShort(flags.flags);
    }

    protected void writeAttributes(Attributes attributes) {
        int size = attributes.size();
        this.out.writeShort(size);
        for (Attribute attr : attributes) {
            this.attributeWriter.write(attr, this.out);
        }
    }

    protected void writeClassInfo() {
        this.out.writeShort(this.classFile.this_class);
        this.out.writeShort(this.classFile.super_class);
        int[] interfaces = this.classFile.interfaces;
        this.out.writeShort(interfaces.length);
        for (int i : interfaces) {
            this.out.writeShort(i);
        }
    }

    protected void writeDescriptor(Descriptor d) {
        this.out.writeShort(d.index);
    }

    protected void writeConstantPool() {
        ConstantPool pool = this.classFile.constant_pool;
        int size = pool.size();
        this.out.writeShort(size);
        for (ConstantPool.CPInfo cpInfo : pool.entries()) {
            this.constantPoolWriter.write(cpInfo, this.out);
        }
    }

    protected void writeFields() throws IOException {
        Field[] fields = this.classFile.fields;
        this.out.writeShort(fields.length);
        for (Field f : fields) {
            this.writeField(f);
        }
    }

    protected void writeField(Field f) throws IOException {
        this.writeAccessFlags(f.access_flags);
        this.out.writeShort(f.name_index);
        this.writeDescriptor(f.descriptor);
        this.writeAttributes(f.attributes);
    }

    protected void writeMethods() throws IOException {
        Method[] methods = this.classFile.methods;
        this.out.writeShort(methods.length);
        for (Method m : methods) {
            this.writeMethod(m);
        }
    }

    protected void writeMethod(Method m) throws IOException {
        this.writeAccessFlags(m.access_flags);
        this.out.writeShort(m.name_index);
        this.writeDescriptor(m.descriptor);
        this.writeAttributes(m.attributes);
    }

    protected static class AnnotationWriter
    implements Annotation.element_value.Visitor<Void, ClassOutputStream> {
        protected AnnotationWriter() {
        }

        public void write(Annotation[] annos, ClassOutputStream out) {
            out.writeShort(annos.length);
            for (Annotation anno : annos) {
                this.write(anno, out);
            }
        }

        public void write(TypeAnnotation[] annos, ClassOutputStream out) {
            out.writeShort(annos.length);
            for (TypeAnnotation anno : annos) {
                this.write(anno, out);
            }
        }

        public void write(Annotation anno, ClassOutputStream out) {
            out.writeShort(anno.type_index);
            out.writeShort(anno.element_value_pairs.length);
            for (Annotation.element_value_pair p : anno.element_value_pairs) {
                this.write(p, out);
            }
        }

        public void write(TypeAnnotation anno, ClassOutputStream out) {
            this.write(anno.position, out);
            this.write(anno.annotation, out);
        }

        public void write(Annotation.element_value_pair pair, ClassOutputStream out) {
            out.writeShort(pair.element_name_index);
            this.write(pair.value, out);
        }

        public void write(Annotation.element_value ev, ClassOutputStream out) {
            out.writeByte(ev.tag);
            ev.accept(this, out);
        }

        @Override
        public Void visitPrimitive(Annotation.Primitive_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.const_value_index);
            return null;
        }

        @Override
        public Void visitEnum(Annotation.Enum_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.type_name_index);
            out.writeShort(ev.const_name_index);
            return null;
        }

        @Override
        public Void visitClass(Annotation.Class_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.class_info_index);
            return null;
        }

        @Override
        public Void visitAnnotation(Annotation.Annotation_element_value ev, ClassOutputStream out) {
            this.write(ev.annotation_value, out);
            return null;
        }

        @Override
        public Void visitArray(Annotation.Array_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.num_values);
            for (Annotation.element_value v : ev.values) {
                this.write(v, out);
            }
            return null;
        }

        private void write(TypeAnnotation.Position p, ClassOutputStream out) {
            out.writeByte(p.type.targetTypeValue());
            switch (p.type) {
                case INSTANCEOF: 
                case NEW: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE: {
                    out.writeShort(p.offset);
                    break;
                }
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: {
                    int table_length = p.lvarOffset.length;
                    out.writeShort(table_length);
                    for (int i = 0; i < table_length; ++i) {
                        out.writeShort(1);
                        out.writeShort(p.lvarOffset[i]);
                        out.writeShort(p.lvarLength[i]);
                        out.writeShort(p.lvarIndex[i]);
                    }
                    break;
                }
                case EXCEPTION_PARAMETER: {
                    out.writeShort(p.exception_index);
                    break;
                }
                case METHOD_RECEIVER: {
                    break;
                }
                case CLASS_TYPE_PARAMETER: 
                case METHOD_TYPE_PARAMETER: {
                    out.writeByte(p.parameter_index);
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: 
                case METHOD_TYPE_PARAMETER_BOUND: {
                    out.writeByte(p.parameter_index);
                    out.writeByte(p.bound_index);
                    break;
                }
                case CLASS_EXTENDS: {
                    out.writeShort(p.type_index);
                    break;
                }
                case THROWS: {
                    out.writeShort(p.type_index);
                    break;
                }
                case METHOD_FORMAL_PARAMETER: {
                    out.writeByte(p.parameter_index);
                    break;
                }
                case CAST: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: {
                    out.writeShort(p.offset);
                    out.writeByte(p.type_index);
                    break;
                }
                case METHOD_RETURN: 
                case FIELD: {
                    break;
                }
                case UNKNOWN: {
                    throw new AssertionError((Object)"ClassWriter: UNKNOWN target type should never occur!");
                }
                default: {
                    throw new AssertionError((Object)("ClassWriter: Unknown target type for position: " + p));
                }
            }
            out.writeByte((byte)p.location.size());
            for (int i : TypeAnnotation.Position.getBinaryFromTypePath(p.location)) {
                out.writeByte((byte)i);
            }
        }
    }

    protected static class StackMapTableWriter
    implements StackMapTable_attribute.stack_map_frame.Visitor<Void, ClassOutputStream> {
        protected StackMapTableWriter() {
        }

        public void write(StackMapTable_attribute.stack_map_frame frame, ClassOutputStream out) {
            out.write(frame.frame_type);
            frame.accept(this, out);
        }

        @Override
        public Void visit_same_frame(StackMapTable_attribute.same_frame frame, ClassOutputStream p) {
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame frame, ClassOutputStream out) {
            this.writeVerificationTypeInfo(frame.stack[0], out);
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            this.writeVerificationTypeInfo(frame.stack[0], out);
            return null;
        }

        @Override
        public Void visit_chop_frame(StackMapTable_attribute.chop_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            return null;
        }

        @Override
        public Void visit_same_frame_extended(StackMapTable_attribute.same_frame_extended frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            return null;
        }

        @Override
        public Void visit_append_frame(StackMapTable_attribute.append_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            for (StackMapTable_attribute.verification_type_info l : frame.locals) {
                this.writeVerificationTypeInfo(l, out);
            }
            return null;
        }

        @Override
        public Void visit_full_frame(StackMapTable_attribute.full_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            out.writeShort(frame.locals.length);
            for (StackMapTable_attribute.verification_type_info l : frame.locals) {
                this.writeVerificationTypeInfo(l, out);
            }
            out.writeShort(frame.stack.length);
            for (StackMapTable_attribute.verification_type_info s : frame.stack) {
                this.writeVerificationTypeInfo(s, out);
            }
            return null;
        }

        protected void writeVerificationTypeInfo(StackMapTable_attribute.verification_type_info info, ClassOutputStream out) {
            out.write(info.tag);
            switch (info.tag) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    StackMapTable_attribute.Object_variable_info o = (StackMapTable_attribute.Object_variable_info)info;
                    out.writeShort(o.cpool_index);
                    break;
                }
                case 8: {
                    StackMapTable_attribute.Uninitialized_variable_info u = (StackMapTable_attribute.Uninitialized_variable_info)info;
                    out.writeShort(u.offset);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }

    protected static class AttributeWriter
    implements Attribute.Visitor<Void, ClassOutputStream> {
        protected ClassOutputStream sharedOut = new ClassOutputStream();
        protected AnnotationWriter annotationWriter = new AnnotationWriter();
        protected StackMapTableWriter stackMapWriter;

        protected AttributeWriter() {
        }

        public void write(Attributes attributes, ClassOutputStream out) {
            int size = attributes.size();
            out.writeShort(size);
            for (Attribute a : attributes) {
                this.write(a, out);
            }
        }

        public void write(Attribute attr, ClassOutputStream out) {
            out.writeShort(attr.attribute_name_index);
            this.sharedOut.reset();
            attr.accept(this, this.sharedOut);
            out.writeInt(this.sharedOut.size());
            this.sharedOut.writeTo(out);
        }

        @Override
        public Void visitDefault(DefaultAttribute attr, ClassOutputStream out) {
            out.write(attr.info, 0, attr.info.length);
            return null;
        }

        @Override
        public Void visitAnnotationDefault(AnnotationDefault_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.default_value, out);
            return null;
        }

        @Override
        public Void visitBootstrapMethods(BootstrapMethods_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.bootstrap_method_specifiers.length);
            for (BootstrapMethods_attribute.BootstrapMethodSpecifier bsm : attr.bootstrap_method_specifiers) {
                out.writeShort(bsm.bootstrap_method_ref);
                int bsm_args_count = bsm.bootstrap_arguments.length;
                out.writeShort(bsm_args_count);
                for (int i : bsm.bootstrap_arguments) {
                    out.writeShort(i);
                }
            }
            return null;
        }

        @Override
        public Void visitCharacterRangeTable(CharacterRangeTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.character_range_table.length);
            for (CharacterRangeTable_attribute.Entry e : attr.character_range_table) {
                this.writeCharacterRangeTableEntry(e, out);
            }
            return null;
        }

        protected void writeCharacterRangeTableEntry(CharacterRangeTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.end_pc);
            out.writeInt(entry.character_range_start);
            out.writeInt(entry.character_range_end);
            out.writeShort(entry.flags);
        }

        @Override
        public Void visitCode(Code_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.max_stack);
            out.writeShort(attr.max_locals);
            out.writeInt(attr.code.length);
            out.write(attr.code, 0, attr.code.length);
            out.writeShort(attr.exception_table.length);
            for (Code_attribute.Exception_data e : attr.exception_table) {
                this.writeExceptionTableEntry(e, out);
            }
            new AttributeWriter().write(attr.attributes, out);
            return null;
        }

        protected void writeExceptionTableEntry(Code_attribute.Exception_data exception_data, ClassOutputStream out) {
            out.writeShort(exception_data.start_pc);
            out.writeShort(exception_data.end_pc);
            out.writeShort(exception_data.handler_pc);
            out.writeShort(exception_data.catch_type);
        }

        @Override
        public Void visitCompilationID(CompilationID_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.compilationID_index);
            return null;
        }

        @Override
        public Void visitConcealedPackages(ConcealedPackages_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.packages_count);
            for (int i : attr.packages_index) {
                out.writeShort(i);
            }
            return null;
        }

        @Override
        public Void visitConstantValue(ConstantValue_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.constantvalue_index);
            return null;
        }

        @Override
        public Void visitDeprecated(Deprecated_attribute attr, ClassOutputStream out) {
            return null;
        }

        @Override
        public Void visitEnclosingMethod(EnclosingMethod_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.class_index);
            out.writeShort(attr.method_index);
            return null;
        }

        @Override
        public Void visitExceptions(Exceptions_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.exception_index_table.length);
            for (int i : attr.exception_index_table) {
                out.writeShort(i);
            }
            return null;
        }

        @Override
        public Void visitInnerClasses(InnerClasses_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.classes.length);
            for (InnerClasses_attribute.Info info : attr.classes) {
                this.writeInnerClassesInfo(info, out);
            }
            return null;
        }

        protected void writeInnerClassesInfo(InnerClasses_attribute.Info info, ClassOutputStream out) {
            out.writeShort(info.inner_class_info_index);
            out.writeShort(info.outer_class_info_index);
            out.writeShort(info.inner_name_index);
            this.writeAccessFlags(info.inner_class_access_flags, out);
        }

        @Override
        public Void visitLineNumberTable(LineNumberTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.line_number_table.length);
            for (LineNumberTable_attribute.Entry e : attr.line_number_table) {
                this.writeLineNumberTableEntry(e, out);
            }
            return null;
        }

        protected void writeLineNumberTableEntry(LineNumberTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.line_number);
        }

        @Override
        public Void visitLocalVariableTable(LocalVariableTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.local_variable_table.length);
            for (LocalVariableTable_attribute.Entry e : attr.local_variable_table) {
                this.writeLocalVariableTableEntry(e, out);
            }
            return null;
        }

        protected void writeLocalVariableTableEntry(LocalVariableTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.length);
            out.writeShort(entry.name_index);
            out.writeShort(entry.descriptor_index);
            out.writeShort(entry.index);
        }

        @Override
        public Void visitLocalVariableTypeTable(LocalVariableTypeTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.local_variable_table.length);
            for (LocalVariableTypeTable_attribute.Entry e : attr.local_variable_table) {
                this.writeLocalVariableTypeTableEntry(e, out);
            }
            return null;
        }

        protected void writeLocalVariableTypeTableEntry(LocalVariableTypeTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.length);
            out.writeShort(entry.name_index);
            out.writeShort(entry.signature_index);
            out.writeShort(entry.index);
        }

        @Override
        public Void visitMethodParameters(MethodParameters_attribute attr, ClassOutputStream out) {
            out.writeByte(attr.method_parameter_table.length);
            for (MethodParameters_attribute.Entry e : attr.method_parameter_table) {
                out.writeShort(e.name_index);
                out.writeShort(e.flags);
            }
            return null;
        }

        @Override
        public Void visitMainClass(MainClass_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.main_class_index);
            return null;
        }

        @Override
        public Void visitModule(Module_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.requires.length);
            for (Module_attribute.RequiresEntry requiresEntry : attr.requires) {
                out.writeShort(requiresEntry.requires_index);
                out.writeShort(requiresEntry.requires_flags);
            }
            out.writeShort(attr.exports.length);
            for (Module_attribute.ExportsEntry exportsEntry : attr.exports) {
                out.writeShort(exportsEntry.exports_index);
                out.writeShort(exportsEntry.exports_to_index.length);
                for (int index : exportsEntry.exports_to_index) {
                    out.writeShort(index);
                }
            }
            out.writeShort(attr.uses_index.length);
            for (int n : attr.uses_index) {
                out.writeShort(n);
            }
            out.writeShort(attr.provides.length);
            for (Module_attribute.ProvidesEntry providesEntry : attr.provides) {
                out.writeShort(providesEntry.provides_index);
                out.writeShort(providesEntry.with_index);
            }
            return null;
        }

        @Override
        public Void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleAnnotations(RuntimeInvisibleAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeVisibleTypeAnnotations(RuntimeVisibleTypeAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleTypeAnnotations(RuntimeInvisibleTypeAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations_attribute attr, ClassOutputStream out) {
            out.writeByte(attr.parameter_annotations.length);
            for (Annotation[] annos : attr.parameter_annotations) {
                this.annotationWriter.write(annos, out);
            }
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisibleParameterAnnotations_attribute attr, ClassOutputStream out) {
            out.writeByte(attr.parameter_annotations.length);
            for (Annotation[] annos : attr.parameter_annotations) {
                this.annotationWriter.write(annos, out);
            }
            return null;
        }

        @Override
        public Void visitSignature(Signature_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.signature_index);
            return null;
        }

        @Override
        public Void visitSourceDebugExtension(SourceDebugExtension_attribute attr, ClassOutputStream out) {
            out.write(attr.debug_extension, 0, attr.debug_extension.length);
            return null;
        }

        @Override
        public Void visitSourceFile(SourceFile_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.sourcefile_index);
            return null;
        }

        @Override
        public Void visitSourceID(SourceID_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.sourceID_index);
            return null;
        }

        @Override
        public Void visitStackMap(StackMap_attribute attr, ClassOutputStream out) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            out.writeShort(attr.entries.length);
            for (StackMap_attribute.stack_map_frame f : attr.entries) {
                this.stackMapWriter.write(f, out);
            }
            return null;
        }

        @Override
        public Void visitStackMapTable(StackMapTable_attribute attr, ClassOutputStream out) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            out.writeShort(attr.entries.length);
            for (StackMapTable_attribute.stack_map_frame f : attr.entries) {
                this.stackMapWriter.write(f, out);
            }
            return null;
        }

        @Override
        public Void visitSynthetic(Synthetic_attribute attr, ClassOutputStream out) {
            return null;
        }

        protected void writeAccessFlags(AccessFlags flags, ClassOutputStream p) {
            this.sharedOut.writeShort(flags.flags);
        }

        @Override
        public Void visitVersion(Version_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.version_index);
            return null;
        }
    }

    protected static class ConstantPoolWriter
    implements ConstantPool.Visitor<Integer, ClassOutputStream> {
        protected ConstantPoolWriter() {
        }

        protected int write(ConstantPool.CPInfo info, ClassOutputStream out) {
            out.writeByte(info.getTag());
            return info.accept(this, out);
        }

        @Override
        public Integer visitClass(ConstantPool.CONSTANT_Class_info info, ClassOutputStream out) {
            out.writeShort(info.name_index);
            return 1;
        }

        @Override
        public Integer visitDouble(ConstantPool.CONSTANT_Double_info info, ClassOutputStream out) {
            out.writeDouble(info.value);
            return 2;
        }

        @Override
        public Integer visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, ClassOutputStream out) {
            this.writeRef(info, out);
            return 1;
        }

        @Override
        public Integer visitFloat(ConstantPool.CONSTANT_Float_info info, ClassOutputStream out) {
            out.writeFloat(info.value);
            return 1;
        }

        @Override
        public Integer visitInteger(ConstantPool.CONSTANT_Integer_info info, ClassOutputStream out) {
            out.writeInt(info.value);
            return 1;
        }

        @Override
        public Integer visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, ClassOutputStream out) {
            this.writeRef(info, out);
            return 1;
        }

        @Override
        public Integer visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, ClassOutputStream out) {
            out.writeShort(info.bootstrap_method_attr_index);
            out.writeShort(info.name_and_type_index);
            return 1;
        }

        @Override
        public Integer visitLong(ConstantPool.CONSTANT_Long_info info, ClassOutputStream out) {
            out.writeLong(info.value);
            return 2;
        }

        @Override
        public Integer visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, ClassOutputStream out) {
            out.writeShort(info.name_index);
            out.writeShort(info.type_index);
            return 1;
        }

        @Override
        public Integer visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, ClassOutputStream out) {
            out.writeByte(info.reference_kind.tag);
            out.writeShort(info.reference_index);
            return 1;
        }

        @Override
        public Integer visitMethodType(ConstantPool.CONSTANT_MethodType_info info, ClassOutputStream out) {
            out.writeShort(info.descriptor_index);
            return 1;
        }

        @Override
        public Integer visitMethodref(ConstantPool.CONSTANT_Methodref_info info, ClassOutputStream out) {
            return this.writeRef(info, out);
        }

        @Override
        public Integer visitString(ConstantPool.CONSTANT_String_info info, ClassOutputStream out) {
            out.writeShort(info.string_index);
            return 1;
        }

        @Override
        public Integer visitUtf8(ConstantPool.CONSTANT_Utf8_info info, ClassOutputStream out) {
            out.writeUTF(info.value);
            return 1;
        }

        protected Integer writeRef(ConstantPool.CPRefInfo info, ClassOutputStream out) {
            out.writeShort(info.class_index);
            out.writeShort(info.name_and_type_index);
            return 1;
        }
    }

    protected static class ClassOutputStream
    extends ByteArrayOutputStream {
        private DataOutputStream d = new DataOutputStream(this);

        public void writeByte(int value) {
            try {
                this.d.writeByte(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeShort(int value) {
            try {
                this.d.writeShort(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeInt(int value) {
            try {
                this.d.writeInt(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeLong(long value) {
            try {
                this.d.writeLong(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeFloat(float value) {
            try {
                this.d.writeFloat(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeDouble(double value) {
            try {
                this.d.writeDouble(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeUTF(String value) {
            try {
                this.d.writeUTF(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeTo(ClassOutputStream s) {
            try {
                super.writeTo(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

