/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import java.io.IOException;

public class MethodParameters_attribute
extends Attribute {
    public final int method_parameter_table_length;
    public final Entry[] method_parameter_table;

    MethodParameters_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        this.method_parameter_table_length = cr.readUnsignedByte();
        this.method_parameter_table = new Entry[this.method_parameter_table_length];
        for (int i = 0; i < this.method_parameter_table_length; ++i) {
            this.method_parameter_table[i] = new Entry(cr);
        }
    }

    public MethodParameters_attribute(ConstantPool constant_pool, Entry[] method_parameter_table) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("MethodParameters"), method_parameter_table);
    }

    public MethodParameters_attribute(int name_index, Entry[] method_parameter_table) {
        super(name_index, 1 + method_parameter_table.length * Entry.length());
        this.method_parameter_table_length = method_parameter_table.length;
        this.method_parameter_table = method_parameter_table;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitMethodParameters(this, data);
    }

    public static class Entry {
        public final int name_index;
        public final int flags;

        Entry(ClassReader cr) throws IOException {
            this.name_index = cr.readUnsignedShort();
            this.flags = cr.readUnsignedShort();
        }

        public static int length() {
            return 6;
        }
    }
}

