/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.jvm;

import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Symtab;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.jvm.ByteCodes;
import com.redhat.ceylon.langtools.tools.javac.jvm.Code;
import com.redhat.ceylon.langtools.tools.javac.jvm.Pool;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;

public class Items {
    Pool pool;
    Code code;
    Symtab syms;
    Types types;
    private final Item voidItem;
    private final Item thisItem;
    private final Item superItem;
    private final Item[] stackItem = new Item[9];

    public Items(Pool pool, Code code, Symtab syms, Types types) {
        this.code = code;
        this.pool = pool;
        this.types = types;
        this.voidItem = new Item(8){

            @Override
            public String toString() {
                return "void";
            }
        };
        this.thisItem = new SelfItem(false);
        this.superItem = new SelfItem(true);
        for (int i = 0; i < 8; ++i) {
            this.stackItem[i] = new StackItem(i);
        }
        this.stackItem[8] = this.voidItem;
        this.syms = syms;
    }

    Item makeVoidItem() {
        return this.voidItem;
    }

    Item makeThisItem() {
        return this.thisItem;
    }

    Item makeSuperItem() {
        return this.superItem;
    }

    Item makeStackItem(Type type) {
        return this.stackItem[Code.typecode(type)];
    }

    Item makeDynamicItem(Symbol member) {
        return new DynamicItem(member);
    }

    Item makeIndexedItem(Type type) {
        return new IndexedItem(type);
    }

    LocalItem makeLocalItem(Symbol.VarSymbol v) {
        return new LocalItem(v.erasure(this.types), v.adr);
    }

    private LocalItem makeLocalItem(Type type, int reg) {
        return new LocalItem(type, reg);
    }

    Item makeStaticItem(Symbol member) {
        return new StaticItem(member);
    }

    Item makeMemberItem(Symbol member, boolean nonvirtual) {
        return new MemberItem(member, nonvirtual);
    }

    Item makeImmediateItem(Type type, Object value) {
        return new ImmediateItem(type, value);
    }

    Item makeAssignItem(Item lhs) {
        return new AssignItem(lhs);
    }

    CondItem makeCondItem(int opcode, Code.Chain trueJumps, Code.Chain falseJumps) {
        return new CondItem(opcode, trueJumps, falseJumps);
    }

    CondItem makeCondItem(int opcode) {
        return this.makeCondItem(opcode, null, null);
    }

    class CondItem
    extends Item {
        Code.Chain trueJumps;
        Code.Chain falseJumps;
        int opcode;
        JCTree tree;

        CondItem(int opcode, Code.Chain truejumps, Code.Chain falsejumps) {
            super(5);
            this.opcode = opcode;
            this.trueJumps = truejumps;
            this.falseJumps = falsejumps;
        }

        @Override
        Item load() {
            Code.Chain trueChain = null;
            Code.Chain falseChain = this.jumpFalse();
            if (!this.isFalse()) {
                Items.this.code.resolve(this.trueJumps);
                Items.this.code.emitop0(4);
                trueChain = Items.this.code.branch(167);
            }
            if (falseChain != null) {
                Items.this.code.resolve(falseChain);
                Items.this.code.emitop0(3);
            }
            Items.this.code.resolve(trueChain);
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void duplicate() {
            this.load().duplicate();
        }

        @Override
        void drop() {
            this.load().drop();
        }

        @Override
        void stash(int toscode) {
            Assert.error();
        }

        @Override
        CondItem mkCond() {
            return this;
        }

        Code.Chain jumpTrue() {
            if (this.tree == null) {
                return Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            }
            int startpc = Items.this.code.curCP();
            Code.Chain c = Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            Items.this.code.crt.put(this.tree, 128, startpc, Items.this.code.curCP());
            return c;
        }

        Code.Chain jumpFalse() {
            if (this.tree == null) {
                return Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            }
            int startpc = Items.this.code.curCP();
            Code.Chain c = Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            Items.this.code.crt.put(this.tree, 256, startpc, Items.this.code.curCP());
            return c;
        }

        CondItem negate() {
            CondItem c = new CondItem(Code.negate(this.opcode), this.falseJumps, this.trueJumps);
            c.tree = this.tree;
            return c;
        }

        @Override
        int width() {
            throw new AssertionError();
        }

        boolean isTrue() {
            return this.falseJumps == null && this.opcode == 167;
        }

        boolean isFalse() {
            return this.trueJumps == null && this.opcode == 168;
        }

        @Override
        public String toString() {
            return "cond(" + Code.mnem(this.opcode) + ")";
        }
    }

    class AssignItem
    extends Item {
        Item lhs;

        AssignItem(Item lhs) {
            super(lhs.typecode);
            this.lhs = lhs;
        }

        @Override
        Item load() {
            this.lhs.stash(this.typecode);
            this.lhs.store();
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void duplicate() {
            this.load().duplicate();
        }

        @Override
        void drop() {
            this.lhs.store();
        }

        @Override
        void stash(int toscode) {
            Assert.error();
        }

        @Override
        int width() {
            return this.lhs.width() + Code.width(this.typecode);
        }

        @Override
        public String toString() {
            return "assign(lhs = " + this.lhs + ")";
        }
    }

    class ImmediateItem
    extends Item {
        Object value;

        ImmediateItem(Type type, Object value) {
            super(Code.typecode(type));
            this.value = value;
        }

        private void ldc() {
            int idx = Items.this.pool.put(this.value);
            if (this.typecode == 1 || this.typecode == 3) {
                Items.this.code.emitop2(20, idx);
            } else {
                Items.this.code.emitLdc(idx);
            }
        }

        @Override
        Item load() {
            switch (this.typecode) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    int ival = ((Number)this.value).intValue();
                    if (-1 <= ival && ival <= 5) {
                        Items.this.code.emitop0(3 + ival);
                        break;
                    }
                    if (-128 <= ival && ival <= 127) {
                        Items.this.code.emitop1(16, ival);
                        break;
                    }
                    if (Short.MIN_VALUE <= ival && ival <= Short.MAX_VALUE) {
                        Items.this.code.emitop2(17, ival);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 1: {
                    long lval = ((Number)this.value).longValue();
                    if (lval == 0L || lval == 1L) {
                        Items.this.code.emitop0(9 + (int)lval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 2: {
                    float fval = ((Number)this.value).floatValue();
                    if (this.isPosZero(fval) || (double)fval == 1.0 || (double)fval == 2.0) {
                        Items.this.code.emitop0(11 + (int)fval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 3: {
                    double dval = ((Number)this.value).doubleValue();
                    if (this.isPosZero(dval) || dval == 1.0) {
                        Items.this.code.emitop0(14 + (int)dval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 4: {
                    this.ldc();
                    break;
                }
                default: {
                    Assert.error();
                }
            }
            return Items.this.stackItem[this.typecode];
        }

        private boolean isPosZero(float x) {
            return x == 0.0f && 1.0f / x > 0.0f;
        }

        private boolean isPosZero(double x) {
            return x == 0.0 && 1.0 / x > 0.0;
        }

        @Override
        CondItem mkCond() {
            int ival = ((Number)this.value).intValue();
            return Items.this.makeCondItem(ival != 0 ? 167 : 168);
        }

        @Override
        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            switch (targetcode) {
                case 0: {
                    if (Code.truncate(this.typecode) == 0) {
                        return this;
                    }
                    return new ImmediateItem(Items.this.syms.intType, ((Number)this.value).intValue());
                }
                case 1: {
                    return new ImmediateItem(Items.this.syms.longType, ((Number)this.value).longValue());
                }
                case 2: {
                    return new ImmediateItem(Items.this.syms.floatType, Float.valueOf(((Number)this.value).floatValue()));
                }
                case 3: {
                    return new ImmediateItem(Items.this.syms.doubleType, ((Number)this.value).doubleValue());
                }
                case 5: {
                    return new ImmediateItem(Items.this.syms.byteType, (byte)((Number)this.value).intValue());
                }
                case 6: {
                    return new ImmediateItem(Items.this.syms.charType, (char)((Number)this.value).intValue());
                }
                case 7: {
                    return new ImmediateItem(Items.this.syms.shortType, (short)((Number)this.value).intValue());
                }
            }
            return super.coerce(targetcode);
        }

        @Override
        public String toString() {
            return "immediate(" + this.value + ")";
        }
    }

    class MemberItem
    extends Item {
        Symbol member;
        boolean nonvirtual;

        MemberItem(Symbol member, boolean nonvirtual) {
            super(Code.typecode(member.erasure(Items.this.types)));
            this.member = member;
            this.nonvirtual = nonvirtual;
        }

        @Override
        Item load() {
            Items.this.code.emitop2(180, Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void store() {
            Items.this.code.emitop2(181, Items.this.pool.put(this.member));
        }

        @Override
        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.externalType(Items.this.types);
            int rescode = Code.typecode(mtype.restype);
            if ((this.member.owner.flags() & 0x200L) != 0L && !this.nonvirtual) {
                Items.this.code.emitInvokeinterface(Items.this.pool.put(this.member), mtype);
            } else if (this.nonvirtual) {
                Items.this.code.emitInvokespecial(Items.this.pool.put(this.member), mtype);
            } else {
                Items.this.code.emitInvokevirtual(Items.this.pool.put(this.member), mtype);
            }
            return Items.this.stackItem[rescode];
        }

        @Override
        void duplicate() {
            Items.this.stackItem[4].duplicate();
        }

        @Override
        void drop() {
            Items.this.stackItem[4].drop();
        }

        @Override
        void stash(int toscode) {
            Items.this.stackItem[4].stash(toscode);
        }

        @Override
        int width() {
            return 1;
        }

        @Override
        public String toString() {
            return "member(" + this.member + (this.nonvirtual ? " nonvirtual)" : ")");
        }
    }

    class DynamicItem
    extends StaticItem {
        DynamicItem(Symbol member) {
            super(member);
        }

        @Override
        Item load() {
            assert (false);
            return null;
        }

        @Override
        void store() {
            assert (false);
        }

        @Override
        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.erasure(Items.this.types);
            int rescode = Code.typecode(mtype.restype);
            Items.this.code.emitInvokedynamic(Items.this.pool.put(this.member), mtype);
            return Items.this.stackItem[rescode];
        }

        @Override
        public String toString() {
            return "dynamic(" + this.member + ")";
        }
    }

    class StaticItem
    extends Item {
        Symbol member;

        StaticItem(Symbol member) {
            super(Code.typecode(member.erasure(Items.this.types)));
            this.member = member;
        }

        @Override
        Item load() {
            Items.this.code.emitop2(178, Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void store() {
            Items.this.code.emitop2(179, Items.this.pool.put(this.member));
        }

        @Override
        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.erasure(Items.this.types);
            int rescode = Code.typecode(mtype.restype);
            Items.this.code.emitInvokestatic(Items.this.pool.put(this.member), mtype);
            return Items.this.stackItem[rescode];
        }

        @Override
        public String toString() {
            return "static(" + this.member + ")";
        }
    }

    class LocalItem
    extends Item {
        int reg;
        Type type;

        LocalItem(Type type, int reg) {
            super(Code.typecode(type));
            Assert.check(reg >= 0);
            this.type = type;
            this.reg = reg;
        }

        @Override
        Item load() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(26 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(21 + Code.truncate(this.typecode), this.reg);
            }
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void store() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(59 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(54 + Code.truncate(this.typecode), this.reg);
            }
            Items.this.code.setDefined(this.reg);
        }

        void incr(int x) {
            if (this.typecode == 0 && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                Items.this.code.emitop1w(132, this.reg, x);
            } else {
                this.load();
                if (x >= 0) {
                    Items.this.makeImmediateItem(Items.this.syms.intType, x).load();
                    Items.this.code.emitop0(96);
                } else {
                    Items.this.makeImmediateItem(Items.this.syms.intType, -x).load();
                    Items.this.code.emitop0(100);
                }
                Items.this.makeStackItem(Items.this.syms.intType).coerce(this.typecode);
                this.store();
            }
        }

        @Override
        public String toString() {
            return "localItem(type=" + this.type + "; reg=" + this.reg + ")";
        }
    }

    class SelfItem
    extends Item {
        boolean isSuper;

        SelfItem(boolean isSuper) {
            super(4);
            this.isSuper = isSuper;
        }

        @Override
        Item load() {
            Items.this.code.emitop0(42);
            return Items.this.stackItem[this.typecode];
        }

        @Override
        public String toString() {
            return this.isSuper ? "super" : "this";
        }
    }

    class IndexedItem
    extends Item {
        IndexedItem(Type type) {
            super(Code.typecode(type));
        }

        @Override
        Item load() {
            Items.this.code.emitop0(46 + this.typecode);
            return Items.this.stackItem[this.typecode];
        }

        @Override
        void store() {
            Items.this.code.emitop0(79 + this.typecode);
        }

        @Override
        void duplicate() {
            Items.this.code.emitop0(92);
        }

        @Override
        void drop() {
            Items.this.code.emitop0(88);
        }

        @Override
        void stash(int toscode) {
            Items.this.code.emitop0(91 + 3 * (Code.width(toscode) - 1));
        }

        @Override
        int width() {
            return 2;
        }

        @Override
        public String toString() {
            return "indexed(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    class StackItem
    extends Item {
        StackItem(int typecode) {
            super(typecode);
        }

        @Override
        Item load() {
            return this;
        }

        @Override
        void duplicate() {
            Items.this.code.emitop0(this.width() == 2 ? 92 : 89);
        }

        @Override
        void drop() {
            Items.this.code.emitop0(this.width() == 2 ? 88 : 87);
        }

        @Override
        void stash(int toscode) {
            Items.this.code.emitop0((this.width() == 2 ? 91 : 90) + 3 * (Code.width(toscode) - 1));
        }

        @Override
        int width() {
            return Code.width(this.typecode);
        }

        @Override
        public String toString() {
            return "stack(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    abstract class Item {
        int typecode;

        Item(int typecode) {
            this.typecode = typecode;
        }

        Item load() {
            throw new AssertionError();
        }

        void store() {
            throw new AssertionError((Object)("store unsupported: " + this));
        }

        Item invoke() {
            throw new AssertionError(this);
        }

        void duplicate() {
        }

        void drop() {
        }

        void stash(int toscode) {
            Items.this.stackItem[toscode].duplicate();
        }

        CondItem mkCond() {
            this.load();
            return Items.this.makeCondItem(154);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            this.load();
            int typecode1 = Code.truncate(this.typecode);
            int targetcode1 = Code.truncate(targetcode);
            if (typecode1 != targetcode1) {
                int offset = targetcode1 > typecode1 ? targetcode1 - 1 : targetcode1;
                Items.this.code.emitop0(133 + typecode1 * 3 + offset);
            }
            if (targetcode != targetcode1) {
                Items.this.code.emitop0(145 + targetcode - 5);
            }
            return Items.this.stackItem[targetcode];
        }

        Item coerce(Type targettype) {
            return this.coerce(Code.typecode(targettype));
        }

        int width() {
            return 0;
        }

        public abstract String toString();
    }
}

