/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.tree;

import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.type.TypeKind;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.tree.AnnotatedTypeTree;
import com.redhat.ceylon.langtools.source.tree.AnnotationTree;
import com.redhat.ceylon.langtools.source.tree.ArrayAccessTree;
import com.redhat.ceylon.langtools.source.tree.ArrayTypeTree;
import com.redhat.ceylon.langtools.source.tree.AssertTree;
import com.redhat.ceylon.langtools.source.tree.AssignmentTree;
import com.redhat.ceylon.langtools.source.tree.BinaryTree;
import com.redhat.ceylon.langtools.source.tree.BlockTree;
import com.redhat.ceylon.langtools.source.tree.BreakTree;
import com.redhat.ceylon.langtools.source.tree.CaseTree;
import com.redhat.ceylon.langtools.source.tree.CatchTree;
import com.redhat.ceylon.langtools.source.tree.ClassTree;
import com.redhat.ceylon.langtools.source.tree.CompilationUnitTree;
import com.redhat.ceylon.langtools.source.tree.CompoundAssignmentTree;
import com.redhat.ceylon.langtools.source.tree.ConditionalExpressionTree;
import com.redhat.ceylon.langtools.source.tree.ContinueTree;
import com.redhat.ceylon.langtools.source.tree.DoWhileLoopTree;
import com.redhat.ceylon.langtools.source.tree.EmptyStatementTree;
import com.redhat.ceylon.langtools.source.tree.EnhancedForLoopTree;
import com.redhat.ceylon.langtools.source.tree.ErroneousTree;
import com.redhat.ceylon.langtools.source.tree.ExpressionStatementTree;
import com.redhat.ceylon.langtools.source.tree.ExpressionTree;
import com.redhat.ceylon.langtools.source.tree.ForLoopTree;
import com.redhat.ceylon.langtools.source.tree.IdentifierTree;
import com.redhat.ceylon.langtools.source.tree.IfTree;
import com.redhat.ceylon.langtools.source.tree.ImportTree;
import com.redhat.ceylon.langtools.source.tree.InstanceOfTree;
import com.redhat.ceylon.langtools.source.tree.IntersectionTypeTree;
import com.redhat.ceylon.langtools.source.tree.LabeledStatementTree;
import com.redhat.ceylon.langtools.source.tree.LambdaExpressionTree;
import com.redhat.ceylon.langtools.source.tree.LetTree;
import com.redhat.ceylon.langtools.source.tree.LiteralTree;
import com.redhat.ceylon.langtools.source.tree.MemberReferenceTree;
import com.redhat.ceylon.langtools.source.tree.MemberSelectTree;
import com.redhat.ceylon.langtools.source.tree.MethodInvocationTree;
import com.redhat.ceylon.langtools.source.tree.MethodTree;
import com.redhat.ceylon.langtools.source.tree.ModifiersTree;
import com.redhat.ceylon.langtools.source.tree.NewArrayTree;
import com.redhat.ceylon.langtools.source.tree.NewClassTree;
import com.redhat.ceylon.langtools.source.tree.ParameterizedTypeTree;
import com.redhat.ceylon.langtools.source.tree.ParenthesizedTree;
import com.redhat.ceylon.langtools.source.tree.PrimitiveTypeTree;
import com.redhat.ceylon.langtools.source.tree.ReturnTree;
import com.redhat.ceylon.langtools.source.tree.StatementTree;
import com.redhat.ceylon.langtools.source.tree.SwitchTree;
import com.redhat.ceylon.langtools.source.tree.SynchronizedTree;
import com.redhat.ceylon.langtools.source.tree.ThrowTree;
import com.redhat.ceylon.langtools.source.tree.Tree;
import com.redhat.ceylon.langtools.source.tree.TreeVisitor;
import com.redhat.ceylon.langtools.source.tree.TryTree;
import com.redhat.ceylon.langtools.source.tree.TypeCastTree;
import com.redhat.ceylon.langtools.source.tree.TypeParameterTree;
import com.redhat.ceylon.langtools.source.tree.UnaryTree;
import com.redhat.ceylon.langtools.source.tree.UnionTypeTree;
import com.redhat.ceylon.langtools.source.tree.VariableTree;
import com.redhat.ceylon.langtools.source.tree.WhileLoopTree;
import com.redhat.ceylon.langtools.source.tree.WildcardTree;
import com.redhat.ceylon.langtools.tools.javac.code.Attribute;
import com.redhat.ceylon.langtools.tools.javac.code.BoundKind;
import com.redhat.ceylon.langtools.tools.javac.code.Flags;
import com.redhat.ceylon.langtools.tools.javac.code.Scope;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.tree.EndPosTable;
import com.redhat.ceylon.langtools.tools.javac.tree.Pretty;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeInfo;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;

public abstract class JCTree
implements Tree,
Cloneable,
JCDiagnostic.DiagnosticPosition {
    public int pos;
    public Type type;

    public abstract Tag getTag();

    public boolean hasTag(Tag tag) {
        return tag == this.getTag();
    }

    public String toString() {
        StringWriter s = new StringWriter();
        try {
            new Pretty(s, false).printExpr(this);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return s.toString();
    }

    public JCTree setPos(int pos) {
        this.pos = pos;
        return this;
    }

    public JCTree setType(Type type) {
        this.type = type;
        return this;
    }

    public abstract void accept(Visitor var1);

    @Override
    public abstract <R, D> R accept(TreeVisitor<R, D> var1, D var2);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public JCDiagnostic.DiagnosticPosition pos() {
        return this;
    }

    @Override
    public JCTree getTree() {
        return this;
    }

    @Override
    public int getStartPosition() {
        return TreeInfo.getStartPos(this);
    }

    @Override
    public int getPreferredPosition() {
        return this.pos;
    }

    @Override
    public int getEndPosition(EndPosTable endPosTable) {
        return TreeInfo.getEndPos(this, endPosTable);
    }

    public static abstract class Visitor {
        public void visitTopLevel(JCCompilationUnit that) {
            this.visitTree(that);
        }

        public void visitImport(JCImport that) {
            this.visitTree(that);
        }

        public void visitClassDef(JCClassDecl that) {
            this.visitTree(that);
        }

        public void visitMethodDef(JCMethodDecl that) {
            this.visitTree(that);
        }

        public void visitVarDef(JCVariableDecl that) {
            this.visitTree(that);
        }

        public void visitSkip(JCSkip that) {
            this.visitTree(that);
        }

        public void visitBlock(JCBlock that) {
            this.visitTree(that);
        }

        public void visitDoLoop(JCDoWhileLoop that) {
            this.visitTree(that);
        }

        public void visitWhileLoop(JCWhileLoop that) {
            this.visitTree(that);
        }

        public void visitForLoop(JCForLoop that) {
            this.visitTree(that);
        }

        public void visitForeachLoop(JCEnhancedForLoop that) {
            this.visitTree(that);
        }

        public void visitLabelled(JCLabeledStatement that) {
            this.visitTree(that);
        }

        public void visitSwitch(JCSwitch that) {
            this.visitTree(that);
        }

        public void visitCase(JCCase that) {
            this.visitTree(that);
        }

        public void visitSynchronized(JCSynchronized that) {
            this.visitTree(that);
        }

        public void visitTry(JCTry that) {
            this.visitTree(that);
        }

        public void visitCatch(JCCatch that) {
            this.visitTree(that);
        }

        public void visitConditional(JCConditional that) {
            this.visitTree(that);
        }

        public void visitIf(JCIf that) {
            this.visitTree(that);
        }

        public void visitExec(JCExpressionStatement that) {
            this.visitTree(that);
        }

        public void visitBreak(JCBreak that) {
            this.visitTree(that);
        }

        public void visitContinue(JCContinue that) {
            this.visitTree(that);
        }

        public void visitReturn(JCReturn that) {
            this.visitTree(that);
        }

        public void visitThrow(JCThrow that) {
            this.visitTree(that);
        }

        public void visitAssert(JCAssert that) {
            this.visitTree(that);
        }

        public void visitApply(JCMethodInvocation that) {
            this.visitTree(that);
        }

        public void visitNewClass(JCNewClass that) {
            this.visitTree(that);
        }

        public void visitNewArray(JCNewArray that) {
            this.visitTree(that);
        }

        public void visitLambda(JCLambda that) {
            this.visitTree(that);
        }

        public void visitParens(JCParens that) {
            this.visitTree(that);
        }

        public void visitAssign(JCAssign that) {
            this.visitTree(that);
        }

        public void visitAssignop(JCAssignOp that) {
            this.visitTree(that);
        }

        public void visitUnary(JCUnary that) {
            this.visitTree(that);
        }

        public void visitBinary(JCBinary that) {
            this.visitTree(that);
        }

        public void visitTypeCast(JCTypeCast that) {
            this.visitTree(that);
        }

        public void visitTypeTest(JCInstanceOf that) {
            this.visitTree(that);
        }

        public void visitIndexed(JCArrayAccess that) {
            this.visitTree(that);
        }

        public void visitSelect(JCFieldAccess that) {
            this.visitTree(that);
        }

        public void visitReference(JCMemberReference that) {
            this.visitTree(that);
        }

        public void visitIdent(JCIdent that) {
            this.visitTree(that);
        }

        public void visitLiteral(JCLiteral that) {
            this.visitTree(that);
        }

        public void visitTypeIdent(JCPrimitiveTypeTree that) {
            this.visitTree(that);
        }

        public void visitTypeArray(JCArrayTypeTree that) {
            this.visitTree(that);
        }

        public void visitTypeApply(JCTypeApply that) {
            this.visitTree(that);
        }

        public void visitTypeUnion(JCTypeUnion that) {
            this.visitTree(that);
        }

        public void visitTypeIntersection(JCTypeIntersection that) {
            this.visitTree(that);
        }

        public void visitTypeParameter(JCTypeParameter that) {
            this.visitTree(that);
        }

        public void visitWildcard(JCWildcard that) {
            this.visitTree(that);
        }

        public void visitTypeBoundKind(TypeBoundKind that) {
            this.visitTree(that);
        }

        public void visitAnnotation(JCAnnotation that) {
            this.visitTree(that);
        }

        public void visitModifiers(JCModifiers that) {
            this.visitTree(that);
        }

        public void visitAnnotatedType(JCAnnotatedType that) {
            this.visitTree(that);
        }

        public void visitErroneous(JCErroneous that) {
            this.visitTree(that);
        }

        public void visitLetExpr(LetExpr that) {
            this.visitTree(that);
        }

        public void visitTree(JCTree that) {
            Assert.error();
        }
    }

    public static interface Factory {
        public JCCompilationUnit TopLevel(com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> var1, JCExpression var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> var3);

        public JCImport Import(JCTree var1, boolean var2);

        public JCClassDecl ClassDef(JCModifiers var1, Name var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> var3, JCExpression var4, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var5, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> var6);

        public JCMethodDecl MethodDef(JCModifiers var1, Name var2, JCExpression var3, com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> var4, JCVariableDecl var5, com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> var6, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var7, JCBlock var8, JCExpression var9);

        public JCVariableDecl VarDef(JCModifiers var1, Name var2, JCExpression var3, JCExpression var4);

        public JCSkip Skip();

        public JCBlock Block(long var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> var3);

        public JCDoWhileLoop DoLoop(JCStatement var1, JCExpression var2);

        public JCWhileLoop WhileLoop(JCExpression var1, JCStatement var2);

        public JCForLoop ForLoop(com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> var1, JCExpression var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpressionStatement> var3, JCStatement var4);

        public JCEnhancedForLoop ForeachLoop(JCVariableDecl var1, JCExpression var2, JCStatement var3);

        public JCLabeledStatement Labelled(Name var1, JCStatement var2);

        public JCSwitch Switch(JCExpression var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCCase> var2);

        public JCCase Case(JCExpression var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> var2);

        public JCSynchronized Synchronized(JCExpression var1, JCBlock var2);

        public JCTry Try(JCBlock var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCCatch> var2, JCBlock var3);

        public JCTry Try(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> var1, JCBlock var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCCatch> var3, JCBlock var4);

        public JCCatch Catch(JCVariableDecl var1, JCBlock var2);

        public JCConditional Conditional(JCExpression var1, JCExpression var2, JCExpression var3);

        public JCIf If(JCExpression var1, JCStatement var2, JCStatement var3);

        public JCExpressionStatement Exec(JCExpression var1);

        public JCBreak Break(Name var1);

        public JCContinue Continue(Name var1);

        public JCReturn Return(JCExpression var1);

        public JCThrow Throw(JCExpression var1);

        public JCAssert Assert(JCExpression var1, JCExpression var2);

        public JCMethodInvocation Apply(com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var1, JCExpression var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var3);

        public JCNewClass NewClass(JCExpression var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var2, JCExpression var3, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var4, JCClassDecl var5);

        public JCNewArray NewArray(JCExpression var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var2, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var3);

        public JCParens Parens(JCExpression var1);

        public JCAssign Assign(JCExpression var1, JCExpression var2);

        public JCAssignOp Assignop(Tag var1, JCTree var2, JCTree var3);

        public JCUnary Unary(Tag var1, JCExpression var2);

        public JCBinary Binary(Tag var1, JCExpression var2, JCExpression var3);

        public JCTypeCast TypeCast(JCTree var1, JCExpression var2);

        public JCInstanceOf TypeTest(JCExpression var1, JCTree var2);

        public JCArrayAccess Indexed(JCExpression var1, JCExpression var2);

        public JCFieldAccess Select(JCExpression var1, Name var2);

        public JCIdent Ident(Name var1);

        public JCLiteral Literal(TypeTag var1, Object var2);

        public JCPrimitiveTypeTree TypeIdent(TypeTag var1);

        public JCArrayTypeTree TypeArray(JCExpression var1);

        public JCTypeApply TypeApply(JCExpression var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var2);

        public JCTypeParameter TypeParameter(Name var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var2);

        public JCWildcard Wildcard(TypeBoundKind var1, JCTree var2);

        public TypeBoundKind TypeBoundKind(BoundKind var1);

        public JCAnnotation Annotation(JCTree var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> var2);

        public JCModifiers Modifiers(long var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> var3);

        public JCErroneous Erroneous(com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> var1);

        public LetExpr LetExpr(com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> var1, JCTree var2);
    }

    public static class LetExpr
    extends JCExpression
    implements LetTree {
        public JCTree expr;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats;

        protected LetExpr(com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats, JCTree expr) {
            this.stats = stats;
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitLetExpr(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.LET;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitLet(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.LETEXPR;
        }

        @Override
        public List<? extends StatementTree> getStatements() {
            return this.stats;
        }

        @Override
        public Tree getExpressio() {
            return this.expr;
        }
    }

    public static class JCErroneous
    extends JCExpression
    implements ErroneousTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> errs;

        protected JCErroneous(com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> errs) {
            this.errs = errs;
        }

        @Override
        public void accept(Visitor v) {
            v.visitErroneous(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ERRONEOUS;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> getErrorTrees() {
            return this.errs;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitErroneous(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.ERRONEOUS;
        }
    }

    public static class JCAnnotatedType
    extends JCExpression
    implements AnnotatedTypeTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations;
        public JCExpression underlyingType;

        protected JCAnnotatedType(com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations, JCExpression underlyingType) {
            Assert.check(annotations != null && annotations.nonEmpty());
            this.annotations = annotations;
            this.underlyingType = underlyingType;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAnnotatedType(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ANNOTATED_TYPE;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public JCExpression getUnderlyingType() {
            return this.underlyingType;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitAnnotatedType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.ANNOTATED_TYPE;
        }
    }

    public static class JCModifiers
    extends JCTree
    implements ModifiersTree {
        public long flags;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations;

        protected JCModifiers(long flags, com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations) {
            this.flags = flags;
            this.annotations = annotations;
        }

        @Override
        public void accept(Visitor v) {
            v.visitModifiers(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MODIFIERS;
        }

        @Override
        public Set<Modifier> getFlags() {
            return Flags.asModifierSet(this.flags);
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitModifiers(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.MODIFIERS;
        }
    }

    public static class JCAnnotation
    extends JCExpression
    implements AnnotationTree {
        private Tag tag;
        public JCTree annotationType;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args;
        public Attribute.Compound attribute;

        protected JCAnnotation(Tag tag, JCTree annotationType, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args) {
            this.tag = tag;
            this.annotationType = annotationType;
            this.args = args;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAnnotation(this);
        }

        @Override
        public Tree.Kind getKind() {
            return TreeInfo.tagToKind(this.getTag());
        }

        @Override
        public JCTree getAnnotationType() {
            return this.annotationType;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getArguments() {
            return this.args;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitAnnotation(this, d);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static class TypeBoundKind
    extends JCTree {
        public BoundKind kind;

        protected TypeBoundKind(BoundKind kind) {
            this.kind = kind;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeBoundKind(this);
        }

        @Override
        public Tree.Kind getKind() {
            throw new AssertionError((Object)"TypeBoundKind is not part of a public API");
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            throw new AssertionError((Object)"TypeBoundKind is not part of a public API");
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEBOUNDKIND;
        }
    }

    public static class JCWildcard
    extends JCExpression
    implements WildcardTree {
        public TypeBoundKind kind;
        public JCTree inner;

        protected JCWildcard(TypeBoundKind kind, JCTree inner) {
            kind.getClass();
            this.kind = kind;
            this.inner = inner;
        }

        @Override
        public void accept(Visitor v) {
            v.visitWildcard(this);
        }

        @Override
        public Tree.Kind getKind() {
            switch (this.kind.kind) {
                case UNBOUND: {
                    return Tree.Kind.UNBOUNDED_WILDCARD;
                }
                case EXTENDS: {
                    return Tree.Kind.EXTENDS_WILDCARD;
                }
                case SUPER: {
                    return Tree.Kind.SUPER_WILDCARD;
                }
            }
            throw new AssertionError((Object)("Unknown wildcard bound " + this.kind));
        }

        @Override
        public JCTree getBound() {
            return this.inner;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitWildcard(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.WILDCARD;
        }
    }

    public static class JCTypeParameter
    extends JCTree
    implements TypeParameterTree {
        public Name name;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> bounds;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations;

        protected JCTypeParameter(Name name, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> bounds, com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations) {
            this.name = name;
            this.bounds = bounds;
            this.annotations = annotations;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeParameter(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TYPE_PARAMETER;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getBounds() {
            return this.bounds;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitTypeParameter(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEPARAMETER;
        }
    }

    public static class JCTypeIntersection
    extends JCExpression
    implements IntersectionTypeTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> bounds;

        protected JCTypeIntersection(com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> bounds) {
            this.bounds = bounds;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeIntersection(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.INTERSECTION_TYPE;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getBounds() {
            return this.bounds;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitIntersectionType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEINTERSECTION;
        }
    }

    public static class JCTypeUnion
    extends JCExpression
    implements UnionTypeTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> alternatives;

        protected JCTypeUnion(com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> components) {
            this.alternatives = components;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeUnion(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.UNION_TYPE;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getTypeAlternatives() {
            return this.alternatives;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitUnionType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEUNION;
        }
    }

    public static class JCTypeApply
    extends JCExpression
    implements ParameterizedTypeTree {
        public JCExpression clazz;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> arguments;

        protected JCTypeApply(JCExpression clazz, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> arguments) {
            this.clazz = clazz;
            this.arguments = arguments;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeApply(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public JCTree getType() {
            return this.clazz;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getTypeArguments() {
            return this.arguments;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitParameterizedType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEAPPLY;
        }
    }

    public static class JCArrayTypeTree
    extends JCExpression
    implements ArrayTypeTree {
        public JCExpression elemtype;

        protected JCArrayTypeTree(JCExpression elemtype) {
            this.elemtype = elemtype;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeArray(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public JCTree getType() {
            return this.elemtype;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitArrayType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEARRAY;
        }
    }

    public static class JCPrimitiveTypeTree
    extends JCExpression
    implements PrimitiveTypeTree {
        public TypeTag typetag;

        protected JCPrimitiveTypeTree(TypeTag typetag) {
            this.typetag = typetag;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeIdent(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public TypeKind getPrimitiveTypeKind() {
            return this.typetag.getPrimitiveTypeKind();
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitPrimitiveType(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPEIDENT;
        }
    }

    public static class JCLiteral
    extends JCExpression
    implements LiteralTree {
        public TypeTag typetag;
        public Object value;

        protected JCLiteral(TypeTag typetag, Object value) {
            this.typetag = typetag;
            this.value = value;
        }

        @Override
        public void accept(Visitor v) {
            v.visitLiteral(this);
        }

        @Override
        public Tree.Kind getKind() {
            return this.typetag.getKindLiteral();
        }

        @Override
        public Object getValue() {
            switch (this.typetag) {
                case BOOLEAN: {
                    int bi = (Integer)this.value;
                    return bi != 0;
                }
                case CHAR: {
                    int ci = (Integer)this.value;
                    char c = (char)ci;
                    if (c != ci) {
                        throw new AssertionError((Object)"bad value for char literal");
                    }
                    return Character.valueOf(c);
                }
            }
            return this.value;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitLiteral(this, d);
        }

        @Override
        public JCLiteral setType(Type type) {
            super.setType(type);
            return this;
        }

        @Override
        public Tag getTag() {
            return Tag.LITERAL;
        }
    }

    public static class JCIndyIdent
    extends JCIdent {
        public Name bsmName;
        public JCExpression bsmType;
        public com.redhat.ceylon.langtools.tools.javac.util.List<Object> bsmStatic;
        public JCExpression indyReturnType;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> indyParameterTypes;

        protected JCIndyIdent(Name name, Symbol sym, JCExpression indyReturnType, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> indyParameterTypes, JCExpression bsmType, Name bsmName, com.redhat.ceylon.langtools.tools.javac.util.List<Object> bsmStatic) {
            super(name, sym);
            this.bsmType = bsmType;
            this.bsmName = bsmName;
            this.bsmStatic = bsmStatic;
            this.indyReturnType = indyReturnType;
            this.indyParameterTypes = indyParameterTypes;
        }
    }

    public static class JCIdent
    extends JCExpression
    implements IdentifierTree {
        public Name name;
        public Symbol sym;

        protected JCIdent(Name name, Symbol sym) {
            this.name = name;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitIdent(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IDENTIFIER;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitIdentifier(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.IDENT;
        }
    }

    public static class JCMemberReference
    extends JCFunctionalExpression
    implements MemberReferenceTree {
        public MemberReferenceTree.ReferenceMode mode;
        public ReferenceKind kind;
        public Name name;
        public JCExpression expr;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs;
        public Symbol sym;
        public Type varargsElement;
        public JCPolyExpression.PolyKind refPolyKind;
        public boolean ownerAccessible;
        public OverloadKind overloadKind;

        protected JCMemberReference(MemberReferenceTree.ReferenceMode mode, Name name, JCExpression expr, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs) {
            this.mode = mode;
            this.name = name;
            this.expr = expr;
            this.typeargs = typeargs;
        }

        @Override
        public void accept(Visitor v) {
            v.visitReference(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MEMBER_REFERENCE;
        }

        @Override
        public MemberReferenceTree.ReferenceMode getMode() {
            return this.mode;
        }

        @Override
        public JCExpression getQualifierExpression() {
            return this.expr;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getTypeArguments() {
            return this.typeargs;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitMemberReference(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.REFERENCE;
        }

        public boolean hasKind(ReferenceKind kind) {
            return this.kind == kind;
        }

        public static enum ReferenceKind {
            SUPER(MemberReferenceTree.ReferenceMode.INVOKE, false),
            UNBOUND(MemberReferenceTree.ReferenceMode.INVOKE, true),
            STATIC(MemberReferenceTree.ReferenceMode.INVOKE, false),
            BOUND(MemberReferenceTree.ReferenceMode.INVOKE, false),
            IMPLICIT_INNER(MemberReferenceTree.ReferenceMode.NEW, false),
            TOPLEVEL(MemberReferenceTree.ReferenceMode.NEW, false),
            ARRAY_CTOR(MemberReferenceTree.ReferenceMode.NEW, false);

            final MemberReferenceTree.ReferenceMode mode;
            final boolean unbound;

            private ReferenceKind(MemberReferenceTree.ReferenceMode mode, boolean unbound) {
                this.mode = mode;
                this.unbound = unbound;
            }

            public boolean isUnbound() {
                return this.unbound;
            }
        }

        public static enum OverloadKind {
            OVERLOADED,
            UNOVERLOADED;

        }
    }

    public static class JCFieldAccess
    extends JCExpression
    implements MemberSelectTree {
        public JCExpression selected;
        public Name name;
        public Symbol sym;

        protected JCFieldAccess(JCExpression selected, Name name, Symbol sym) {
            this.selected = selected;
            this.name = name;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitSelect(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MEMBER_SELECT;
        }

        @Override
        public JCExpression getExpression() {
            return this.selected;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitMemberSelect(this, d);
        }

        @Override
        public Name getIdentifier() {
            return this.name;
        }

        @Override
        public Tag getTag() {
            return Tag.SELECT;
        }
    }

    public static class JCArrayAccess
    extends JCExpression
    implements ArrayAccessTree {
        public JCExpression indexed;
        public JCExpression index;

        protected JCArrayAccess(JCExpression indexed, JCExpression index) {
            this.indexed = indexed;
            this.index = index;
        }

        @Override
        public void accept(Visitor v) {
            v.visitIndexed(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_ACCESS;
        }

        @Override
        public JCExpression getExpression() {
            return this.indexed;
        }

        @Override
        public JCExpression getIndex() {
            return this.index;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitArrayAccess(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.INDEXED;
        }
    }

    public static class JCInstanceOf
    extends JCExpression
    implements InstanceOfTree {
        public JCExpression expr;
        public JCTree clazz;

        protected JCInstanceOf(JCExpression expr, JCTree clazz) {
            this.expr = expr;
            this.clazz = clazz;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeTest(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.INSTANCE_OF;
        }

        @Override
        public JCTree getType() {
            return this.clazz;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitInstanceOf(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPETEST;
        }
    }

    public static class JCTypeCast
    extends JCExpression
    implements TypeCastTree {
        public JCTree clazz;
        public JCExpression expr;

        protected JCTypeCast(JCTree clazz, JCExpression expr) {
            this.clazz = clazz;
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeCast(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TYPE_CAST;
        }

        @Override
        public JCTree getType() {
            return this.clazz;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitTypeCast(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TYPECAST;
        }
    }

    public static class JCBinary
    extends JCExpression
    implements BinaryTree {
        private Tag opcode;
        public JCExpression lhs;
        public JCExpression rhs;
        public Symbol operator;

        protected JCBinary(Tag opcode, JCExpression lhs, JCExpression rhs, Symbol operator) {
            this.opcode = opcode;
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = operator;
        }

        @Override
        public void accept(Visitor v) {
            v.visitBinary(this);
        }

        @Override
        public Tree.Kind getKind() {
            return TreeInfo.tagToKind(this.getTag());
        }

        @Override
        public JCExpression getLeftOperand() {
            return this.lhs;
        }

        @Override
        public JCExpression getRightOperand() {
            return this.rhs;
        }

        public Symbol getOperator() {
            return this.operator;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitBinary(this, d);
        }

        @Override
        public Tag getTag() {
            return this.opcode;
        }
    }

    public static class JCUnary
    extends JCExpression
    implements UnaryTree {
        private Tag opcode;
        public JCExpression arg;
        public Symbol operator;

        protected JCUnary(Tag opcode, JCExpression arg) {
            this.opcode = opcode;
            this.arg = arg;
        }

        @Override
        public void accept(Visitor v) {
            v.visitUnary(this);
        }

        @Override
        public Tree.Kind getKind() {
            return TreeInfo.tagToKind(this.getTag());
        }

        @Override
        public JCExpression getExpression() {
            return this.arg;
        }

        public Symbol getOperator() {
            return this.operator;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitUnary(this, d);
        }

        @Override
        public Tag getTag() {
            return this.opcode;
        }

        public void setTag(Tag tag) {
            this.opcode = tag;
        }
    }

    public static class JCAssignOp
    extends JCExpression
    implements CompoundAssignmentTree {
        private Tag opcode;
        public JCExpression lhs;
        public JCExpression rhs;
        public Symbol operator;

        protected JCAssignOp(Tag opcode, JCTree lhs, JCTree rhs, Symbol operator) {
            this.opcode = opcode;
            this.lhs = (JCExpression)lhs;
            this.rhs = (JCExpression)rhs;
            this.operator = operator;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAssignop(this);
        }

        @Override
        public Tree.Kind getKind() {
            return TreeInfo.tagToKind(this.getTag());
        }

        @Override
        public JCExpression getVariable() {
            return this.lhs;
        }

        @Override
        public JCExpression getExpression() {
            return this.rhs;
        }

        public Symbol getOperator() {
            return this.operator;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitCompoundAssignment(this, d);
        }

        @Override
        public Tag getTag() {
            return this.opcode;
        }
    }

    public static class JCAssign
    extends JCExpression
    implements AssignmentTree {
        public JCExpression lhs;
        public JCExpression rhs;

        protected JCAssign(JCExpression lhs, JCExpression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAssign(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ASSIGNMENT;
        }

        @Override
        public JCExpression getVariable() {
            return this.lhs;
        }

        @Override
        public JCExpression getExpression() {
            return this.rhs;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitAssignment(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.ASSIGN;
        }
    }

    public static class JCParens
    extends JCExpression
    implements ParenthesizedTree {
        public JCExpression expr;

        protected JCParens(JCExpression expr) {
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitParens(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARENTHESIZED;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitParenthesized(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.PARENS;
        }
    }

    public static class JCLambda
    extends JCFunctionalExpression
    implements LambdaExpressionTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> params;
        public JCTree body;
        public boolean canCompleteNormally = true;
        public ParameterKind paramKind;

        public JCLambda(com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> params, JCTree body) {
            this.params = params;
            this.body = body;
            this.paramKind = params.isEmpty() || ((JCVariableDecl)params.head).vartype != null ? ParameterKind.EXPLICIT : ParameterKind.IMPLICIT;
        }

        @Override
        public Tag getTag() {
            return Tag.LAMBDA;
        }

        @Override
        public void accept(Visitor v) {
            v.visitLambda(this);
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitLambdaExpression(this, d);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.LAMBDA_EXPRESSION;
        }

        @Override
        public JCTree getBody() {
            return this.body;
        }

        @Override
        public List<? extends VariableTree> getParameters() {
            return this.params;
        }

        @Override
        public JCLambda setType(Type type) {
            super.setType(type);
            return this;
        }

        @Override
        public LambdaExpressionTree.BodyKind getBodyKind() {
            return this.body.hasTag(Tag.BLOCK) ? LambdaExpressionTree.BodyKind.STATEMENT : LambdaExpressionTree.BodyKind.EXPRESSION;
        }

        public static enum ParameterKind {
            IMPLICIT,
            EXPLICIT;

        }
    }

    public static class JCNewArray
    extends JCExpression
    implements NewArrayTree {
        public JCExpression elemtype;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> dims;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> annotations;
        public com.redhat.ceylon.langtools.tools.javac.util.List<com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation>> dimAnnotations;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> elems;

        protected JCNewArray(JCExpression elemtype, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> dims, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> elems) {
            this.elemtype = elemtype;
            this.dims = dims;
            this.annotations = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            this.dimAnnotations = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            this.elems = elems;
        }

        @Override
        public void accept(Visitor v) {
            v.visitNewArray(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.NEW_ARRAY;
        }

        @Override
        public JCExpression getType() {
            return this.elemtype;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getDimensions() {
            return this.dims;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getInitializers() {
            return this.elems;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitNewArray(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.NEWARRAY;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> getAnnotations() {
            return this.annotations;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation>> getDimAnnotations() {
            return this.dimAnnotations;
        }
    }

    public static class JCNewClass
    extends JCPolyExpression
    implements NewClassTree {
        public JCExpression encl;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs;
        public JCExpression clazz;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args;
        public JCClassDecl def;
        public Symbol constructor;
        public Type varargsElement;
        public Type constructorType;

        protected JCNewClass(JCExpression encl, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs, JCExpression clazz, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args, JCClassDecl def) {
            this.encl = encl;
            this.typeargs = typeargs == null ? com.redhat.ceylon.langtools.tools.javac.util.List.nil() : typeargs;
            this.clazz = clazz;
            this.args = args;
            this.def = def;
        }

        @Override
        public void accept(Visitor v) {
            v.visitNewClass(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.NEW_CLASS;
        }

        @Override
        public JCExpression getEnclosingExpression() {
            return this.encl;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getTypeArguments() {
            return this.typeargs;
        }

        @Override
        public JCExpression getIdentifier() {
            return this.clazz;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getArguments() {
            return this.args;
        }

        @Override
        public JCClassDecl getClassBody() {
            return this.def;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitNewClass(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.NEWCLASS;
        }
    }

    public static class JCMethodInvocation
    extends JCPolyExpression
    implements MethodInvocationTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs;
        public JCExpression meth;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args;
        public Type varargsElement;

        protected JCMethodInvocation(com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> typeargs, JCExpression meth, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> args) {
            this.typeargs = typeargs == null ? com.redhat.ceylon.langtools.tools.javac.util.List.nil() : typeargs;
            this.meth = meth;
            this.args = args;
        }

        @Override
        public void accept(Visitor v) {
            v.visitApply(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.METHOD_INVOCATION;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getTypeArguments() {
            return this.typeargs;
        }

        @Override
        public JCExpression getMethodSelect() {
            return this.meth;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getArguments() {
            return this.args;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitMethodInvocation(this, d);
        }

        @Override
        public JCMethodInvocation setType(Type type) {
            super.setType(type);
            return this;
        }

        @Override
        public Tag getTag() {
            return Tag.APPLY;
        }
    }

    public static class JCAssert
    extends JCStatement
    implements AssertTree {
        public JCExpression cond;
        public JCExpression detail;

        protected JCAssert(JCExpression cond, JCExpression detail) {
            this.cond = cond;
            this.detail = detail;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAssert(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ASSERT;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCExpression getDetail() {
            return this.detail;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitAssert(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.ASSERT;
        }
    }

    public static class JCThrow
    extends JCStatement
    implements ThrowTree {
        public JCExpression expr;

        protected JCThrow(JCExpression expr) {
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitThrow(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.THROW;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitThrow(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.THROW;
        }
    }

    public static class JCReturn
    extends JCStatement
    implements ReturnTree {
        public JCExpression expr;

        protected JCReturn(JCExpression expr) {
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitReturn(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.RETURN;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitReturn(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.RETURN;
        }
    }

    public static class JCContinue
    extends JCStatement
    implements ContinueTree {
        public Name label;
        public JCTree target;

        protected JCContinue(Name label, JCTree target) {
            this.label = label;
            this.target = target;
        }

        @Override
        public void accept(Visitor v) {
            v.visitContinue(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CONTINUE;
        }

        @Override
        public Name getLabel() {
            return this.label;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitContinue(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.CONTINUE;
        }
    }

    public static class JCBreak
    extends JCStatement
    implements BreakTree {
        public Name label;
        public JCTree target;

        protected JCBreak(Name label, JCTree target) {
            this.label = label;
            this.target = target;
        }

        @Override
        public void accept(Visitor v) {
            v.visitBreak(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.BREAK;
        }

        @Override
        public Name getLabel() {
            return this.label;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitBreak(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.BREAK;
        }
    }

    public static class JCExpressionStatement
    extends JCStatement
    implements ExpressionStatementTree {
        public JCExpression expr;

        protected JCExpressionStatement(JCExpression expr) {
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitExec(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.EXPRESSION_STATEMENT;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitExpressionStatement(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.EXEC;
        }

        @Override
        public String toString() {
            StringWriter s = new StringWriter();
            try {
                new Pretty(s, false).printStat(this);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return s.toString();
        }
    }

    public static class JCIf
    extends JCStatement
    implements IfTree {
        public JCExpression cond;
        public JCStatement thenpart;
        public JCStatement elsepart;

        protected JCIf(JCExpression cond, JCStatement thenpart, JCStatement elsepart) {
            this.cond = cond;
            this.thenpart = thenpart;
            this.elsepart = elsepart;
        }

        @Override
        public void accept(Visitor v) {
            v.visitIf(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IF;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCStatement getThenStatement() {
            return this.thenpart;
        }

        @Override
        public JCStatement getElseStatement() {
            return this.elsepart;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitIf(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.IF;
        }
    }

    public static class JCConditional
    extends JCPolyExpression
    implements ConditionalExpressionTree {
        public JCExpression cond;
        public JCExpression truepart;
        public JCExpression falsepart;

        protected JCConditional(JCExpression cond, JCExpression truepart, JCExpression falsepart) {
            this.cond = cond;
            this.truepart = truepart;
            this.falsepart = falsepart;
        }

        @Override
        public void accept(Visitor v) {
            v.visitConditional(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CONDITIONAL_EXPRESSION;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCExpression getTrueExpression() {
            return this.truepart;
        }

        @Override
        public JCExpression getFalseExpression() {
            return this.falsepart;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitConditionalExpression(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.CONDEXPR;
        }
    }

    public static class JCCatch
    extends JCTree
    implements CatchTree {
        public JCVariableDecl param;
        public JCBlock body;

        protected JCCatch(JCVariableDecl param, JCBlock body) {
            this.param = param;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCatch(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CATCH;
        }

        @Override
        public JCVariableDecl getParameter() {
            return this.param;
        }

        @Override
        public JCBlock getBlock() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitCatch(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.CATCH;
        }
    }

    public static class JCTry
    extends JCStatement
    implements TryTree {
        public JCBlock body;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCCatch> catchers;
        public JCBlock finalizer;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> resources;
        public boolean finallyCanCompleteNormally;

        protected JCTry(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> resources, JCBlock body, com.redhat.ceylon.langtools.tools.javac.util.List<JCCatch> catchers, JCBlock finalizer) {
            this.body = body;
            this.catchers = catchers;
            this.finalizer = finalizer;
            this.resources = resources;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTry(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TRY;
        }

        @Override
        public JCBlock getBlock() {
            return this.body;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCCatch> getCatches() {
            return this.catchers;
        }

        @Override
        public JCBlock getFinallyBlock() {
            return this.finalizer;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitTry(this, d);
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> getResources() {
            return this.resources;
        }

        @Override
        public Tag getTag() {
            return Tag.TRY;
        }
    }

    public static class JCSynchronized
    extends JCStatement
    implements SynchronizedTree {
        public JCExpression lock;
        public JCBlock body;

        protected JCSynchronized(JCExpression lock, JCBlock body) {
            this.lock = lock;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitSynchronized(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.SYNCHRONIZED;
        }

        @Override
        public JCExpression getExpression() {
            return this.lock;
        }

        @Override
        public JCBlock getBlock() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitSynchronized(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.SYNCHRONIZED;
        }
    }

    public static class JCCase
    extends JCStatement
    implements CaseTree {
        public JCExpression pat;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats;

        protected JCCase(JCExpression pat, com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats) {
            this.pat = pat;
            this.stats = stats;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCase(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CASE;
        }

        @Override
        public JCExpression getExpression() {
            return this.pat;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> getStatements() {
            return this.stats;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitCase(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.CASE;
        }
    }

    public static class JCSwitch
    extends JCStatement
    implements SwitchTree {
        public JCExpression selector;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCCase> cases;

        protected JCSwitch(JCExpression selector, com.redhat.ceylon.langtools.tools.javac.util.List<JCCase> cases) {
            this.selector = selector;
            this.cases = cases;
        }

        @Override
        public void accept(Visitor v) {
            v.visitSwitch(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.SWITCH;
        }

        @Override
        public JCExpression getExpression() {
            return this.selector;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCCase> getCases() {
            return this.cases;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitSwitch(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.SWITCH;
        }
    }

    public static class JCLabeledStatement
    extends JCStatement
    implements LabeledStatementTree {
        public Name label;
        public JCStatement body;

        protected JCLabeledStatement(Name label, JCStatement body) {
            this.label = label;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitLabelled(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.LABELED_STATEMENT;
        }

        @Override
        public Name getLabel() {
            return this.label;
        }

        @Override
        public JCStatement getStatement() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitLabeledStatement(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.LABELLED;
        }
    }

    public static class JCEnhancedForLoop
    extends JCStatement
    implements EnhancedForLoopTree {
        public JCVariableDecl var;
        public JCExpression expr;
        public JCStatement body;

        protected JCEnhancedForLoop(JCVariableDecl var, JCExpression expr, JCStatement body) {
            this.var = var;
            this.expr = expr;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitForeachLoop(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ENHANCED_FOR_LOOP;
        }

        @Override
        public JCVariableDecl getVariable() {
            return this.var;
        }

        @Override
        public JCExpression getExpression() {
            return this.expr;
        }

        @Override
        public JCStatement getStatement() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitEnhancedForLoop(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.FOREACHLOOP;
        }
    }

    public static class JCForLoop
    extends JCStatement
    implements ForLoopTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> init;
        public JCExpression cond;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpressionStatement> step;
        public JCStatement body;

        protected JCForLoop(com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> init, JCExpression cond, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpressionStatement> update, JCStatement body) {
            this.init = init;
            this.cond = cond;
            this.step = update;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitForLoop(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.FOR_LOOP;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCStatement getStatement() {
            return this.body;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> getInitializer() {
            return this.init;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpressionStatement> getUpdate() {
            return this.step;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitForLoop(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.FORLOOP;
        }
    }

    public static class JCWhileLoop
    extends JCStatement
    implements WhileLoopTree {
        public JCExpression cond;
        public JCStatement body;

        protected JCWhileLoop(JCExpression cond, JCStatement body) {
            this.cond = cond;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitWhileLoop(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.WHILE_LOOP;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCStatement getStatement() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitWhileLoop(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.WHILELOOP;
        }
    }

    public static class JCDoWhileLoop
    extends JCStatement
    implements DoWhileLoopTree {
        public JCStatement body;
        public JCExpression cond;

        protected JCDoWhileLoop(JCStatement body, JCExpression cond) {
            this.body = body;
            this.cond = cond;
        }

        @Override
        public void accept(Visitor v) {
            v.visitDoLoop(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.DO_WHILE_LOOP;
        }

        @Override
        public JCExpression getCondition() {
            return this.cond;
        }

        @Override
        public JCStatement getStatement() {
            return this.body;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitDoWhileLoop(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.DOLOOP;
        }
    }

    public static class JCBlock
    extends JCStatement
    implements BlockTree {
        public long flags;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats;
        public int endpos = -1;

        protected JCBlock(long flags, com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> stats) {
            this.stats = stats;
            this.flags = flags;
        }

        @Override
        public void accept(Visitor v) {
            v.visitBlock(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.BLOCK;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCStatement> getStatements() {
            return this.stats;
        }

        @Override
        public boolean isStatic() {
            return (this.flags & 8L) != 0L;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitBlock(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.BLOCK;
        }
    }

    public static class JCSkip
    extends JCStatement
    implements EmptyStatementTree {
        protected JCSkip() {
        }

        @Override
        public void accept(Visitor v) {
            v.visitSkip(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.EMPTY_STATEMENT;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitEmptyStatement(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.SKIP;
        }
    }

    public static class JCVariableDecl
    extends JCStatement
    implements VariableTree {
        public JCModifiers mods;
        public Name name;
        public JCExpression nameexpr;
        public JCExpression vartype;
        public JCExpression init;
        public Symbol.VarSymbol sym;

        protected JCVariableDecl(JCModifiers mods, Name name, JCExpression vartype, JCExpression init, Symbol.VarSymbol sym) {
            this.mods = mods;
            this.name = name;
            this.vartype = vartype;
            this.init = init;
            this.sym = sym;
        }

        protected JCVariableDecl(JCModifiers mods, JCExpression nameexpr, JCExpression vartype) {
            this(mods, null, vartype, null, null);
            this.nameexpr = nameexpr;
            this.name = nameexpr.hasTag(Tag.IDENT) ? ((JCIdent)nameexpr).name : ((JCFieldAccess)nameexpr).name;
        }

        @Override
        public void accept(Visitor v) {
            v.visitVarDef(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.VARIABLE;
        }

        @Override
        public JCModifiers getModifiers() {
            return this.mods;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public JCExpression getNameExpression() {
            return this.nameexpr;
        }

        @Override
        public JCTree getType() {
            return this.vartype;
        }

        @Override
        public JCExpression getInitializer() {
            return this.init;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitVariable(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.VARDEF;
        }
    }

    public static class JCMethodDecl
    extends JCTree
    implements MethodTree {
        public JCModifiers mods;
        public Name name;
        public JCExpression restype;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> typarams;
        public JCVariableDecl recvparam;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> params;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> thrown;
        public JCBlock body;
        public JCExpression defaultValue;
        public Symbol.MethodSymbol sym;

        protected JCMethodDecl(JCModifiers mods, Name name, JCExpression restype, com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> typarams, JCVariableDecl recvparam, com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> params, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> thrown, JCBlock body, JCExpression defaultValue, Symbol.MethodSymbol sym) {
            this.mods = mods;
            this.name = name;
            this.restype = restype;
            this.typarams = typarams;
            this.params = params;
            this.recvparam = recvparam;
            this.thrown = thrown;
            this.body = body;
            this.defaultValue = defaultValue;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitMethodDef(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.METHOD;
        }

        @Override
        public JCModifiers getModifiers() {
            return this.mods;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public JCTree getReturnType() {
            return this.restype;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> getTypeParameters() {
            return this.typarams;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCVariableDecl> getParameters() {
            return this.params;
        }

        @Override
        public JCVariableDecl getReceiverParameter() {
            return this.recvparam;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getThrows() {
            return this.thrown;
        }

        @Override
        public JCBlock getBody() {
            return this.body;
        }

        @Override
        public JCTree getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitMethod(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.METHODDEF;
        }
    }

    public static class JCClassDecl
    extends JCStatement
    implements ClassTree {
        public JCModifiers mods;
        public Name name;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> typarams;
        public JCExpression extending;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> implementing;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs;
        public Symbol.ClassSymbol sym;

        protected JCClassDecl(JCModifiers mods, Name name, com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> typarams, JCExpression extending, com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> implementing, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs, Symbol.ClassSymbol sym) {
            this.mods = mods;
            this.name = name;
            this.typarams = typarams;
            this.extending = extending;
            this.implementing = implementing;
            this.defs = defs;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitClassDef(this);
        }

        @Override
        public Tree.Kind getKind() {
            if ((this.mods.flags & 0x2000L) != 0L) {
                return Tree.Kind.ANNOTATION_TYPE;
            }
            if ((this.mods.flags & 0x200L) != 0L) {
                return Tree.Kind.INTERFACE;
            }
            if ((this.mods.flags & 0x4000L) != 0L) {
                return Tree.Kind.ENUM;
            }
            return Tree.Kind.CLASS;
        }

        @Override
        public JCModifiers getModifiers() {
            return this.mods;
        }

        @Override
        public Name getSimpleName() {
            return this.name;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTypeParameter> getTypeParameters() {
            return this.typarams;
        }

        @Override
        public JCExpression getExtendsClause() {
            return this.extending;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCExpression> getImplementsClause() {
            return this.implementing;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> getMembers() {
            return this.defs;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitClass(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.CLASSDEF;
        }
    }

    public static abstract class JCFunctionalExpression
    extends JCPolyExpression {
        public com.redhat.ceylon.langtools.tools.javac.util.List<Type> targets;

        public JCFunctionalExpression() {
            this.polyKind = JCPolyExpression.PolyKind.POLY;
        }

        public Type getDescriptorType(Types types) {
            return this.targets.nonEmpty() ? types.findDescriptorType((Type)this.targets.head) : types.createErrorType(null);
        }
    }

    public static abstract class JCPolyExpression
    extends JCExpression {
        public PolyKind polyKind;

        @Override
        public boolean isPoly() {
            return this.polyKind == PolyKind.POLY;
        }

        @Override
        public boolean isStandalone() {
            return this.polyKind == PolyKind.STANDALONE;
        }

        public static enum PolyKind {
            STANDALONE,
            POLY;

        }
    }

    public static abstract class JCExpression
    extends JCTree
    implements ExpressionTree {
        @Override
        public JCExpression setType(Type type) {
            super.setType(type);
            return this;
        }

        @Override
        public JCExpression setPos(int pos) {
            super.setPos(pos);
            return this;
        }

        public boolean isPoly() {
            return false;
        }

        public boolean isStandalone() {
            return true;
        }
    }

    public static abstract class JCStatement
    extends JCTree
    implements StatementTree {
        @Override
        public JCStatement setType(Type type) {
            super.setType(type);
            return this;
        }

        @Override
        public JCStatement setPos(int pos) {
            super.setPos(pos);
            return this;
        }
    }

    public static class JCImport
    extends JCTree
    implements ImportTree {
        public boolean staticImport;
        public JCTree qualid;

        protected JCImport(JCTree qualid, boolean importStatic) {
            this.qualid = qualid;
            this.staticImport = importStatic;
        }

        @Override
        public void accept(Visitor v) {
            v.visitImport(this);
        }

        @Override
        public boolean isStatic() {
            return this.staticImport;
        }

        @Override
        public JCTree getQualifiedIdentifier() {
            return this.qualid;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IMPORT;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitImport(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.IMPORT;
        }
    }

    public static class JCCompilationUnit
    extends JCTree
    implements CompilationUnitTree {
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> packageAnnotations;
        public JCExpression pid;
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs;
        public JavaFileObject sourcefile;
        public Symbol.PackageSymbol packge;
        public Scope.ImportScope namedImportScope;
        public Scope.StarImportScope starImportScope;
        public Position.LineMap lineMap = null;
        public EndPosTable endPositions = null;
        public boolean isCeylonProgram;

        protected JCCompilationUnit(com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> packageAnnotations, JCExpression pid, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs, JavaFileObject sourcefile, Symbol.PackageSymbol packge, Scope.ImportScope namedImportScope, Scope.StarImportScope starImportScope) {
            this.packageAnnotations = packageAnnotations;
            this.pid = pid;
            this.defs = defs;
            this.sourcefile = sourcefile;
            this.packge = packge;
            this.namedImportScope = namedImportScope;
            this.starImportScope = starImportScope;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTopLevel(this);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCAnnotation> getPackageAnnotations() {
            return this.packageAnnotations;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCImport> getImports() {
            ListBuffer<JCImport> imports = new ListBuffer<JCImport>();
            for (JCTree tree : this.defs) {
                if (tree.hasTag(Tag.IMPORT)) {
                    imports.append((JCImport)tree);
                    continue;
                }
                if (tree.hasTag(Tag.SKIP)) continue;
                break;
            }
            return imports.toList();
        }

        @Override
        public JCExpression getPackageName() {
            return this.pid;
        }

        @Override
        public JavaFileObject getSourceFile() {
            return this.sourcefile;
        }

        @Override
        public Position.LineMap getLineMap() {
            return this.lineMap;
        }

        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> getTypeDecls() {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> typeDefs = this.defs;
            while (!typeDefs.isEmpty() && ((JCTree)typeDefs.head).hasTag(Tag.IMPORT)) {
                typeDefs = typeDefs.tail;
            }
            return typeDefs;
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> v, D d) {
            return v.visitCompilationUnit(this, d);
        }

        @Override
        public Tag getTag() {
            return Tag.TOPLEVEL;
        }
    }

    public static enum Tag {
        NO_TAG,
        TOPLEVEL,
        IMPORT,
        CLASSDEF,
        METHODDEF,
        VARDEF,
        SKIP,
        BLOCK,
        DOLOOP,
        WHILELOOP,
        FORLOOP,
        FOREACHLOOP,
        LABELLED,
        SWITCH,
        CASE,
        SYNCHRONIZED,
        TRY,
        CATCH,
        CONDEXPR,
        IF,
        EXEC,
        BREAK,
        CONTINUE,
        RETURN,
        THROW,
        ASSERT,
        APPLY,
        NEWCLASS,
        NEWARRAY,
        LAMBDA,
        PARENS,
        ASSIGN,
        TYPECAST,
        TYPETEST,
        INDEXED,
        SELECT,
        REFERENCE,
        IDENT,
        LITERAL,
        TYPEIDENT,
        TYPEARRAY,
        TYPEAPPLY,
        TYPEUNION,
        TYPEINTERSECTION,
        TYPEPARAMETER,
        WILDCARD,
        TYPEBOUNDKIND,
        ANNOTATION,
        TYPE_ANNOTATION,
        MODIFIERS,
        ANNOTATED_TYPE,
        ERRONEOUS,
        POS,
        NEG,
        NOT,
        COMPL,
        PREINC,
        PREDEC,
        POSTINC,
        POSTDEC,
        NULLCHK,
        OR,
        AND,
        BITOR,
        BITXOR,
        BITAND,
        EQ,
        NE,
        LT,
        GT,
        LE,
        GE,
        SL,
        SR,
        USR,
        PLUS,
        MINUS,
        MUL,
        DIV,
        MOD,
        BITOR_ASG(BITOR),
        BITXOR_ASG(BITXOR),
        BITAND_ASG(BITAND),
        SL_ASG(SL),
        SR_ASG(SR),
        USR_ASG(USR),
        PLUS_ASG(PLUS),
        MINUS_ASG(MINUS),
        MUL_ASG(MUL),
        DIV_ASG(DIV),
        MOD_ASG(MOD),
        LETEXPR;

        private final Tag noAssignTag;
        private static final int numberOfOperators;

        private Tag(Tag noAssignTag) {
            this.noAssignTag = noAssignTag;
        }

        private Tag() {
            this(null);
        }

        public static int getNumberOfOperators() {
            return numberOfOperators;
        }

        public Tag noAssignOp() {
            if (this.noAssignTag != null) {
                return this.noAssignTag;
            }
            throw new AssertionError((Object)"noAssignOp() method is not available for non assignment tags");
        }

        public boolean isPostUnaryOp() {
            return this == POSTINC || this == POSTDEC;
        }

        public boolean isIncOrDecUnaryOp() {
            return this == PREINC || this == PREDEC || this == POSTINC || this == POSTDEC;
        }

        public boolean isAssignop() {
            return this.noAssignTag != null;
        }

        public int operatorIndex() {
            return this.ordinal() - POS.ordinal();
        }

        static {
            numberOfOperators = MOD.ordinal() - POS.ordinal() + 1;
        }
    }
}

