/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.loader.Java9ModuleReader;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.LanguageAnnotation;
import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.ParameterNameParser;
import com.redhat.ceylon.model.loader.SimpleReflType;
import com.redhat.ceylon.model.loader.Timer;
import com.redhat.ceylon.model.loader.TypeParser;
import com.redhat.ceylon.model.loader.TypeParserException;
import com.redhat.ceylon.model.loader.mirror.AccessibleMirror;
import com.redhat.ceylon.model.loader.mirror.AnnotatedMirror;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.FieldMirror;
import com.redhat.ceylon.model.loader.mirror.FunctionalInterfaceType;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.PackageMirror;
import com.redhat.ceylon.model.loader.mirror.TypeKind;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import com.redhat.ceylon.model.loader.mirror.VariableMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.loader.model.FieldValue;
import com.redhat.ceylon.model.loader.model.JavaBeanValue;
import com.redhat.ceylon.model.loader.model.JavaMethod;
import com.redhat.ceylon.model.loader.model.JavaParameterValue;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyClassAlias;
import com.redhat.ceylon.model.loader.model.LazyContainer;
import com.redhat.ceylon.model.loader.model.LazyElement;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.LazyInterfaceAlias;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.loader.model.LazyTypeAlias;
import com.redhat.ceylon.model.loader.model.LazyValue;
import com.redhat.ceylon.model.loader.model.LocalDeclarationContainer;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.loader.model.SetterWithLocalDeclarations;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationCompleter;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class AbstractModelLoader
implements ModelCompleter,
ModelLoader,
DeclarationCompleter {
    public static final String JAVA_BASE_MODULE_NAME = "java.base";
    public static final String CEYLON_LANGUAGE = "ceylon.language";
    public static final String CEYLON_LANGUAGE_MODEL = "ceylon.language.meta.model";
    public static final String CEYLON_LANGUAGE_MODEL_DECLARATION = "ceylon.language.meta.declaration";
    public static final String CEYLON_LANGUAGE_SERIALIZATION = "ceylon.language.serialization";
    private static final String TIMER_MODEL_LOADER_CATEGORY = "model loader";
    public static final String CEYLON_CEYLON_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Ceylon";
    protected static final String CEYLON_MODULE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Module";
    protected static final String CEYLON_PACKAGE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Package";
    public static final String CEYLON_IGNORE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Ignore";
    private static final String CEYLON_CLASS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Class";
    private static final String CEYLON_JPA_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Jpa";
    private static final String CEYLON_ENUMERATED_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Enumerated";
    public static final String CEYLON_NAME_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Name";
    private static final String CEYLON_SEQUENCED_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Sequenced";
    private static final String CEYLON_FUNCTIONAL_PARAMETER_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.FunctionalParameter";
    private static final String CEYLON_DEFAULTED_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Defaulted";
    private static final String CEYLON_SATISFIED_TYPES_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes";
    private static final String CEYLON_CASE_TYPES_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.CaseTypes";
    private static final String CEYLON_TYPE_PARAMETERS = "com.redhat.ceylon.compiler.java.metadata.TypeParameters";
    private static final String CEYLON_TYPE_INFO_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.TypeInfo";
    public static final String CEYLON_ATTRIBUTE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Attribute";
    public static final String CEYLON_SETTER_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Setter";
    public static final String CEYLON_OBJECT_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Object";
    public static final String CEYLON_METHOD_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Method";
    public static final String CEYLON_CONTAINER_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Container";
    public static final String CEYLON_LOCAL_CONTAINER_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.LocalContainer";
    public static final String CEYLON_LOCAL_DECLARATION_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.LocalDeclaration";
    public static final String CEYLON_LOCAL_DECLARATIONS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.LocalDeclarations";
    private static final String CEYLON_MEMBERS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Members";
    private static final String CEYLON_ANNOTATIONS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Annotations";
    public static final String CEYLON_VALUETYPE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.ValueType";
    public static final String CEYLON_ALIAS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Alias";
    public static final String CEYLON_TYPE_ALIAS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.TypeAlias";
    public static final String CEYLON_ANNOTATION_INSTANTIATION_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.AnnotationInstantiation";
    public static final String CEYLON_FINAL_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Final";
    public static final String CEYLON_ANNOTATION_INSTANTIATION_ARGUMENTS_MEMBER = "arguments";
    public static final String CEYLON_ANNOTATION_INSTANTIATION_ANNOTATION_MEMBER = "primary";
    public static final String CEYLON_ANNOTATION_INSTANTIATION_TREE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.AnnotationInstantiationTree";
    public static final String CEYLON_STRING_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.StringValue";
    public static final String CEYLON_STRING_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.StringExprs";
    public static final String CEYLON_BOOLEAN_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.BooleanValue";
    public static final String CEYLON_BOOLEAN_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.BooleanExprs";
    public static final String CEYLON_INTEGER_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.IntegerValue";
    public static final String CEYLON_INTEGER_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.IntegerExprs";
    public static final String CEYLON_CHARACTER_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.CharacterValue";
    public static final String CEYLON_CHARACTER_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.CharacterExprs";
    public static final String CEYLON_FLOAT_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.FloatValue";
    public static final String CEYLON_FLOAT_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.FloatExprs";
    public static final String CEYLON_OBJECT_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.ObjectValue";
    public static final String CEYLON_OBJECT_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.ObjectExprs";
    public static final String CEYLON_DECLARATION_VALUE_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.DeclarationValue";
    public static final String CEYLON_DECLARATION_EXPRS_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.DeclarationExprs";
    private static final String CEYLON_TRANSIENT_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Transient";
    private static final String CEYLON_DYNAMIC_ANNOTATION = "com.redhat.ceylon.compiler.java.metadata.Dynamic";
    private static final String JAVA_DEPRECATED_ANNOTATION = "java.lang.Deprecated";
    static final String CEYLON_LANGUAGE_ABSTRACT_ANNOTATION = "ceylon.language.AbstractAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_ACTUAL_ANNOTATION = "ceylon.language.ActualAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_ANNOTATION_ANNOTATION = "ceylon.language.AnnotationAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_DEFAULT_ANNOTATION = "ceylon.language.DefaultAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_FORMAL_ANNOTATION = "ceylon.language.FormalAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_SHARED_ANNOTATION = "ceylon.language.SharedAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_LATE_ANNOTATION = "ceylon.language.LateAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_SEALED_ANNOTATION = "ceylon.language.SealedAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_VARIABLE_ANNOTATION = "ceylon.language.VariableAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_FINAL_ANNOTATION = "ceylon.language.FinalAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_NATIVE_ANNOTATION = "ceylon.language.NativeAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_OPTIONAL_ANNOTATION = "ceylon.language.OptionalAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_SERIALIZABLE_ANNOTATION = "ceylon.language.SerializableAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_DOC_ANNOTATION = "ceylon.language.DocAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_THROWS_ANNOTATIONS = "ceylon.language.ThrownExceptionAnnotation$annotations$";
    static final String CEYLON_LANGUAGE_THROWS_ANNOTATION = "ceylon.language.ThrownExceptionAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_AUTHORS_ANNOTATION = "ceylon.language.AuthorsAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_SEE_ANNOTATIONS = "ceylon.language.SeeAnnotation$annotations$";
    static final String CEYLON_LANGUAGE_SEE_ANNOTATION = "ceylon.language.SeeAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_DEPRECATED_ANNOTATION = "ceylon.language.DeprecationAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_SUPPRESS_WARNINGS_ANNOTATION = "ceylon.language.SuppressWarningsAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_LICENSE_ANNOTATION = "ceylon.language.LicenseAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_TAGS_ANNOTATION = "ceylon.language.TagsAnnotation$annotation$";
    static final String CEYLON_LANGUAGE_ALIASES_ANNOTATION = "ceylon.language.AliasesAnnotation$annotation$";
    private static final String CEYLON_LANGUAGE_CALLABLE_TYPE_NAME = "ceylon.language::Callable";
    private static final String CEYLON_LANGUAGE_TUPLE_TYPE_NAME = "ceylon.language::Tuple";
    private static final String CEYLON_LANGUAGE_SEQUENTIAL_TYPE_NAME = "ceylon.language::Sequential";
    private static final String CEYLON_LANGUAGE_SEQUENCE_TYPE_NAME = "ceylon.language::Sequence";
    private static final String CEYLON_LANGUAGE_EMPTY_TYPE_NAME = "ceylon.language::Empty";
    private static final TypeMirror OBJECT_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.Object");
    private static final TypeMirror CHAR_SEQUENCE_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.CharSequence");
    private static final TypeMirror ANNOTATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.annotation.Annotation");
    private static final TypeMirror CEYLON_OBJECT_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Object");
    private static final TypeMirror CEYLON_ANNOTATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Annotation");
    private static final TypeMirror CEYLON_CONSTRAINED_ANNOTATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.ConstrainedAnnotation");
    private static final TypeMirror CEYLON_FUNCTION_OR_VALUE_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.FunctionOrValueDeclaration");
    private static final TypeMirror CEYLON_VALUE_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ValueDeclaration");
    private static final TypeMirror CEYLON_PACKAGE_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.Package");
    private static final TypeMirror CEYLON_ALIAS_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.AliasDeclaration");
    private static final TypeMirror CEYLON_CLASS_OR_INTERFACE_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ClassOrInterfaceDeclaration");
    private static final TypeMirror CEYLON_CLASS_WITH_INIT_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ClassWithInitializerDeclaration");
    private static final TypeMirror CEYLON_CLASS_WITH_CTORS_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ClassWithConstructorsDeclaration");
    private static final TypeMirror CEYLON_CONSTRUCTOR_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ConstructorDeclaration");
    private static final TypeMirror CEYLON_CALLABLE_CONSTRUCTOR_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.CallableConstructorDeclaration");
    private static final TypeMirror CEYLON_VALUE_CONSTRUCTOR_DECLARATION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.meta.declaration.ValueConstructorDeclaration");
    private static final TypeMirror CEYLON_ANNOTATED_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Annotated");
    private static final TypeMirror CEYLON_BASIC_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Basic");
    private static final TypeMirror CEYLON_REIFIED_TYPE_TYPE = AbstractModelLoader.simpleCeylonObjectType("com.redhat.ceylon.compiler.java.runtime.model.ReifiedType");
    private static final TypeMirror CEYLON_SERIALIZABLE_TYPE = AbstractModelLoader.simpleCeylonObjectType("com.redhat.ceylon.compiler.java.runtime.serialization.Serializable");
    private static final TypeMirror CEYLON_TYPE_DESCRIPTOR_TYPE = AbstractModelLoader.simpleCeylonObjectType("com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor");
    private static final TypeMirror THROWABLE_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.Throwable");
    private static final TypeMirror EXCEPTION_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.Exception");
    private static final TypeMirror CEYLON_THROWABLE_TYPE = AbstractModelLoader.simpleCeylonObjectType("java.lang.Throwable");
    private static final TypeMirror CEYLON_EXCEPTION_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Exception");
    private static final TypeMirror STRING_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.String");
    private static final TypeMirror CEYLON_STRING_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.String");
    private static final TypeMirror CLASS_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.Class");
    private static final TypeMirror PRIM_BOOLEAN_TYPE = AbstractModelLoader.simpleJDKObjectType("boolean");
    private static final TypeMirror CEYLON_BOOLEAN_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Boolean");
    private static final TypeMirror PRIM_BYTE_TYPE = AbstractModelLoader.simpleJDKObjectType("byte");
    private static final TypeMirror CEYLON_BYTE_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Byte");
    private static final TypeMirror PRIM_SHORT_TYPE = AbstractModelLoader.simpleJDKObjectType("short");
    private static final TypeMirror PRIM_INT_TYPE = AbstractModelLoader.simpleJDKObjectType("int");
    private static final TypeMirror PRIM_LONG_TYPE = AbstractModelLoader.simpleJDKObjectType("long");
    private static final TypeMirror CEYLON_INTEGER_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Integer");
    private static final TypeMirror PRIM_FLOAT_TYPE = AbstractModelLoader.simpleJDKObjectType("float");
    private static final TypeMirror PRIM_DOUBLE_TYPE = AbstractModelLoader.simpleJDKObjectType("double");
    private static final TypeMirror CEYLON_FLOAT_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Float");
    private static final TypeMirror PRIM_CHAR_TYPE = AbstractModelLoader.simpleJDKObjectType("char");
    private static final TypeMirror CEYLON_CHARACTER_TYPE = AbstractModelLoader.simpleCeylonObjectType("ceylon.language.Character");
    protected static final String JAVA_LANG_BYTE_ARRAY = "java.lang.ByteArray";
    protected static final String JAVA_LANG_SHORT_ARRAY = "java.lang.ShortArray";
    protected static final String JAVA_LANG_INT_ARRAY = "java.lang.IntArray";
    protected static final String JAVA_LANG_LONG_ARRAY = "java.lang.LongArray";
    protected static final String JAVA_LANG_FLOAT_ARRAY = "java.lang.FloatArray";
    protected static final String JAVA_LANG_DOUBLE_ARRAY = "java.lang.DoubleArray";
    protected static final String JAVA_LANG_CHAR_ARRAY = "java.lang.CharArray";
    protected static final String JAVA_LANG_BOOLEAN_ARRAY = "java.lang.BooleanArray";
    protected static final String JAVA_LANG_OBJECT_ARRAY = "java.lang.ObjectArray";
    private static final String CEYLON_BYTE_ARRAY = "com.redhat.ceylon.compiler.java.language.ByteArray";
    private static final String CEYLON_SHORT_ARRAY = "com.redhat.ceylon.compiler.java.language.ShortArray";
    private static final String CEYLON_INT_ARRAY = "com.redhat.ceylon.compiler.java.language.IntArray";
    private static final String CEYLON_LONG_ARRAY = "com.redhat.ceylon.compiler.java.language.LongArray";
    private static final String CEYLON_FLOAT_ARRAY = "com.redhat.ceylon.compiler.java.language.FloatArray";
    private static final String CEYLON_DOUBLE_ARRAY = "com.redhat.ceylon.compiler.java.language.DoubleArray";
    private static final String CEYLON_CHAR_ARRAY = "com.redhat.ceylon.compiler.java.language.CharArray";
    private static final String CEYLON_BOOLEAN_ARRAY = "com.redhat.ceylon.compiler.java.language.BooleanArray";
    private static final String CEYLON_OBJECT_ARRAY = "com.redhat.ceylon.compiler.java.language.ObjectArray";
    private static final TypeMirror JAVA_BYTE_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.ByteArray");
    private static final TypeMirror JAVA_SHORT_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.ShortArray");
    private static final TypeMirror JAVA_INT_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.IntArray");
    private static final TypeMirror JAVA_LONG_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.LongArray");
    private static final TypeMirror JAVA_FLOAT_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.FloatArray");
    private static final TypeMirror JAVA_DOUBLE_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.DoubleArray");
    private static final TypeMirror JAVA_CHAR_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.CharArray");
    private static final TypeMirror JAVA_BOOLEAN_ARRAY_TYPE = AbstractModelLoader.simpleJDKObjectType("java.lang.BooleanArray");
    private static final TypeMirror JAVA_IO_SERIALIZABLE_TYPE_TYPE = AbstractModelLoader.simpleJDKObjectType("java.io.Serializable");
    protected static final String JAVA_LANG_TRANSIENT_ANNOTATION = "java.lang.transient";
    protected static final String JAVA_LANG_VOLATILE_ANNOTATION = "java.lang.volatile";
    protected static final String JAVA_LANG_SYNCHRONIZED_ANNOTATION = "java.lang.synchronized";
    protected static final String JAVA_LANG_NATIVE_ANNOTATION = "java.lang.native";
    protected static final String JAVA_LANG_STRICTFP_ANNOTATION = "java.lang.strictfp";
    private static final String CEYLON_INTEROP_TRANSIENT_ANNOTATION = "com.redhat.ceylon.compiler.java.language.transient";
    private static final String CEYLON_INTEROP_VOLATILE_ANNOTATION = "com.redhat.ceylon.compiler.java.language.volatile";
    private static final String CEYLON_INTEROP_SYNCHRONIZED_ANNOTATION = "com.redhat.ceylon.compiler.java.language.synchronized";
    private static final String CEYLON_INTEROP_NATIVE_ANNOTATION = "com.redhat.ceylon.compiler.java.language.native";
    private static final String CEYLON_INTEROP_STRICTFP_ANNOTATION = "com.redhat.ceylon.compiler.java.language.strictfp";
    private static final Set<String> CEYLON_INTEROP_DECLARATIONS = new HashSet<String>();
    protected Map<String, Declaration> valueDeclarationsByName = new HashMap<String, Declaration>();
    protected Map<String, Declaration> typeDeclarationsByName = new HashMap<String, Declaration>();
    protected Map<String, Unit> unitsByPackage = new HashMap<String, Unit>();
    protected TypeParser typeParser;
    protected Unit typeFactory;
    protected final Set<String> loadedPackages = new HashSet<String>();
    protected final Map<String, LazyPackage> packagesByName = new HashMap<String, LazyPackage>();
    protected boolean packageDescriptorsNeedLoading = false;
    protected boolean isBootstrap;
    private ModuleManager moduleManager;
    protected Modules modules;
    protected Map<String, ClassMirror> classMirrorCache = new HashMap<String, ClassMirror>();
    protected boolean binaryCompatibilityErrorRaised = false;
    protected Timer timer;
    private Map<String, LazyPackage> modulelessPackages = new HashMap<String, LazyPackage>();
    private ParameterNameParser parameterNameParser = new ParameterNameParser(this);
    protected JdkProvider jdkProvider;
    MethodMirrorFilter constructorOnly = new MethodMirrorFilter(){

        @Override
        public boolean accept(MethodMirror methodMirror) {
            return methodMirror.isConstructor();
        }
    };

    private static TypeMirror simpleJDKObjectType(String name) {
        return new SimpleReflType(name, SimpleReflType.Module.JDK, TypeKind.DECLARED, new TypeMirror[0]);
    }

    private static TypeMirror simpleCeylonObjectType(String name) {
        return new SimpleReflType(name, SimpleReflType.Module.CEYLON, TypeKind.DECLARED, new TypeMirror[0]);
    }

    protected final void initModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    protected ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public abstract boolean loadPackage(Module var1, String var2, boolean var3);

    @Override
    public final Object getLock() {
        return this;
    }

    public <T> T embeddingSync(Callable<T> action) throws Exception {
        return action.call();
    }

    @Override
    public final <T> T synchronizedCall(final Callable<T> action) {
        try {
            return this.embeddingSync(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    Object object = AbstractModelLoader.this.getLock();
                    synchronized (object) {
                        return action.call();
                    }
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EmbeddedException(e);
        }
    }

    @Override
    public final void synchronizedRun(final Runnable action) {
        this.synchronizedCall(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                action.run();
                return null;
            }
        });
    }

    protected boolean hasJavaAndCeylonSources() {
        return false;
    }

    protected boolean needsLocalDeclarations() {
        return true;
    }

    protected boolean needsPrivateMembers() {
        return true;
    }

    public boolean searchAgain(ClassMirror cachedMirror, Module module, String name) {
        return false;
    }

    public boolean searchAgain(Declaration cachedDeclaration, LazyPackage lazyPackage, String name) {
        return false;
    }

    public final ClassMirror lookupClassMirror(final Module theModule, final String theName) {
        return this.synchronizedCall(new Callable<ClassMirror>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClassMirror call() throws Exception {
                Module module = theModule;
                String name = theName;
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                try {
                    ClassMirror cachedMirror;
                    String cacheKey;
                    if (AbstractModelLoader.JAVA_LANG_OBJECT_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_BOOLEAN_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_BYTE_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_SHORT_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_INT_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_LONG_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_FLOAT_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_DOUBLE_ARRAY.equals(name) || AbstractModelLoader.JAVA_LANG_CHAR_ARRAY.equals(name)) {
                        name = "com.redhat.ceylon.compiler.java.language" + name.substring(9);
                        module = AbstractModelLoader.this.getLanguageModule();
                    }
                    if (AbstractModelLoader.JAVA_LANG_TRANSIENT_ANNOTATION.equals(name) || AbstractModelLoader.JAVA_LANG_VOLATILE_ANNOTATION.equals(name) || AbstractModelLoader.JAVA_LANG_SYNCHRONIZED_ANNOTATION.equals(name) || AbstractModelLoader.JAVA_LANG_NATIVE_ANNOTATION.equals(name) || AbstractModelLoader.JAVA_LANG_STRICTFP_ANNOTATION.equals(name)) {
                        name = "com.redhat.ceylon.compiler.java.language" + name.substring(9);
                        module = AbstractModelLoader.this.getLanguageModule();
                    }
                    if (AbstractModelLoader.this.classMirrorCache.containsKey(cacheKey = AbstractModelLoader.this.cacheKeyByModule(module, name)) && !AbstractModelLoader.this.searchAgain(cachedMirror = AbstractModelLoader.this.classMirrorCache.get(cacheKey), module, name)) {
                        ClassMirror classMirror = cachedMirror;
                        return classMirror;
                    }
                    ClassMirror mirror = AbstractModelLoader.this.lookupNewClassMirror(module, name);
                    AbstractModelLoader.this.classMirrorCache.put(cacheKey, mirror);
                    ClassMirror classMirror = mirror;
                    return classMirror;
                }
                finally {
                    AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                }
            }
        });
    }

    protected String cacheKeyByModule(Module module, String name) {
        return AbstractModelLoader.getCacheKeyByModule(module, name);
    }

    public static String getCacheKeyByModule(Module module, String name) {
        String moduleSignature = module.getSignature();
        StringBuilder buf = new StringBuilder(moduleSignature.length() + 1 + name.length());
        return buf.append(moduleSignature).append('/').append(name).toString();
    }

    protected boolean lastPartHasLowerInitial(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (!(name = NamingBase.stripLeadingDollar(name)).isEmpty()) {
            int codepoint = name.codePointAt(0);
            return JvmBackendUtil.isLowerCase(codepoint);
        }
        return false;
    }

    protected abstract ClassMirror lookupNewClassMirror(Module var1, String var2);

    public abstract void addModuleToClassPath(Module var1, ArtifactResult var2);

    public boolean isModuleInClassPath(Module module) {
        return true;
    }

    protected abstract boolean isOverridingMethod(MethodMirror var1);

    protected abstract boolean isOverloadingMethod(MethodMirror var1);

    protected abstract void logWarning(String var1);

    protected abstract void logVerbose(String var1);

    protected abstract void logError(String var1);

    public void loadStandardModules() {
        Timer nested = this.timer.nestedTimer();
        nested.startTask("load ceylon.language");
        Module languageModule = this.loadLanguageModuleAndPackage();
        nested.endTask();
        nested.startTask("load JDK");
        String jdkModuleSpec = this.getAlternateJdkModuleSpec();
        Module jdkModule = null;
        if (jdkModuleSpec != null) {
            ModuleSpec spec = ModuleSpec.parse(jdkModuleSpec, new ModuleSpec.Option[0]);
            jdkModule = this.findOrCreateModule(spec.getName(), spec.getVersion());
        }
        if (jdkModule == null) {
            this.jdkProvider = new JdkProvider();
            this.loadJDKModules();
            jdkModule = this.findOrCreateModule(JAVA_BASE_MODULE_NAME, this.jdkProvider.getJDKVersion());
        }
        nested.endTask();
        nested.startTask("load standard packages");
        this.loadPackage(jdkModule, "java.lang", false);
        this.loadPackage(languageModule, "com.redhat.ceylon.compiler.java.metadata", false);
        this.loadPackage(languageModule, "com.redhat.ceylon.compiler.java.language", false);
        nested.endTask();
    }

    protected String getAlternateJdkModuleSpec() {
        return null;
    }

    protected Module loadLanguageModuleAndPackage() {
        Module languageModule = this.findOrCreateModule(CEYLON_LANGUAGE, null);
        this.addModuleToClassPath(languageModule, null);
        LazyPackage languagePackage = this.findOrCreatePackage(languageModule, CEYLON_LANGUAGE);
        this.typeFactory.setPackage(languagePackage);
        languageModule.addImport(new ModuleImport(null, this.findOrCreateModule("com.redhat.ceylon.common", "1.3.2"), false, false, Backend.Java));
        languageModule.addImport(new ModuleImport(null, this.findOrCreateModule("com.redhat.ceylon.model", "1.3.2"), false, false, Backend.Java));
        return languageModule;
    }

    protected void loadJDKModules() {
        String version2 = this.jdkProvider.getJDKVersion();
        for (String jdkModule : this.jdkProvider.getJDKModuleNames()) {
            this.findOrCreateModule(jdkModule, version2);
        }
    }

    public void setupWithNoStandardModules() {
        Module languageModule = this.modules.getLanguageModule();
        if (languageModule == null) {
            throw new RuntimeException("Assertion failed: language module is null");
        }
        Package languagePackage = languageModule.getPackage(CEYLON_LANGUAGE);
        if (languagePackage == null) {
            throw new RuntimeException("Assertion failed: language package is null");
        }
        this.typeFactory.setPackage(languagePackage);
    }

    private ClassMirror loadClass(Module module, String pkgName, String className) {
        ClassMirror moduleClass = null;
        try {
            moduleClass = this.lookupClassMirror(module, className);
        }
        catch (Exception x) {
            this.logVerbose("[Failed to complete class " + className + "]");
        }
        return moduleClass;
    }

    private Declaration convertNonPrimitiveTypeToDeclaration(Module moduleScope, TypeMirror type, Scope scope, ModelLoader.DeclarationType declarationType) {
        switch (type.getKind()) {
            case VOID: {
                return this.typeFactory.getAnythingDeclaration();
            }
            case ARRAY: {
                return (Class)this.convertToDeclaration(this.getLanguageModule(), JAVA_LANG_OBJECT_ARRAY, ModelLoader.DeclarationType.TYPE);
            }
            case DECLARED: {
                return this.convertDeclaredTypeToDeclaration(moduleScope, type, declarationType);
            }
            case TYPEVAR: {
                return this.safeLookupTypeParameter(scope, type.getQualifiedName());
            }
            case WILDCARD: {
                return this.typeFactory.getNothingDeclaration();
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                throw new RuntimeException("Expected non-primitive type: " + type);
            }
            case ERROR: {
                return null;
            }
        }
        throw new RuntimeException("Failed to handle type " + type);
    }

    private Declaration convertDeclaredTypeToDeclaration(Module moduleScope, TypeMirror type, ModelLoader.DeclarationType declarationType) {
        String typeName = type.getQualifiedName();
        if (type instanceof SimpleReflType) {
            Module module = null;
            switch (((SimpleReflType)type).getModule()) {
                case CEYLON: {
                    module = this.getLanguageModule();
                    break;
                }
                case JDK: {
                    module = this.getJDKBaseModule();
                }
            }
            return this.convertToDeclaration(module, typeName, declarationType);
        }
        ClassMirror classMirror = type.getDeclaredClass();
        Module module = this.findModuleForClassMirror(classMirror);
        if (this.isImported(moduleScope, module)) {
            return this.convertToDeclaration(module, typeName, declarationType);
        }
        if (module != null && this.isFlatClasspath() && this.isMavenModule(moduleScope)) {
            return this.convertToDeclaration(module, typeName, declarationType);
        }
        String error = "Declaration '" + typeName + "' could not be found in module '" + moduleScope.getNameAsString() + "' or its imported modules";
        if (module != null && !module.isDefaultModule()) {
            error = error + " but was found in the non-imported module '" + module.getNameAsString() + "'";
        }
        return this.logModelResolutionException(null, moduleScope, error).getDeclaration();
    }

    public Declaration convertToDeclaration(Module module, ClassMirror classMirror, ModelLoader.DeclarationType declarationType) {
        return this.convertToDeclaration(module, null, classMirror, declarationType);
    }

    private Declaration convertToDeclaration(Module module, Declaration container, ClassMirror classMirror, ModelLoader.DeclarationType declarationType) {
        Declaration decl;
        String pkgName = this.getPackageNameForQualifiedClassName(classMirror);
        if (pkgName.equals("java.lang")) {
            module = this.getJDKBaseModule();
        }
        if ((decl = this.findCachedDeclaration(module, container, classMirror, declarationType)) != null) {
            return decl;
        }
        if (classMirror.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null) {
            return null;
        }
        if (classMirror.getAnnotation(CEYLON_LOCAL_CONTAINER_ANNOTATION) != null && !this.needsLocalDeclarations()) {
            return null;
        }
        if (classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null && classMirror.isAnnotationType()) {
            return null;
        }
        if (classMirror.getAnnotation(CEYLON_MODULE_ANNOTATION) != null || classMirror.getAnnotation(CEYLON_PACKAGE_ANNOTATION) != null) {
            return null;
        }
        ArrayList<Declaration> decls = new ArrayList<Declaration>();
        LazyPackage pkg = this.findOrCreatePackage(module, pkgName);
        decl = this.createDeclaration(container, classMirror, declarationType, decls);
        this.cacheDeclaration(module, container, classMirror, declarationType, decl, decls);
        Unit unit = this.getCompiledUnit(pkg, classMirror);
        for (Declaration d : decls) {
            d.setUnit(unit);
            unit.addDeclaration(d);
            this.setContainer(classMirror, d, pkg);
        }
        return decl;
    }

    public String getPackageNameForQualifiedClassName(String pkg, String qualifiedName) {
        for (String name : CEYLON_INTEROP_DECLARATIONS) {
            if (!qualifiedName.startsWith(name)) continue;
            return "java.lang";
        }
        return this.unquotePackageName(pkg);
    }

    protected String getPackageNameForQualifiedClassName(ClassMirror classMirror) {
        return this.getPackageNameForQualifiedClassName(classMirror.getPackage().getQualifiedName(), classMirror.getQualifiedName());
    }

    private String unquotePackageName(PackageMirror pkg) {
        return this.unquotePackageName(pkg.getQualifiedName());
    }

    private String unquotePackageName(String pkg) {
        return JvmBackendUtil.removeChar('$', pkg);
    }

    private void setContainer(ClassMirror classMirror, Declaration d, LazyPackage pkg) {
        if (!classMirror.isInnerClass() && !classMirror.isLocalClass()) {
            d.setContainer(pkg);
            d.setScope(pkg);
            pkg.addCompiledMember(d);
            if (d instanceof LazyInterface && ((LazyInterface)d).isCeylon()) {
                this.setInterfaceCompanionClass(d, null, pkg);
            }
            ModelUtil.setVisibleScope(d);
        } else if (classMirror.isLocalClass() && !classMirror.isInnerClass()) {
            Scope localContainer = this.getLocalContainer(pkg, classMirror, d);
            if (localContainer != null) {
                d.setContainer(localContainer);
                d.setScope(localContainer);
            } else {
                d.setContainer(pkg);
                d.setScope(pkg);
            }
            ((LazyElement)((Object)d)).setLocal(true);
        } else if (!(!(d instanceof ClassOrInterface) && !(d instanceof TypeAlias) || d instanceof Class && ((Class)d).isOverloaded())) {
            ClassOrInterface container = this.getContainer(pkg.getModule(), classMirror);
            if (d.isNativeHeader() && container.isNative()) {
                container = (ClassOrInterface)ModelUtil.getNativeHeader(container);
            } else if (d.isNativeImplementation() && container.isNativeHeader()) {
                container = (ClassOrInterface)ModelUtil.getNativeDeclaration((Declaration)container, Backend.Java);
            }
            d.setContainer(container);
            d.setScope(container);
            if (d instanceof LazyInterface && ((LazyInterface)d).isCeylon()) {
                this.setInterfaceCompanionClass(d, container, pkg);
            }
            ((LazyContainer)((Object)container)).addMember(d);
            ModelUtil.setVisibleScope(d);
            if (d instanceof Class && ((Class)d).getOverloads() != null) {
                for (Declaration overload : ((Class)d).getOverloads()) {
                    overload.setContainer(container);
                    overload.setScope(container);
                    ((LazyContainer)((Object)container)).addMember(overload);
                    ModelUtil.setVisibleScope(overload);
                }
            }
            if (d instanceof LazyInterface && !((LazyInterface)d).isCeylon() && ((LazyInterface)d).isAnnotationType()) {
                for (Declaration decl : this.makeInteropAnnotation((LazyInterface)d, container)) {
                    container.addMember(decl);
                }
            }
        }
    }

    public List<Declaration> makeInteropAnnotation(LazyInterface iface, Scope container) {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        AnnotationProxyClass klass = this.makeInteropAnnotationClass(iface, container);
        AnnotationProxyMethod method = this.makeInteropAnnotationConstructor(iface, klass, null, container);
        declarations.add(method);
        for (OutputElement target : AnnotationTarget.outputTargets(klass)) {
            declarations.add(this.makeInteropAnnotationConstructor(iface, klass, target, container));
        }
        declarations.add(klass);
        return declarations;
    }

    protected void setInterfaceCompanionClass(Declaration d, ClassOrInterface container, LazyPackage pkg) {
        String companionName;
        ClassMirror containerMirror = null;
        if (container instanceof LazyClass) {
            containerMirror = ((LazyClass)container).classMirror;
        } else if (container instanceof LazyInterface && (containerMirror = ((LazyInterface)container).companionClass) == null) {
            throw new ModelResolutionException("Interface companion class for " + container.getQualifiedNameString() + " not set up");
        }
        if (containerMirror != null) {
            companionName = containerMirror.getFlatName() + "$" + NamingBase.suffixName(NamingBase.Suffix.$impl, d.getName());
        } else {
            String p = pkg.getNameAsString();
            companionName = "";
            if (!p.isEmpty()) {
                companionName = p + ".";
            }
            companionName = companionName + NamingBase.suffixName(NamingBase.Suffix.$impl, d.getName());
        }
        ClassMirror companionClass = this.lookupClassMirror(pkg.getModule(), companionName);
        if (companionClass == null) {
            ((Interface)d).setCompanionClassNeeded(false);
        }
        ((LazyInterface)d).companionClass = companionClass;
    }

    private Scope getLocalContainer(Package pkg, ClassMirror classMirror, Declaration declaration) {
        AnnotationMirror localContainerAnnotation = classMirror.getAnnotation(CEYLON_LOCAL_CONTAINER_ANNOTATION);
        String qualifier = this.getAnnotationStringValue(classMirror, CEYLON_LOCAL_DECLARATION_ANNOTATION, "qualifier");
        Boolean isPackageLocal = this.getAnnotationBooleanValue(classMirror, CEYLON_LOCAL_DECLARATION_ANNOTATION, "isPackageLocal");
        if (BooleanUtil.isTrue(isPackageLocal)) {
            declaration.setQualifier(qualifier);
            return null;
        }
        LocalDeclarationContainer methodDecl = null;
        if (localContainerAnnotation != null) {
            methodDecl = (LocalDeclarationContainer)this.findLocalContainerFromAnnotationAndSetCompanionClass(pkg, (Interface)declaration, localContainerAnnotation);
        } else {
            Declaration enclosingClassDeclaration;
            String javaClassName;
            MethodMirror method = classMirror.getEnclosingMethod();
            if (method == null) {
                return null;
            }
            ClassMirror enclosingClass = method.getEnclosingClass();
            while (enclosingClass.isAnonymous()) {
                method = enclosingClass.getEnclosingMethod();
                if (method == null) {
                    return null;
                }
                enclosingClass = method.getEnclosingClass();
            }
            TypeMirror getterClass = (TypeMirror)this.getAnnotationValue(enclosingClass, CEYLON_SETTER_ANNOTATION, "getterClass");
            boolean isSetter = false;
            if (getterClass != null && !getterClass.isPrimitive()) {
                enclosingClass = getterClass.getDeclaredClass();
                isSetter = true;
            }
            if ((javaClassName = enclosingClass.getQualifiedName()).endsWith(NamingBase.Suffix.$impl.name())) {
                javaClassName = javaClassName.substring(0, javaClassName.length() - 5);
            }
            if ((enclosingClassDeclaration = this.convertToDeclaration(pkg.getModule(), javaClassName, ModelLoader.DeclarationType.TYPE)) instanceof ClassOrInterface) {
                ClassOrInterface containerDecl = (ClassOrInterface)enclosingClassDeclaration;
                String name = method.getName();
                if (method.isConstructor() || name.startsWith(NamingBase.Prefix.$default$.toString())) {
                    methodDecl = (LocalDeclarationContainer)((Object)containerDecl);
                } else {
                    String type;
                    if (this.isStringAttribute(method)) {
                        name = "string";
                        type = "attribute";
                    } else if (this.isHashAttribute(method)) {
                        name = "hash";
                        type = "attribute";
                    } else if (this.isGetter(method)) {
                        name = this.getJavaAttributeName(method);
                        type = "attribute";
                    } else if (this.isSetter(method)) {
                        name = this.getJavaAttributeName(method);
                        type = "attribute setter";
                        isSetter = true;
                    } else {
                        type = "method";
                    }
                    if (name.endsWith(NamingBase.Suffix.$canonical$.toString())) {
                        name = name.substring(0, name.length() - 11);
                    }
                    if ((name = JvmBackendUtil.strip(name, true, method.isPublic() || method.isProtected() || method.isDefaultAccess())).indexOf(36) > 0) {
                        name = name.substring(0, name.indexOf(36));
                    }
                    if ((methodDecl = (LocalDeclarationContainer)((Object)containerDecl.getDirectMember(name, null, false))) == null) {
                        throw new ModelResolutionException("Failed to load outer " + type + " " + name + " for local type " + classMirror.getQualifiedName().toString());
                    }
                    if (isSetter) {
                        LocalDeclarationContainer setter = (LocalDeclarationContainer)((Object)((Value)((Object)methodDecl)).getSetter());
                        if (setter == null) {
                            throw new ModelResolutionException("Failed to load outer " + type + " " + name + " for local type " + classMirror.getQualifiedName().toString());
                        }
                        methodDecl = setter;
                    }
                }
            } else if (enclosingClassDeclaration instanceof LazyFunction) {
                methodDecl = (LazyFunction)enclosingClassDeclaration;
            } else if (enclosingClassDeclaration instanceof LazyValue) {
                if (enclosingClassDeclaration.isToplevel() && method.getName().equals(NamingBase.Unfix.set_.name())) {
                    isSetter = true;
                }
                if (isSetter) {
                    LocalDeclarationContainer setter = (LocalDeclarationContainer)((Object)((LazyValue)enclosingClassDeclaration).getSetter());
                    if (setter == null) {
                        throw new ModelResolutionException("Failed to toplevel attribute setter " + enclosingClassDeclaration.getName() + " for local type " + classMirror.getQualifiedName().toString());
                    }
                    methodDecl = setter;
                } else {
                    methodDecl = (LazyValue)enclosingClassDeclaration;
                }
            } else {
                throw new ModelResolutionException("Unknown container type " + enclosingClassDeclaration + " for local type " + classMirror.getQualifiedName().toString());
            }
        }
        if (qualifier == null) {
            return null;
        }
        declaration.setQualifier(qualifier);
        methodDecl.addLocalDeclaration(declaration);
        return methodDecl;
    }

    private Scope findLocalContainerFromAnnotationAndSetCompanionClass(Package pkg, Interface declaration, AnnotationMirror localContainerAnnotation) {
        ClassMirror container;
        List path = (List)localContainerAnnotation.getValue("path");
        Scope scope = pkg;
        for (String name : path) {
            scope = (Scope)((Object)AbstractModelLoader.getDirectMember(scope, name));
        }
        String companionClassName = (String)localContainerAnnotation.getValue("companionClassName");
        if (companionClassName == null || companionClassName.isEmpty()) {
            declaration.setCompanionClassNeeded(false);
            return scope;
        }
        Scope javaClassScope = scope instanceof TypedDeclaration && ((TypedDeclaration)((Object)scope)).isMember() ? scope.getContainer() : scope;
        if (javaClassScope instanceof LazyInterface) {
            container = ((LazyInterface)javaClassScope).companionClass;
        } else if (javaClassScope instanceof LazyClass) {
            container = ((LazyClass)javaClassScope).classMirror;
        } else if (javaClassScope instanceof LazyValue) {
            container = ((LazyValue)javaClassScope).classMirror;
        } else if (javaClassScope instanceof LazyFunction) {
            container = ((LazyFunction)javaClassScope).classMirror;
        } else if (javaClassScope instanceof SetterWithLocalDeclarations) {
            container = ((SetterWithLocalDeclarations)javaClassScope).classMirror;
        } else {
            throw new ModelResolutionException("Unknown scope class: " + javaClassScope);
        }
        String qualifiedCompanionClassName = container.getQualifiedName() + "$" + companionClassName;
        ClassMirror companionClassMirror = this.lookupClassMirror(pkg.getModule(), qualifiedCompanionClassName);
        if (companionClassMirror == null) {
            throw new ModelResolutionException("Could not find companion class mirror: " + qualifiedCompanionClassName);
        }
        ((LazyInterface)declaration).companionClass = companionClassMirror;
        return scope;
    }

    public static Declaration getDirectMember(Scope container, String name) {
        if (name.isEmpty()) {
            return null;
        }
        boolean wantsSetter = false;
        if (name.startsWith(NamingBase.Suffix.$setter$.name())) {
            wantsSetter = true;
            name = name.substring(8);
        }
        if (Character.isDigit(name.charAt(0))) {
            return ((LocalDeclarationContainer)container).getLocalDeclaration(name);
        }
        if (container instanceof Package) {
            Declaration result = container.getDirectMember(name, null, false);
            return AbstractModelLoader.selectTypeOrSetter(result, wantsSetter);
        }
        for (Declaration member : container.getMembers()) {
            Declaration result;
            if (member.getName() == null || !member.getName().equals(name) || (result = AbstractModelLoader.selectTypeOrSetter(member, wantsSetter)) == null) continue;
            return result;
        }
        return null;
    }

    private static Declaration selectTypeOrSetter(Declaration member, boolean wantsSetter) {
        if (member instanceof ClassOrInterface || member instanceof Constructor || member instanceof Function) {
            return member;
        }
        if (member instanceof Value) {
            TypeDeclaration typeDeclaration = ((Value)member).getTypeDeclaration();
            if (typeDeclaration instanceof Class && typeDeclaration.isAnonymous()) {
                return typeDeclaration;
            }
            if (wantsSetter) {
                return ((Value)member).getSetter();
            }
            return member;
        }
        return null;
    }

    private ClassOrInterface getContainer(Module module, ClassMirror classMirror) {
        AnnotationMirror containerAnnotation = classMirror.getAnnotation(CEYLON_CONTAINER_ANNOTATION);
        if (containerAnnotation != null) {
            TypeMirror javaClassMirror = (TypeMirror)containerAnnotation.getValue("klass");
            String javaClassName = javaClassMirror.getQualifiedName();
            ClassOrInterface containerDecl = (ClassOrInterface)this.convertToDeclaration(module, javaClassName, ModelLoader.DeclarationType.TYPE);
            if (containerDecl == null) {
                throw new ModelResolutionException("Failed to load outer type " + javaClassName + " for inner type " + classMirror.getQualifiedName().toString());
            }
            return containerDecl;
        }
        return (ClassOrInterface)this.convertToDeclaration(module, classMirror.getEnclosingClass(), ModelLoader.DeclarationType.TYPE);
    }

    private Declaration findCachedDeclaration(Module module, Declaration container, ClassMirror classMirror, ModelLoader.DeclarationType declarationType) {
        boolean isNativeHeaderMember;
        ClassType type = this.getClassType(classMirror);
        String key = classMirror.getCacheKey(module);
        boolean bl = isNativeHeaderMember = container != null && container.isNativeHeader();
        if (isNativeHeaderMember) {
            key = key + "$header";
        }
        Map<String, Declaration> declarationCache = this.getCacheByType(type, declarationType);
        return declarationCache.get(key);
    }

    private void cacheDeclaration(Module module, Declaration container, ClassMirror classMirror, ModelLoader.DeclarationType declarationType, Declaration decl, List<Declaration> decls) {
        boolean isNativeHeaderMember;
        ClassType type = this.getClassType(classMirror);
        String key = classMirror.getCacheKey(module);
        boolean bl = isNativeHeaderMember = container != null && container.isNativeHeader();
        if (isNativeHeaderMember) {
            key = key + "$header";
        }
        if (type == ClassType.OBJECT) {
            this.typeDeclarationsByName.put(key, this.getByType(decls, Class.class));
            this.valueDeclarationsByName.put(key, this.getByType(decls, Value.class));
        } else {
            Map<String, Declaration> declarationCache = this.getCacheByType(type, declarationType);
            declarationCache.put(key, decl);
        }
    }

    private Map<String, Declaration> getCacheByType(ClassType type, ModelLoader.DeclarationType declarationType) {
        Map<String, Declaration> declarationCache = null;
        switch (type) {
            case OBJECT: {
                if (declarationType == ModelLoader.DeclarationType.TYPE) {
                    declarationCache = this.typeDeclarationsByName;
                    break;
                }
            }
            case ATTRIBUTE: 
            case METHOD: {
                declarationCache = this.valueDeclarationsByName;
                break;
            }
            case CLASS: 
            case INTERFACE: {
                declarationCache = this.typeDeclarationsByName;
            }
        }
        return declarationCache;
    }

    private Declaration getByType(List<Declaration> decls, java.lang.Class<?> klass) {
        for (Declaration decl : decls) {
            if (!klass.isAssignableFrom(decl.getClass())) continue;
            return decl;
        }
        return null;
    }

    private Declaration createDeclaration(Declaration container, ClassMirror classMirror, ModelLoader.DeclarationType declarationType, List<Declaration> decls) {
        Declaration decl = null;
        Declaration hdr = null;
        this.checkBinaryCompatibility(classMirror);
        ClassType type = this.getClassType(classMirror);
        boolean isCeylon = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null;
        boolean isNativeHeaderMember = container != null && container.isNativeHeader();
        try {
            switch (type) {
                case ATTRIBUTE: {
                    decl = this.makeToplevelAttribute(classMirror, isNativeHeaderMember);
                    this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, true);
                    if (!isCeylon || !this.shouldCreateNativeHeader(decl, container)) break;
                    hdr = this.makeToplevelAttribute(classMirror, true);
                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                    break;
                }
                case METHOD: {
                    decl = this.makeToplevelMethod(classMirror, isNativeHeaderMember);
                    this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, true);
                    if (!isCeylon || !this.shouldCreateNativeHeader(decl, container)) break;
                    hdr = this.makeToplevelMethod(classMirror, true);
                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                    break;
                }
                case OBJECT: {
                    LazyClass objectClassDecl = this.makeLazyClass(classMirror, null, null, isNativeHeaderMember);
                    this.setNonLazyDeclarationProperties(objectClassDecl, classMirror, classMirror, classMirror, true);
                    if (isCeylon && this.shouldCreateNativeHeader(objectClassDecl, container)) {
                        LazyClass hdrobj = this.makeLazyClass(classMirror, null, null, true);
                        this.setNonLazyDeclarationProperties(hdrobj, classMirror, classMirror, classMirror, true);
                        decls.add(this.initNativeHeader(hdrobj, objectClassDecl));
                    }
                    decls.add(objectClassDecl);
                    if (((Declaration)objectClassDecl).isNamed()) {
                        LazyValue objectDecl = this.makeToplevelAttribute(classMirror, isNativeHeaderMember);
                        this.setNonLazyDeclarationProperties(objectDecl, classMirror, classMirror, classMirror, true);
                        if (isCeylon && this.shouldCreateNativeHeader(objectDecl, container)) {
                            LazyValue hdrobj = this.makeToplevelAttribute(classMirror, true);
                            this.setNonLazyDeclarationProperties(hdrobj, classMirror, classMirror, classMirror, true);
                            decls.add(this.initNativeHeader(hdrobj, objectDecl));
                        }
                        decls.add(objectDecl);
                        decl = declarationType == ModelLoader.DeclarationType.TYPE ? objectClassDecl : objectDecl;
                        break;
                    }
                    decl = objectClassDecl;
                    break;
                }
                case CLASS: {
                    if (classMirror.getAnnotation(CEYLON_ALIAS_ANNOTATION) != null) {
                        decl = this.makeClassAlias(classMirror);
                        this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, true);
                        break;
                    }
                    if (classMirror.getAnnotation(CEYLON_TYPE_ALIAS_ANNOTATION) != null) {
                        decl = this.makeTypeAlias(classMirror);
                        this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, true);
                        break;
                    }
                    List<MethodMirror> constructors = this.getClassConstructors(classMirror, classMirror, this.constructorOnly);
                    if (!constructors.isEmpty()) {
                        Boolean hasConstructors = this.hasConstructors(classMirror);
                        if (constructors.size() > 1) {
                            if (hasConstructors == null || !hasConstructors.booleanValue()) {
                                decl = this.makeOverloadedConstructor(constructors, classMirror, decls, isCeylon);
                            } else {
                                decl = this.makeLazyClass(classMirror, null, null, isNativeHeaderMember);
                                this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                                if (isCeylon && this.shouldCreateNativeHeader(decl, container)) {
                                    hdr = this.makeLazyClass(classMirror, null, null, true);
                                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                                }
                            }
                        } else if (hasConstructors == null || !hasConstructors.booleanValue()) {
                            MethodMirror constructor = constructors.get(0);
                            if (isCeylon || this.getJavaVisibility(classMirror) == this.getJavaVisibility(constructor) && !this.isCoercedMethod(constructor)) {
                                decl = this.makeLazyClass(classMirror, null, constructor, isNativeHeaderMember);
                                this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                                if (isCeylon && this.shouldCreateNativeHeader(decl, container)) {
                                    hdr = this.makeLazyClass(classMirror, null, constructor, true);
                                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                                }
                            } else {
                                decl = this.makeOverloadedConstructor(constructors, classMirror, decls, isCeylon);
                            }
                        } else {
                            decl = this.makeLazyClass(classMirror, null, null, isNativeHeaderMember);
                            this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                            if (isCeylon && this.shouldCreateNativeHeader(decl, container)) {
                                hdr = this.makeLazyClass(classMirror, null, null, true);
                                this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                            }
                        }
                    } else if (isCeylon && classMirror.getAnnotation(CEYLON_OBJECT_ANNOTATION) != null) {
                        decl = this.makeLazyClass(classMirror, null, null, isNativeHeaderMember);
                        this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                        if (isCeylon && this.shouldCreateNativeHeader(decl, container)) {
                            hdr = this.makeLazyClass(classMirror, null, null, true);
                            this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                        }
                    } else {
                        decl = this.makeLazyClass(classMirror, null, null, isNativeHeaderMember);
                        this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                        if (isCeylon && this.shouldCreateNativeHeader(decl, container)) {
                            hdr = this.makeLazyClass(classMirror, null, null, true);
                            this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                        }
                    }
                    if (!isCeylon) {
                        this.setSealedFromConstructorMods(decl, constructors);
                    }
                    break;
                }
                case INTERFACE: {
                    boolean isAlias = classMirror.getAnnotation(CEYLON_ALIAS_ANNOTATION) != null;
                    decl = isAlias ? this.makeInterfaceAlias(classMirror) : this.makeLazyInterface(classMirror, isNativeHeaderMember);
                    this.setNonLazyDeclarationProperties(decl, classMirror, classMirror, classMirror, isCeylon);
                    if (isAlias || !isCeylon || !this.shouldCreateNativeHeader(decl, container)) break;
                    hdr = this.makeLazyInterface(classMirror, true);
                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                }
            }
        }
        catch (ModelResolutionException x) {
            decl = this.logModelResolutionException(x, null, "Failed to load declaration " + classMirror).getDeclaration();
        }
        if (type != ClassType.OBJECT) {
            if (hdr != null) {
                decls.add(this.initNativeHeader(hdr, decl));
            }
            decls.add(decl);
        }
        return hdr != null ? hdr : decl;
    }

    private ClassType getClassType(ClassMirror classMirror) {
        ClassType type = classMirror.isCeylonToplevelAttribute() ? ClassType.ATTRIBUTE : (classMirror.isCeylonToplevelMethod() ? ClassType.METHOD : (classMirror.isCeylonToplevelObject() ? ClassType.OBJECT : (classMirror.isInterface() ? ClassType.INTERFACE : ClassType.CLASS)));
        return type;
    }

    private boolean shouldCreateNativeHeader(Declaration decl, Declaration container) {
        if (decl.isNativeImplementation() && decl.isShared()) {
            if (container != null) {
                if (!decl.isOverloaded()) {
                    return !container.isNative();
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean shouldLinkNatives(Declaration decl) {
        if (decl.isNative() && decl.isShared()) {
            Declaration container = (Declaration)((Object)decl.getContainer());
            return container.isNative();
        }
        return false;
    }

    private Declaration initNativeHeader(Declaration hdr, Declaration impl2) {
        List<Declaration> al = AbstractModelLoader.getOverloads(hdr);
        if (al == null) {
            al = new ArrayList<Declaration>(1);
        }
        al.add(impl2);
        AbstractModelLoader.setOverloads(hdr, al);
        return hdr;
    }

    private void initNativeHeaderMember(Declaration dec) {
        Declaration hdr;
        if (dec.isNativeImplementation() && (hdr = ModelUtil.getNativeHeader(dec)) != null) {
            this.initNativeHeader(hdr, dec);
        }
    }

    private Boolean hasConstructors(ClassMirror classMirror) {
        Boolean hasConstructors;
        AnnotationMirror a = classMirror.getAnnotation(CEYLON_CLASS_ANNOTATION);
        if (a != null) {
            hasConstructors = (Boolean)a.getValue("constructors");
            if (hasConstructors == null) {
                hasConstructors = false;
            }
        } else {
            hasConstructors = null;
        }
        return hasConstructors;
    }

    private boolean isDefaultNamedCtor(ClassMirror classMirror, MethodMirror ctor) {
        return classMirror.getName().equals(this.getCtorName(ctor));
    }

    private String getCtorName(MethodMirror ctor) {
        AnnotationMirror nameAnno = ctor.getAnnotation(CEYLON_NAME_ANNOTATION);
        if (nameAnno != null) {
            return (String)nameAnno.getValue();
        }
        return null;
    }

    private void setSealedFromConstructorMods(Declaration decl, List<MethodMirror> constructors) {
        boolean effectivelySealed = true;
        for (MethodMirror ctor : constructors) {
            if (!ctor.isPublic() && !ctor.isProtected()) continue;
            effectivelySealed = false;
            break;
        }
        if (effectivelySealed && decl instanceof Class) {
            Class type = (Class)decl;
            type.setSealed(effectivelySealed);
            if (type.getOverloads() != null) {
                for (Declaration oload : type.getOverloads()) {
                    ((Class)oload).setSealed(effectivelySealed);
                }
            }
        }
    }

    private Declaration makeOverloadedConstructor(List<MethodMirror> constructors, ClassMirror classMirror, List<Declaration> decls, boolean isCeylon) {
        LazyClass supercls = this.makeLazyClass(classMirror, null, null, false);
        this.setNonLazyDeclarationProperties(supercls, classMirror, classMirror, classMirror, isCeylon);
        supercls.setAbstraction(true);
        ArrayList<Declaration> overloads = new ArrayList<Declaration>(constructors.size());
        for (MethodMirror constructor : constructors) {
            LazyClass subdecl = this.makeLazyClass(classMirror, supercls, constructor, false);
            this.setNonLazyDeclarationProperties(subdecl, constructor, constructor, classMirror, isCeylon);
            subdecl.setOverloaded(true);
            overloads.add(subdecl);
            decls.add(subdecl);
            if (isCeylon || !this.isCoercedMethod(constructor)) continue;
            LazyClass subdecl2 = this.makeLazyClass(classMirror, supercls, constructor, false);
            subdecl2.setCoercionPoint(true);
            subdecl2.setRealClass(subdecl);
            this.setNonLazyDeclarationProperties(subdecl2, constructor, constructor, classMirror, isCeylon);
            subdecl2.setOverloaded(true);
            overloads.add(subdecl2);
            decls.add(subdecl2);
        }
        supercls.setOverloads(overloads);
        return supercls;
    }

    private void setNonLazyDeclarationProperties(Declaration decl, AccessibleMirror mirror, AnnotatedMirror annotatedMirror, ClassMirror classMirror, boolean isCeylon) {
        if (isCeylon) {
            decl.setShared(mirror.isPublic() || annotatedMirror.getAnnotation(CEYLON_LANGUAGE_SHARED_ANNOTATION) != null);
            AbstractModelLoader.setDeclarationAliases(decl, annotatedMirror);
        } else {
            decl.setShared(mirror.isPublic() || mirror.isDefaultAccess() && classMirror.isInnerClass() || mirror.isProtected());
            decl.setPackageVisibility(mirror.isDefaultAccess());
            decl.setProtectedVisibility(mirror.isProtected());
        }
        decl.setDeprecated(this.isDeprecated(annotatedMirror));
    }

    private JavaVisibility getJavaVisibility(AccessibleMirror mirror) {
        if (mirror.isPublic()) {
            return JavaVisibility.PUBLIC;
        }
        if (mirror.isProtected()) {
            return JavaVisibility.PROTECTED;
        }
        if (mirror.isDefaultAccess()) {
            return JavaVisibility.PACKAGE;
        }
        return JavaVisibility.PRIVATE;
    }

    protected Declaration makeClassAlias(ClassMirror classMirror) {
        LazyClassAlias decl = new LazyClassAlias(classMirror, this);
        decl.setStatic(classMirror.isStatic());
        return decl;
    }

    protected Declaration makeTypeAlias(ClassMirror classMirror) {
        LazyTypeAlias decl = new LazyTypeAlias(classMirror, this);
        decl.setStatic(classMirror.isStatic());
        return decl;
    }

    protected Declaration makeInterfaceAlias(ClassMirror classMirror) {
        LazyInterfaceAlias decl = new LazyInterfaceAlias(classMirror, this);
        decl.setStatic(classMirror.isStatic());
        return decl;
    }

    private void checkBinaryCompatibility(ClassMirror classMirror) {
        Integer minor;
        if (this.binaryCompatibilityErrorRaised) {
            return;
        }
        AnnotationMirror annotation = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION);
        if (annotation == null) {
            return;
        }
        Integer major = (Integer)annotation.getValue("major");
        if (major == null) {
            major = 0;
        }
        if ((minor = (Integer)annotation.getValue("minor")) == null) {
            minor = 0;
        }
        if (!Versions.isJvmBinaryVersionSupported(major, minor)) {
            this.logError("Ceylon class " + classMirror.getQualifiedName() + " was compiled by an incompatible version of the Ceylon compiler" + "\nThe class was compiled using " + major + "." + minor + "." + "\nThis compiler supports " + 8 + "." + 1 + "." + "\nPlease try to recompile your module using a compatible compiler." + "\nBinary compatibility will only be supported after Ceylon 1.2.");
            this.binaryCompatibilityErrorRaised = true;
        }
    }

    private void setHasJpaConstructor(LazyClass c, ClassMirror classMirror) {
        for (MethodMirror methodMirror : classMirror.getDirectMethods()) {
            if (!methodMirror.isConstructor() || methodMirror.getAnnotation(CEYLON_JPA_ANNOTATION) == null) continue;
            c.setHasJpaConstructor(true);
            break;
        }
    }

    private List<MethodMirror> getClassConstructors(ClassMirror instantiatedType, ClassMirror methodContainer, MethodMirrorFilter p) {
        LinkedList<MethodMirror> constructors = new LinkedList<MethodMirror>();
        boolean isFromJDK = this.isFromJDK(methodContainer);
        for (MethodMirror methodMirror : methodContainer.getDirectMethods()) {
            if (methodMirror.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null && methodMirror.getAnnotation(CEYLON_ENUMERATED_ANNOTATION) == null || !p.accept(methodMirror) || !methodMirror.getTypeParameters().isEmpty() || isFromJDK && !methodMirror.isPublic() && !methodMirror.isProtected()) continue;
            if (methodContainer.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null) {
                int tpCount;
                List<AnnotationMirror> tpAnnotations = this.getTypeParametersFromAnnotations(instantiatedType);
                int n = tpCount = tpAnnotations != null ? tpAnnotations.size() : instantiatedType.getTypeParameters().size();
                if (!this.checkReifiedTypeDescriptors(tpCount, instantiatedType.getQualifiedName(), methodMirror, true)) continue;
            }
            constructors.add(methodMirror);
        }
        return constructors;
    }

    private boolean checkReifiedTypeDescriptors(int tpCount, String containerName, MethodMirror methodMirror, boolean isConstructor) {
        List<VariableMirror> params = methodMirror.getParameters();
        int actualTypeDescriptorParameters = 0;
        for (VariableMirror param : params) {
            if (param.getAnnotation(CEYLON_IGNORE_ANNOTATION) == null || !this.sameType(CEYLON_TYPE_DESCRIPTOR_TYPE, param.getType())) break;
            ++actualTypeDescriptorParameters;
        }
        if (tpCount != actualTypeDescriptorParameters) {
            if (isConstructor) {
                this.logError("Constructor for '" + containerName + "' should take " + tpCount + " reified type arguments (TypeDescriptor) but has '" + actualTypeDescriptorParameters + "': skipping constructor.");
            } else {
                this.logError("Function '" + containerName + "." + methodMirror.getName() + "' should take " + tpCount + " reified type arguments (TypeDescriptor) but has '" + actualTypeDescriptorParameters + "': method is invalid.");
            }
            return false;
        }
        return true;
    }

    protected Unit getCompiledUnit(LazyPackage pkg, ClassMirror classMirror) {
        String key = this.getPackageCacheKey(pkg);
        Unit unit = this.unitsByPackage.get(key);
        if (unit == null) {
            unit = new Unit();
            unit.setPackage(pkg);
            this.unitsByPackage.put(key, unit);
        }
        return unit;
    }

    protected String getPackageCacheKey(LazyPackage pkg) {
        String key = pkg.getQualifiedNameString() + "/" + pkg.getModule().getVersion();
        return key;
    }

    protected LazyValue makeToplevelAttribute(ClassMirror classMirror, boolean isNativeHeader) {
        LazyValue value = new LazyValue(classMirror, this);
        AnnotationMirror objectAnnotation = classMirror.getAnnotation(CEYLON_OBJECT_ANNOTATION);
        if (objectAnnotation == null) {
            this.manageNativeBackend(value, classMirror, isNativeHeader);
        } else {
            this.manageNativeBackend(value, this.getGetterMethodMirror(value, value.classMirror, true), isNativeHeader);
        }
        return value;
    }

    protected LazyFunction makeToplevelMethod(ClassMirror classMirror, boolean isNativeHeader) {
        LazyFunction method = new LazyFunction(classMirror, this);
        this.manageNativeBackend(method, this.getFunctionMethodMirror(method), isNativeHeader);
        return method;
    }

    protected LazyClass makeLazyClass(ClassMirror classMirror, Class superClass, MethodMirror initOrDefaultConstructor, boolean isNativeHeader) {
        LazyClass klass = new LazyClass(classMirror, this, superClass, initOrDefaultConstructor);
        AnnotationMirror objectAnnotation = classMirror.getAnnotation(CEYLON_OBJECT_ANNOTATION);
        if (objectAnnotation != null) {
            klass.setAnonymous(true);
            if (BooleanUtil.isFalse((Boolean)objectAnnotation.getValue("named"))) {
                klass.setNamed(false);
            }
        }
        klass.setAnnotation(classMirror.getAnnotation(CEYLON_LANGUAGE_ANNOTATION_ANNOTATION) != null);
        if (klass.isCeylon()) {
            klass.setAbstract(classMirror.getAnnotation(CEYLON_LANGUAGE_ABSTRACT_ANNOTATION) != null || !classMirror.isInnerClass() && !classMirror.isLocalClass() && classMirror.isAbstract());
        } else {
            klass.setAbstract(classMirror.isAbstract());
        }
        klass.setFormal(classMirror.getAnnotation(CEYLON_LANGUAGE_FORMAL_ANNOTATION) != null);
        klass.setDefault(classMirror.getAnnotation(CEYLON_LANGUAGE_DEFAULT_ANNOTATION) != null);
        klass.setSerializable(classMirror.getAnnotation(CEYLON_LANGUAGE_SERIALIZABLE_ANNOTATION) != null || classMirror.getQualifiedName().equals("ceylon.language.Array") || classMirror.getQualifiedName().equals("ceylon.language.Tuple"));
        klass.setSealed(classMirror.getAnnotation(CEYLON_LANGUAGE_SEALED_ANNOTATION) != null || CEYLON_LANGUAGE.equals(classMirror.getPackage().getQualifiedName()) && "Throwable".equals(classMirror.getName()));
        boolean actual = classMirror.getAnnotation(CEYLON_LANGUAGE_ACTUAL_ANNOTATION) != null;
        klass.setActual(actual);
        klass.setActualCompleter(this);
        klass.setFinal(classMirror.isFinal());
        klass.setStatic(classMirror.isStatic());
        if (objectAnnotation == null) {
            this.manageNativeBackend(klass, classMirror, isNativeHeader);
        } else {
            this.manageNativeBackend(klass, this.getGetterMethodMirror(klass, klass.classMirror, true), isNativeHeader);
        }
        return klass;
    }

    protected LazyInterface makeLazyInterface(ClassMirror classMirror, boolean isNativeHeader) {
        LazyInterface iface = new LazyInterface(classMirror, this);
        iface.setSealed(classMirror.getAnnotation(CEYLON_LANGUAGE_SEALED_ANNOTATION) != null);
        iface.setDynamic(classMirror.getAnnotation(CEYLON_DYNAMIC_ANNOTATION) != null);
        if (iface.isCeylon()) {
            Object value;
            AnnotationMirror container = classMirror.getAnnotation(CEYLON_CONTAINER_ANNOTATION);
            if (container != null && (value = container.getValue("isStatic")) != null) {
                iface.setStatic(Boolean.TRUE.equals(value));
            }
        } else {
            iface.setStatic(classMirror.getEnclosingClass() != null);
        }
        this.manageNativeBackend(iface, classMirror, isNativeHeader);
        return iface;
    }

    @Nullable
    public Declaration convertToDeclaration(Module module, String typeName, ModelLoader.DeclarationType declarationType) {
        return this.convertToDeclaration(module, null, typeName, declarationType);
    }

    @Nullable
    private Declaration convertToDeclaration(final Module theModule, final Declaration theContainer, final String theTypeName, final ModelLoader.DeclarationType theDeclarationType) {
        return this.synchronizedCall(new Callable<Declaration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Declaration call() throws Exception {
                Module module = theModule;
                Declaration container = theContainer;
                String typeName = theTypeName;
                ModelLoader.DeclarationType declarationType = theDeclarationType;
                typeName = typeName.trim();
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                try {
                    ClassMirror classMirror;
                    if ("ceylon.language.Nothing".equals(typeName)) {
                        NothingType nothingType = AbstractModelLoader.this.typeFactory.getNothingDeclaration();
                        return nothingType;
                    }
                    if ("java.lang.Throwable".equals(typeName)) {
                        Declaration declaration = AbstractModelLoader.this.convertToDeclaration(AbstractModelLoader.this.modules.getLanguageModule(), "ceylon.language.Throwable", declarationType);
                        return declaration;
                    }
                    if ("java.lang.Exception".equals(typeName)) {
                        Declaration declaration = AbstractModelLoader.this.convertToDeclaration(AbstractModelLoader.this.modules.getLanguageModule(), "ceylon.language.Exception", declarationType);
                        return declaration;
                    }
                    if ("java.lang.annotation.Annotation".equals(typeName)) {
                        Declaration declaration = AbstractModelLoader.this.convertToDeclaration(AbstractModelLoader.this.modules.getLanguageModule(), "ceylon.language.Annotation", declarationType);
                        return declaration;
                    }
                    try {
                        classMirror = AbstractModelLoader.this.lookupClassMirror(module, typeName);
                    }
                    catch (NoClassDefFoundError x) {
                        TypeDeclaration typeDeclaration = AbstractModelLoader.this.logModelResolutionException(x.getMessage(), module, "Unable to load type " + typeName).getDeclaration();
                        AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                        return typeDeclaration;
                    }
                    if (classMirror == null) {
                        Declaration languageDeclaration;
                        if (AbstractModelLoader.this.isBootstrap && typeName.startsWith("ceylon.language.") && (languageDeclaration = AbstractModelLoader.this.findLanguageModuleDeclarationForBootstrap(typeName)) != null) {
                            Declaration declaration = languageDeclaration;
                            return declaration;
                        }
                        String modulePackagePrefix = module.getNameAsString() + ".";
                        if (AbstractModelLoader.this.hasJavaAndCeylonSources() && container == null && typeName.startsWith(modulePackagePrefix)) {
                            int lastDot = typeName.length();
                            LinkedList<String> qualified = null;
                            while ((lastDot = AbstractModelLoader.this.lastIndexOf(typeName, "$.", lastDot - 1)) != -1) {
                                String packagePart = typeName.substring(0, lastDot);
                                String namePart = typeName.substring(lastDot + 1);
                                int namePartDot = AbstractModelLoader.this.indexOf(namePart, "$.");
                                if (namePartDot != -1) {
                                    namePart = namePart.substring(0, namePartDot);
                                }
                                if (!packagePart.startsWith(modulePackagePrefix) && !packagePart.equals(module.getNameAsString())) break;
                                Package pkg = module.getPackage(packagePart);
                                if (pkg instanceof LazyPackage) {
                                    Declaration memberFromSource = ((LazyPackage)pkg).getDirectMemberFromSource(namePart, Backends.JAVA);
                                    if (memberFromSource == null) break;
                                    if (qualified != null) {
                                        String path;
                                        Iterator i$ = qualified.iterator();
                                        while (i$.hasNext() && (memberFromSource = memberFromSource.getDirectMember(path = (String)i$.next(), null, false)) != null) {
                                        }
                                    }
                                    Declaration declaration = memberFromSource;
                                    return declaration;
                                }
                                if (qualified == null) {
                                    qualified = new LinkedList<String>();
                                }
                                qualified.add(0, namePart);
                            }
                        }
                        throw new ModelResolutionException("Failed to resolve " + typeName);
                    }
                    if (classMirror.isLoadedFromSource() && !classMirror.isJavaSource()) {
                        Declaration declaration = null;
                        return declaration;
                    }
                    Declaration declaration = AbstractModelLoader.this.convertToDeclaration(module, container, classMirror, declarationType);
                    return declaration;
                }
                finally {
                    AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                }
            }
        });
    }

    private int indexOf(String string, String elements) {
        int smallerIndex = -1;
        for (int i = 0; i < elements.length(); ++i) {
            char sep = elements.charAt(i);
            int index = string.indexOf(sep);
            if (smallerIndex == -1) {
                smallerIndex = index;
                continue;
            }
            if (index == -1 || index >= smallerIndex) continue;
            smallerIndex = index;
        }
        return smallerIndex;
    }

    private int lastIndexOf(String string, String elements, int startFrom) {
        int largerIndex = -1;
        for (int i = 0; i < elements.length(); ++i) {
            char sep = elements.charAt(i);
            int index = string.lastIndexOf(sep, startFrom);
            if (largerIndex == -1) {
                largerIndex = index;
                continue;
            }
            if (index <= largerIndex) continue;
            largerIndex = index;
        }
        return largerIndex;
    }

    private Type newUnknownType() {
        return new UnknownType(this.typeFactory).getType();
    }

    protected TypeParameter safeLookupTypeParameter(Scope scope, String name) {
        TypeParameter param = this.lookupTypeParameter(scope, name);
        if (param == null) {
            throw new ModelResolutionException("Type param " + name + " not found in " + scope);
        }
        return param;
    }

    private TypeParameter lookupTypeParameter(Scope scope, String name) {
        if (scope instanceof Function) {
            Function m = (Function)scope;
            for (TypeParameter param : m.getTypeParameters()) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
            if (!m.isToplevel()) {
                return this.lookupTypeParameter(scope.getContainer(), name);
            }
            return null;
        }
        if (scope instanceof ClassOrInterface || scope instanceof TypeAlias) {
            TypeDeclaration decl = (TypeDeclaration)scope;
            for (TypeParameter param : decl.getTypeParameters()) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
            if (!decl.isToplevel()) {
                return this.lookupTypeParameter(scope.getContainer(), name);
            }
            return null;
        }
        if (scope instanceof Constructor) {
            return this.lookupTypeParameter(scope.getContainer(), name);
        }
        if (scope instanceof Value || scope instanceof Setter) {
            Declaration decl = (Declaration)((Object)scope);
            if (!decl.isToplevel()) {
                return this.lookupTypeParameter(scope.getContainer(), name);
            }
            return null;
        }
        throw new ModelResolutionException("Type param " + name + " lookup not supported for scope " + scope);
    }

    public LazyPackage findExistingPackage(final Module theModule, final String thePkgName) {
        return this.synchronizedCall(new Callable<LazyPackage>(){

            @Override
            public LazyPackage call() throws Exception {
                Module module = theModule;
                String pkgName = thePkgName;
                String quotedPkgName = JVMModuleUtil.quoteJavaKeywords(pkgName);
                LazyPackage pkg = AbstractModelLoader.this.findCachedPackage(module, quotedPkgName);
                if (pkg != null) {
                    return AbstractModelLoader.this.loadPackage(pkg);
                }
                String moduleName = module.getNameAsString();
                if (AbstractModelLoader.this.jdkProvider.isJDKModule(moduleName)) {
                    if (AbstractModelLoader.this.jdkProvider.isJDKPackage(moduleName, pkgName)) {
                        return AbstractModelLoader.this.findOrCreatePackage(module, pkgName);
                    }
                    return null;
                }
                if (((LazyModule)module).containsPackage(pkgName) && AbstractModelLoader.this.loadPackage(module, pkgName, false)) {
                    return AbstractModelLoader.this.findOrCreatePackage(module, pkgName);
                }
                return null;
            }
        });
    }

    public LazyPackage loadPackage(LazyPackage pkg) {
        if (!pkg.isDescriptorLoaded() && this.packageDescriptorsNeedLoading) {
            this.loadPackageDescriptor(pkg);
        }
        return pkg;
    }

    private LazyPackage findCachedPackage(Module module, String quotedPkgName) {
        LazyPackage pkg = this.packagesByName.get(this.cacheKeyByModule(module, quotedPkgName));
        if (pkg != null) {
            if (module != null && pkg.getModule() != null && !module.equals(pkg.getModule())) {
                return null;
            }
            return pkg;
        }
        return null;
    }

    public LazyPackage findOrCreatePackage(final Module module, final String pkgName) {
        return this.synchronizedCall(new Callable<LazyPackage>(){

            @Override
            public LazyPackage call() throws Exception {
                boolean isNew;
                String quotedPkgName = JVMModuleUtil.quoteJavaKeywords(pkgName);
                LazyPackage pkg = AbstractModelLoader.this.findCachedPackage(module, quotedPkgName);
                if (pkg != null) {
                    return AbstractModelLoader.this.loadPackage(pkg);
                }
                if (module instanceof LazyModule) {
                    pkg = (LazyPackage)((LazyModule)module).findPackageNoLazyLoading(pkgName);
                } else if (module != null) {
                    pkg = (LazyPackage)module.getDirectPackage(pkgName);
                }
                boolean bl = isNew = pkg == null;
                if (pkg == null) {
                    pkg = new LazyPackage(AbstractModelLoader.this);
                    pkg.setName(Arrays.asList(pkgName.split("\\.")));
                }
                AbstractModelLoader.this.packagesByName.put(AbstractModelLoader.this.cacheKeyByModule(module, quotedPkgName), pkg);
                if (isNew && module != null) {
                    pkg.setModule(module);
                    if (module instanceof LazyModule) {
                        ((LazyModule)module).addPackage(pkg);
                    } else {
                        module.getPackages().add(pkg);
                    }
                }
                if (AbstractModelLoader.this.packageDescriptorsNeedLoading) {
                    AbstractModelLoader.this.loadPackageDescriptor(pkg);
                }
                return pkg;
            }
        });
    }

    public void loadPackageDescriptors() {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                for (LazyPackage pkg : AbstractModelLoader.this.packagesByName.values()) {
                    AbstractModelLoader.this.loadPackageDescriptor(pkg);
                }
                AbstractModelLoader.this.packageDescriptorsNeedLoading = true;
            }
        });
    }

    private void loadPackageDescriptor(LazyPackage pkg) {
        if (!pkg.getModule().isAvailable()) {
            this.lazyLoadModule(pkg.getModule());
        }
        pkg.setDescriptorLoaded(true);
        if (this.isBootstrap && pkg.getQualifiedNameString().startsWith(CEYLON_LANGUAGE)) {
            return;
        }
        if (pkg.getModule() != null && ((LazyModule)pkg.getModule()).isJava()) {
            pkg.setShared(((LazyModule)pkg.getModule()).isExportedJavaPackage(pkg.getNameAsString()));
            return;
        }
        String quotedQualifiedName = JVMModuleUtil.quoteJavaKeywords(pkg.getQualifiedNameString());
        String className = quotedQualifiedName.isEmpty() ? "$package_" : quotedQualifiedName + "." + "$package_";
        this.logVerbose("[Trying to look up package from " + className + "]");
        Module module = pkg.getModule();
        if (module == null) {
            throw new RuntimeException("Assertion failed: module is null for package " + pkg.getNameAsString());
        }
        ClassMirror packageClass = this.loadClass(module, quotedQualifiedName, className);
        if (packageClass == null) {
            this.logVerbose("[Failed to complete " + className + "]");
            return;
        }
        if (packageClass.isLoadedFromSource()) {
            this.logVerbose("[We are compiling the package " + className + "]");
            return;
        }
        this.loadCompiledPackage(packageClass, pkg);
    }

    public void lazyLoadModule(Module module) {
    }

    private void loadCompiledPackage(ClassMirror packageClass, Package pkg) {
        String name = this.getAnnotationStringValue(packageClass, CEYLON_PACKAGE_ANNOTATION, "name");
        Boolean shared = this.getAnnotationBooleanValue(packageClass, CEYLON_PACKAGE_ANNOTATION, "shared");
        if (name == null || name.isEmpty()) {
            this.logWarning("Package class " + pkg.getQualifiedNameString() + " contains no name, ignoring it");
            return;
        }
        if (shared == null) {
            this.logWarning("Package class " + pkg.getQualifiedNameString() + " contains no shared, ignoring it");
            return;
        }
        pkg.setShared(shared);
    }

    public Module lookupModuleByPackageName(String packageName) {
        for (Module module : this.modules.getListOfModules()) {
            if (module.isDefaultModule() || !ModelUtil.equalModules(module, this.getLanguageModule()) && !this.isModuleInClassPath(module) || !(module instanceof LazyModule ? ((LazyModule)module).containsPackage(packageName) : this.isSubPackage(module.getNameAsString(), packageName))) continue;
            return module;
        }
        if (this.jdkProvider.isJDKPackage(packageName)) {
            String moduleName = this.jdkProvider.getJDKModuleNameForPackage(packageName);
            return this.findModule(moduleName, this.jdkProvider.getJDKVersion());
        }
        if (packageName.startsWith("com.redhat.ceylon.compiler.java.runtime") || packageName.startsWith("com.redhat.ceylon.compiler.java.language") || packageName.startsWith("com.redhat.ceylon.compiler.java.metadata")) {
            return this.getLanguageModule();
        }
        return this.modules.getDefaultModule();
    }

    private boolean isSubPackage(String moduleName, String pkgName) {
        return pkgName.equals(moduleName) || pkgName.startsWith(moduleName + ".");
    }

    protected Module findOrCreateModule(final String theModuleName, final String theVersion) {
        return this.synchronizedCall(new Callable<Module>(){

            @Override
            public Module call() throws Exception {
                String moduleName = theModuleName;
                String version2 = theVersion;
                boolean isJdk = false;
                Module module = AbstractModelLoader.this.getLoadedModule(moduleName, version2);
                if (module != null) {
                    return module;
                }
                if (AbstractModelLoader.this.jdkProvider != null && AbstractModelLoader.this.jdkProvider.isJDKModule(moduleName)) {
                    isJdk = true;
                }
                List<String> moduleNameList = Arrays.asList(moduleName.split("\\."));
                module = AbstractModelLoader.this.moduleManager.getOrCreateModule(moduleNameList, version2);
                if (moduleName.equals(AbstractModelLoader.CEYLON_LANGUAGE) && AbstractModelLoader.this.modules.getLanguageModule() == null) {
                    AbstractModelLoader.this.modules.setLanguageModule(module);
                }
                if (isJdk && module instanceof LazyModule) {
                    ((LazyModule)module).setJava(true);
                    module.setNativeBackends(Backend.Java.asSet());
                }
                if (isJdk) {
                    module.setAvailable(true);
                }
                return module;
            }
        });
    }

    public boolean loadCompiledModule(Module module) {
        return this.loadCompiledModule(module, true);
    }

    public boolean loadCompiledModule(final Module theModule, final boolean theLoadModuleImports) {
        return this.synchronizedCall(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Module module = theModule;
                boolean loadModuleImports = theLoadModuleImports;
                if (module.isDefaultModule()) {
                    return false;
                }
                String pkgName = module.getNameAsString();
                if (pkgName.isEmpty()) {
                    return false;
                }
                ClassMirror moduleClass = AbstractModelLoader.this.findModuleClass(module, pkgName);
                if (moduleClass != null) {
                    return AbstractModelLoader.this.loadCompiledModule(module, moduleClass, loadModuleImports);
                }
                return false;
            }
        });
    }

    protected ClassMirror findModuleClass(Module module, String pkgName) {
        String moduleClassName = pkgName + "." + "$module_";
        this.logVerbose("[Trying to look up module from " + moduleClassName + "]");
        ClassMirror moduleClass = this.loadClass(module, pkgName, moduleClassName);
        if (moduleClass == null) {
            String oldModuleClassName = pkgName + "." + "module_";
            this.logVerbose("[Trying to look up older module descriptor from " + oldModuleClassName + "]");
            ClassMirror oldModuleClass = this.loadClass(module, pkgName, oldModuleClassName);
            if (oldModuleClass != null && oldModuleClass.getAnnotation(CEYLON_MODULE_ANNOTATION) != null) {
                moduleClass = oldModuleClass;
            }
        }
        return moduleClass;
    }

    private boolean loadCompiledModule(Module module, ClassMirror moduleClass, boolean loadModuleImports) {
        List imports;
        String moduleClassName = moduleClass.getQualifiedName();
        String name = this.getAnnotationStringValue(moduleClass, CEYLON_MODULE_ANNOTATION, "name");
        String version2 = this.getAnnotationStringValue(moduleClass, CEYLON_MODULE_ANNOTATION, "version");
        if (name == null || name.isEmpty()) {
            this.logWarning("Module class " + moduleClassName + " contains no name, ignoring it");
            return false;
        }
        if (!name.equals(module.getNameAsString())) {
            this.logWarning("Module class " + moduleClassName + " declares an invalid name: " + name + ". It should be: " + module.getNameAsString());
            return false;
        }
        if (version2 == null || version2.isEmpty()) {
            this.logWarning("Module class " + moduleClassName + " contains no version, ignoring it");
            return false;
        }
        if (!version2.equals(module.getVersion())) {
            this.logWarning("Module class " + moduleClassName + " declares an invalid version: " + version2 + ". It should be: " + module.getVersion());
            return false;
        }
        int major = this.getAnnotationIntegerValue(moduleClass, CEYLON_CEYLON_ANNOTATION, "major", 0);
        int minor = this.getAnnotationIntegerValue(moduleClass, CEYLON_CEYLON_ANNOTATION, "minor", 0);
        module.setJvmMajor(major);
        module.setJvmMinor(minor);
        this.setAnnotations(module, moduleClass, false);
        if (loadModuleImports && (imports = this.getAnnotationArrayValue(moduleClass, CEYLON_MODULE_ANNOTATION, "dependencies")) != null) {
            boolean supportsNamespaces = ModuleUtil.supportsImportsWithNamespaces(major, minor);
            for (AnnotationMirror importAttribute : imports) {
                Backends backends;
                String namespace;
                String dependencyName = (String)importAttribute.getValue("name");
                if (dependencyName == null) continue;
                if (supportsNamespaces) {
                    namespace = (String)importAttribute.getValue("namespace");
                    if (namespace != null && namespace.isEmpty()) {
                        namespace = null;
                    }
                } else {
                    namespace = ModuleUtil.isMavenModule(dependencyName) ? "maven" : null;
                }
                String dependencyVersion = (String)importAttribute.getValue("version");
                Module dependency = this.moduleManager.getOrCreateModule(ModuleManager.splitModuleName(dependencyName), dependencyVersion);
                Boolean optionalVal = (Boolean)importAttribute.getValue("optional");
                Boolean exportVal = (Boolean)importAttribute.getValue("export");
                List nativeBackends = (List)importAttribute.getValue("nativeBackends");
                Backends backends2 = backends = nativeBackends == null ? Backends.ANY : Backends.fromAnnotations(nativeBackends);
                ModuleImport moduleImport = this.moduleManager.findImport(module, dependency);
                if (moduleImport != null) continue;
                boolean optional = optionalVal != null && optionalVal != false;
                boolean export = exportVal != null && exportVal != false;
                moduleImport = new ModuleImport(namespace, dependency, optional, export, backends);
                module.addImport(moduleImport);
            }
        }
        module.setAvailable(true);
        this.modules.getListOfModules().add(module);
        Module languageModule = this.modules.getLanguageModule();
        module.setLanguageModule(languageModule);
        if (loadModuleImports && !ModelUtil.equalModules(module, languageModule)) {
            boolean found = false;
            for (ModuleImport mi : module.getImports()) {
                if (!mi.getModule().isLanguageModule()) continue;
                found = true;
                break;
            }
            if (!found) {
                LazyModule oldLangMod = new LazyModule(){

                    @Override
                    protected AbstractModelLoader getModelLoader() {
                        return AbstractModelLoader.this;
                    }
                };
                oldLangMod.setLanguageModule(oldLangMod);
                oldLangMod.setName(Arrays.asList("ceylon", "language"));
                oldLangMod.setVersion(Versions.getJvmLanguageModuleVersion(major, minor));
                oldLangMod.setNativeBackends(Backends.JAVA);
                oldLangMod.setJvmMajor(major);
                oldLangMod.setJvmMinor(minor);
                ModuleImport moduleImport = new ModuleImport(null, oldLangMod, false, false);
                module.addImport(moduleImport);
            }
        }
        return true;
    }

    private <T> List<T> getAnnotationArrayValue(AnnotatedMirror mirror, String type, String field) {
        return (List)this.getAnnotationValue(mirror, type, field);
    }

    private <T> List<T> getAnnotationArrayValue(AnnotatedMirror mirror, String type) {
        return (List)this.getAnnotationValue(mirror, type);
    }

    private String getAnnotationStringValue(AnnotatedMirror mirror, String type) {
        return this.getAnnotationStringValue(mirror, type, "value");
    }

    protected String getAnnotationStringValue(AnnotatedMirror mirror, String type, String field) {
        return (String)this.getAnnotationValue(mirror, type, field);
    }

    private Boolean getAnnotationBooleanValue(AnnotatedMirror mirror, String type, String field) {
        return (Boolean)this.getAnnotationValue(mirror, type, field);
    }

    private int getAnnotationIntegerValue(AnnotatedMirror mirror, String type, String field, int defaultValue) {
        Integer val = (Integer)this.getAnnotationValue(mirror, type, field);
        return val != null ? val : defaultValue;
    }

    private List<String> getAnnotationStringValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private Object getAnnotationValue(AnnotatedMirror mirror, String type) {
        return this.getAnnotationValue(mirror, type, "value");
    }

    private Object getAnnotationValue(AnnotatedMirror mirror, String type, String fieldName) {
        AnnotationMirror annotation = mirror.getAnnotation(type);
        if (annotation != null) {
            return annotation.getValue(fieldName);
        }
        return null;
    }

    @Override
    public void complete(final AnnotationProxyClass klass) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.complete(klass, klass.iface);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final AnnotationProxyMethod ctor) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AnnotationProxyClass klass = ctor.proxyClass;
                LazyInterface iface = klass.iface;
                AbstractModelLoader.this.complete(ctor, klass, iface);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final LazyInterface iface) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.complete(iface, iface.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void completeTypeParameters(final LazyInterface iface) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeTypeParameters(iface, iface.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final LazyClass klass) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.complete(klass, klass.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void completeTypeParameters(final LazyClass klass) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeTypeParameters(klass, klass.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void completeTypeParameters(final LazyClassAlias lazyClassAlias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAliasTypeParameters(lazyClassAlias, lazyClassAlias.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void completeTypeParameters(final LazyInterfaceAlias lazyInterfaceAlias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAliasTypeParameters(lazyInterfaceAlias, lazyInterfaceAlias.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void completeTypeParameters(final LazyTypeAlias lazyTypeAlias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAliasTypeParameters(lazyTypeAlias, lazyTypeAlias.classMirror);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final LazyInterfaceAlias alias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAlias(alias, alias.classMirror, AbstractModelLoader.CEYLON_ALIAS_ANNOTATION);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final LazyClassAlias alias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAlias(alias, alias.classMirror, AbstractModelLoader.CEYLON_ALIAS_ANNOTATION);
                String constructorName = (String)alias.classMirror.getAnnotation(AbstractModelLoader.CEYLON_ALIAS_ANNOTATION).getValue("constructor");
                TypeDeclaration extendedTypeDeclaration = alias.getExtendedType().getDeclaration();
                if (constructorName != null && !constructorName.isEmpty()) {
                    Declaration constructor = alias.getExtendedType().getDeclaration().getMember(constructorName, null, false);
                    if (constructor instanceof FunctionOrValue && ((FunctionOrValue)constructor).getTypeDeclaration() instanceof Constructor) {
                        alias.setConstructor(((FunctionOrValue)constructor).getTypeDeclaration());
                    } else {
                        AbstractModelLoader.this.logError("class aliased constructor " + constructorName + " which is no longer a constructor of " + alias.getExtendedType().getDeclaration().getQualifiedNameString());
                    }
                } else if (extendedTypeDeclaration instanceof Class) {
                    Class theClass = (Class)extendedTypeDeclaration;
                    if (theClass.hasConstructors()) {
                        alias.setConstructor(theClass.getDefaultConstructor());
                    } else if (theClass.getParameterList() != null) {
                        alias.setConstructor(theClass);
                    }
                }
                MethodMirror instantiator = null;
                ClassMirror instantiatorClass = alias.isToplevel() ? alias.classMirror : alias.classMirror.getEnclosingClass();
                String aliasName = NamingBase.getAliasInstantiatorMethodName(alias);
                for (MethodMirror method : instantiatorClass.getDirectMethods()) {
                    if (!method.getName().equals(aliasName)) continue;
                    instantiator = method;
                    break;
                }
                if (instantiator != null) {
                    AbstractModelLoader.this.setParameters(alias, alias.classMirror, instantiator, true, alias, false);
                }
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    @Override
    public void complete(final LazyTypeAlias alias) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                AbstractModelLoader.this.completeLazyAlias(alias, alias.classMirror, AbstractModelLoader.CEYLON_TYPE_ALIAS_ANNOTATION);
                AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
            }
        });
    }

    private void complete(AnnotationProxyMethod ctor, AnnotationProxyClass klass, LazyInterface iface) {
        ParameterList ctorpl = new ParameterList();
        ctorpl.setPositionalParametersSupported(false);
        ctor.addParameterList(ctorpl);
        ArrayList<Parameter> ctorParams = new ArrayList<Parameter>();
        for (Declaration member : iface.getMembers()) {
            boolean isValue = member.getName().equals("value");
            if (!(member instanceof JavaMethod)) continue;
            JavaMethod m = (JavaMethod)member;
            Parameter ctorParam = new Parameter();
            ctorParams.add(ctorParam);
            Value value = new Value();
            ctorParam.setModel(value);
            value.setInitializerParameter(ctorParam);
            ctorParam.setDeclaration(ctor);
            value.setContainer(klass);
            value.setScope(klass);
            ctorParam.setDefaulted(m.isDefaultedAnnotation());
            value.setName(member.getName());
            ctorParam.setName(member.getName());
            value.setType(this.annotationParameterType(iface.getUnit(), m));
            value.setUnboxed(true);
            value.setUnit(iface.getUnit());
            if (isValue) {
                ctorpl.getParameters().add(0, ctorParam);
            } else {
                ctorpl.getParameters().add(ctorParam);
            }
            ctor.addMember(value);
        }
        this.makeInteropAnnotationConstructorInvocation(ctor, klass, ctorParams);
    }

    private void complete(AnnotationProxyClass klass, LazyInterface iface) {
        ParameterList classpl = new ParameterList();
        klass.addParameterList(classpl);
        for (Declaration member : iface.getMembers()) {
            boolean isValue = member.getName().equals("value");
            if (!(member instanceof JavaMethod)) continue;
            JavaMethod m = (JavaMethod)member;
            Parameter klassParam = new Parameter();
            Value value = new Value();
            klassParam.setModel(value);
            value.setInitializerParameter(klassParam);
            klassParam.setDeclaration(klass);
            value.setContainer(klass);
            value.setScope(klass);
            value.setName(member.getName());
            klassParam.setName(member.getName());
            value.setType(this.annotationParameterType(iface.getUnit(), m));
            value.setUnboxed(true);
            value.setUnit(iface.getUnit());
            if (isValue) {
                classpl.getParameters().add(0, klassParam);
            } else {
                classpl.getParameters().add(klassParam);
            }
            klass.addMember(value);
        }
    }

    private void completeLazyAliasTypeParameters(TypeDeclaration alias, ClassMirror mirror) {
        this.setTypeParameters(alias, mirror, true);
    }

    private void completeLazyAlias(TypeDeclaration alias, ClassMirror mirror, String aliasAnnotationName) {
        AnnotationMirror aliasAnnotation = mirror.getAnnotation(aliasAnnotationName);
        String extendedTypeString = (String)aliasAnnotation.getValue();
        Type extendedType = this.decodeType(extendedTypeString, alias, ModelUtil.getModuleContainer(alias), "alias target");
        alias.setExtendedType(extendedType);
    }

    private void completeTypeParameters(ClassOrInterface klass, ClassMirror classMirror) {
        boolean isCeylon = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null;
        this.setTypeParameters(klass, classMirror, isCeylon);
    }

    /*
     * WARNING - void declaration
     */
    private void complete(ClassOrInterface klass, ClassMirror classMirror) {
        Declaration declaration;
        Declaration declaration2;
        Value hdr;
        Value decl;
        Declaration decl2;
        Boolean hasConstructors;
        boolean isFromJDK = this.isFromJDK(classMirror);
        boolean isCeylon = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null;
        boolean isNativeHeaderMember = klass.isNativeHeader();
        if (!(klass instanceof Class) || !((Class)klass).isOverloaded()) {
            this.addInnerClasses(klass, classMirror);
        }
        MethodMirror constructor = null;
        if (klass instanceof LazyClass) {
            constructor = ((LazyClass)klass).getConstructor();
            this.setHasJpaConstructor((LazyClass)klass, classMirror);
        }
        if ((hasConstructors = this.hasConstructors(classMirror)) != null && hasConstructors.booleanValue()) {
            HashMap<String, MethodMirror> m = new HashMap<String, MethodMirror>();
            for (MethodMirror ctorMirror : this.getClassConstructors(classMirror, classMirror, this.constructorOnly)) {
                m.put(this.getCtorName(ctorMirror), ctorMirror);
            }
            for (MethodMirror ctor : this.getClassConstructors(classMirror, classMirror.getEnclosingClass() != null ? classMirror.getEnclosingClass() : classMirror, new ValueConstructorGetter(classMirror))) {
                Object name = this.getAnnotationValue(ctor, CEYLON_NAME_ANNOTATION);
                MethodMirror ctorMirror = (MethodMirror)m.remove(name);
                Constructor c = ctorMirror == null ? this.addConstructor((Class)klass, classMirror, ctor, isNativeHeaderMember) : this.addConstructor((Class)klass, classMirror, ctorMirror, isNativeHeaderMember);
                FunctionOrValue fov = this.addConstructorMethorOrValue((Class)klass, classMirror, ctor, c, isNativeHeaderMember);
                if (isCeylon && this.shouldCreateNativeHeader(c, klass)) {
                    Constructor hdr2;
                    if (ctorMirror == null) {
                        Constructor hdr22 = this.addConstructor((Class)klass, classMirror, ctor, true);
                    } else {
                        hdr2 = this.addConstructor((Class)klass, classMirror, ctorMirror, true);
                    }
                    FunctionOrValue hdrfov = this.addConstructorMethorOrValue((Class)klass, classMirror, ctorMirror, hdr2, true);
                    this.initNativeHeader(hdr2, c);
                    this.initNativeHeader(hdrfov, fov);
                    continue;
                }
                if (!isCeylon || !this.shouldLinkNatives(c)) continue;
                this.initNativeHeaderMember(c);
                this.initNativeHeaderMember(fov);
            }
            for (MethodMirror ctorMirror : m.values()) {
                Constructor c = this.addConstructor((Class)klass, classMirror, ctorMirror, isNativeHeaderMember);
                FunctionOrValue fov = this.addConstructorMethorOrValue((Class)klass, classMirror, ctorMirror, c, isNativeHeaderMember);
                if (isCeylon && this.shouldCreateNativeHeader(c, klass)) {
                    Constructor hdr3 = this.addConstructor((Class)klass, classMirror, ctorMirror, true);
                    FunctionOrValue hdrfov = this.addConstructorMethorOrValue((Class)klass, classMirror, ctorMirror, hdr3, true);
                    this.initNativeHeader(hdr3, c);
                    this.initNativeHeader(hdrfov, fov);
                    continue;
                }
                if (!isCeylon || !this.shouldLinkNatives(c)) continue;
                this.initNativeHeaderMember(c);
                this.initNativeHeaderMember(fov);
            }
        }
        LinkedHashMap<String, List<MethodMirror>> methods = new LinkedHashMap<String, List<MethodMirror>>();
        this.collectMethods(classMirror.getDirectMethods(), methods, isCeylon, isFromJDK);
        if (isCeylon && klass instanceof LazyInterface && JvmBackendUtil.isCompanionClassNeeded(klass)) {
            ClassMirror companionClass = ((LazyInterface)klass).companionClass;
            if (companionClass != null) {
                this.collectMethods(companionClass.getDirectMethods(), methods, isCeylon, isFromJDK);
            } else {
                this.logWarning("CompanionClass missing for " + klass);
            }
        }
        boolean seenStringAttribute = false;
        boolean seenHashAttribute = false;
        boolean seenStringGetter = false;
        boolean seenHashGetter = false;
        MethodMirror stringSetter = null;
        MethodMirror hashSetter = null;
        HashMap getters = new HashMap();
        HashMap setters = new HashMap();
        for (List list : methods.values()) {
            MethodMirror methodMirror;
            Iterator i$ = list.iterator();
            while (i$.hasNext() && !(methodMirror = (MethodMirror)i$.next()).isConstructor() && !this.isInstantiator(methodMirror)) {
                String name;
                if (this.isGetter(methodMirror)) {
                    name = this.getJavaAttributeName(methodMirror);
                    this.putMultiMap(getters, name, methodMirror);
                    continue;
                }
                if (this.isSetter(methodMirror)) {
                    name = this.getJavaAttributeName(methodMirror);
                    this.putMultiMap(setters, name, methodMirror);
                    continue;
                }
                if (this.isHashAttribute(methodMirror)) {
                    this.putMultiMap(getters, "hash", methodMirror);
                    seenHashAttribute = true;
                    continue;
                }
                if (this.isStringAttribute(methodMirror)) {
                    this.putMultiMap(getters, "string", methodMirror);
                    seenStringAttribute = true;
                    continue;
                }
                if (this.isStringGetter(methodMirror)) {
                    seenStringGetter = true;
                    continue;
                }
                if (this.isHashGetter(methodMirror)) {
                    seenHashGetter = true;
                    continue;
                }
                if (this.isStringSetter(methodMirror)) {
                    stringSetter = methodMirror;
                    continue;
                }
                if (!this.isHashSetter(methodMirror)) continue;
                hashSetter = methodMirror;
            }
        }
        block8: for (Map.Entry entry : getters.entrySet()) {
            String propertyName = (String)entry.getKey();
            List getterList = (List)entry.getValue();
            for (MethodMirror getterMethod : getterList) {
                if (this.isHashAttribute(getterMethod)) {
                    JavaBeanValue decl22 = this.addValue(klass, getterMethod, "hash", isCeylon, isNativeHeaderMember);
                    if (isCeylon && this.shouldCreateNativeHeader(decl22, klass)) {
                        JavaBeanValue hdr5 = this.addValue(klass, getterMethod, "hash", true, true);
                        this.setNonLazyDeclarationProperties(hdr5, classMirror, classMirror, classMirror, true);
                        this.initNativeHeader(hdr5, decl22);
                    } else if (isCeylon && this.shouldLinkNatives(decl22)) {
                        this.initNativeHeaderMember(decl22);
                    }
                    this.removeMultiMap(methods, getterMethod.getName(), getterMethod);
                    continue block8;
                }
                if (!this.isStringAttribute(getterMethod)) continue;
                decl2 = this.addValue(klass, getterMethod, "string", isCeylon, isNativeHeaderMember);
                if (isCeylon && this.shouldCreateNativeHeader(decl2, klass)) {
                    JavaBeanValue hdr6 = this.addValue(klass, getterMethod, "string", true, true);
                    this.setNonLazyDeclarationProperties(hdr6, classMirror, classMirror, classMirror, true);
                    this.initNativeHeader(hdr6, decl2);
                } else if (isCeylon && this.shouldLinkNatives(decl2)) {
                    this.initNativeHeaderMember(decl2);
                }
                this.removeMultiMap(methods, getterMethod.getName(), getterMethod);
                continue block8;
            }
            if (getterList.size() == 1) {
                MethodMirror getterMethod = (MethodMirror)getterList.get(0);
                decl = this.addValue(klass, getterMethod, propertyName, isCeylon, isNativeHeaderMember);
                if (isCeylon && this.shouldCreateNativeHeader(decl, klass)) {
                    hdr = this.addValue(klass, getterMethod, propertyName, true, true);
                    this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                    this.initNativeHeader(hdr, decl);
                } else if (isCeylon && this.shouldLinkNatives(decl)) {
                    this.initNativeHeaderMember(decl);
                }
                this.removeMultiMap(methods, getterMethod.getName(), getterMethod);
                continue;
            }
            List matchingSetters = (List)setters.get(propertyName);
            if (matchingSetters != null && matchingSetters.size() == 1) {
                MethodMirror matchingSetter = (MethodMirror)matchingSetters.get(0);
                MethodMirror bestGetter = null;
                boolean booleanSetter = matchingSetter.getParameters().get(0).getType().getKind() == TypeKind.BOOLEAN;
                for (MethodMirror getterMethod : getterList) {
                    if (!this.propertiesMatch(klass, getterMethod, matchingSetter)) continue;
                    if (bestGetter == null) {
                        bestGetter = getterMethod;
                        continue;
                    }
                    if (booleanSetter) {
                        if (!getterMethod.getName().startsWith("is")) break;
                        bestGetter = getterMethod;
                        break;
                    }
                    if (!getterMethod.getName().startsWith("get")) break;
                    bestGetter = getterMethod;
                    break;
                }
                if (bestGetter != null) {
                    JavaBeanValue decl3 = this.addValue(klass, bestGetter, propertyName, isCeylon, isNativeHeaderMember);
                    if (isCeylon && this.shouldCreateNativeHeader(decl3, klass)) {
                        JavaBeanValue hdr3 = this.addValue(klass, bestGetter, propertyName, true, true);
                        this.setNonLazyDeclarationProperties(hdr3, classMirror, classMirror, classMirror, true);
                        this.initNativeHeader(hdr3, decl3);
                    } else if (isCeylon && this.shouldLinkNatives(decl3)) {
                        this.initNativeHeaderMember(decl3);
                    }
                    this.removeMultiMap(methods, bestGetter.getName(), bestGetter);
                    continue;
                }
            }
            if (getterList.size() != 2) continue;
            MethodMirror isMethod = null;
            MethodMirror getMethod = null;
            for (MethodMirror getterMethod : getterList) {
                if (getterMethod.getName().startsWith("is")) {
                    isMethod = getterMethod;
                    continue;
                }
                if (!getterMethod.getName().startsWith("get")) continue;
                getMethod = getterMethod;
            }
            if (isMethod == null || getMethod == null) continue;
            MethodMirror bestGetter = getMethod.getReturnType().getKind() == TypeKind.BOOLEAN ? isMethod : getMethod;
            JavaBeanValue decl3 = this.addValue(klass, bestGetter, propertyName, isCeylon, isNativeHeaderMember);
            if (isCeylon && this.shouldCreateNativeHeader(decl3, klass)) {
                JavaBeanValue hdr4 = this.addValue(klass, bestGetter, propertyName, true, true);
                this.setNonLazyDeclarationProperties(hdr4, classMirror, classMirror, classMirror, true);
                this.initNativeHeader(hdr4, decl3);
            } else if (isCeylon && this.shouldLinkNatives(decl3)) {
                this.initNativeHeaderMember(decl3);
            }
            this.removeMultiMap(methods, bestGetter.getName(), bestGetter);
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (FieldMirror fieldMirror : classMirror.getDirectFields()) {
            if (!this.keepField(fieldMirror, isCeylon, isFromJDK)) continue;
            fieldNames.add(fieldMirror.getName());
        }
        for (FieldMirror fieldMirror : classMirror.getDirectFields()) {
            boolean conflicts;
            String newName;
            if (!this.keepField(fieldMirror, isCeylon, isFromJDK)) continue;
            String name = fieldMirror.getName();
            if (!(isCeylon || JvmBackendUtil.isInitialLowerCase(name) || fieldNames.contains(newName = NamingBase.getJavaBeanName(name)) || this.addingFieldWouldConflictWithMember(klass, newName) || methods.containsKey(newName))) {
                name = newName;
            }
            if (conflicts = this.addingFieldWouldConflictWithMember(klass, name)) continue;
            decl = this.addValue(klass, name, fieldMirror, isCeylon, isNativeHeaderMember);
            if (isCeylon && this.shouldCreateNativeHeader(decl, klass)) {
                hdr = this.addValue(klass, name, fieldMirror, true, true);
                this.setNonLazyDeclarationProperties(hdr, classMirror, classMirror, classMirror, true);
                this.initNativeHeader(hdr, decl);
                continue;
            }
            if (!isCeylon || !this.shouldLinkNatives(decl)) continue;
            this.initNativeHeaderMember(decl);
        }
        for (List variables : setters.values()) {
            for (MethodMirror setter : variables) {
                String name = this.getJavaAttributeName(setter);
                decl2 = klass.getMember(name = JvmBackendUtil.strip(name, isCeylon, setter.isPublic()), null, false);
                if (!(decl2 instanceof JavaBeanValue)) continue;
                Declaration value = decl2;
                if (setter.isPublic() && ((JavaBeanValue)value).mirror.isPublic() || setter.isProtected() && ((JavaBeanValue)value).mirror.isProtected() || setter.isDefaultAccess() && ((JavaBeanValue)value).mirror.isDefaultAccess() || !setter.isPublic() && !((JavaBeanValue)value).mirror.isPublic() && !setter.isProtected() && !((JavaBeanValue)value).mirror.isProtected() && !setter.isDefaultAccess() && !((JavaBeanValue)value).mirror.isDefaultAccess()) {
                    VariableMirror setterParam = setter.getParameters().get(0);
                    Module module = ModelUtil.getModuleContainer(klass);
                    Type paramType = this.obtainType(setterParam.getType(), setterParam, klass, module, VarianceLocation.INVARIANT, "setter '" + setter.getName() + "'", klass);
                    NullStatus nullPolicy = this.getUncheckedNullPolicy(isCeylon, setterParam.getType(), setterParam);
                    if (nullPolicy == NullStatus.UncheckedNull) {
                        nullPolicy = this.getUncheckedNullPolicy(isCeylon, ((JavaBeanValue)value).mirror.getReturnType(), ((JavaBeanValue)value).mirror);
                    }
                    switch (nullPolicy) {
                        case Optional: {
                            if (isCeylon) break;
                            paramType = this.makeOptionalTypePreserveUnderlyingType(paramType, module);
                        }
                    }
                    if (paramType.isExactly(((TypedDeclaration)value).getType())) {
                        ((Value)value).setVariable(true);
                        ((JavaBeanValue)value).setSetterName(setter.getName());
                        if (((Value)value).isTransient()) {
                            this.makeSetter((Value)value, null);
                        }
                        if (!isCeylon && this.isCoercedMethod(setter)) continue;
                        this.removeMultiMap(methods, setter.getName(), setter);
                        continue;
                    }
                    this.logVerbose("Setter parameter type for " + name + " does not match corresponding getter type, adding setter as a method");
                    continue;
                }
                this.logVerbose("Setter visibility for " + name + " does not match corresponding getter visibility, adding setter as a method");
            }
        }
        if (hashSetter != null && seenHashAttribute && !seenHashGetter && (declaration2 = klass.getDirectMember("hash", null, false)) instanceof JavaBeanValue) {
            ((JavaBeanValue)declaration2).setVariable(true);
            ((JavaBeanValue)declaration2).setSetterName(hashSetter.getName());
            this.removeMultiMap(methods, hashSetter.getName(), hashSetter);
        }
        if (stringSetter != null && seenStringAttribute && !seenStringGetter && (declaration = klass.getDirectMember("string", null, false)) instanceof JavaBeanValue) {
            ((JavaBeanValue)declaration).setVariable(true);
            ((JavaBeanValue)declaration).setSetterName(stringSetter.getName());
            this.removeMultiMap(methods, stringSetter.getName(), stringSetter);
        }
        for (List methodMirrors : methods.values()) {
            boolean isOverloaded = this.isMethodOverloaded(methodMirrors, isCeylon);
            List overloads = null;
            for (MethodMirror methodMirror : methodMirrors) {
                Function m = this.addMethod(klass, methodMirror, classMirror, isCeylon, isOverloaded, isNativeHeaderMember, false);
                if (!isOverloaded && isCeylon && this.shouldCreateNativeHeader(m, klass)) {
                    Function hdr7 = this.addMethod(klass, methodMirror, classMirror, true, isOverloaded, true, false);
                    this.setNonLazyDeclarationProperties(hdr7, classMirror, classMirror, classMirror, true);
                    this.initNativeHeader(hdr7, m);
                } else if (isCeylon && this.shouldLinkNatives(m)) {
                    this.initNativeHeaderMember(m);
                }
                if (m.isOverloaded()) {
                    overloads = overloads == null ? new ArrayList(methodMirrors.size()) : overloads;
                    overloads.add(m);
                }
                if (!isOverloaded || isCeylon || !this.isCoercedMethod(methodMirror)) continue;
                Function coercionMethod = this.addMethod(klass, methodMirror, classMirror, isCeylon, isOverloaded, isNativeHeaderMember, true);
                coercionMethod.setRealFunction(m);
                overloads.add(coercionMethod);
            }
            if (overloads == null || overloads.isEmpty()) continue;
            Function abstractionMethod = this.addMethod(klass, (MethodMirror)methodMirrors.get(0), classMirror, isCeylon, false, false, false);
            abstractionMethod.setAbstraction(true);
            abstractionMethod.setOverloads(overloads);
            abstractionMethod.setType(this.newUnknownType());
        }
        if (!(constructor == null || this.isDefaultNamedCtor(classMirror, constructor) || klass instanceof LazyClass && ((LazyClass)klass).isAnonymous())) {
            this.setParameters((Class)klass, classMirror, constructor, isCeylon, klass, klass.isCoercionPoint());
        }
        if (klass instanceof Class) {
            for (Declaration m : klass.getMembers()) {
                Value v;
                Parameter p;
                if (!JvmBackendUtil.isValue(m) || (p = ((Class)klass).getParameter((v = (Value)m).getName())) == null) continue;
                p.setHidden(true);
            }
        }
        this.setExtendedType(klass, classMirror);
        this.setSatisfiedTypes(klass, classMirror);
        this.setCaseTypes(klass, classMirror);
        this.setAnnotations(klass, classMirror, isNativeHeaderMember);
        if (klass instanceof Interface) {
            klass.setSamName(this.isFunctionalInterfaceWithExceptions(classMirror));
        }
        if (!klass.isAlias()) {
            void var18_37;
            ClassMirror companionClass;
            ClassMirror classMirror2 = classMirror;
            if (klass instanceof LazyInterface && (companionClass = ((LazyInterface)klass).companionClass) != null) {
                ClassMirror classMirror3 = companionClass;
            }
            this.addLocalDeclarations((LazyContainer)((Object)klass), (ClassMirror)var18_37, classMirror);
        }
        if (!isCeylon) {
            for (Declaration d : klass.getMembers()) {
                if (!d.isShared()) continue;
                d.setVisibleScope(null);
            }
        }
    }

    private boolean addingFieldWouldConflictWithMember(ClassOrInterface klass, String name) {
        return klass.getDirectMember(name, null, false) != null || "equals".equals(name) || "string".equals(name) || "hash".equals(name);
    }

    private boolean keepField(FieldMirror fieldMirror, boolean isCeylon, boolean isFromJDK) {
        if (fieldMirror.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null) {
            return false;
        }
        if (this.skipPrivateMember(fieldMirror)) {
            return false;
        }
        if (isCeylon && fieldMirror.isStatic()) {
            return false;
        }
        return !isFromJDK || fieldMirror.isPublic() || fieldMirror.isProtected();
    }

    private boolean propertiesMatch(ClassOrInterface klass, MethodMirror getter, MethodMirror setter) {
        if (setter.isPublic() && getter.isPublic() || setter.isProtected() && getter.isProtected() || setter.isDefaultAccess() && getter.isDefaultAccess() || !setter.isPublic() && !getter.isPublic() && !setter.isProtected() && !getter.isProtected() && !setter.isDefaultAccess() && !getter.isDefaultAccess()) {
            Type returnType;
            Module module = ModelUtil.getModuleContainer(klass);
            VariableMirror setterParam = setter.getParameters().get(0);
            Type paramType = this.obtainType(setterParam.getType(), setterParam, klass, module, VarianceLocation.INVARIANT, "setter '" + setter.getName() + "'", klass);
            if (paramType.isExactly(returnType = this.obtainType(getter.getReturnType(), getter, klass, module, VarianceLocation.INVARIANT, "getter '" + getter.getName() + "'", klass))) {
                return true;
            }
        }
        return false;
    }

    private <Key, Val> void removeMultiMap(Map<Key, List<Val>> map, Key key, Val val) {
        List<Val> list = map.get(key);
        if (list != null) {
            list.remove(val);
            if (list.isEmpty()) {
                map.remove(key);
            }
        }
    }

    private <Key, Val> void putMultiMap(Map<Key, List<Val>> map, Key key, Val value) {
        List<Val> list = map.get(key);
        if (list == null) {
            list = new LinkedList<Val>();
            map.put(key, list);
        }
        list.add(value);
    }

    private Constructor addConstructor(Class klass, ClassMirror classMirror, MethodMirror ctor, boolean isNativeHeader) {
        boolean isCeylon = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null;
        Constructor constructor = new Constructor();
        constructor.setName(this.getCtorName(ctor));
        constructor.setContainer(klass);
        constructor.setScope(klass);
        constructor.setUnit(klass.getUnit());
        constructor.setAbstract(ctor.getAnnotation(CEYLON_LANGUAGE_ABSTRACT_ANNOTATION) != null);
        constructor.setExtendedType(klass.getType());
        this.setNonLazyDeclarationProperties(constructor, ctor, ctor, classMirror, isCeylon);
        this.setAnnotations(constructor, ctor, isNativeHeader);
        klass.addMember(constructor);
        return constructor;
    }

    protected FunctionOrValue addConstructorMethorOrValue(Class klass, ClassMirror classMirror, MethodMirror ctor, Constructor constructor, boolean isNativeHeader) {
        boolean isCeylon;
        boolean bl = isCeylon = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null;
        if (ctor.getAnnotation(CEYLON_ENUMERATED_ANNOTATION) != null) {
            klass.setEnumerated(true);
            Value v = new Value();
            v.setName(constructor.getName());
            v.setType(constructor.getType());
            v.setContainer(klass);
            v.setScope(klass);
            v.setUnit(klass.getUnit());
            v.setVisibleScope(constructor.getVisibleScope());
            this.setNonLazyDeclarationProperties(v, ctor, ctor, classMirror, isCeylon);
            this.setAnnotations(v, ctor, isNativeHeader);
            klass.addMember(v);
            return v;
        }
        this.setParameters(constructor, classMirror, ctor, true, klass, false);
        klass.setConstructors(true);
        Function f = new Function();
        f.setName(constructor.getName());
        f.setType(constructor.getType());
        f.addParameterList(constructor.getParameterList());
        f.setContainer(klass);
        f.setScope(klass);
        f.setUnit(klass.getUnit());
        f.setVisibleScope(constructor.getVisibleScope());
        this.setNonLazyDeclarationProperties(f, ctor, ctor, classMirror, isCeylon);
        this.setAnnotations(f, ctor, isNativeHeader);
        klass.addMember(f);
        return f;
    }

    private boolean isMethodOverloaded(List<MethodMirror> methodMirrors, boolean isCeylon) {
        MethodMirror methodMirror;
        boolean one = false;
        Iterator<MethodMirror> i$ = methodMirrors.iterator();
        while (!(!i$.hasNext() || (methodMirror = i$.next()).isConstructor() || this.isInstantiator(methodMirror) || this.isGetter(methodMirror) || this.isHashAttribute(methodMirror) || this.isStringAttribute(methodMirror) || methodMirror.getName().equals("hash") || methodMirror.getName().equals("string"))) {
            if (this.isOverloadingMethod(methodMirror)) {
                return true;
            }
            if (!isCeylon && this.isCoercedMethod(methodMirror)) {
                return true;
            }
            if (one) {
                return true;
            }
            one = true;
        }
        return false;
    }

    private void collectMethods(List<MethodMirror> methodMirrors, Map<String, List<MethodMirror>> methods, boolean isCeylon, boolean isFromJDK) {
        for (MethodMirror methodMirror : methodMirrors) {
            if (methodMirror.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null || this.skipPrivateMember(methodMirror) || methodMirror.isStaticInit() || methodMirror.isConstructor() || this.isInstantiator(methodMirror) || isFromJDK && !methodMirror.isPublic() && !methodMirror.isProtected()) continue;
            String methodName = methodMirror.getName();
            List<MethodMirror> homonyms = methods.get(methodName);
            if (homonyms == null) {
                homonyms = new LinkedList<MethodMirror>();
                methods.put(methodName, homonyms);
            }
            homonyms.add(methodMirror);
        }
    }

    private boolean skipPrivateMember(AccessibleMirror mirror) {
        return !mirror.isPublic() && !mirror.isProtected() && !mirror.isDefaultAccess() && !this.needsPrivateMembers();
    }

    private void addLocalDeclarations(LocalDeclarationContainer container, ClassMirror classContainerMirror, AnnotatedMirror annotatedMirror) {
        if (!this.needsLocalDeclarations()) {
            return;
        }
        AnnotationMirror annotation = annotatedMirror.getAnnotation(CEYLON_LOCAL_DECLARATIONS_ANNOTATION);
        if (annotation == null) {
            return;
        }
        List<String> values = this.getAnnotationStringValues(annotation, "value");
        String parentClassName = classContainerMirror.getQualifiedName();
        Package pkg = ModelUtil.getPackageContainer(container);
        Module module = pkg.getModule();
        for (String scope : values) {
            Declaration innerDecl;
            String name;
            if (scope.startsWith("::")) {
                name = pkg.getNameAsString() + "." + scope.substring(2);
            } else {
                name = parentClassName;
                name = name + "$" + scope;
            }
            if ((innerDecl = this.convertToDeclaration(module, (Declaration)((Object)container), name, ModelLoader.DeclarationType.TYPE)) != null) continue;
            throw new ModelResolutionException("Failed to load local type " + name + " for outer type " + container.getQualifiedNameString());
        }
    }

    private boolean isInstantiator(MethodMirror methodMirror) {
        return methodMirror.getName().endsWith("$aliased$");
    }

    private boolean isFromJDK(ClassMirror classMirror) {
        String pkgName = this.unquotePackageName(classMirror.getPackage());
        return this.jdkProvider.isJDKPackage(pkgName);
    }

    private void setAnnotations(Annotated annotated, AnnotatedMirror classMirror, boolean isNativeHeader) {
        if (classMirror.getAnnotation(CEYLON_ANNOTATIONS_ANNOTATION) != null) {
            List annotations;
            Long mods = (Long)this.getAnnotationValue(classMirror, CEYLON_ANNOTATIONS_ANNOTATION, "modifiers");
            if (mods != null) {
                for (LanguageAnnotation mod : LanguageAnnotation.values()) {
                    if (!mod.isModifier() || (mod.mask & mods) == 0L) continue;
                    annotated.getAnnotations().addAll(mod.makeFromCeylonAnnotation(null));
                }
            }
            if ((annotations = this.getAnnotationArrayValue(classMirror, CEYLON_ANNOTATIONS_ANNOTATION)) != null) {
                for (AnnotationMirror annotation : annotations) {
                    annotated.getAnnotations().add(this.readModelAnnotation(annotation));
                }
            }
        } else {
            Class clazz;
            Declaration objectValue;
            for (LanguageAnnotation mod : LanguageAnnotation.values()) {
                if (classMirror.getAnnotation(mod.annotationType) == null) continue;
                annotated.getAnnotations().addAll(mod.makeFromCeylonAnnotation(classMirror.getAnnotation(mod.annotationType)));
            }
            if (annotated instanceof Class && ((Class)annotated).isAnonymous() && (objectValue = (clazz = (Class)annotated).getContainer().getDirectMember(clazz.getName(), null, false)) != null) {
                annotated.getAnnotations().addAll(objectValue.getAnnotations());
            }
        }
        boolean hasCeylonDeprecated = false;
        for (Annotation a : annotated.getAnnotations()) {
            if (!a.getName().equals("deprecated")) continue;
            hasCeylonDeprecated = true;
            break;
        }
        if (classMirror.getAnnotation(JAVA_DEPRECATED_ANNOTATION) != null && !hasCeylonDeprecated) {
            Annotation modelAnnotation = new Annotation();
            modelAnnotation.setName("deprecated");
            modelAnnotation.getPositionalArguments().add("");
            annotated.getAnnotations().add(modelAnnotation);
            hasCeylonDeprecated = true;
        }
        if (!(annotated instanceof Declaration) || ((Declaration)annotated).getNativeBackends().none()) {
            this.manageNativeBackend(annotated, classMirror, isNativeHeader);
        }
    }

    private void manageNativeBackend(Annotated annotated, AnnotatedMirror mirror, boolean isNativeHeader) {
        if (mirror == null) {
            return;
        }
        List nativeBackends = (List)this.getAnnotationValue(mirror, CEYLON_LANGUAGE_NATIVE_ANNOTATION, "backends");
        if (nativeBackends != null) {
            Backends backends = Backends.fromAnnotations(nativeBackends);
            if (isNativeHeader) {
                backends = Backends.HEADER;
            } else if (backends.header()) {
                backends = Backends.JAVA;
            }
            if (annotated instanceof Declaration) {
                Declaration decl = (Declaration)annotated;
                decl.setNativeBackends(backends);
                if (isNativeHeader) {
                    ArrayList<Declaration> al = new ArrayList<Declaration>(1);
                    AbstractModelLoader.setOverloads(decl, al);
                }
            } else if (annotated instanceof Module) {
                ((Module)annotated).setNativeBackends(backends);
            }
        } else if (annotated instanceof LazyClass && !((LazyClass)annotated).isCeylon() || annotated instanceof LazyInterface && !((LazyInterface)annotated).isCeylon()) {
            ((Declaration)annotated).setNativeBackends(Backend.Java.asSet());
        }
    }

    protected boolean isDeprecated(AnnotatedMirror classMirror) {
        if (classMirror.getAnnotation(JAVA_DEPRECATED_ANNOTATION) != null) {
            return true;
        }
        if (classMirror.getAnnotation(CEYLON_ANNOTATIONS_ANNOTATION) != null) {
            List annotations = this.getAnnotationArrayValue(classMirror, CEYLON_ANNOTATIONS_ANNOTATION);
            if (annotations != null) {
                for (AnnotationMirror annotation : annotations) {
                    String name = (String)annotation.getValue();
                    if (name == null || !name.equals("deprecated")) continue;
                    return true;
                }
            }
            return false;
        }
        return classMirror.getAnnotation(LanguageAnnotation.DEPRECATED.annotationType) != null;
    }

    public static List<Declaration> getOverloads(Declaration decl) {
        if (decl instanceof Function) {
            return ((Function)decl).getOverloads();
        }
        if (decl instanceof Value) {
            return ((Value)decl).getOverloads();
        }
        if (decl instanceof Class) {
            return ((Class)decl).getOverloads();
        }
        return null;
    }

    public static void setOverloads(Declaration decl, List<Declaration> overloads) {
        if (decl instanceof Function) {
            ((Function)decl).setOverloads(overloads);
        } else if (decl instanceof Value) {
            ((Value)decl).setOverloads(overloads);
        } else if (decl instanceof Class) {
            ((Class)decl).setOverloads(overloads);
        }
    }

    private Annotation readModelAnnotation(AnnotationMirror annotation) {
        Annotation modelAnnotation = new Annotation();
        modelAnnotation.setName((String)annotation.getValue());
        List arguments = (List)annotation.getValue(CEYLON_ANNOTATION_INSTANTIATION_ARGUMENTS_MEMBER);
        if (arguments != null) {
            modelAnnotation.getPositionalArguments().addAll(arguments);
        } else {
            List namedArguments = (List)annotation.getValue("namedArguments");
            if (namedArguments != null) {
                for (AnnotationMirror namedArgument : namedArguments) {
                    String argName = (String)namedArgument.getValue("name");
                    String argValue = (String)namedArgument.getValue("value");
                    modelAnnotation.getNamedArguments().put(argName, argValue);
                }
            }
        }
        return modelAnnotation;
    }

    private void addInnerClasses(ClassOrInterface klass, ClassMirror classMirror) {
        AnnotationMirror membersAnnotation = classMirror.getAnnotation(CEYLON_MEMBERS_ANNOTATION);
        if (membersAnnotation == null) {
            this.addInnerClassesFromMirror(klass, classMirror);
        } else {
            this.addInnerClassesFromAnnotation(klass, membersAnnotation);
        }
    }

    private void addInnerClassesFromAnnotation(ClassOrInterface klass, AnnotationMirror membersAnnotation) {
        List members = (List)membersAnnotation.getValue();
        for (AnnotationMirror member : members) {
            String javaClassName;
            TypeMirror javaClassMirror = (TypeMirror)member.getValue("klass");
            if (javaClassMirror != null && !javaClassMirror.isPrimitive()) {
                javaClassName = javaClassMirror.getQualifiedName();
            } else {
                String name = (String)member.getValue("javaClassName");
                ClassMirror container = null;
                if (klass instanceof LazyClass) {
                    container = ((LazyClass)klass).classMirror;
                } else if (klass instanceof LazyInterface) {
                    container = ((LazyInterface)klass).isCeylon() ? ((LazyInterface)klass).companionClass : ((LazyInterface)klass).classMirror;
                }
                if (container == null) {
                    throw new ModelResolutionException("Unknown container type: " + klass + " when trying to load inner class " + name);
                }
                javaClassName = container.getQualifiedName() + "$" + name;
            }
            Declaration innerDecl = this.convertToDeclaration(ModelUtil.getModuleContainer(klass), (Declaration)klass, javaClassName, ModelLoader.DeclarationType.TYPE);
            if (innerDecl == null) {
                throw new ModelResolutionException("Failed to load inner type " + javaClassName + " for outer type " + klass.getQualifiedNameString());
            }
            if (!this.shouldLinkNatives(innerDecl)) continue;
            this.initNativeHeaderMember(innerDecl);
        }
    }

    protected String assembleJavaClass(String javaClass, String packageName) {
        return javaClass;
    }

    private void addInnerClassesFromMirror(ClassOrInterface klass, ClassMirror classMirror) {
        boolean isJDK = this.isFromJDK(classMirror);
        Module module = ModelUtil.getModule(klass);
        for (ClassMirror innerClass : classMirror.getDirectInnerClasses()) {
            if (innerClass.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null || innerClass.isAnonymous() || isJDK && !innerClass.isPublic()) continue;
            this.convertToDeclaration(module, (Declaration)klass, innerClass, ModelLoader.DeclarationType.TYPE);
        }
    }

    private Function addMethod(ClassOrInterface klass, MethodMirror methodMirror, ClassMirror classMirror, boolean isCeylon, boolean isOverloaded, boolean isNativeHeader, boolean isCoercedMethod) {
        Type type;
        JavaMethod method;
        block15: {
            method = new JavaMethod(methodMirror);
            String methodName = methodMirror.getName();
            method.setCoercionPoint(isCoercedMethod);
            method.setContainer(klass);
            method.setScope(klass);
            method.setRealName(methodName);
            method.setUnit(klass.getUnit());
            method.setOverloaded(isOverloaded);
            method.setVariadic(methodMirror.isVariadic());
            type = null;
            try {
                this.setMethodOrValueFlags(klass, methodMirror, method, isCeylon);
            }
            catch (ModelResolutionException x) {
                type = this.logModelResolutionException(x, (Scope)klass, "method '" + methodMirror.getName() + "' (checking if it is an overriding method)");
            }
            if (methodName.equals("hash") || methodName.equals("string")) {
                method.setName(methodName + "_method");
            } else {
                String ceylonName = JvmBackendUtil.strip(methodName, isCeylon, method.isShared());
                if (!isCeylon && !JvmBackendUtil.isInitialLowerCase(ceylonName)) {
                    ceylonName = NamingBase.getJavaBeanName(ceylonName);
                }
                method.setName(ceylonName);
            }
            method.setDefaultedAnnotation(methodMirror.isDefault());
            try {
                this.setTypeParameters(method, methodMirror, isCeylon);
            }
            catch (ModelResolutionException x) {
                if (type != null) break block15;
                type = this.logModelResolutionException(x, (Scope)klass, "method '" + methodMirror.getName() + "' (loading type parameters)");
            }
        }
        Module module = ModelUtil.getModuleContainer(method);
        if (type == null) {
            type = this.obtainType(methodMirror.getReturnType(), methodMirror, method, module, VarianceLocation.COVARIANT, "method '" + methodMirror.getName() + "'", klass);
        }
        switch (this.getUncheckedNullPolicy(isCeylon, methodMirror.getReturnType(), methodMirror)) {
            case Optional: {
                if (isCeylon) break;
                type = this.makeOptionalTypePreserveUnderlyingType(type, module);
                break;
            }
            case UncheckedNull: {
                method.setUncheckedNullType(true);
            }
        }
        if (type.isCached()) {
            type = type.clone();
        }
        method.setType(type);
        if (this.isEqualsMethod(methodMirror)) {
            this.setEqualsParameters(method, methodMirror);
        } else {
            this.setParameters(method, classMirror, methodMirror, isCeylon, klass, isCoercedMethod);
        }
        type.setRaw(this.isRaw(module, methodMirror.getReturnType()));
        this.markDeclaredVoid(method, methodMirror);
        this.markUnboxed(method, methodMirror, methodMirror.getReturnType());
        this.markSmall(method, methodMirror.getReturnType());
        this.markTypeErased(method, methodMirror, methodMirror.getReturnType());
        this.markUntrustedType(method, methodMirror, methodMirror.getReturnType());
        method.setDeprecated(this.isDeprecated(methodMirror));
        this.setAnnotations(method, methodMirror, isNativeHeader);
        klass.addMember(method);
        ModelUtil.setVisibleScope(method);
        this.addLocalDeclarations(method, classMirror, methodMirror);
        return method;
    }

    private List<Type> getSignature(Declaration decl) {
        Functional func;
        ArrayList<Type> result = null;
        if (decl instanceof Functional && (func = (Functional)((Object)decl)).getParameterLists().size() > 0) {
            List<Parameter> params = func.getFirstParameterList().getParameters();
            result = new ArrayList<Type>(params.size());
            for (Parameter p : params) {
                result.add(p.getType());
            }
        }
        return result;
    }

    protected boolean isStartOfJavaBeanPropertyName(int codepoint) {
        return codepoint == Character.toUpperCase(codepoint) || codepoint == 95;
    }

    private boolean isNonGenericMethod(MethodMirror methodMirror) {
        return !methodMirror.isConstructor() && methodMirror.getTypeParameters().isEmpty();
    }

    private boolean allReifiedTypeParameters(List<VariableMirror> list) {
        for (VariableMirror v : list) {
            if ("com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor".equals(v.getType().getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    private boolean isGetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror) && !methodMirror.isStatic()) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesGet = name.length() > 3 && name.startsWith("get") && this.isStartOfJavaBeanPropertyName(name.codePointAt(3)) && !"getString".equals(name) && !"getHash".equals(name) && !"getEquals".equals(name);
        boolean matchesIs = name.length() > 2 && name.startsWith("is") && this.isStartOfJavaBeanPropertyName(name.codePointAt(2)) && !"isString".equals(name) && !"isHash".equals(name) && !"isEquals".equals(name);
        boolean hasNoParams = methodMirror.getParameters().size() == 0 || methodMirror.isStatic() && this.allReifiedTypeParameters(methodMirror.getParameters());
        boolean hasNonVoidReturn = methodMirror.getReturnType().getKind() != TypeKind.VOID;
        boolean hasBooleanReturn = methodMirror.getReturnType().getKind() == TypeKind.BOOLEAN;
        return (matchesGet && hasNonVoidReturn || matchesIs && hasBooleanReturn) && hasNoParams;
    }

    private boolean isStringGetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror)) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesGet = "getString".equals(name);
        boolean matchesIs = "isString".equals(name);
        boolean hasNoParams = methodMirror.getParameters().size() == 0;
        boolean hasNonVoidReturn = methodMirror.getReturnType().getKind() != TypeKind.VOID;
        boolean hasBooleanReturn = methodMirror.getReturnType().getKind() == TypeKind.BOOLEAN;
        return (matchesGet && hasNonVoidReturn || matchesIs && hasBooleanReturn) && hasNoParams;
    }

    private boolean isHashGetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror)) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesGet = "getHash".equals(name);
        boolean matchesIs = "isHash".equals(name);
        boolean hasNoParams = methodMirror.getParameters().size() == 0;
        boolean hasNonVoidReturn = methodMirror.getReturnType().getKind() != TypeKind.VOID;
        boolean hasBooleanReturn = methodMirror.getReturnType().getKind() == TypeKind.BOOLEAN;
        return (matchesGet && hasNonVoidReturn || matchesIs && hasBooleanReturn) && hasNoParams;
    }

    private boolean isSetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror)) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesSet = name.length() > 3 && name.startsWith("set") && this.isStartOfJavaBeanPropertyName(name.codePointAt(3)) && !"setString".equals(name) && !"setHash".equals(name) && !"setEquals".equals(name);
        boolean hasOneParam = methodMirror.getParameters().size() == 1;
        boolean hasVoidReturn = methodMirror.getReturnType().getKind() == TypeKind.VOID;
        return matchesSet && hasOneParam && hasVoidReturn;
    }

    private boolean isStringSetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror)) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesSet = name.equals("setString");
        boolean hasOneParam = methodMirror.getParameters().size() == 1;
        boolean hasVoidReturn = methodMirror.getReturnType().getKind() == TypeKind.VOID;
        return matchesSet && hasOneParam && hasVoidReturn;
    }

    private boolean isHashSetter(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror)) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesSet = name.equals("setHash");
        boolean hasOneParam = methodMirror.getParameters().size() == 1;
        boolean hasVoidReturn = methodMirror.getReturnType().getKind() == TypeKind.VOID;
        return matchesSet && hasOneParam && hasVoidReturn;
    }

    private boolean isHashAttribute(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror) || methodMirror.isStatic()) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesName = "hashCode".equals(name);
        boolean hasNoParams = methodMirror.getParameters().size() == 0;
        return matchesName && hasNoParams;
    }

    private boolean isStringAttribute(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror) || methodMirror.isStatic()) {
            return false;
        }
        String name = methodMirror.getName();
        boolean matchesName = "toString".equals(name);
        boolean hasNoParams = methodMirror.getParameters().size() == 0;
        return matchesName && hasNoParams;
    }

    private boolean isEqualsMethod(MethodMirror methodMirror) {
        if (!this.isNonGenericMethod(methodMirror) || methodMirror.isStatic()) {
            return false;
        }
        String name = methodMirror.getName();
        if (!"equals".equals(name) || methodMirror.getParameters().size() != 1) {
            return false;
        }
        VariableMirror param = methodMirror.getParameters().get(0);
        return this.sameType(param.getType(), OBJECT_TYPE);
    }

    private boolean isCoercedMethod(MethodMirror methodMirror) {
        List<VariableMirror> parameters = methodMirror.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableMirror param = parameters.get(i);
            TypeMirror type = param.getType();
            if (methodMirror.isVariadic() && i == parameters.size() - 1) {
                type = type.getComponentType();
            }
            if (!this.isCoercedType(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isCoercedType(TypeMirror type) {
        if (this.sameType(type, CHAR_SEQUENCE_TYPE)) {
            return true;
        }
        if (this.sameType(type, CLASS_TYPE)) {
            return true;
        }
        return this.isFunctionCercion(type);
    }

    private void setEqualsParameters(Function decl, MethodMirror methodMirror) {
        ParameterList parameters = new ParameterList();
        decl.addParameterList(parameters);
        Parameter parameter = new Parameter();
        Value value = new Value();
        parameter.setModel(value);
        value.setInitializerParameter(parameter);
        value.setUnit(decl.getUnit());
        Function scope = decl;
        value.setContainer(scope);
        value.setScope(scope);
        parameter.setName("that");
        value.setName("that");
        value.setType(this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_OBJECT_TYPE, decl, VarianceLocation.INVARIANT));
        parameter.setDeclaration(decl);
        parameters.getParameters().add(parameter);
        decl.addMember(value);
    }

    private String getJavaAttributeName(MethodMirror methodMirror) {
        String name = this.getAnnotationStringValue(methodMirror, CEYLON_NAME_ANNOTATION);
        if (name != null) {
            return name;
        }
        return NamingBase.getJavaAttributeName(methodMirror.getName());
    }

    private Value addValue(ClassOrInterface klass, String ceylonName, FieldMirror fieldMirror, boolean isCeylon, boolean isNativeHeader) {
        FieldValue value = new FieldValue(fieldMirror.getName());
        value.setContainer(klass);
        value.setScope(klass);
        String nameAnnotation = this.getAnnotationStringValue(fieldMirror, CEYLON_NAME_ANNOTATION);
        value.setName(nameAnnotation != null ? nameAnnotation : ceylonName);
        value.setUnit(klass.getUnit());
        value.setShared(fieldMirror.isPublic() || fieldMirror.isProtected() || fieldMirror.isDefaultAccess());
        value.setProtectedVisibility(fieldMirror.isProtected());
        value.setPackageVisibility(fieldMirror.isDefaultAccess());
        value.setStatic(fieldMirror.isStatic());
        AbstractModelLoader.setDeclarationAliases(value, fieldMirror);
        value.setVariable(!fieldMirror.isFinal());
        if (fieldMirror.getType().getKind() == TypeKind.DECLARED && fieldMirror.getType().getDeclaredClass() != null && fieldMirror.getType().getDeclaredClass().isEnum() && fieldMirror.isFinal() && fieldMirror.isStatic()) {
            value.setEnumValue(true);
        }
        Module module = ModelUtil.getModuleContainer(klass);
        Type type = this.obtainType(fieldMirror.getType(), fieldMirror, klass, module, VarianceLocation.INVARIANT, "field '" + value.getName() + "'", klass);
        if (type.isCached()) {
            type = type.clone();
        }
        if (value.isEnumValue()) {
            Class enumValueType = new Class();
            enumValueType.setValueConstructor(true);
            enumValueType.setJavaEnum(true);
            enumValueType.setAnonymous(true);
            enumValueType.setExtendedType(type);
            Scope scope = value.getContainer();
            enumValueType.setContainer(scope);
            enumValueType.setScope(scope);
            enumValueType.setDeprecated(value.isDeprecated());
            enumValueType.setName(value.getName());
            enumValueType.setFinal(true);
            enumValueType.setUnit(value.getUnit());
            enumValueType.setStatic(value.isStatic());
            value.setType(enumValueType.getType());
            value.setUncheckedNullType(false);
        } else {
            switch (this.getUncheckedNullPolicy(isCeylon, fieldMirror.getType(), fieldMirror)) {
                case Optional: {
                    if (isCeylon) break;
                    type = this.makeOptionalTypePreserveUnderlyingType(type, module);
                    break;
                }
                case UncheckedNull: {
                    value.setUncheckedNullType(true);
                }
            }
            value.setType(type);
        }
        type.setRaw(this.isRaw(module, fieldMirror.getType()));
        this.markUnboxed(value, null, fieldMirror.getType());
        this.markSmall(value, fieldMirror.getType());
        this.markTypeErased(value, fieldMirror, fieldMirror.getType());
        this.markUntrustedType(value, fieldMirror, fieldMirror.getType());
        value.setDeprecated(this.isDeprecated(fieldMirror));
        this.setAnnotations(value, fieldMirror, isNativeHeader);
        klass.addMember(value);
        ModelUtil.setVisibleScope(value);
        return value;
    }

    private boolean isRaw(Module module, TypeMirror type) {
        switch (type.getKind()) {
            case VOID: 
            case ARRAY: 
            case TYPEVAR: 
            case WILDCARD: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ERROR: 
            case NULL: {
                return false;
            }
            case DECLARED: {
                ClassMirror klass = type.getDeclaredClass();
                if (klass.isJavaSource()) {
                    return type.isRaw();
                }
                LinkedList<String> path = new LinkedList<String>();
                String pkgName = klass.getPackage().getQualifiedName();
                String unquotedPkgName = this.unquotePackageName(klass.getPackage());
                String qualifiedName = klass.getQualifiedName();
                String relativeName = pkgName.isEmpty() ? qualifiedName : qualifiedName.substring(pkgName.length() + 1);
                for (String name : relativeName.split("[\\$\\.]")) {
                    if (name.isEmpty()) continue;
                    path.add(name);
                }
                if (path.size() > 1 && (klass = this.loadClass(module, pkgName, pkgName + '.' + (String)path.get(0))) == null) {
                    return false;
                }
                if (!path.isEmpty() && klass.isLoadedFromSource()) {
                    Scope scope = this.packagesByName.get(this.cacheKeyByModule(module, unquotedPkgName));
                    if (scope == null) {
                        return false;
                    }
                    for (String name : path) {
                        Declaration decl = scope.getDirectMember(name, null, false);
                        if (decl == null) {
                            return false;
                        }
                        if (JvmBackendUtil.isValue(decl) && ((Value)decl).getTypeDeclaration().getName().equals(name)) {
                            decl = ((Value)decl).getTypeDeclaration();
                        }
                        if (!(decl instanceof TypeDeclaration)) {
                            return false;
                        }
                        scope = (TypeDeclaration)decl;
                    }
                    TypeDeclaration typeDecl = (TypeDeclaration)scope;
                    return !typeDecl.getTypeParameters().isEmpty() && type.getTypeArguments().isEmpty();
                }
                try {
                    return type.isRaw();
                }
                catch (Exception x) {
                    return false;
                }
            }
        }
        return false;
    }

    private JavaBeanValue addValue(ClassOrInterface klass, MethodMirror methodMirror, String methodName, boolean isCeylon, boolean isNativeHeader) {
        JavaBeanValue value = new JavaBeanValue(methodMirror);
        value.setGetterName(methodMirror.getName());
        value.setContainer(klass);
        value.setScope(klass);
        value.setUnit(klass.getUnit());
        Type type = null;
        try {
            this.setMethodOrValueFlags(klass, methodMirror, value, isCeylon);
        }
        catch (ModelResolutionException x) {
            type = this.logModelResolutionException(x, (Scope)klass, "getter '" + methodName + "' (checking if it is an overriding method");
        }
        value.setName(JvmBackendUtil.strip(methodName, isCeylon, value.isShared()));
        Module module = ModelUtil.getModuleContainer(klass);
        if (type == null) {
            type = this.obtainType(methodMirror.getReturnType(), methodMirror, klass, module, VarianceLocation.INVARIANT, "getter '" + methodName + "'", klass);
        }
        if (type.isCached()) {
            type = type.clone();
        }
        if (value.isShared() && methodName.equals("hash")) {
            type.setUnderlyingType("long");
        }
        switch (this.getUncheckedNullPolicy(isCeylon, methodMirror.getReturnType(), methodMirror)) {
            case Optional: {
                if (isCeylon) break;
                type = this.makeOptionalTypePreserveUnderlyingType(type, module);
                break;
            }
            case UncheckedNull: {
                value.setUncheckedNullType(true);
            }
        }
        value.setType(type);
        type.setRaw(this.isRaw(module, methodMirror.getReturnType()));
        this.markUnboxed(value, methodMirror, methodMirror.getReturnType());
        this.markSmall(value, methodMirror.getReturnType());
        this.markTypeErased(value, methodMirror, methodMirror.getReturnType());
        this.markUntrustedType(value, methodMirror, methodMirror.getReturnType());
        value.setDeprecated(this.isDeprecated(methodMirror));
        this.setAnnotations(value, methodMirror, isNativeHeader);
        klass.addMember(value);
        ModelUtil.setVisibleScope(value);
        return value;
    }

    private NullStatus getUncheckedNullPolicy(boolean isCeylon, TypeMirror typeMirror, AnnotatedMirror annotatedMirror) {
        Boolean unchecked;
        if (!isCeylon) {
            if (typeMirror.isPrimitive()) {
                return NullStatus.NonOptional;
            }
            for (String name : annotatedMirror.getAnnotationNames()) {
                String lcName = name.toLowerCase();
                if (lcName.endsWith(".nullable")) {
                    return NullStatus.Optional;
                }
                if (!lcName.endsWith(".notnull") && !lcName.endsWith(".nonnull")) continue;
                return NullStatus.NonOptional;
            }
        }
        if ((unchecked = this.getAnnotationBooleanValue(annotatedMirror, CEYLON_TYPE_INFO_ANNOTATION, "uncheckedNull")) != null) {
            return unchecked != false ? NullStatus.UncheckedNull : NullStatus.NonOptional;
        }
        return isCeylon ? NullStatus.NoCheck : NullStatus.UncheckedNull;
    }

    private void setMethodOrValueFlags(ClassOrInterface klass, MethodMirror methodMirror, FunctionOrValue decl, boolean isCeylon) {
        decl.setShared(methodMirror.isPublic() || methodMirror.isProtected() || methodMirror.isDefaultAccess());
        decl.setProtectedVisibility(methodMirror.isProtected());
        decl.setPackageVisibility(methodMirror.isDefaultAccess());
        AbstractModelLoader.setDeclarationAliases(decl, methodMirror);
        if (decl instanceof Value) {
            this.setValueTransientLateFlags((Value)decl, methodMirror, isCeylon);
        }
        if (klass instanceof Class && methodMirror.isAbstract() || methodMirror.getAnnotation(CEYLON_LANGUAGE_FORMAL_ANNOTATION) != null) {
            decl.setFormal(true);
        } else if (klass instanceof Interface && !((LazyInterface)klass).isCeylon()) {
            decl.setFormal(methodMirror.isAbstract() && !methodMirror.isDefaultMethod() && !methodMirror.isStatic());
            decl.setDefault(methodMirror.isDefaultMethod());
        } else if (klass instanceof Class && !klass.isFinal() && !methodMirror.isFinal() && methodMirror.getAnnotation(CEYLON_FINAL_ANNOTATION) == null && !methodMirror.isStatic() || klass instanceof Interface && !((LazyInterface)klass).isCeylon() || methodMirror.getAnnotation(CEYLON_LANGUAGE_DEFAULT_ANNOTATION) != null) {
            decl.setDefault(true);
        }
        decl.setStatic(methodMirror.isStatic() && methodMirror.getAnnotation(CEYLON_ENUMERATED_ANNOTATION) == null);
        decl.setActualCompleter(this);
    }

    @Override
    public void completeActual(Declaration decl) {
        Scope container = decl.getContainer();
        if (container instanceof ClassOrInterface) {
            ClassOrInterface klass = (ClassOrInterface)container;
            decl.setRefinedDeclaration(decl);
            if (decl instanceof Class) {
                if (!JvmBackendUtil.isCeylon((Class)decl)) {
                    return;
                }
                if (decl.isActual()) {
                    Declaration refined = klass.getRefinedMember(decl.getName(), this.getSignature(decl), klass.isVariadic());
                    decl.setRefinedDeclaration(refined);
                }
            } else {
                Declaration refined;
                MethodMirror methodMirror;
                if (decl instanceof JavaBeanValue) {
                    methodMirror = ((JavaBeanValue)decl).mirror;
                } else if (decl instanceof JavaMethod) {
                    methodMirror = ((JavaMethod)decl).mirror;
                } else {
                    throw new ModelResolutionException("Unknown type of declaration: " + decl + ": " + decl.getClass().getName());
                }
                decl.setRefinedDeclaration(decl);
                if (klass instanceof LazyInterface && ((LazyInterface)klass).isCeylon()) {
                    boolean actual = methodMirror.getAnnotation(CEYLON_LANGUAGE_ACTUAL_ANNOTATION) != null;
                    decl.setActual(actual);
                    if (actual) {
                        Declaration refined2 = klass.getRefinedMember(decl.getName(), this.getSignature(decl), decl.isVariadic());
                        decl.setRefinedDeclaration(refined2);
                    }
                } else if (this.isOverridingMethod(methodMirror) && !((refined = klass.getRefinedMember(decl.getName(), this.getSignature(decl), decl.isVariadic())) instanceof FieldValue)) {
                    decl.setActual(true);
                    decl.setRefinedDeclaration(refined);
                }
                if (decl instanceof JavaMethod && JvmBackendUtil.isCeylon(klass) && !methodMirror.getTypeParameters().isEmpty() && JvmBackendUtil.supportsReified(decl)) {
                    this.checkReifiedTypeDescriptors(methodMirror.getTypeParameters().size(), container.getQualifiedNameString(), methodMirror, false);
                }
            }
        }
        this.completeVariable(decl);
    }

    private void completeVariable(Declaration value) {
        if (value instanceof JavaBeanValue) {
            Declaration refined;
            Declaration declaration = refined = value != null ? value.getRefinedDeclaration() : null;
            if (refined instanceof Value && ((Value)refined).isVariable() && value instanceof Value && !((Value)value).isVariable()) {
                ((Value)value).setVariable(true);
            }
        }
    }

    private void setValueTransientLateFlags(Value decl, MethodMirror methodMirror, boolean isCeylon) {
        if (isCeylon) {
            decl.setTransient(methodMirror.getAnnotation(CEYLON_TRANSIENT_ANNOTATION) != null);
        } else {
            decl.setTransient(!(decl instanceof FieldValue));
        }
        decl.setLate(methodMirror.getAnnotation(CEYLON_LANGUAGE_LATE_ANNOTATION) != null);
    }

    private void setExtendedType(ClassOrInterface klass, ClassMirror classMirror) {
        Type extendedType;
        TypeMirror superClass = classMirror.getSuperclass();
        if (klass instanceof Interface) {
            extendedType = superClass == null || superClass.getKind() == TypeKind.NONE ? this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_OBJECT_TYPE, klass, VarianceLocation.INVARIANT) : this.getNonPrimitiveType(ModelUtil.getModule(klass), superClass, klass, VarianceLocation.INVARIANT);
        } else if (klass instanceof Class && ((Class)klass).isOverloaded()) {
            extendedType = klass.getExtendedType();
        } else {
            String superClassName;
            String className = classMirror.getQualifiedName();
            String string = superClassName = superClass == null ? null : superClass.getQualifiedName();
            if (className.equals("ceylon.language.Anything")) {
                extendedType = null;
            } else if (className.equals("java.lang.Object")) {
                extendedType = this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_BASIC_TYPE, klass, VarianceLocation.INVARIANT);
            } else {
                String annotationSuperClassName = this.getAnnotationStringValue(classMirror, CEYLON_CLASS_ANNOTATION, "extendsType");
                if (annotationSuperClassName != null && !annotationSuperClassName.isEmpty()) {
                    extendedType = this.decodeType(annotationSuperClassName, klass, ModelUtil.getModuleContainer(klass), "extended type");
                } else if ("java.lang.Object".equals(superClassName)) {
                    extendedType = this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_BASIC_TYPE, klass, VarianceLocation.INVARIANT);
                } else if (superClass != null) {
                    try {
                        extendedType = this.getNonPrimitiveType(ModelUtil.getModule(klass), superClass, klass, VarianceLocation.INVARIANT);
                    }
                    catch (ModelResolutionException x) {
                        extendedType = this.logModelResolutionException(x, (Scope)klass, "Error while resolving extended type of " + klass.getQualifiedNameString());
                    }
                } else {
                    extendedType = null;
                }
            }
        }
        if (extendedType != null) {
            klass.setExtendedType(extendedType);
        }
    }

    private Type getJavaAnnotationExtendedType(ClassOrInterface klass, ClassMirror classMirror) {
        Type annotatedType;
        TypeDeclaration constrainedAnnotation = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_CONSTRAINED_ANNOTATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
        AnnotationMirror target = classMirror.getAnnotation("java.lang.annotation.Target");
        HashSet<Type> types = new HashSet<Type>();
        if (target != null) {
            List values = (List)target.getValue();
            Iterator i$ = values.iterator();
            while (i$.hasNext()) {
                String value;
                switch (value = (String)i$.next()) {
                    case "TYPE": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_CLASS_OR_INTERFACE_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_ALIAS_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                    case "ANNOTATION_TYPE": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_CLASS_OR_INTERFACE_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                    case "CONSTRUCTOR": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_CONSTRUCTOR_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        if (values.contains("TYPE")) break;
                        decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_CLASS_WITH_INIT_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                    case "METHOD": 
                    case "PARAMETER": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_FUNCTION_OR_VALUE_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                    case "FIELD": 
                    case "LOCAL_VARIABLE": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_VALUE_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                    case "PACKAGE": {
                        TypeDeclaration decl = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_PACKAGE_DECLARATION_TYPE, klass, ModelLoader.DeclarationType.TYPE);
                        types.add(decl.getType());
                        break;
                    }
                }
            }
        }
        Module module = ModelUtil.getModuleContainer(klass);
        if (types.size() == 1) {
            annotatedType = (Type)types.iterator().next();
        } else if (types.isEmpty()) {
            TypeDeclaration decl = target == null ? (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(this.getLanguageModule(), CEYLON_ANNOTATED_TYPE, klass, ModelLoader.DeclarationType.TYPE) : this.typeFactory.getNothingDeclaration();
            annotatedType = decl.getType();
        } else {
            ArrayList<Type> list = new ArrayList<Type>(types.size());
            list.addAll(types);
            annotatedType = ModelUtil.union(list, this.getUnitForModule(module));
        }
        Type constrainedType = constrainedAnnotation.appliedType(null, Arrays.asList(klass.getType(), this.getOptionalType(klass.getType(), module), annotatedType));
        return constrainedType;
    }

    private void setParameters(Functional decl, ClassMirror classMirror, MethodMirror methodMirror, boolean isCeylon, Scope container, boolean isCoercedMethod) {
        AnnotationMirror functionalParameterAnnotation;
        ParameterList parameters = new ParameterList();
        parameters.setNamedParametersSupported(isCeylon);
        decl.addParameterList(parameters);
        int parameterCount = methodMirror.getParameters().size();
        int parameterIndex = 0;
        for (VariableMirror paramMirror : methodMirror.getParameters()) {
            Type newType;
            Type type;
            if (paramMirror.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null) continue;
            boolean isLastParameter = parameterIndex == parameterCount - 1;
            boolean isVariadic = isLastParameter && methodMirror.isVariadic();
            String paramName = this.getAnnotationStringValue(paramMirror, CEYLON_NAME_ANNOTATION);
            if (paramName == null) {
                paramName = paramMirror.getName();
            }
            Parameter parameter = new Parameter();
            parameter.setName(paramName);
            TypeMirror typeMirror = paramMirror.getType();
            Scope scope = (Scope)((Object)decl);
            Module module = ModelUtil.getModuleContainer(scope);
            boolean coercedParameter = false;
            if (isVariadic) {
                TypeMirror variadicType = typeMirror.getComponentType();
                if (isCoercedMethod && this.isCoercedType(variadicType)) {
                    type = this.applyTypeCoercion(variadicType, paramMirror, methodMirror, paramName, (Declaration)((Object)decl), module, scope);
                    coercedParameter = true;
                } else {
                    type = this.obtainType(module, variadicType, scope, TypeLocation.TOPLEVEL, VarianceLocation.CONTRAVARIANT);
                }
                if (!isCeylon && this.getUncheckedNullPolicy(isCeylon, variadicType, paramMirror) != NullStatus.NonOptional) {
                    type = this.makeOptionalTypePreserveUnderlyingType(type, module);
                }
                type = this.typeFactory.getSequentialType(type);
            } else {
                if (isCoercedMethod && this.isCoercedType(typeMirror)) {
                    type = this.applyTypeCoercion(typeMirror, paramMirror, methodMirror, paramName, (Declaration)((Object)decl), module, scope);
                    coercedParameter = true;
                } else {
                    type = this.obtainType(typeMirror, paramMirror, scope, module, VarianceLocation.CONTRAVARIANT, "parameter '" + paramName + "' of method '" + methodMirror.getName() + "'", (Declaration)((Object)decl));
                }
                if (!isCeylon && this.getUncheckedNullPolicy(isCeylon, typeMirror, paramMirror) != NullStatus.NonOptional) {
                    type = this.makeOptionalTypePreserveUnderlyingType(type, module);
                }
            }
            if (type.isCached()) {
                type = type.clone();
            }
            type.setRaw(this.isRaw(ModelUtil.getModuleContainer(container), typeMirror));
            FunctionOrValue value = null;
            boolean lookedup = false;
            if (isCeylon && decl instanceof Class) {
                value = (FunctionOrValue)((Class)decl).getDirectMember(paramName, null, false);
                boolean bl = lookedup = value != null;
            }
            if (value == null) {
                Function method;
                AnnotationMirror functionalParameterAnnotation2 = paramMirror.getAnnotation(CEYLON_FUNCTIONAL_PARAMETER_ANNOTATION);
                if (functionalParameterAnnotation2 != null) {
                    method = this.loadFunctionalParameter((Declaration)((Object)decl), paramName, type, (String)functionalParameterAnnotation2.getValue());
                    value = method;
                    parameter.setDeclaredAnything(method.isDeclaredVoid());
                } else if (coercedParameter && this.isFunctionCercion(typeMirror)) {
                    method = this.loadFunctionCoercionParameter((Declaration)((Object)decl), paramName, typeMirror, module, scope);
                    value = method;
                    parameter.setDeclaredAnything(method.isDeclaredVoid());
                } else {
                    value = isCeylon ? new Value() : new JavaParameterValue();
                    value.setType(type);
                }
                value.setContainer(scope);
                value.setScope(scope);
                ModelUtil.setVisibleScope(value);
                value.setUnit(scope.getUnit());
                value.setName(paramName);
            } else if (value instanceof Function && this.isCeylon1Dot1(classMirror) && !(newType = this.getSimpleCallableReturnType(value.getType())).isUnknown()) {
                value.setType(newType);
            }
            value.setInitializerParameter(parameter);
            value.setCoercionPoint(coercedParameter);
            parameter.setModel(value);
            if (paramMirror.getAnnotation(CEYLON_SEQUENCED_ANNOTATION) != null || isVariadic) {
                parameter.setSequenced(true);
            }
            if (paramMirror.getAnnotation(CEYLON_DEFAULTED_ANNOTATION) != null) {
                parameter.setDefaulted(true);
            }
            if (parameter.isSequenced() && this.typeFactory.isNonemptyIterableType(parameter.getType())) {
                parameter.setAtLeastOne(true);
            }
            if (!lookedup) {
                this.markUnboxed(value, null, isVariadic ? paramMirror.getType().getComponentType() : paramMirror.getType());
                this.markSmall(value, paramMirror.getType());
            }
            parameter.setDeclaration((Declaration)((Object)decl));
            value.setDeprecated(value.isDeprecated() || this.isDeprecated(paramMirror));
            this.setAnnotations(value, paramMirror, false);
            parameters.getParameters().add(parameter);
            if (!lookedup) {
                parameter.getDeclaration().getMembers().add(parameter.getModel());
            }
            ++parameterIndex;
        }
        if (decl instanceof Function && (functionalParameterAnnotation = methodMirror.getAnnotation(CEYLON_FUNCTIONAL_PARAMETER_ANNOTATION)) != null) {
            this.parameterNameParser.parseMpl((String)functionalParameterAnnotation.getValue(), ((Function)decl).getType().getFullType(), (Function)decl);
        }
    }

    private Function loadFunctionCoercionParameter(Declaration decl, String paramName, TypeMirror typeMirror, Module moduleScope, Scope scope) {
        Function method = new Function();
        method.setName(paramName);
        method.setUnit(decl.getUnit());
        try {
            FunctionalInterfaceType functionalInterfaceType = this.getFunctionalInterfaceType(typeMirror);
            MethodMirror functionalMethod = functionalInterfaceType.getMethod();
            Type returnType = this.obtainType(moduleScope, functionalInterfaceType.getReturnType(), scope, TypeLocation.TOPLEVEL, VarianceLocation.COVARIANT);
            switch (this.getUncheckedNullPolicy(false, functionalInterfaceType.getReturnType(), functionalMethod)) {
                case Optional: 
                case UncheckedNull: {
                    returnType = this.makeOptionalTypePreserveUnderlyingType(returnType, moduleScope);
                }
            }
            method.setType(returnType);
            ParameterList pl = new ParameterList();
            int count = 0;
            List<VariableMirror> functionalParameters = functionalMethod.getParameters();
            for (TypeMirror parameterType : functionalInterfaceType.getParameterTypes()) {
                Type modelParameterType = this.obtainType(moduleScope, parameterType, scope, TypeLocation.TOPLEVEL, VarianceLocation.CONTRAVARIANT);
                Parameter p = new Parameter();
                Value v = new Value();
                String name = "arg" + count++;
                p.setName(name);
                v.setName(name);
                v.setContainer(method);
                v.setScope(method);
                p.setModel(v);
                v.setInitializerParameter(p);
                switch (this.getUncheckedNullPolicy(false, parameterType, functionalMethod)) {
                    case Optional: {
                        modelParameterType = this.makeOptionalTypePreserveUnderlyingType(modelParameterType, moduleScope);
                        break;
                    }
                    case UncheckedNull: {
                        v.setUncheckedNullType(true);
                    }
                }
                v.setType(modelParameterType);
                pl.getParameters().add(p);
                method.addMember(v);
            }
            method.addParameterList(pl);
        }
        catch (ModelResolutionException x) {
            method.setType(this.logModelResolutionException(x, scope, "Failure to turn functional interface to Callable type"));
        }
        return method;
    }

    private boolean isFunctionCercion(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            ClassMirror paramClass = type.getDeclaredClass();
            return this.isFunctionalInterfaceWithExceptions(paramClass) != null;
        }
        return false;
    }

    private Type applyTypeCoercion(TypeMirror type, AnnotatedMirror annotatedMirror, MethodMirror methodMirror, String paramName, Declaration decl, Module module, Scope scope) {
        if (this.sameType(type, CHAR_SEQUENCE_TYPE)) {
            return this.typeFactory.getStringType();
        }
        if (this.sameType(type, CLASS_TYPE)) {
            Type classType = this.obtainType(type, annotatedMirror, scope, module, VarianceLocation.CONTRAVARIANT, "parameter '" + paramName + "' of method '" + methodMirror.getName() + "'", decl);
            if (classType.isUnknown() || classType.getTypeArgumentList().isEmpty()) {
                return classType;
            }
            return this.typeFactory.getClassOrInterfaceModelType(classType.getTypeArgumentList().get(0));
        }
        return this.getFunctionalInterfaceAsCallable(module, scope, type);
    }

    private Type makeOptionalTypePreserveUnderlyingType(Type type, Module module) {
        Type optionalType = this.getOptionalType(type, module);
        if (optionalType.isCached()) {
            optionalType = optionalType.clone();
        }
        optionalType.setUnderlyingType(type.getUnderlyingType());
        return optionalType;
    }

    private boolean isCeylon1Dot1(ClassMirror classMirror) {
        Integer minor;
        AnnotationMirror annotation = classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION);
        if (annotation == null) {
            return false;
        }
        Integer major = (Integer)annotation.getValue("major");
        if (major == null) {
            major = 0;
        }
        if ((minor = (Integer)annotation.getValue("minor")) == null) {
            minor = 0;
        }
        return major == 7 && minor == 0;
    }

    private Function loadFunctionalParameter(Declaration decl, String paramName, Type type, String parameterNames) {
        Function method = new Function();
        method.setName(paramName);
        method.setUnit(decl.getUnit());
        if (parameterNames == null || parameterNames.isEmpty()) {
            method.setType(this.getSimpleCallableReturnType(type));
            ParameterList pl = new ParameterList();
            int count = 0;
            for (Type pt : this.getSimpleCallableArgumentTypes(type)) {
                Parameter p = new Parameter();
                Value v = new Value();
                String name = "arg" + count++;
                p.setName(name);
                v.setName(name);
                v.setType(pt);
                v.setContainer(method);
                v.setScope(method);
                p.setModel(v);
                v.setInitializerParameter(p);
                pl.getParameters().add(p);
                method.addMember(v);
            }
            method.addParameterList(pl);
        } else {
            try {
                this.parameterNameParser.parse(parameterNames, type, method);
            }
            catch (Exception x) {
                this.logError(x.getClass().getSimpleName() + " while parsing parameter names of " + decl + ": " + x.getMessage());
                return method;
            }
        }
        return method;
    }

    List<Type> getSimpleCallableArgumentTypes(Type type) {
        if (type != null && type.isClassOrInterface() && type.getDeclaration().getQualifiedNameString().equals(CEYLON_LANGUAGE_CALLABLE_TYPE_NAME) && type.getTypeArgumentList().size() >= 2) {
            return this.flattenCallableTupleType(type.getTypeArgumentList().get(1));
        }
        return Collections.emptyList();
    }

    List<Type> flattenCallableTupleType(Type tupleType) {
        if (tupleType != null && tupleType.isClassOrInterface()) {
            String declName = tupleType.getDeclaration().getQualifiedNameString();
            if (declName.equals(CEYLON_LANGUAGE_TUPLE_TYPE_NAME)) {
                List<Type> tal = tupleType.getTypeArgumentList();
                if (tal.size() >= 3) {
                    List<Type> ret = this.flattenCallableTupleType(tal.get(2));
                    ret.add(0, tal.get(1));
                    return ret;
                }
            } else {
                if (declName.equals(CEYLON_LANGUAGE_EMPTY_TYPE_NAME)) {
                    return new LinkedList<Type>();
                }
                if (declName.equals(CEYLON_LANGUAGE_SEQUENTIAL_TYPE_NAME)) {
                    LinkedList<Type> ret = new LinkedList<Type>();
                    ret.add(tupleType);
                    return ret;
                }
                if (declName.equals(CEYLON_LANGUAGE_SEQUENCE_TYPE_NAME)) {
                    LinkedList<Type> ret = new LinkedList<Type>();
                    ret.add(tupleType);
                    return ret;
                }
            }
        }
        return Collections.emptyList();
    }

    Type getSimpleCallableReturnType(Type type) {
        if (type != null && type.isClassOrInterface() && type.getDeclaration().getQualifiedNameString().equals(CEYLON_LANGUAGE_CALLABLE_TYPE_NAME) && !type.getTypeArgumentList().isEmpty()) {
            return type.getTypeArgumentList().get(0);
        }
        return this.newUnknownType();
    }

    private Type getOptionalType(Type type, Module moduleScope) {
        if (type.isUnknown()) {
            return type;
        }
        ArrayList<Type> list = new ArrayList<Type>(2);
        list.add(this.typeFactory.getNullType());
        list.add(type);
        return ModelUtil.union(list, this.getUnitForModule(moduleScope));
    }

    private Type logModelResolutionError(Scope container, String message) {
        return this.logModelResolutionException((String)null, container, message);
    }

    private Type logModelResolutionException(ModelResolutionException x, Scope container, String message) {
        String exceptionMessage = x.getMessage();
        Throwable causer = x;
        while (causer.getCause() != null) {
            exceptionMessage = exceptionMessage + " caused by: " + causer.getCause();
            causer = causer.getCause();
        }
        return this.logModelResolutionException(exceptionMessage, container, message);
    }

    private Type logModelResolutionException(String exceptionMessage, Scope container, String message) {
        Module module = ModelUtil.getModuleContainer(container);
        return this.logModelResolutionException(exceptionMessage, module, message);
    }

    private Type logModelResolutionException(String exceptionMessage, Module module, String message) {
        UnknownType.ErrorReporter errorReporter;
        if (module != null && !module.isDefaultModule()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error while loading the ").append(module.getNameAsString()).append("/").append(module.getVersion());
            sb.append(" module:\n ");
            sb.append(message);
            if (exceptionMessage != null) {
                sb.append(":\n ").append(exceptionMessage);
            }
            errorReporter = this.makeModelErrorReporter(module, sb.toString());
        } else {
            errorReporter = exceptionMessage == null ? this.makeModelErrorReporter(message) : this.makeModelErrorReporter(message + ": " + exceptionMessage);
        }
        UnknownType ret = new UnknownType(this.typeFactory);
        ret.setErrorReporter(errorReporter);
        return ret.getType();
    }

    protected UnknownType.ErrorReporter makeModelErrorReporter(String message) {
        return new LogErrorRunnable(this, message);
    }

    protected abstract UnknownType.ErrorReporter makeModelErrorReporter(Module var1, String var2);

    private void markTypeErased(TypedDeclaration decl, AnnotatedMirror typedMirror, TypeMirror type) {
        if (BooleanUtil.isTrue(this.getAnnotationBooleanValue(typedMirror, CEYLON_TYPE_INFO_ANNOTATION, "erased"))) {
            decl.setTypeErased(true);
        } else {
            decl.setTypeErased(this.sameType(type, OBJECT_TYPE));
        }
    }

    private void markUntrustedType(TypedDeclaration decl, AnnotatedMirror typedMirror, TypeMirror type) {
        boolean untrusted = BooleanUtil.isTrue(this.getAnnotationBooleanValue(typedMirror, CEYLON_TYPE_INFO_ANNOTATION, "untrusted"));
        if ("com.redhat.ceylon.compiler.java.test.structure.klass::IterableSequence.sequence".equals(decl.getQualifiedNameString()) || "ceylon.language::Iterable.sequence".equals(decl.getQualifiedNameString())) {
            untrusted = true;
        }
        decl.setUntrustedType(untrusted);
    }

    private void markDeclaredVoid(Function decl, MethodMirror methodMirror) {
        if (methodMirror.isDeclaredVoid() || BooleanUtil.isTrue(this.getAnnotationBooleanValue(methodMirror, CEYLON_TYPE_INFO_ANNOTATION, "declaredVoid"))) {
            decl.setDeclaredVoid(true);
        }
    }

    private void markUnboxed(TypedDeclaration decl, MethodMirror methodMirror, TypeMirror type) {
        boolean unboxed = false;
        if (type.isPrimitive() || this.isPrimitiveArray(type) || this.sameType(type, STRING_TYPE) || methodMirror != null && methodMirror.isDeclaredVoid()) {
            unboxed = true;
        }
        decl.setUnboxed(unboxed);
    }

    private boolean isPrimitiveArray(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            TypeMirror componentType = type.getComponentType();
            return componentType.isPrimitive() || this.sameType(type, STRING_TYPE);
        }
        return false;
    }

    private void markSmall(FunctionOrValue value, TypeMirror type) {
        if (!value.isMember() || !value.getName().equals("hash")) {
            value.setSmall(this.sameType(type, PRIM_INT_TYPE) && !value.getType().isCharacter() || this.sameType(type, PRIM_FLOAT_TYPE) || this.sameType(type, PRIM_CHAR_TYPE));
        }
    }

    @Override
    public void complete(final LazyValue value) {
        this.synchronizedRun(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                try {
                    MethodMirror meth = AbstractModelLoader.this.getGetterMethodMirror(value, value.classMirror, value.isToplevel());
                    if (meth == null || meth.getReturnType() == null) {
                        value.setType(AbstractModelLoader.this.logModelResolutionError(value.getContainer(), "Error while resolving toplevel attribute " + value.getQualifiedNameString() + ": getter method missing"));
                        return;
                    }
                    value.setDeprecated(value.isDeprecated() | AbstractModelLoader.this.isDeprecated(meth));
                    value.setType(AbstractModelLoader.this.obtainType(meth.getReturnType(), meth, null, ModelUtil.getModuleContainer(value.getContainer()), VarianceLocation.INVARIANT, "toplevel attribute", value));
                    AbstractModelLoader.this.markVariable(value);
                    AbstractModelLoader.this.setValueTransientLateFlags(value, meth, true);
                    AbstractModelLoader.this.setAnnotations(value, meth, value.isNativeHeader());
                    AbstractModelLoader.this.markUnboxed(value, meth, meth.getReturnType());
                    AbstractModelLoader.this.markSmall(value, meth.getReturnType());
                    AbstractModelLoader.this.markTypeErased(value, meth, meth.getReturnType());
                    TypeMirror setterClass = (TypeMirror)AbstractModelLoader.this.getAnnotationValue(value.classMirror, AbstractModelLoader.CEYLON_ATTRIBUTE_ANNOTATION, "setterClass");
                    if (setterClass != null && !setterClass.isPrimitive()) {
                        ClassMirror setterClassMirror = setterClass.getDeclaredClass();
                        value.setVariable(true);
                        SetterWithLocalDeclarations setter = AbstractModelLoader.this.makeSetter(value, setterClassMirror);
                        AbstractModelLoader.this.addLocalDeclarations(value, value.classMirror, value.classMirror);
                        AbstractModelLoader.this.addLocalDeclarations(setter, setterClassMirror, setterClassMirror);
                    } else if (value.isToplevel() && value.isTransient() && value.isVariable()) {
                        AbstractModelLoader.this.makeSetter(value, value.classMirror);
                        AbstractModelLoader.this.addLocalDeclarations(value, value.classMirror, value.classMirror);
                    } else {
                        AbstractModelLoader.this.addLocalDeclarations(value, value.classMirror, value.classMirror);
                    }
                }
                finally {
                    AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                }
            }
        });
    }

    private MethodMirror getGetterMethodMirror(Declaration value, ClassMirror classMirror, boolean toplevel) {
        MethodMirror meth = null;
        String getterName = toplevel ? NamingBase.Unfix.get_.name() : NamingBase.getGetterName(value);
        for (MethodMirror m : classMirror.getDirectMethods()) {
            if (!m.getName().equals(getterName) || toplevel && !m.isStatic() || m.getParameters().size() != 0) continue;
            meth = m;
            break;
        }
        return meth;
    }

    private void markVariable(LazyValue value) {
        String setterName = NamingBase.getSetterName(value);
        boolean toplevel = value.isToplevel();
        for (MethodMirror m : value.classMirror.getDirectMethods()) {
            if (!m.getName().equals(setterName) || toplevel && !m.isStatic() || m.getParameters().size() != 1) continue;
            value.setVariable(true);
        }
    }

    private SetterWithLocalDeclarations makeSetter(Value value, ClassMirror classMirror) {
        SetterWithLocalDeclarations setter = new SetterWithLocalDeclarations(classMirror);
        Scope scope = value.getContainer();
        setter.setContainer(scope);
        setter.setScope(scope);
        setter.setType(value.getType());
        setter.setName(value.getName());
        Parameter p = new Parameter();
        p.setHidden(true);
        Value v = new Value();
        v.setType(value.getType());
        v.setUnboxed(value.getUnboxed());
        v.setInitializerParameter(p);
        v.setContainer(setter);
        v.setScope(setter);
        p.setModel(v);
        v.setName(setter.getName());
        p.setName(setter.getName());
        p.setDeclaration(setter);
        setter.setParameter(p);
        value.setSetter(setter);
        setter.setGetter(value);
        return setter;
    }

    @Override
    public void complete(final LazyFunction method) {
        this.synchronizedRun(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractModelLoader.this.timer.startIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                try {
                    MethodMirror meth = AbstractModelLoader.this.getFunctionMethodMirror(method);
                    if (meth == null || meth.getReturnType() == null) {
                        method.setType(AbstractModelLoader.this.logModelResolutionError(method.getContainer(), "Error while resolving toplevel method " + method.getQualifiedNameString() + ": static method missing"));
                        return;
                    }
                    if (!method.classMirror.isLocalClass() && !meth.isStatic()) {
                        method.setType(AbstractModelLoader.this.logModelResolutionError(method.getContainer(), "Error while resolving toplevel method " + method.getQualifiedNameString() + ": method is not static"));
                        return;
                    }
                    method.setDeprecated(method.isDeprecated() | AbstractModelLoader.this.isDeprecated(meth));
                    method.setRealMethodName(meth.getName());
                    method.setMethodMirror(meth);
                    AbstractModelLoader.this.setTypeParameters(method, meth, true);
                    method.setType(AbstractModelLoader.this.obtainType(meth.getReturnType(), meth, method, ModelUtil.getModuleContainer(method), VarianceLocation.COVARIANT, "toplevel method", method));
                    method.setDeclaredVoid(meth.isDeclaredVoid());
                    AbstractModelLoader.this.markDeclaredVoid(method, meth);
                    AbstractModelLoader.this.markUnboxed(method, meth, meth.getReturnType());
                    AbstractModelLoader.this.markSmall(method, meth.getReturnType());
                    AbstractModelLoader.this.markTypeErased(method, meth, meth.getReturnType());
                    AbstractModelLoader.this.markUntrustedType(method, meth, meth.getReturnType());
                    AbstractModelLoader.this.setParameters(method, method.classMirror, meth, true, method, false);
                    method.setAnnotation(meth.getAnnotation(AbstractModelLoader.CEYLON_LANGUAGE_ANNOTATION_ANNOTATION) != null);
                    AbstractModelLoader.this.setAnnotations(method, meth, method.isNativeHeader());
                    AbstractModelLoader.this.setAnnotationConstructor(method, meth);
                    AbstractModelLoader.this.addLocalDeclarations(method, method.classMirror, method.classMirror);
                }
                finally {
                    AbstractModelLoader.this.timer.stopIgnore(AbstractModelLoader.TIMER_MODEL_LOADER_CATEGORY);
                }
            }
        });
    }

    private MethodMirror getFunctionMethodMirror(LazyFunction method) {
        MethodMirror meth = null;
        String lookupName = method.getName();
        for (MethodMirror m : method.classMirror.getDirectMethods()) {
            if (m.getAnnotation(CEYLON_IGNORE_ANNOTATION) != null || !NamingBase.stripLeadingDollar(m.getName()).equals(lookupName)) continue;
            meth = m;
            break;
        }
        return meth;
    }

    protected abstract void setAnnotationConstructor(LazyFunction var1, MethodMirror var2);

    public AnnotationProxyMethod makeInteropAnnotationConstructor(LazyInterface iface, AnnotationProxyClass klass, OutputElement oe, Scope scope) {
        String ctorName = oe == null ? NamingBase.getJavaBeanName(iface.getName()) : NamingBase.getDisambigAnnoCtorName(iface, oe);
        AnnotationProxyMethod ctor = new AnnotationProxyMethod(this, klass, oe);
        ctor.setAnnotationTarget(oe);
        ctor.setContainer(scope);
        ctor.setScope(scope);
        if (!(scope instanceof Package)) {
            ctor.setStatic(true);
        }
        ctor.setAnnotation(true);
        ctor.setName(ctorName);
        ctor.setShared(iface.isShared());
        Annotation annotationAnnotation2 = new Annotation();
        annotationAnnotation2.setName("annotation");
        ctor.getAnnotations().add(annotationAnnotation2);
        ctor.setType(((TypeDeclaration)iface).getType());
        ctor.setUnit(iface.getUnit());
        return ctor;
    }

    protected abstract void makeInteropAnnotationConstructorInvocation(AnnotationProxyMethod var1, AnnotationProxyClass var2, List<Parameter> var3);

    public AnnotationProxyClass makeInteropAnnotationClass(LazyInterface iface, Scope scope) {
        AnnotationProxyClass klass = new AnnotationProxyClass(this, iface);
        klass.setContainer(scope);
        klass.setScope(scope);
        if (!(scope instanceof Package)) {
            klass.setStatic(true);
        }
        klass.setName(iface.getName() + "$Proxy");
        klass.setShared(iface.isShared());
        klass.setAnnotation(true);
        Annotation annotationAnnotation = new Annotation();
        annotationAnnotation.setName("annotation");
        klass.getAnnotations().add(annotationAnnotation);
        klass.getSatisfiedTypes().add(iface.getType());
        klass.setUnit(iface.getUnit());
        klass.setScope(scope);
        return klass;
    }

    private Type annotationParameterType(Unit unit, JavaMethod m) {
        Type type = m.getType();
        if (JvmBackendUtil.isJavaArray(type.getDeclaration())) {
            Type elementType;
            String name = type.getDeclaration().getQualifiedNameString();
            String underlyingType = null;
            if (name.equals("java.lang::ObjectArray")) {
                Type eType = type.getTypeArgumentList().get(0);
                String elementTypeName = eType.getDeclaration().getQualifiedNameString();
                if ("java.lang::String".equals(elementTypeName)) {
                    elementType = unit.getStringType();
                } else if ("java.lang::Class".equals(elementTypeName) || "java.lang.Class".equals(eType.getUnderlyingType())) {
                    elementType = unit.getAnythingType();
                    underlyingType = "java.lang.Class";
                } else {
                    elementType = eType;
                    if (elementType.isCached()) {
                        elementType = type.clone();
                        type.getTypeArgumentList().set(0, elementType);
                    }
                }
            } else if (name.equals("java.lang::LongArray")) {
                elementType = unit.getIntegerType();
            } else if (name.equals("java.lang::ByteArray")) {
                elementType = unit.getByteType();
            } else if (name.equals("java.lang::ShortArray")) {
                elementType = unit.getIntegerType();
                underlyingType = "short";
            } else if (name.equals("java.lang::IntArray")) {
                elementType = unit.getIntegerType();
                underlyingType = "int";
            } else if (name.equals("java.lang::BooleanArray")) {
                elementType = unit.getBooleanType();
            } else if (name.equals("java.lang::CharArray")) {
                elementType = unit.getCharacterType();
                underlyingType = "char";
            } else if (name.equals("java.lang::DoubleArray")) {
                elementType = unit.getFloatType();
            } else if (name.equals("java.lang::FloatArray")) {
                elementType = unit.getFloatType();
                underlyingType = "float";
            } else {
                throw new RuntimeException();
            }
            if (elementType.isCached()) {
                elementType = elementType.clone();
            }
            elementType.setUnderlyingType(underlyingType);
            Type iterableType = unit.getIterableType(elementType);
            return iterableType;
        }
        if ("java.lang::Class".equals(type.getDeclaration().getQualifiedNameString())) {
            return this.typeFactory.getClassOrInterfaceDeclarationType();
        }
        return type;
    }

    private List<String> getSatisfiedTypesFromAnnotations(AnnotatedMirror symbol) {
        return this.getAnnotationArrayValue(symbol, CEYLON_SATISFIED_TYPES_ANNOTATION);
    }

    private void setSatisfiedTypes(ClassOrInterface klass, ClassMirror classMirror) {
        List<String> satisfiedTypes = this.getSatisfiedTypesFromAnnotations(classMirror);
        if (satisfiedTypes != null) {
            klass.getSatisfiedTypes().addAll(this.getTypesList(satisfiedTypes, klass, ModelUtil.getModuleContainer(klass), "satisfied types", klass.getQualifiedNameString()));
        } else {
            if (classMirror.isAnnotationType()) {
                klass.getSatisfiedTypes().add(this.getJavaAnnotationExtendedType(klass, classMirror));
            }
            for (TypeMirror iface : classMirror.getInterfaces()) {
                if (this.sameType(iface, CEYLON_REIFIED_TYPE_TYPE) || this.sameType(iface, CEYLON_SERIALIZABLE_TYPE) || classMirror.getAnnotation(CEYLON_CEYLON_ANNOTATION) != null && this.sameType(iface, JAVA_IO_SERIALIZABLE_TYPE_TYPE)) continue;
                try {
                    klass.getSatisfiedTypes().add(this.getNonPrimitiveType(ModelUtil.getModule(klass), iface, klass, VarianceLocation.INVARIANT));
                }
                catch (ModelResolutionException x) {
                    ClassMirror ifaceClass;
                    String ifacePackageName;
                    String classPackageName = this.unquotePackageName(classMirror.getPackage());
                    if (!this.jdkProvider.isJDKPackage(classPackageName) || iface.getKind() != TypeKind.DECLARED || !this.jdkProvider.isJDKPackage(ifacePackageName = this.unquotePackageName((ifaceClass = iface.getDeclaredClass()).getPackage()))) continue;
                    this.logMissingOracleType(iface.getQualifiedName());
                }
            }
        }
    }

    private List<String> getCaseTypesFromAnnotations(AnnotatedMirror symbol) {
        return this.getAnnotationArrayValue(symbol, CEYLON_CASE_TYPES_ANNOTATION);
    }

    private String getSelfTypeFromAnnotations(AnnotatedMirror symbol) {
        return this.getAnnotationStringValue(symbol, CEYLON_CASE_TYPES_ANNOTATION, "of");
    }

    private void setCaseTypes(ClassOrInterface klass, ClassMirror classMirror) {
        if (classMirror.isEnum()) {
            ArrayList<Type> caseTypes = new ArrayList<Type>();
            for (Declaration member : klass.getMembers()) {
                if (!(member instanceof FieldValue) || !((FieldValue)member).isEnumValue()) continue;
                caseTypes.add(((FieldValue)member).getType());
            }
            klass.setCaseTypes(caseTypes);
        } else {
            String selfType = this.getSelfTypeFromAnnotations(classMirror);
            Module moduleScope = ModelUtil.getModuleContainer(klass);
            if (selfType != null && !selfType.isEmpty()) {
                Type type = this.decodeType(selfType, klass, moduleScope, "self type");
                if (!type.isTypeParameter()) {
                    this.logError("Invalid type signature for self type of " + klass.getQualifiedNameString() + ": " + selfType + " is not a type parameter");
                } else {
                    klass.setSelfType(type);
                    LinkedList<Type> caseTypes = new LinkedList<Type>();
                    caseTypes.add(type);
                    klass.setCaseTypes(caseTypes);
                }
            } else {
                List<String> caseTypes = this.getCaseTypesFromAnnotations(classMirror);
                if (caseTypes != null && !caseTypes.isEmpty()) {
                    klass.setCaseTypes(this.getTypesList(caseTypes, klass, moduleScope, "case types", klass.getQualifiedNameString()));
                }
            }
        }
    }

    private List<Type> getTypesList(List<String> caseTypes, Scope scope, Module moduleScope, String targetType, String targetName) {
        LinkedList<Type> producedTypes = new LinkedList<Type>();
        for (String type : caseTypes) {
            producedTypes.add(this.decodeType(type, scope, moduleScope, targetType));
        }
        return producedTypes;
    }

    private List<AnnotationMirror> getTypeParametersFromAnnotations(AnnotatedMirror symbol) {
        return (List)this.getAnnotationValue(symbol, CEYLON_TYPE_PARAMETERS);
    }

    private void setTypeParametersFromAnnotations(Scope scope, List<TypeParameter> params, AnnotatedMirror mirror, List<AnnotationMirror> typeParameterAnnotations, List<TypeParameterMirror> typeParameterMirrors) {
        String selfTypeName = this.getSelfTypeFromAnnotations(mirror);
        int i = 0;
        for (AnnotationMirror typeParamAnnotation : typeParameterAnnotations) {
            String varianceName;
            TypeParameter param = new TypeParameter();
            param.setUnit(scope.getUnit());
            param.setContainer(scope);
            param.setScope(scope);
            ModelUtil.setVisibleScope(param);
            param.setDeclaration((Declaration)((Object)scope));
            if (scope instanceof LazyContainer) {
                ((LazyContainer)scope).addMember(param);
            } else {
                scope.addMember(param);
            }
            param.setName((String)typeParamAnnotation.getValue("value"));
            param.setExtendedType(this.typeFactory.getAnythingType());
            if (i < typeParameterMirrors.size()) {
                TypeParameterMirror typeParameterMirror = typeParameterMirrors.get(i);
                param.setNonErasedBounds(this.hasNonErasedBounds(typeParameterMirror));
            }
            if ((varianceName = (String)typeParamAnnotation.getValue("variance")) != null) {
                if (varianceName.equals("IN")) {
                    param.setContravariant(true);
                } else if (varianceName.equals("OUT")) {
                    param.setCovariant(true);
                }
            }
            if (param.getName().equals(selfTypeName)) {
                param.setSelfTypedDeclaration((TypeDeclaration)scope);
            }
            params.add(param);
            ++i;
        }
        Module moduleScope = ModelUtil.getModuleContainer(scope);
        Iterator<TypeParameter> paramsIterator = params.iterator();
        for (AnnotationMirror typeParamAnnotation : typeParameterAnnotations) {
            TypeParameter param = paramsIterator.next();
            List satisfiesAttribute = (List)typeParamAnnotation.getValue("satisfies");
            this.setListOfTypes(param.getSatisfiedTypes(), satisfiesAttribute, scope, moduleScope, "type parameter '" + param.getName() + "' satisfied types");
            List caseTypesAttribute = (List)typeParamAnnotation.getValue("caseTypes");
            if (caseTypesAttribute != null && !caseTypesAttribute.isEmpty()) {
                param.setCaseTypes(new LinkedList<Type>());
            }
            this.setListOfTypes(param.getCaseTypes(), caseTypesAttribute, scope, moduleScope, "type parameter '" + param.getName() + "' case types");
            String defaultValueAttribute = (String)typeParamAnnotation.getValue("defaultValue");
            if (defaultValueAttribute == null || defaultValueAttribute.isEmpty()) continue;
            Type decodedType = this.decodeType(defaultValueAttribute, scope, moduleScope, "type parameter '" + param.getName() + "' defaultValue");
            param.setDefaultTypeArgument(decodedType);
            param.setDefaulted(true);
        }
    }

    private boolean hasNonErasedBounds(TypeParameterMirror typeParameterMirror) {
        List<TypeMirror> bounds = typeParameterMirror.getBounds();
        return bounds.size() > 0 && (bounds.size() != 1 || !this.sameType(bounds.get(0), OBJECT_TYPE));
    }

    private void setListOfTypes(List<Type> destinationTypeList, List<String> serialisedTypes, Scope scope, Module moduleScope, String targetType) {
        if (serialisedTypes != null) {
            for (String serialisedType : serialisedTypes) {
                Type decodedType = this.decodeType(serialisedType, scope, moduleScope, targetType);
                destinationTypeList.add(decodedType);
            }
        }
    }

    private void setTypeParameters(Scope scope, List<TypeParameter> params, List<TypeParameterMirror> typeParameters, boolean isCeylon) {
        for (TypeParameterMirror typeParam : typeParameters) {
            TypeParameter param = new TypeParameter();
            param.setUnit(scope.getUnit());
            param.setContainer(scope);
            param.setScope(scope);
            ModelUtil.setVisibleScope(param);
            param.setDeclaration((Declaration)((Object)scope));
            if (scope instanceof LazyContainer) {
                ((LazyContainer)scope).addMember(param);
            } else {
                scope.addMember(param);
            }
            param.setName(typeParam.getName());
            param.setExtendedType(this.typeFactory.getAnythingType());
            params.add(param);
        }
        boolean needsObjectBounds = !isCeylon && scope instanceof Function;
        Iterator<TypeParameter> paramsIterator = params.iterator();
        for (TypeParameterMirror typeParam : typeParameters) {
            TypeParameter param = paramsIterator.next();
            List<TypeMirror> bounds = typeParam.getBounds();
            for (TypeMirror bound : bounds) {
                Type boundType;
                if (this.sameType(bound, OBJECT_TYPE)) {
                    if (bounds.size() == 1) break;
                    boundType = this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_OBJECT_TYPE, scope, VarianceLocation.INVARIANT);
                } else {
                    boundType = this.getNonPrimitiveType(ModelUtil.getModuleContainer(scope), bound, scope, VarianceLocation.INVARIANT);
                }
                param.getSatisfiedTypes().add(boundType);
            }
            if (!needsObjectBounds || !param.getSatisfiedTypes().isEmpty()) continue;
            Type boundType = this.getNonPrimitiveType(this.getLanguageModule(), CEYLON_OBJECT_TYPE, scope, VarianceLocation.INVARIANT);
            param.getSatisfiedTypes().add(boundType);
        }
    }

    private void setTypeParameters(Function method, MethodMirror methodMirror, boolean isCeylon) {
        LinkedList<TypeParameter> params = new LinkedList<TypeParameter>();
        method.setTypeParameters(params);
        List<AnnotationMirror> typeParameters = this.getTypeParametersFromAnnotations(methodMirror);
        if (typeParameters != null) {
            this.setTypeParametersFromAnnotations(method, params, methodMirror, typeParameters, methodMirror.getTypeParameters());
        } else {
            List<TypeParameterMirror> jtp = methodMirror.getTypeParameters();
            if (method.isStatic() && (methodMirror.isPublic() || methodMirror.isProtected() || methodMirror.isDefaultAccess()) && isCeylon) {
                jtp = jtp.subList(((ClassOrInterface)method.getContainer()).getTypeParameters().size(), jtp.size());
            }
            this.setTypeParameters(method, params, jtp, isCeylon);
        }
    }

    private void setTypeParameters(TypeDeclaration klass, ClassMirror classMirror, boolean isCeylon) {
        List<AnnotationMirror> typeParameters = this.getTypeParametersFromAnnotations(classMirror);
        List<TypeParameterMirror> mirrorTypeParameters = classMirror.getTypeParameters();
        if (typeParameters != null) {
            if (typeParameters.isEmpty()) {
                return;
            }
            ArrayList<TypeParameter> params = new ArrayList<TypeParameter>(typeParameters.size());
            klass.setTypeParameters(params);
            this.setTypeParametersFromAnnotations(klass, params, classMirror, typeParameters, mirrorTypeParameters);
        } else {
            if (mirrorTypeParameters.isEmpty()) {
                return;
            }
            ArrayList<TypeParameter> params = new ArrayList<TypeParameter>(mirrorTypeParameters.size());
            klass.setTypeParameters(params);
            this.setTypeParameters(klass, params, mirrorTypeParameters, isCeylon);
        }
    }

    private Type decodeType(String value, Scope scope, Module moduleScope, String targetType) {
        return this.decodeType(value, scope, moduleScope, targetType, null);
    }

    private Type decodeType(String value, Scope scope, Module moduleScope, String targetType, Declaration target) {
        try {
            return this.typeParser.decodeType(value, scope, moduleScope, this.getUnitForModule(moduleScope));
        }
        catch (TypeParserException x) {
            String text = this.formatTypeErrorMessage("Error while parsing type of", targetType, target, scope);
            return this.logModelResolutionException(x.getMessage(), scope, text);
        }
        catch (ModelResolutionException x) {
            String text = this.formatTypeErrorMessage("Error while resolving type of", targetType, target, scope);
            return this.logModelResolutionException(x, scope, text);
        }
    }

    private Unit getUnitForModule(Module module) {
        List<Package> packages = module.getPackages();
        if (packages.isEmpty()) {
            System.err.println("No package for module " + module.getNameAsString());
            return null;
        }
        Package pkg = packages.get(0);
        if (!(pkg instanceof LazyPackage)) {
            System.err.println("No lazy package for module " + module.getNameAsString());
            return null;
        }
        Unit unit = this.getCompiledUnit((LazyPackage)pkg, null);
        if (unit == null) {
            System.err.println("No unit for module " + module.getNameAsString());
            return null;
        }
        return unit;
    }

    private String formatTypeErrorMessage(String prefix, String targetType, Declaration target, Scope scope) {
        String forTarget = target != null ? " for " + target.getQualifiedNameString() : (scope != null ? " for " + scope.getQualifiedNameString() : "");
        return prefix + " " + targetType + forTarget;
    }

    private Type obtainType(TypeMirror type, AnnotatedMirror symbol, Scope scope, Module moduleScope, VarianceLocation variance, String targetType, Declaration target) {
        String typeName = this.getAnnotationStringValue(symbol, CEYLON_TYPE_INFO_ANNOTATION);
        if (typeName != null) {
            Type ret = this.decodeType(typeName, scope, moduleScope, targetType, target);
            if (ret.isCached()) {
                ret = ret.clone();
            }
            ret.setUnderlyingType(this.getUnderlyingType(type, TypeLocation.TOPLEVEL));
            return ret;
        }
        try {
            return this.obtainType(moduleScope, type, scope, TypeLocation.TOPLEVEL, variance);
        }
        catch (ModelResolutionException x) {
            String text = this.formatTypeErrorMessage("Error while resolving type of", targetType, target, scope);
            return this.logModelResolutionException(x, scope, text);
        }
    }

    private String getUnderlyingType(TypeMirror type, TypeLocation location) {
        if (this.sameType(type, STRING_TYPE) && location != TypeLocation.TYPE_PARAM || this.sameType(type, PRIM_BYTE_TYPE) || this.sameType(type, PRIM_SHORT_TYPE) || this.sameType(type, PRIM_INT_TYPE) || this.sameType(type, PRIM_FLOAT_TYPE) || this.sameType(type, PRIM_CHAR_TYPE)) {
            return type.getQualifiedName();
        }
        return null;
    }

    public Type obtainType(Module moduleScope, TypeMirror type, Scope scope, TypeLocation location, VarianceLocation variance) {
        TypeMirror originalType = type;
        Type ret = this.getNonPrimitiveType(moduleScope, type = this.applyTypeMapping(type, location), scope, variance);
        if (ret.isCached()) {
            ret = ret.clone();
        }
        if (ret.getUnderlyingType() == null) {
            ret.setUnderlyingType(this.getUnderlyingType(originalType, location));
        }
        return ret;
    }

    protected boolean isFunctionalInterfaceType(TypeMirror typeMirror) {
        return false;
    }

    protected String isFunctionalInterfaceWithExceptions(ClassMirror klass) {
        if (klass.getQualifiedName().equals("java.util.Iterable") || klass.getQualifiedName().equals("java.lang.annotation.Annotation")) {
            return null;
        }
        return this.isFunctionalInterface(klass);
    }

    protected String isFunctionalInterface(ClassMirror klass) {
        return null;
    }

    protected FunctionalInterfaceType getFunctionalInterfaceType(TypeMirror typeMirror) throws ModelResolutionException {
        return null;
    }

    private Type getFunctionalInterfaceAsCallable(Module moduleScope, Scope scope, TypeMirror typeMirror) {
        try {
            FunctionalInterfaceType functionalInterfaceType = this.getFunctionalInterfaceType(typeMirror);
            Type returnType = this.obtainType(moduleScope, functionalInterfaceType.getReturnType(), scope, TypeLocation.TOPLEVEL, VarianceLocation.COVARIANT);
            ArrayList<Type> modelParameterTypes = new ArrayList<Type>(functionalInterfaceType.getParameterTypes().size());
            for (TypeMirror parameterType : functionalInterfaceType.getParameterTypes()) {
                Type modelParameterType = this.obtainType(moduleScope, parameterType, scope, TypeLocation.TOPLEVEL, VarianceLocation.CONTRAVARIANT);
                modelParameterTypes.add(modelParameterType);
            }
            Type parameterTuple = this.typeFactory.getTupleType(modelParameterTypes, functionalInterfaceType.isVariadic(), false, -1);
            Type callableType = this.typeFactory.getCallableDeclaration().appliedType(null, Arrays.asList(returnType, parameterTuple));
            return callableType;
        }
        catch (ModelResolutionException x) {
            return this.logModelResolutionException(x, scope, "Failure to turn functional interface to Callable type");
        }
    }

    private TypeMirror applyTypeMapping(TypeMirror type, TypeLocation location) {
        if (this.sameType(type, STRING_TYPE) && location != TypeLocation.TYPE_PARAM) {
            return CEYLON_STRING_TYPE;
        }
        if (this.sameType(type, PRIM_BOOLEAN_TYPE)) {
            return CEYLON_BOOLEAN_TYPE;
        }
        if (this.sameType(type, PRIM_BYTE_TYPE)) {
            return CEYLON_BYTE_TYPE;
        }
        if (this.sameType(type, PRIM_SHORT_TYPE)) {
            return CEYLON_INTEGER_TYPE;
        }
        if (this.sameType(type, PRIM_INT_TYPE)) {
            return CEYLON_INTEGER_TYPE;
        }
        if (this.sameType(type, PRIM_LONG_TYPE)) {
            return CEYLON_INTEGER_TYPE;
        }
        if (this.sameType(type, PRIM_FLOAT_TYPE)) {
            return CEYLON_FLOAT_TYPE;
        }
        if (this.sameType(type, PRIM_DOUBLE_TYPE)) {
            return CEYLON_FLOAT_TYPE;
        }
        if (this.sameType(type, PRIM_CHAR_TYPE)) {
            return CEYLON_CHARACTER_TYPE;
        }
        if (this.sameType(type, OBJECT_TYPE)) {
            return CEYLON_OBJECT_TYPE;
        }
        if (this.sameType(type, THROWABLE_TYPE)) {
            return CEYLON_THROWABLE_TYPE;
        }
        if (this.sameType(type, EXCEPTION_TYPE)) {
            return CEYLON_EXCEPTION_TYPE;
        }
        if (this.sameType(type, ANNOTATION_TYPE)) {
            return CEYLON_ANNOTATION_TYPE;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            TypeMirror ct = type.getComponentType();
            if (this.sameType(ct, PRIM_BOOLEAN_TYPE)) {
                return JAVA_BOOLEAN_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_BYTE_TYPE)) {
                return JAVA_BYTE_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_SHORT_TYPE)) {
                return JAVA_SHORT_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_INT_TYPE)) {
                return JAVA_INT_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_LONG_TYPE)) {
                return JAVA_LONG_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_FLOAT_TYPE)) {
                return JAVA_FLOAT_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_DOUBLE_TYPE)) {
                return JAVA_DOUBLE_ARRAY_TYPE;
            }
            if (this.sameType(ct, PRIM_CHAR_TYPE)) {
                return JAVA_CHAR_ARRAY_TYPE;
            }
            return new SimpleReflType(JAVA_LANG_OBJECT_ARRAY, SimpleReflType.Module.JDK, TypeKind.DECLARED, ct);
        }
        return type;
    }

    private boolean sameType(TypeMirror t1, TypeMirror t2) {
        if (t1.getKind() == TypeKind.ARRAY) {
            if (t2.getKind() != TypeKind.ARRAY) {
                return false;
            }
            return this.sameType(t1.getComponentType(), t2.getComponentType());
        }
        if (t2.getKind() == TypeKind.ARRAY) {
            return false;
        }
        return t1.getQualifiedName().equals(t2.getQualifiedName());
    }

    @Override
    public Declaration getDeclaration(Module module, String typeName, ModelLoader.DeclarationType declarationType) {
        return this.convertToDeclaration(module, typeName, declarationType);
    }

    private Type getNonPrimitiveType(Module moduleScope, TypeMirror type, Scope scope, VarianceLocation variance) {
        TypeDeclaration declaration = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(moduleScope, type, scope, ModelLoader.DeclarationType.TYPE);
        if (declaration == null) {
            throw new ModelResolutionException("Failed to find declaration for " + type.getQualifiedName());
        }
        return this.applyTypeArguments(moduleScope, declaration, type, scope, variance, TypeMappingMode.NORMAL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type applyTypeArguments(Module moduleScope, TypeDeclaration declaration, TypeMirror type, Scope scope, VarianceLocation variance, TypeMappingMode mode, Set<TypeDeclaration> rawDeclarationsSeen) {
        boolean isRaw;
        List<TypeMirror> javacTypeArguments = type.getTypeArguments();
        boolean hasTypeParameters = !declaration.getTypeParameters().isEmpty();
        boolean hasTypeArguments = !javacTypeArguments.isEmpty();
        boolean bl = isRaw = !hasTypeArguments && hasTypeParameters;
        if (hasTypeArguments || isRaw) {
            if (rawDeclarationsSeen == null) {
                rawDeclarationsSeen = new HashSet<TypeDeclaration>();
            }
            if (rawDeclarationsSeen != null && !rawDeclarationsSeen.add(declaration)) {
                throw new RecursiveTypeParameterBoundException();
            }
            try {
                ArrayList<Type> typeArguments = new ArrayList<Type>(javacTypeArguments.size());
                List<TypeParameter> typeParameters = declaration.getTypeParameters();
                List<TypeParameterMirror> typeParameterMirrors = null;
                if (type.getDeclaredClass() != null) {
                    typeParameterMirrors = type.getDeclaredClass().getTypeParameters();
                }
                HashMap<TypeParameter, SiteVariance> siteVarianceMap = null;
                int len = hasTypeArguments ? javacTypeArguments.size() : typeParameters.size();
                for (int i = 0; i < len; ++i) {
                    TypeParameterMirror typeParameterMirror;
                    TypeParameter typeParameter = null;
                    if (i < typeParameters.size()) {
                        typeParameter = typeParameters.get(i);
                    }
                    Type producedTypeArgument = null;
                    TypeMirror typeArgument = null;
                    SiteVariance siteVariance = null;
                    if (hasTypeArguments && (typeArgument = javacTypeArguments.get(i)).getKind() == TypeKind.WILDCARD) {
                        TypeMirror bound = typeArgument.getUpperBound();
                        if (bound != null) {
                            siteVariance = SiteVariance.OUT;
                        } else {
                            bound = typeArgument.getLowerBound();
                            if (bound != null) {
                                siteVariance = SiteVariance.IN;
                            }
                        }
                        typeArgument = bound;
                    }
                    if (typeArgument == null && typeParameterMirrors != null && i < typeParameterMirrors.size() && (typeParameterMirror = typeParameterMirrors.get(i)).getBounds().size() == 1) {
                        if (rawDeclarationsSeen == null && !(rawDeclarationsSeen = new HashSet<TypeDeclaration>()).add(declaration)) {
                            throw new RecursiveTypeParameterBoundException();
                        }
                        TypeMirror bound = typeParameterMirror.getBounds().get(0);
                        try {
                            producedTypeArgument = this.obtainTypeParameterBound(moduleScope, bound, declaration, rawDeclarationsSeen);
                            siteVariance = SiteVariance.OUT;
                        }
                        catch (RecursiveTypeParameterBoundException recursiveTypeParameterBoundException) {
                            // empty catch block
                        }
                    }
                    if (typeArgument == null && producedTypeArgument == null) {
                        producedTypeArgument = this.typeFactory.getObjectType();
                        siteVariance = SiteVariance.OUT;
                    }
                    if (!JvmBackendUtil.isCeylon(declaration) && siteVariance != null) {
                        if (siteVarianceMap == null) {
                            siteVarianceMap = new HashMap<TypeParameter, SiteVariance>();
                        }
                        siteVarianceMap.put(typeParameter, siteVariance);
                    }
                    if (producedTypeArgument == null) {
                        producedTypeArgument = mode == TypeMappingMode.NORMAL ? this.obtainType(moduleScope, typeArgument, scope, TypeLocation.TYPE_PARAM, variance) : this.obtainTypeParameterBound(moduleScope, typeArgument, scope, rawDeclarationsSeen);
                    }
                    typeArguments.add(producedTypeArgument);
                }
                Type qualifyingType = null;
                if (type.getQualifyingType() != null) {
                    qualifyingType = this.getNonPrimitiveType(moduleScope, type.getQualifyingType(), scope, variance);
                }
                Type ret = declaration.appliedType(qualifyingType, typeArguments);
                if (siteVarianceMap != null) {
                    ret.setVarianceOverrides(siteVarianceMap);
                }
                if (ret.isCached()) {
                    ret = ret.clone();
                }
                ret.setUnderlyingType(type.getQualifiedName());
                ret.setRaw(isRaw);
                Type type2 = ret;
                return type2;
            }
            finally {
                if (rawDeclarationsSeen != null) {
                    rawDeclarationsSeen.remove(declaration);
                }
            }
        }
        if (type.getQualifyingType() != null) {
            Type qualifyingType = this.getNonPrimitiveType(moduleScope, type.getQualifyingType(), scope, variance);
            Type ret = declaration.appliedType(qualifyingType, Collections.emptyList());
            if (ret.isCached()) {
                ret = ret.clone();
            }
            ret.setUnderlyingType(type.getQualifiedName());
            ret.setRaw(isRaw);
            return ret;
        }
        return declaration.getType();
    }

    private Type obtainTypeParameterBound(Module moduleScope, TypeMirror type, Scope scope, Set<TypeDeclaration> rawDeclarationsSeen) {
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeParameterMirror typeParameter = type.getTypeParameter();
            if (!typeParameter.getBounds().isEmpty()) {
                ArrayList<Type> bounds = new ArrayList<Type>(typeParameter.getBounds().size());
                for (TypeMirror bound : typeParameter.getBounds()) {
                    Type boundModel = this.obtainTypeParameterBound(moduleScope, bound, scope, rawDeclarationsSeen);
                    bounds.add(boundModel);
                }
                return ModelUtil.intersection(bounds, this.getUnitForModule(moduleScope));
            }
            return this.typeFactory.getObjectType();
        }
        TypeMirror mappedType = this.applyTypeMapping(type, TypeLocation.TYPE_PARAM);
        TypeDeclaration declaration = (TypeDeclaration)this.convertNonPrimitiveTypeToDeclaration(moduleScope, mappedType, scope, ModelLoader.DeclarationType.TYPE);
        if (declaration == null) {
            throw new RuntimeException("Failed to find declaration for " + type);
        }
        if (declaration instanceof UnknownType) {
            return declaration.getType();
        }
        Type ret = this.applyTypeArguments(moduleScope, declaration, type, scope, VarianceLocation.CONTRAVARIANT, TypeMappingMode.GENERATOR, rawDeclarationsSeen);
        if (ret.isCached()) {
            ret = ret.clone();
        }
        if (ret.getUnderlyingType() == null) {
            ret.setUnderlyingType(this.getUnderlyingType(type, TypeLocation.TYPE_PARAM));
        }
        return ret;
    }

    @Override
    public Type getType(Module module, String pkgName, String name, Scope scope) {
        Declaration decl = this.getDeclaration(module, pkgName, name, scope);
        if (decl == null) {
            return null;
        }
        if (decl instanceof TypeDeclaration) {
            return ((TypeDeclaration)decl).getType();
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(final Module module, final String pkgName, final String name, final Scope scope) {
        return this.synchronizedCall(new Callable<Declaration>(){

            @Override
            public Declaration call() throws Exception {
                TypeParameter typeParameter;
                if (scope != null && (typeParameter = AbstractModelLoader.this.lookupTypeParameter(scope, name)) != null) {
                    return typeParameter;
                }
                if (!AbstractModelLoader.this.isBootstrap || !name.startsWith(AbstractModelLoader.CEYLON_LANGUAGE)) {
                    if (scope != null && pkgName != null) {
                        Package containingPackage = ModelUtil.getPackageContainer(scope);
                        Package pkg = containingPackage.getModule().getPackage(pkgName);
                        String relativeName = null;
                        String unquotedName = name.replace("$", "");
                        if (!pkgName.isEmpty()) {
                            if (unquotedName.startsWith(pkgName + ".")) {
                                relativeName = unquotedName.substring(pkgName.length() + 1);
                            }
                        } else {
                            relativeName = unquotedName;
                        }
                        if (relativeName != null && pkg != null) {
                            Declaration declaration = pkg.getDirectMember(relativeName, null, false);
                            if (JvmBackendUtil.isValue(declaration) && ((Value)declaration).getTypeDeclaration().getName().equals(relativeName)) {
                                declaration = ((Value)declaration).getTypeDeclaration();
                            }
                            if (declaration != null) {
                                return declaration;
                            }
                        }
                    }
                    return AbstractModelLoader.this.convertToDeclaration(module, name, ModelLoader.DeclarationType.TYPE);
                }
                return AbstractModelLoader.this.findLanguageModuleDeclarationForBootstrap(name);
            }
        });
    }

    private Declaration findLanguageModuleDeclarationForBootstrap(String name) {
        if (name.equals(CEYLON_LANGUAGE)) {
            return null;
        }
        Module languageModule = this.modules.getLanguageModule();
        int lastDot = name.lastIndexOf(".");
        if (lastDot == -1) {
            return null;
        }
        String pkgName = name.substring(0, lastDot);
        String simpleName = name.substring(lastDot + 1);
        if (name.equals("ceylon.language.Nothing")) {
            return this.typeFactory.getNothingDeclaration();
        }
        Package pkg = languageModule.getDirectPackage(pkgName);
        if (pkg != null) {
            Declaration member = pkg.getDirectMember(simpleName, null, false);
            if (JvmBackendUtil.isValue(member) && ((Value)member).getTypeDeclaration().getName().equals(simpleName)) {
                member = ((Value)member).getTypeDeclaration();
            }
            if (member != null) {
                return member;
            }
        }
        throw new ModelResolutionException("Failed to look up given type in language module while bootstrapping: " + name);
    }

    public ClassMirror[] getClassMirrorsToRemove(Declaration declaration) {
        if (declaration instanceof LazyClass) {
            return new ClassMirror[]{((LazyClass)declaration).classMirror};
        }
        if (declaration instanceof LazyInterface) {
            LazyInterface lazyInterface = (LazyInterface)declaration;
            if (lazyInterface.companionClass != null) {
                return new ClassMirror[]{lazyInterface.classMirror, lazyInterface.companionClass};
            }
            return new ClassMirror[]{lazyInterface.classMirror};
        }
        if (declaration instanceof LazyFunction) {
            return new ClassMirror[]{((LazyFunction)declaration).classMirror};
        }
        if (declaration instanceof LazyValue) {
            return new ClassMirror[]{((LazyValue)declaration).classMirror};
        }
        if (declaration instanceof LazyClassAlias) {
            return new ClassMirror[]{((LazyClassAlias)declaration).classMirror};
        }
        if (declaration instanceof LazyInterfaceAlias) {
            return new ClassMirror[]{((LazyInterfaceAlias)declaration).classMirror};
        }
        if (declaration instanceof LazyTypeAlias) {
            return new ClassMirror[]{((LazyTypeAlias)declaration).classMirror};
        }
        return new ClassMirror[0];
    }

    public void removeDeclarations(final List<Declaration> declarations) {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                HashSet<String> qualifiedNames = new HashSet<String>(declarations.size() * 2);
                for (Declaration decl : declarations) {
                    try {
                        ClassMirror[] classMirrors = AbstractModelLoader.this.getClassMirrorsToRemove(decl);
                        if (classMirrors == null || classMirrors.length == 0) continue;
                        Scope container = decl.getContainer();
                        boolean isNativeHeaderMember = container instanceof Declaration && ((Declaration)((Object)container)).isNativeHeader();
                        Map<String, Declaration> firstCache = null;
                        Map<String, Declaration> secondCache = null;
                        if (decl.isToplevel()) {
                            if (JvmBackendUtil.isValue(decl)) {
                                firstCache = AbstractModelLoader.this.valueDeclarationsByName;
                                TypeDeclaration typeDeclaration = ((Value)decl).getTypeDeclaration();
                                if (typeDeclaration != null) {
                                    if (typeDeclaration.isAnonymous()) {
                                        secondCache = AbstractModelLoader.this.typeDeclarationsByName;
                                    }
                                } else {
                                    secondCache = AbstractModelLoader.this.typeDeclarationsByName;
                                }
                            } else if (JvmBackendUtil.isMethod(decl)) {
                                firstCache = AbstractModelLoader.this.valueDeclarationsByName;
                            }
                        }
                        if (decl instanceof TypeDeclaration) {
                            firstCache = AbstractModelLoader.this.typeDeclarationsByName;
                        }
                        Module module = ModelUtil.getModuleContainer(decl.getContainer());
                        for (ClassMirror classMirror : classMirrors) {
                            qualifiedNames.add(classMirror.getQualifiedName());
                            String key = classMirror.getCacheKey(module);
                            String string = key = isNativeHeaderMember ? key + "$header" : key;
                            if (firstCache == null) continue;
                            if (firstCache.remove(key) == null) {
                                // empty if block
                            }
                            if (secondCache != null && secondCache.remove(key) != null) continue;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<String> keysToRemove = new ArrayList<String>(qualifiedNames.size());
                for (Map.Entry<String, ClassMirror> entry : AbstractModelLoader.this.classMirrorCache.entrySet()) {
                    ClassMirror mirror = entry.getValue();
                    if (mirror != null && !qualifiedNames.contains(mirror.getQualifiedName())) continue;
                    keysToRemove.add(entry.getKey());
                }
                for (String keyToRemove : keysToRemove) {
                    AbstractModelLoader.this.classMirrorCache.remove(keyToRemove);
                }
            }
        });
    }

    private int inspectForStats(Map<String, Declaration> cache, Map<Package, Stats> loadedByPackage) {
        int loaded = 0;
        for (Declaration decl : cache.values()) {
            if (!(decl instanceof LazyElement)) continue;
            Package pkg = AbstractModelLoader.getPackage(decl);
            if (pkg == null) {
                this.logVerbose("[Model loader stats: declaration " + decl.getName() + " has no package. Skipping.]");
                continue;
            }
            Stats stats = loadedByPackage.get(pkg);
            if (stats == null) {
                stats = new Stats();
                loadedByPackage.put(pkg, stats);
            }
            ++stats.total;
            if (!((LazyElement)((Object)decl)).isLoaded()) continue;
            ++loaded;
            ++stats.loaded;
        }
        return loaded;
    }

    public void printStats() {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                HashMap loadedByPackage = new HashMap();
                int loaded = AbstractModelLoader.this.inspectForStats(AbstractModelLoader.this.typeDeclarationsByName, loadedByPackage) + AbstractModelLoader.this.inspectForStats(AbstractModelLoader.this.valueDeclarationsByName, loadedByPackage);
                AbstractModelLoader.this.logVerbose("[Model loader: " + loaded + "(loaded)/" + (AbstractModelLoader.this.typeDeclarationsByName.size() + AbstractModelLoader.this.valueDeclarationsByName.size()) + "(total) declarations]");
                for (Map.Entry packageEntry : loadedByPackage.entrySet()) {
                    AbstractModelLoader.this.logVerbose("[ Package " + ((Package)packageEntry.getKey()).getNameAsString() + ": " + ((Stats)packageEntry.getValue()).loaded + "(loaded)/" + ((Stats)packageEntry.getValue()).total + "(total) declarations]");
                }
            }
        });
    }

    private static Package getPackage(Object decl) {
        if (decl == null) {
            return null;
        }
        if (decl instanceof Package) {
            return (Package)decl;
        }
        return AbstractModelLoader.getPackage(((Declaration)decl).getContainer());
    }

    protected void logMissingOracleType(String type) {
        this.logVerbose("Hopefully harmless completion failure in model loader: " + type + ". This is most likely when the JDK depends on Oracle private classes that we can't find." + " As a result some model information will be incomplete.");
    }

    public void setupSourceFileObjects(List<?> treeHolders) {
    }

    @Override
    public Module getLoadedModule(String moduleName, String version2) {
        return this.findModule(moduleName, version2);
    }

    public Module getLanguageModule() {
        return this.modules.getLanguageModule();
    }

    public Module findModule(String name, String version2) {
        return this.moduleManager.findLoadedModule(name, version2);
    }

    public Module getJdkProviderModule() {
        String jdkModuleSpec = this.getAlternateJdkModuleSpec();
        if (jdkModuleSpec != null) {
            ModuleSpec spec = ModuleSpec.parse(jdkModuleSpec, new ModuleSpec.Option[0]);
            return this.findModule(spec.getName(), spec.getVersion());
        }
        return null;
    }

    public Module getJDKBaseModule() {
        return this.findModule(JAVA_BASE_MODULE_NAME, this.jdkProvider.getJDKVersion());
    }

    public Module findModuleForFile(File file) {
        for (File path = file.getParentFile(); path != null; path = path.getParentFile()) {
            String name = path.getPath().replaceAll("[\\\\/]", ".");
            Module m = this.getLoadedModule(name, null);
            if (m == null) continue;
            return m;
        }
        return this.modules.getDefaultModule();
    }

    public abstract Module findModuleForClassMirror(ClassMirror var1);

    protected boolean isTypeHidden(Module module, String qualifiedName) {
        return module.getNameAsString().equals(JAVA_BASE_MODULE_NAME) && qualifiedName.equals("java.lang.Object");
    }

    public Package findPackage(final String quotedPkgName) {
        return this.synchronizedCall(new Callable<Package>(){

            @Override
            public Package call() throws Exception {
                String pkgName = quotedPkgName.replace("$", "");
                for (Package package_2 : AbstractModelLoader.this.packagesByName.values()) {
                    if (!package_2.getNameAsString().equals(pkgName)) continue;
                    return package_2;
                }
                return null;
            }
        });
    }

    public LazyPackage findOrCreateModulelessPackage(final String pkgName) {
        return this.synchronizedCall(new Callable<LazyPackage>(){

            @Override
            public LazyPackage call() throws Exception {
                LazyPackage pkg = (LazyPackage)AbstractModelLoader.this.modulelessPackages.get(pkgName);
                if (pkg != null) {
                    return pkg;
                }
                pkg = new LazyPackage(AbstractModelLoader.this);
                pkg.setName(pkgName == null ? Collections.emptyList() : Arrays.asList(pkgName.split("\\.")));
                AbstractModelLoader.this.modulelessPackages.put(pkgName, pkg);
                return pkg;
            }
        });
    }

    public void cacheModulelessPackages() {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                for (LazyPackage pkg : AbstractModelLoader.this.modulelessPackages.values()) {
                    String quotedPkgName = JVMModuleUtil.quoteJavaKeywords(pkg.getQualifiedNameString());
                    if (pkg.getModule() == null) continue;
                    AbstractModelLoader.this.packagesByName.put(AbstractModelLoader.this.cacheKeyByModule(pkg.getModule(), quotedPkgName), pkg);
                }
                AbstractModelLoader.this.modulelessPackages.clear();
            }
        });
    }

    public void fixDefaultPackage() {
        this.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                Module defaultModule = AbstractModelLoader.this.modules.getDefaultModule();
                Package defaultPackage = defaultModule.getDirectPackage("");
                if (!(defaultPackage instanceof LazyPackage)) {
                    LazyPackage newPkg = AbstractModelLoader.this.findOrCreateModulelessPackage("");
                    List<Package> defaultModulePackages = defaultModule.getPackages();
                    if (defaultModulePackages.size() != 1) {
                        throw new RuntimeException("Assertion failed: default module has more than the default package: " + defaultModulePackages.size());
                    }
                    defaultModulePackages.clear();
                    defaultModulePackages.add(newPkg);
                    newPkg.setModule(defaultModule);
                    defaultPackage.setModule(null);
                }
            }
        });
    }

    public boolean isImported(Module moduleScope, Module importedModule) {
        boolean isMavenAutoExport;
        if (ModelUtil.equalModules(moduleScope, importedModule)) {
            return true;
        }
        if (this.isImportedSpecialRules(moduleScope, importedModule)) {
            return true;
        }
        boolean bl = isMavenAutoExport = this.isAutoExportMavenDependencies() && this.isMavenModule(moduleScope) || this.isFullyExportMavenDependencies();
        if (isMavenAutoExport && this.isMavenModule(importedModule)) {
            return true;
        }
        HashSet<Module> visited = new HashSet<Module>();
        visited.add(moduleScope);
        for (ModuleImport imp : moduleScope.getImports()) {
            if (ModelUtil.equalModules(imp.getModule(), importedModule)) {
                return true;
            }
            if (!imp.isExport() && !isMavenAutoExport || !this.isImportedTransitively(imp.getModule(), importedModule, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean isMavenModule(Module moduleScope) {
        return moduleScope.isJava() && ModuleUtil.isMavenModule(moduleScope.getNameAsString());
    }

    private boolean isImportedSpecialRules(Module moduleScope, Module importedModule) {
        String importedModuleName = importedModule.getNameAsString();
        if ((moduleScope.isJava() || ModelUtil.equalModules(moduleScope, this.getLanguageModule())) && this.jdkProvider.isJDKModule(importedModuleName)) {
            return true;
        }
        if (ModelUtil.equalModules(importedModule, this.getLanguageModule())) {
            return true;
        }
        if (ModelUtil.equalModules(moduleScope, this.getLanguageModule())) {
            if ((importedModuleName.equals("com.redhat.ceylon.compiler.java") || importedModuleName.equals("com.redhat.ceylon.typechecker") || importedModuleName.equals("com.redhat.ceylon.common") || importedModuleName.equals("com.redhat.ceylon.model") || importedModuleName.equals("com.redhat.ceylon.module-resolver")) && importedModule.getVersion().equals("1.3.2")) {
                return true;
            }
            if (importedModuleName.equals("org.jboss.modules") && importedModule.getVersion().equals("1.4.4.Final")) {
                return true;
            }
        }
        return false;
    }

    private boolean isImportedTransitively(Module moduleScope, Module importedModule, Set<Module> visited) {
        if (!visited.add(moduleScope)) {
            return false;
        }
        boolean isMavenAutoExport = this.isAutoExportMavenDependencies() && this.isMavenModule(moduleScope) || this.isFullyExportMavenDependencies();
        for (ModuleImport imp : moduleScope.getImports()) {
            if (!imp.isExport() && !isMavenAutoExport) continue;
            if (ModelUtil.equalModules(imp.getModule(), importedModule)) {
                return true;
            }
            if (this.isImportedSpecialRules(imp.getModule(), importedModule)) {
                return true;
            }
            if (!this.isImportedTransitively(imp.getModule(), importedModule, visited)) continue;
            return true;
        }
        return false;
    }

    protected boolean isModuleOrPackageDescriptorName(String name) {
        return name.equals("$module_") || name.equals("$package_") || name.equals("module-info");
    }

    protected void loadJavaBaseArrays() {
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_OBJECT_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_BOOLEAN_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_BYTE_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_SHORT_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_INT_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_LONG_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_FLOAT_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_DOUBLE_ARRAY, ModelLoader.DeclarationType.TYPE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_CHAR_ARRAY, ModelLoader.DeclarationType.TYPE);
    }

    protected void loadJavaBaseAnnotations() {
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_NATIVE_ANNOTATION, ModelLoader.DeclarationType.VALUE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_TRANSIENT_ANNOTATION, ModelLoader.DeclarationType.VALUE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_VOLATILE_ANNOTATION, ModelLoader.DeclarationType.VALUE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_SYNCHRONIZED_ANNOTATION, ModelLoader.DeclarationType.VALUE);
        this.convertToDeclaration(this.getJDKBaseModule(), JAVA_LANG_NATIVE_ANNOTATION, ModelLoader.DeclarationType.VALUE);
    }

    protected void loadJavaBaseExtras() {
        this.loadJavaBaseArrays();
        this.loadJavaBaseAnnotations();
    }

    protected boolean isAutoExportMavenDependencies() {
        return false;
    }

    public boolean isFullyExportMavenDependencies() {
        return false;
    }

    protected boolean isFlatClasspath() {
        return false;
    }

    private static void setDeclarationAliases(Declaration decl, AnnotatedMirror mirror) {
        List value;
        AnnotationMirror annot = mirror.getAnnotation(CEYLON_LANGUAGE_ALIASES_ANNOTATION);
        if (annot != null && (value = (List)annot.getValue("aliases")) != null && !value.isEmpty()) {
            decl.setAliases(value);
        }
    }

    public void loadJava9Module(LazyModule module, File jar) {
        List<String> exportedPackages = Java9ModuleReader.getExportedPackages(jar);
        if (exportedPackages != null) {
            module.setExportedJavaPackages(exportedPackages);
        }
    }

    public void setupAlternateJdk(Module module, ArtifactResult artifact) {
        try {
            this.jdkProvider = new JdkProvider(module.getNameAsString(), module.getVersion(), module, artifact.artifact());
        }
        catch (RepositoryException | IOException e) {
            throw new RuntimeException("Failed to load alternate Jdk provider " + module, e);
        }
    }

    public JdkProvider getJdkProvider() {
        return this.jdkProvider;
    }

    public Interface getRepeatableContainer(Class c) {
        AnnotationMirror mirror;
        if (c instanceof AnnotationProxyClass && (mirror = ((AnnotationProxyClass)c).iface.classMirror.getAnnotation("java.lang.annotation.Repeatable")) != null) {
            TypeMirror m = (TypeMirror)mirror.getValue();
            Module module = this.findModuleForClassMirror(m.getDeclaredClass());
            return (Interface)this.convertDeclaredTypeToDeclaration(module, m, ModelLoader.DeclarationType.TYPE);
        }
        return null;
    }

    @Override
    public boolean isDynamicMetamodel() {
        return false;
    }

    static {
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_BYTE_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_SHORT_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INT_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_LONG_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_BOOLEAN_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_FLOAT_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_DOUBLE_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_CHAR_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_OBJECT_ARRAY);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INTEROP_NATIVE_ANNOTATION);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INTEROP_TRANSIENT_ANNOTATION);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INTEROP_VOLATILE_ANNOTATION);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INTEROP_SYNCHRONIZED_ANNOTATION);
        CEYLON_INTEROP_DECLARATIONS.add(CEYLON_INTEROP_STRICTFP_ANNOTATION);
    }

    private static class Stats {
        int loaded;
        int total;

        private Stats() {
        }
    }

    private static class RecursiveTypeParameterBoundException
    extends RuntimeException {
        private RecursiveTypeParameterBoundException() {
        }
    }

    private static enum TypeMappingMode {
        NORMAL,
        GENERATOR;

    }

    private static enum VarianceLocation {
        CONTRAVARIANT,
        COVARIANT,
        INVARIANT;

    }

    private static enum TypeLocation {
        TOPLEVEL,
        TYPE_PARAM;

    }

    private static class LogErrorRunnable
    extends UnknownType.ErrorReporter {
        private AbstractModelLoader modelLoader;

        public LogErrorRunnable(AbstractModelLoader modelLoader, String message) {
            super(message);
            this.modelLoader = modelLoader;
        }

        @Override
        public void reportError() {
            this.modelLoader.logError(this.getMessage());
        }
    }

    private static enum NullStatus {
        UncheckedNull,
        Optional,
        NonOptional,
        NoCheck;

    }

    class ValueConstructorGetter
    implements MethodMirrorFilter {
        private ClassMirror classMirror;

        ValueConstructorGetter(ClassMirror classMirror) {
            this.classMirror = classMirror;
        }

        @Override
        public boolean accept(MethodMirror methodMirror) {
            return !methodMirror.isConstructor() && methodMirror.getAnnotation(AbstractModelLoader.CEYLON_ENUMERATED_ANNOTATION) != null && methodMirror.getReturnType().getDeclaredClass().toString().equals(this.classMirror.toString());
        }
    }

    static interface MethodMirrorFilter {
        public boolean accept(MethodMirror var1);
    }

    private static enum JavaVisibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;

    }

    static enum ClassType {
        ATTRIBUTE,
        METHOD,
        OBJECT,
        CLASS,
        INTERFACE;

    }

    public class EmbeddedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public EmbeddedException(Exception cause) {
            super(cause);
        }
    }
}

