/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.common.IOUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.Exclusion;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.cmr.VisibilityType;
import com.redhat.ceylon.model.loader.ContentAwareArtifactResult;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.StaticMetamodelLoader;
import com.redhat.ceylon.model.loader.mirror.AnnotatedMirror;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JvmBackendUtil {
    public static boolean isInitialLowerCase(String name) {
        return !name.isEmpty() && JvmBackendUtil.isLowerCase(name.codePointAt(0));
    }

    public static boolean isLowerCase(int codepoint) {
        return Character.isLowerCase(codepoint) || codepoint == 95;
    }

    public static String getName(List<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            sb.append(parts.get(i));
            if (i >= parts.size() - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static String getMirrorName(AnnotatedMirror mirror) {
        String name;
        AnnotationMirror annot = mirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Name");
        if (annot != null) {
            name = (String)annot.getValue();
        } else {
            name = mirror.getName();
            String string = name = name.isEmpty() ? name : NamingBase.stripLeadingDollar(name);
            if (mirror instanceof ClassMirror && JvmBackendUtil.isInitialLowerCase(name) && name.endsWith("_") && mirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Ceylon") != null) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    public static boolean isSubPackage(String moduleName, String pkgName) {
        return pkgName.equals(moduleName) || pkgName.startsWith(moduleName + ".");
    }

    public static String removeChar(char c, String string) {
        int nextChar = string.indexOf(c);
        if (nextChar == -1) {
            return string;
        }
        int start = 0;
        StringBuilder ret = new StringBuilder(string.length() - 1);
        while (nextChar != -1) {
            ret.append(string, start, nextChar);
            start = nextChar + 1;
            nextChar = string.indexOf(c, start);
        }
        ret.append(string, start, string.length());
        return ret.toString();
    }

    public static String strip(String name, boolean isCeylon, boolean isShared) {
        String stripped = NamingBase.stripLeadingDollar(name);
        String privSuffix = NamingBase.Suffix.$priv$.name();
        if (isCeylon && !isShared && name.endsWith(privSuffix)) {
            return stripped.substring(0, stripped.length() - privSuffix.length());
        }
        return stripped;
    }

    public static boolean isValue(Declaration decl) {
        return decl instanceof Value && !((Value)decl).isParameter() && !((Value)decl).isTransient();
    }

    public static boolean isMethod(Declaration decl) {
        return decl instanceof Function && !((Function)decl).isParameter();
    }

    public static boolean isCeylon(TypeDeclaration declaration) {
        return ModelUtil.isCeylonDeclaration(declaration);
    }

    public static Declaration getTopmostRefinedDeclaration(Declaration decl) {
        return JvmBackendUtil.getTopmostRefinedDeclaration(decl, null);
    }

    public static Declaration getTopmostRefinedDeclaration(Declaration decl, Map<Function, Function> methodOverrides) {
        Declaration refinedDecl;
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() && decl.getContainer() instanceof Class) {
            Declaration refinedDecl2;
            Class c = (Class)decl.getContainer();
            boolean isAlias = c.isAlias();
            boolean isActual = c.isActual();
            if (isAlias || isActual) {
                Class ctor = null;
                int index = c.getParameterList().getParameters().indexOf(JvmBackendUtil.findParamForDecl((TypedDeclaration)decl));
                while (isAlias && c.isAlias() || isActual && c.isActual()) {
                    ctor = isAlias && c.isAlias() ? (Functional)((Object)((ClassAlias)c).getConstructor()) : c;
                    Type et = c.getExtendedType();
                    if ((c = et != null && et.isClass() ? (Class)et.getDeclaration() : null) != null) continue;
                    return null;
                }
                if (isActual) {
                    ctor = c;
                }
                if (ctor == null || ctor.getParameterLists() == null || ctor.getParameterLists().isEmpty() || ctor.getFirstParameterList() == null || ctor.getFirstParameterList().getParameters() == null || ctor.getFirstParameterList().getParameters().size() <= index) {
                    return null;
                }
                decl = ctor.getFirstParameterList().getParameters().get(index).getModel();
            }
            if (decl.isShared() && (refinedDecl2 = c.getRefinedMember(decl.getName(), ModelUtil.getSignature(decl), ModelUtil.isVariadic(decl))) != null && !ModelUtil.equal(refinedDecl2, decl)) {
                return JvmBackendUtil.getTopmostRefinedDeclaration(refinedDecl2, methodOverrides);
            }
            return decl;
        }
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() && (decl.getContainer() instanceof Function && !((Function)decl.getContainer()).isParameter() || decl.getContainer() instanceof Specification || decl.getContainer() instanceof Function && ((Function)decl.getContainer()).isParameter() && JvmBackendUtil.createMethod((Function)decl.getContainer()))) {
            Functional func = (Functional)((Object)JvmBackendUtil.getParameterized((FunctionOrValue)decl));
            if (func == null) {
                return decl;
            }
            Declaration kk = JvmBackendUtil.getTopmostRefinedDeclaration((Declaration)((Object)func), methodOverrides);
            if (!(kk instanceof Functional)) {
                return decl;
            }
            Functional refinedFunc = (Functional)((Object)kk);
            if (ModelUtil.equal((Declaration)((Object)refinedFunc), (Declaration)((Object)func))) {
                return decl;
            }
            if (func.getParameterLists().size() != refinedFunc.getParameterLists().size()) {
                return decl;
            }
            for (int ii = 0; ii < func.getParameterLists().size(); ++ii) {
                if (func.getParameterLists().get(ii).getParameters().size() != refinedFunc.getParameterLists().get(ii).getParameters().size()) {
                    return decl;
                }
                int index = 0;
                for (Parameter px : func.getParameterLists().get(ii).getParameters()) {
                    if (px.getModel() == null || px.getModel().equals(decl)) {
                        return refinedFunc.getParameterLists().get(ii).getParameters().get(index).getModel();
                    }
                    ++index;
                }
            }
        } else if (methodOverrides != null && decl instanceof Function && ModelUtil.equal(decl.getRefinedDeclaration(), decl) && decl.getContainer() instanceof Specification && ((Specification)decl.getContainer()).getDeclaration() instanceof Function && ((Function)((Specification)decl.getContainer()).getDeclaration()).isShortcutRefinement() && methodOverrides.containsKey(decl)) {
            decl = methodOverrides.get(decl);
        }
        if ((refinedDecl = decl.getRefinedDeclaration()) != null && !ModelUtil.equal(refinedDecl, decl)) {
            return JvmBackendUtil.getTopmostRefinedDeclaration(refinedDecl);
        }
        return decl;
    }

    public static Parameter findParamForDecl(TypedDeclaration decl) {
        String attrName = decl.getName();
        return JvmBackendUtil.findParamForDecl(attrName, decl);
    }

    public static Parameter findParamForDecl(String attrName, TypedDeclaration decl) {
        Parameter result = null;
        if (decl.getContainer() instanceof Functional) {
            Functional f = (Functional)((Object)decl.getContainer());
            result = f.getParameter(attrName);
        }
        return result;
    }

    public static Declaration getParameterized(FunctionOrValue methodOrValue) {
        if (!methodOrValue.isParameter()) {
            return null;
        }
        Scope scope = methodOrValue.getContainer();
        if (scope instanceof Specification) {
            return ((Specification)scope).getDeclaration();
        }
        if (scope instanceof Declaration) {
            return (Declaration)((Object)scope);
        }
        return null;
    }

    public static boolean createMethod(FunctionOrValue model) {
        return model instanceof Function && model.isParameter() && model.isClassMember() && (model.isShared() || model.isCaptured());
    }

    public static boolean supportsReified(Declaration declaration) {
        if (declaration instanceof ClassOrInterface) {
            return JvmBackendUtil.isCeylon((TypeDeclaration)declaration);
        }
        if (declaration instanceof Function) {
            if (((Function)declaration).isParameter()) {
                return false;
            }
            if (declaration.isToplevel()) {
                return true;
            }
            Function m = (Function)JvmBackendUtil.getTopmostRefinedDeclaration(declaration);
            ClassOrInterface container = ModelUtil.getClassOrInterfaceContainer(m);
            if (container == null) {
                return true;
            }
            return JvmBackendUtil.supportsReified(container);
        }
        if (declaration instanceof Constructor) {
            return JvmBackendUtil.isCeylon((Constructor)declaration);
        }
        return false;
    }

    public static boolean isCompanionClassNeeded(TypeDeclaration decl) {
        return decl instanceof Interface && BooleanUtil.isNotFalse(((Interface)decl).isCompanionClassNeeded());
    }

    public static boolean isBoxedVariable(TypedDeclaration attr) {
        return ModelUtil.isNonTransientValue(attr) && ModelUtil.isLocalNotInitializer(attr) && (attr.isVariable() && attr.isCaptured() || attr.isSelfCaptured()) || attr instanceof Value && ModelUtil.isEnumeratedConstructorInLocalVariable((Value)attr);
    }

    private static String getArrayName(TypeDeclaration decl) {
        if (!(decl instanceof Class)) {
            return null;
        }
        return decl.getQualifiedNameString();
    }

    public static boolean isJavaArray(TypeDeclaration decl) {
        String name = JvmBackendUtil.getArrayName(decl);
        return "java.lang::ObjectArray".equals(name) || "java.lang::ByteArray".equals(name) || "java.lang::ShortArray".equals(name) || "java.lang::IntArray".equals(name) || "java.lang::LongArray".equals(name) || "java.lang::FloatArray".equals(name) || "java.lang::DoubleArray".equals(name) || "java.lang::BooleanArray".equals(name) || "java.lang::CharArray".equals(name);
    }

    public static boolean isJavaBooleanArray(TypeDeclaration decl) {
        return "java.lang::BooleanArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaByteArray(TypeDeclaration decl) {
        return "java.lang::ByteArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaShortArray(TypeDeclaration decl) {
        return "java.lang::ShortArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaIntArray(TypeDeclaration decl) {
        return "java.lang::IntArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaLongArray(TypeDeclaration decl) {
        return "java.lang::LongArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaFloatArray(TypeDeclaration decl) {
        return "java.lang::FloatArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaDoubleArray(TypeDeclaration decl) {
        return "java.lang::DoubleArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaCharArray(TypeDeclaration decl) {
        return "java.lang::CharArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static SortedSet<String> listPackages(File jar, PathFilter pathFilter) throws IOException {
        TreeSet<String> packages = new TreeSet<String>();
        if (ModuleUtil.isMavenJarlessModule(jar)) {
            return packages;
        }
        try (ZipFile zf = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                String pkg;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (pkg = JvmBackendUtil.getPackageForPath(entry.getName(), pathFilter)) == null) continue;
                packages.add(pkg);
            }
        }
        return packages;
    }

    private static String getPackageForPath(String path, PathFilter pathFilter) {
        if (JvmBackendUtil.definesPackage(path)) {
            int sep = path.lastIndexOf(47);
            path = sep != -1 ? path.substring(0, sep) : "";
            String pkg = path;
            pkg = pkg.replace("$", "");
            String pathQuery = path.isEmpty() ? pkg : pkg + "/";
            if (pathFilter == null || pathFilter.accept(pathQuery)) {
                pkg = pkg.replace('/', '.');
                return pkg;
            }
        }
        return null;
    }

    public static boolean definesPackage(String path) {
        return path.toLowerCase().endsWith(".class") && !path.equals("module-info.class");
    }

    public static void writeStaticMetamodel(File outputFolder, List<ArtifactResult> entries, JdkProvider jdkProvider, String metaInfEntry) throws IOException {
        File meta = new File(outputFolder, metaInfEntry + "/ceylon");
        meta.mkdirs();
        File metamodel = new File(meta, "metamodel");
        try (FileWriter ret = new FileWriter(metamodel);){
            JvmBackendUtil.writeStaticMetamodel((Writer)ret, entries, jdkProvider, Collections.emptySet());
        }
    }

    public static void writeStaticMetamodel(File outputFolder, List<ArtifactResult> entries, JdkProvider jdkProvider) throws IOException {
        JvmBackendUtil.writeStaticMetamodel(outputFolder, entries, jdkProvider, "META-INF");
    }

    public static void writeStaticMetamodel(ZipOutputStream outputZip, Set<String> added, List<ArtifactResult> entries, JdkProvider jdkProvider, Set<String> providedModules) throws IOException {
        ZipEntry entry;
        if (added.add("META-INF/")) {
            entry = new ZipEntry("META-INF/");
            outputZip.putNextEntry(entry);
        }
        if (added.add("META-INF/ceylon/")) {
            entry = new ZipEntry("META-INF/ceylon/");
            outputZip.putNextEntry(entry);
        }
        outputZip.putNextEntry(new ZipEntry("META-INF/ceylon/metamodel"));
        OutputStreamWriter ret = new OutputStreamWriter(outputZip);
        JvmBackendUtil.writeStaticMetamodel((Writer)ret, entries, jdkProvider, providedModules);
    }

    private static void writeStaticMetamodel(Writer ret, List<ArtifactResult> entries, JdkProvider jdkProvider, Set<String> providedModules) throws IOException {
        if (jdkProvider.isAlternateJdk()) {
            for (String jdkModule : jdkProvider.getJDKModuleNames()) {
                ret.write("=" + jdkModule + "/" + jdkProvider.getJDKVersion() + "\n");
                for (String pkg : jdkProvider.getJDKPackages(jdkModule)) {
                    ret.write("@" + pkg + "\n");
                }
            }
        }
        for (ArtifactResult entry : entries) {
            JvmBackendUtil.writeStaticMetamodel(ret, entry, jdkProvider, providedModules);
        }
        ret.flush();
    }

    private static void writeStaticMetamodel(Writer metamodelOs, ArtifactResult entry, JdkProvider jdkProvider, Set<String> providedModules) throws IOException {
        if (entry.version() != null) {
            metamodelOs.write("=" + entry.name() + "/" + entry.version() + "\n");
        } else {
            metamodelOs.write("=" + entry.name() + "\n");
        }
        if (!providedModules.contains(entry.name())) {
            for (ArtifactResult dep : entry.dependencies()) {
                if (dep.exported()) {
                    metamodelOs.write("+");
                }
                if (dep.optional()) {
                    metamodelOs.write("?");
                }
                metamodelOs.write(dep.name() + "/" + dep.version() + "\n");
            }
        }
        JvmBackendUtil.listPackages(metamodelOs, entry.name(), entry.artifact(), jdkProvider);
    }

    private static void listPackages(Writer metamodelOs, String name, File artifact, JdkProvider jdkProvider) throws ZipException, IOException {
        List<String> jdkPackageList = null;
        if (name.equals(jdkProvider.getJdkContainerModuleName())) {
            jdkPackageList = jdkProvider.getJDKPackageList();
        }
        SortedSet<String> packages = JvmBackendUtil.listPackages(artifact, null);
        for (String pkg : packages) {
            if (jdkPackageList != null && jdkPackageList.contains(pkg)) continue;
            metamodelOs.write("@" + pkg + "\n");
        }
    }

    public static void loadStaticMetamodel(InputStream is, List<String> dexEntries, StaticMetamodelLoader staticMetamodelLoader) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            ModuleSpec module = null;
            TreeSet<String> packages = new TreeSet<String>();
            LinkedList<ArtifactResult> imports = new LinkedList<ArtifactResult>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("=")) {
                    if (module != null) {
                        JvmBackendUtil.finishLoadingModule(module, packages, imports, dexEntries, staticMetamodelLoader);
                    }
                    module = ModuleSpec.parse(line.substring(1), new ModuleSpec.Option[0]);
                    packages.clear();
                    imports.clear();
                    continue;
                }
                boolean _optional = false;
                boolean _shared = false;
                if (line.startsWith("?")) {
                    _optional = true;
                    line = line.substring(1);
                }
                if (line.startsWith("+")) {
                    _shared = true;
                    line = line.substring(1);
                }
                final boolean optional = _optional;
                final boolean shared = _shared;
                if (line.startsWith("@")) {
                    packages.add(line.substring(1));
                    continue;
                }
                ModuleSpec importSpec = ModuleSpec.parse(line, new ModuleSpec.Option[0]);
                final String namespace = ModuleUtil.getNamespaceFromUri(importSpec.getName());
                final String name = ModuleUtil.getModuleNameFromUri(importSpec.getName());
                final String version2 = importSpec.getVersion();
                imports.add(new ArtifactResult(){

                    @Override
                    public String namespace() {
                        return namespace;
                    }

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public String version() {
                        return version2;
                    }

                    @Override
                    public boolean optional() {
                        return optional;
                    }

                    @Override
                    public boolean exported() {
                        return shared;
                    }

                    @Override
                    public ArtifactResultType type() {
                        return ArtifactResultType.OTHER;
                    }

                    @Override
                    public VisibilityType visibilityType() {
                        return VisibilityType.STRICT;
                    }

                    @Override
                    public File artifact() throws RepositoryException {
                        return null;
                    }

                    @Override
                    public PathFilter filter() {
                        return null;
                    }

                    @Override
                    public List<ArtifactResult> dependencies() throws RepositoryException {
                        return null;
                    }

                    @Override
                    public String artifactId() {
                        return ModuleUtil.getMavenArtifactIdIfMavenModule(name);
                    }

                    @Override
                    public String groupId() {
                        return ModuleUtil.getMavenGroupIdIfMavenModule(name);
                    }

                    @Override
                    public String repositoryDisplayString() {
                        return "Android dependency";
                    }

                    @Override
                    public Repository repository() {
                        return null;
                    }

                    @Override
                    public ModuleScope moduleScope() {
                        return ModuleScope.COMPILE;
                    }

                    @Override
                    public List<Exclusion> getExclusions() {
                        return null;
                    }
                });
            }
            if (module != null) {
                JvmBackendUtil.finishLoadingModule(module, packages, imports, dexEntries, staticMetamodelLoader);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void finishLoadingModule(ModuleSpec module, SortedSet<String> packages, List<ArtifactResult> dependencies, final List<String> dexEntries, StaticMetamodelLoader staticMetamodelLoader) {
        final TreeSet<String> packagesCopy = new TreeSet<String>(packages);
        final ArrayList<ArtifactResult> dependenciesCopy = new ArrayList<ArtifactResult>(dependencies);
        final String namespace = ModuleUtil.getNamespaceFromUri(module.getName());
        final String name = ModuleUtil.getModuleNameFromUri(module.getName());
        final String version2 = module.getVersion();
        ContentAwareArtifactResult artifact = new ContentAwareArtifactResult(){

            @Override
            public VisibilityType visibilityType() {
                return VisibilityType.STRICT;
            }

            @Override
            public String version() {
                return version2;
            }

            @Override
            public ArtifactResultType type() {
                return ArtifactResultType.OTHER;
            }

            @Override
            public String repositoryDisplayString() {
                return "Android repo";
            }

            @Override
            public Repository repository() {
                return null;
            }

            @Override
            public String namespace() {
                return namespace;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String artifactId() {
                return ModuleUtil.getMavenArtifactIdIfMavenModule(name);
            }

            @Override
            public String groupId() {
                return ModuleUtil.getMavenGroupIdIfMavenModule(name);
            }

            @Override
            public boolean exported() {
                return false;
            }

            @Override
            public boolean optional() {
                return false;
            }

            @Override
            public PathFilter filter() {
                return null;
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                return dependenciesCopy;
            }

            @Override
            public File artifact() throws RepositoryException {
                return null;
            }

            @Override
            public Collection<String> getPackages() {
                return packagesCopy;
            }

            @Override
            public List<String> getFileNames(String path) {
                return this.getAndroidFileNames(path);
            }

            private List<String> getAndroidFileNames(String path) {
                path = path + "/";
                LinkedList<String> ret = new LinkedList<String>();
                for (String entry : dexEntries) {
                    String part;
                    if (!entry.startsWith(path) || (part = entry.substring(path.length())).isEmpty() || part.indexOf(47) != -1) continue;
                    ret.add(entry);
                }
                return ret;
            }

            @Override
            public Collection<String> getEntries() {
                return this.getAndroidEntries();
            }

            private Collection<String> getAndroidEntries() {
                LinkedList<String> ret = new LinkedList<String>();
                block0: for (String entry : dexEntries) {
                    for (String pkg : packagesCopy) {
                        String path = pkg.replace('.', '/') + "/";
                        if (!entry.startsWith(path)) continue;
                        ret.add(entry);
                        continue block0;
                    }
                }
                return ret;
            }

            @Override
            public byte[] getContents(String path) {
                try {
                    return IOUtil.readStream(this.getClass().getClassLoader().getResourceAsStream(path));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URI getContentUri(String path) {
                try {
                    return this.getClass().getClassLoader().getResource(path).toURI();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "StaticMetamodelArtifact for module " + name + "/" + version2;
            }

            @Override
            public ModuleScope moduleScope() {
                return ModuleScope.COMPILE;
            }

            @Override
            public List<Exclusion> getExclusions() {
                return null;
            }
        };
        staticMetamodelLoader.loadModule(module.getName(), module.getVersion(), artifact);
    }

    public static boolean isStaticMetamodel(java.lang.Class<?> fromClass) {
        URL res = fromClass.getResource("/META-INF/ceylon/metamodel");
        if (res == null) {
            res = fromClass.getResource("/ANDROID-META-INF/ceylon/metamodel");
        }
        return res != null;
    }

    public static InputStream getStaticMetamodelInputStream(java.lang.Class<?> fromClass) {
        InputStream stream = fromClass.getResourceAsStream("/META-INF/ceylon/metamodel");
        if (stream == null) {
            stream = fromClass.getResourceAsStream("/ANDROID-META-INF/ceylon/metamodel");
        }
        return stream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getCurrentJarEntries() {
        URL url = JvmBackendUtil.class.getProtectionDomain().getCodeSource().getLocation();
        HashSet<String> entries = new HashSet<String>();
        if (url.getProtocol().equals("vfs")) {
            try {
                java.lang.Class<?> virtualFileClass = java.lang.Class.forName("org.jboss.vfs.VirtualFile");
                java.lang.Class<?> vfsClass = java.lang.Class.forName("org.jboss.vfs.VFS");
                Method getChild = vfsClass.getMethod("getChild", URL.class);
                URL properURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath().replace(" ", "%20"));
                Object thisJar = getChild.invoke(null, properURL);
                Method getParent = virtualFileClass.getMethod("getParent", new java.lang.Class[0]);
                Object libDir = getParent.invoke(thisJar, new Object[0]);
                if (libDir == null) return new ArrayList<String>(entries);
                Method getChildren = virtualFileClass.getMethod("getChildren", new java.lang.Class[0]);
                Method openStream = virtualFileClass.getMethod("openStream", new java.lang.Class[0]);
                Method getName = virtualFileClass.getMethod("getName", new java.lang.Class[0]);
                List children = (List)getChildren.invoke(libDir, new Object[0]);
                for (Object child : children) {
                    String name = (String)getName.invoke(child, new Object[0]);
                    if (!name.toLowerCase().endsWith(".jar")) continue;
                    InputStream stream = (InputStream)openStream.invoke(child, new Object[0]);
                    JvmBackendUtil.scanZipFile(stream, entries);
                }
                return new ArrayList<String>(entries);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
                throw new RuntimeException("Failed to read current fat jar list of entries", e);
            }
        }
        try {
            JvmBackendUtil.scanZipFile(url.openStream(), entries);
            return new ArrayList<String>(entries);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read current fat jar list of entries", e);
        }
    }

    private static void scanZipFile(InputStream is, Set<String> entries) {
        ZipInputStream zipFile1 = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
        try (ZipInputStream zipFile = zipFile1;){
            ZipEntry entry;
            while ((entry = zipFile.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                entries.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read current fat jar list of entries", e);
        }
    }
}

