/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OsgiVersion {
    private static HashMap<String, Integer> ceylonQualifiers = new HashMap();
    private static int QUALIFIER_OTHER;
    public static final SimpleDateFormat formatter;

    public static String withTimestamp(String osgiVersion, String formattedDateInGmt) {
        return OsgiVersion.withTimestamp(osgiVersion, formattedDateInGmt, null);
    }

    public static String withTimestamp(String osgiVersion, String formattedDateInGmt, ErrorReporter errorReporter) {
        Date date;
        try {
            date = formatter.parse(formattedDateInGmt);
        }
        catch (ParseException e) {
            String errorMessage = "The provided OSGI qualifier timestamp cannot be parsed. The current date will be used instead.";
            if (errorReporter != null) {
                errorReporter.reportError(errorMessage, e);
            } else {
                System.err.println("ERROR: " + errorMessage);
            }
            date = new Date();
        }
        return OsgiVersion.withTimestamp(osgiVersion, date);
    }

    public static String withTimestamp(String osgiVersion) {
        return OsgiVersion.withTimestamp(osgiVersion, new Date());
    }

    public static String withTimestamp(String osgiVersion, Date date) {
        return osgiVersion + "-" + formatter.format(date);
    }

    public static String fromCeylonVersion(String ceylonVersion) {
        StringBuffer buf = new StringBuffer();
        Pattern p = Pattern.compile("\\d\\pL|\\pL\\d");
        Matcher m = p.matcher(ceylonVersion);
        while (m.find()) {
            String found = m.group();
            assert (found.length() == 2);
            m.appendReplacement(buf, found.charAt(0) + "." + found.charAt(1));
        }
        m.appendTail(buf);
        String[] versionParts = buf.toString().split("[\\.-]");
        boolean inOsgiQualifier = false;
        boolean lastWasQualifier = false;
        ArrayList<String> resultParts = new ArrayList<String>();
        for (int i = 0; i < versionParts.length; ++i) {
            String part = versionParts[i];
            if (part.isEmpty()) {
                part = "0";
            }
            boolean bl = inOsgiQualifier = inOsgiQualifier || i >= 3;
            if (OsgiVersion.isNumber(part)) {
                if (inOsgiQualifier) {
                    part = String.format("n%03d", Integer.parseInt(part));
                }
                lastWasQualifier = false;
            } else {
                Integer idx;
                if (!inOsgiQualifier) {
                    for (int j = i; j < 3; ++j) {
                        resultParts.add("0");
                    }
                    inOsgiQualifier = true;
                }
                part = (idx = ceylonQualifiers.get(part.toLowerCase())) != null ? idx.toString() : QUALIFIER_OTHER + "-" + part;
                lastWasQualifier = true;
            }
            resultParts.add(part);
        }
        for (int j = resultParts.size(); j < 3; ++j) {
            resultParts.add("0");
            lastWasQualifier = false;
        }
        if (!lastWasQualifier) {
            resultParts.add(ceylonQualifiers.get("final").toString());
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < resultParts.size(); ++i) {
            String part = (String)resultParts.get(i);
            if (i > 3) {
                result.append("-");
            } else if (i > 0) {
                result.append(".");
            }
            if (i == 3) {
                result.append("osgi-");
            }
            result.append(part);
        }
        return result.toString();
    }

    private static boolean isNumber(String txt) {
        return txt.matches("\\d+");
    }

    static {
        ceylonQualifiers.put("alpha", 0);
        ceylonQualifiers.put("a", 0);
        ceylonQualifiers.put("beta", 1);
        ceylonQualifiers.put("b", 1);
        ceylonQualifiers.put("milestone", 2);
        ceylonQualifiers.put("m", 2);
        ceylonQualifiers.put("rc", 3);
        ceylonQualifiers.put("cr", 3);
        ceylonQualifiers.put("snapshot", 4);
        ceylonQualifiers.put("ga", 5);
        ceylonQualifiers.put("final", 5);
        ceylonQualifiers.put("sp", 6);
        QUALIFIER_OTHER = 7;
        formatter = new SimpleDateFormat("yyyyMMdd-HHmm");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static interface ErrorReporter {
        public void reportError(String var1, Throwable var2);
    }
}

