/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionType;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectionAnnotation
implements AnnotationMirror {
    private Annotation annotation;

    public ReflectionAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public Object getValue(String fieldName) {
        try {
            Method method = this.annotation.annotationType().getMethod(fieldName, new Class[0]);
            return this.convertValue(method.invoke((Object)this.annotation, new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object convertValue(Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            if (valueClass.getComponentType().isPrimitive()) {
                Class<?> componentType = valueClass.getComponentType();
                if (componentType == Short.TYPE) {
                    short[] array = (short[])value;
                    ArrayList<Short> values = new ArrayList<Short>(array.length);
                    for (short val : array) {
                        values.add(val);
                    }
                    return values;
                }
                if (componentType == Integer.TYPE) {
                    int[] array = (int[])value;
                    ArrayList<Integer> values = new ArrayList<Integer>(array.length);
                    for (int val : array) {
                        values.add(val);
                    }
                    return values;
                }
                if (componentType == Long.TYPE) {
                    long[] array = (long[])value;
                    ArrayList<Long> values = new ArrayList<Long>(array.length);
                    for (long val : array) {
                        values.add(val);
                    }
                    return values;
                }
                if (componentType == Boolean.TYPE) {
                    boolean[] array = (boolean[])value;
                    ArrayList<Boolean> values = new ArrayList<Boolean>(array.length);
                    for (boolean val : array) {
                        values.add(val);
                    }
                    return values;
                }
                if (componentType == Character.TYPE) {
                    char[] array = (char[])value;
                    ArrayList<Character> values = new ArrayList<Character>(array.length);
                    for (char val : array) {
                        values.add(Character.valueOf(val));
                    }
                    return values;
                }
                if (componentType == Float.TYPE) {
                    float[] array = (float[])value;
                    ArrayList<Float> values = new ArrayList<Float>(array.length);
                    for (float val : array) {
                        values.add(Float.valueOf(val));
                    }
                    return values;
                }
                if (componentType == Double.TYPE) {
                    double[] array = (double[])value;
                    ArrayList<Double> values = new ArrayList<Double>(array.length);
                    for (double val : array) {
                        values.add(val);
                    }
                    return values;
                }
            } else {
                Object[] array = (Object[])value;
                ArrayList<Object> values = new ArrayList<Object>(array.length);
                for (Object val : array) {
                    values.add(this.convertValue(val));
                }
                return values;
            }
        }
        if (value instanceof Annotation) {
            return new ReflectionAnnotation((Annotation)value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Class) {
            return new ReflectionType((Class)value);
        }
        return value;
    }

    @Override
    public Object getValue() {
        return this.getValue("value");
    }
}

