/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionAnnotation;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionTypeParameter;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionUtils {
    static final Class<? extends Annotation> IGNORE_ANNOTATION = ReflectionUtils.getClass("com.redhat.ceylon.compiler.java.metadata.Ignore");

    public static Map<String, AnnotationMirror> getAnnotations(AnnotatedElement annotated) {
        Annotation[] annotations = annotated.getDeclaredAnnotations();
        return ReflectionUtils.getAnnotations(annotations);
    }

    public static Map<String, AnnotationMirror> getAnnotations(Annotation[] annotations) {
        if (annotations.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, AnnotationMirror> map = new HashMap<String, AnnotationMirror>();
        for (int i = annotations.length - 1; i >= 0; --i) {
            Annotation annotation = annotations[i];
            map.put(annotation.annotationType().getName(), new ReflectionAnnotation(annotation));
        }
        return map;
    }

    public static List<TypeParameterMirror> getTypeParameters(GenericDeclaration decl) {
        TypeVariable<?>[] javaTypeParameters = decl.getTypeParameters();
        ArrayList<TypeParameterMirror> typeParameters = new ArrayList<TypeParameterMirror>(javaTypeParameters.length);
        for (TypeVariable<?> javaTypeParameter : javaTypeParameters) {
            typeParameters.add(new ReflectionTypeParameter(javaTypeParameter));
        }
        return typeParameters;
    }

    private static Class<? extends Annotation> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPackageName(Class<?> klass) {
        if (klass.isPrimitive() || klass.isArray()) {
            return "java.lang";
        }
        while (klass.getEnclosingClass() != null) {
            klass = klass.getEnclosingClass();
        }
        String name = klass.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(0, lastDot);
    }

    public static boolean isOverridingMethod(Method method) {
        return ReflectionUtils.isOverXingMethod(OverXing.Overriding, method);
    }

    public static boolean isOverloadingMethod(Method method) {
        return ReflectionUtils.isOverXingMethod(OverXing.Overloading, method);
    }

    private static boolean isOverXingMethod(OverXing searchType, Method method) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        HashSet visited = new HashSet();
        Class<?> superclass = declaringClass.getSuperclass();
        if (superclass != null && ReflectionUtils.isOverXingMethodInClassRecursive(searchType, method, name, parameterTypes, declaringClass, superclass, visited)) {
            return true;
        }
        for (Class<?> interfce : declaringClass.getInterfaces()) {
            if (!ReflectionUtils.isOverXingMethodInClassRecursive(searchType, method, name, parameterTypes, declaringClass, interfce, visited)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverXingMethodInClassRecursive(OverXing searchType, Method method, String name, Class<?>[] parameterTypes, Class<?> declaringClass, Class<?> klass, Set<Class<?>> visited) {
        if (!visited.add(klass)) {
            return false;
        }
        if (ReflectionUtils.isOverXingMethodInClass(searchType, method, name, parameterTypes, declaringClass, klass)) {
            return true;
        }
        Class<?> superclass = klass.getSuperclass();
        if (superclass != null && ReflectionUtils.isOverXingMethodInClassRecursive(searchType, method, name, parameterTypes, declaringClass, superclass, visited)) {
            return true;
        }
        for (Class<?> interfce : klass.getInterfaces()) {
            if (!ReflectionUtils.isOverXingMethodInClassRecursive(searchType, method, name, parameterTypes, declaringClass, interfce, visited)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverXingMethodInClass(OverXing searchType, Method method, String name, Class<?>[] parameterTypes, Class<?> declaringClass, Class<?> klass) {
        switch (searchType) {
            case Overloading: {
                return ReflectionUtils.isOverloadingMethodInClass(method, name, parameterTypes, declaringClass, klass);
            }
            case Overriding: {
                return ReflectionUtils.isOverridingMethodInClass(method, name, parameterTypes, declaringClass, klass);
            }
        }
        throw new RuntimeException("Non-exhaustive switch");
    }

    private static boolean isOverridingMethodInClass(Method method, String name, Class<?>[] parameterTypes, Class<?> declaringClass, Class<?> lookupClass) {
        try {
            Method m = lookupClass.getDeclaredMethod(name, parameterTypes);
            return !m.isBridge() && !m.isSynthetic() && !Modifier.isPrivate(m.getModifiers()) && !m.isAnnotationPresent(IGNORE_ANNOTATION) && !ReflectionUtils.isHiddenMethod(m);
        }
        catch (Exception m) {
            block6: for (Method m2 : lookupClass.getDeclaredMethods()) {
                if (!m2.getName().equals(name) || m2.isBridge() || m2.isSynthetic() || m2.isAnnotationPresent(IGNORE_ANNOTATION) || Modifier.isFinal(m2.getModifiers()) || Modifier.isPrivate(m2.getModifiers()) || ReflectionUtils.isHiddenMethod(m2) || m2.getParameterTypes().length != parameterTypes.length) continue;
                int i = 0;
                try {
                    Map<TypeVariable<?>, Class<?>> typeArguments = ReflectionUtils.getTypeArguments(declaringClass, m2.getDeclaringClass(), Collections.emptyMap());
                    for (Type t : m2.getGenericParameterTypes()) {
                        try {
                            Class<?> parameterErasure = ReflectionUtils.getParameterErasure(typeArguments, t);
                            if (parameterErasure == parameterTypes[i++]) continue;
                        }
                        catch (ClassNotFoundException x) {}
                        continue block6;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Can't find type arguments for " + declaringClass, e);
                }
                return true;
            }
            return false;
        }
    }

    private static boolean isOverloadingMethodInClass(Method method, String name, Class<?>[] parameterTypes, Class<?> declaringClass, Class<?> lookupClass) {
        for (Method m : lookupClass.getDeclaredMethods()) {
            if (!m.getName().equals(name) || m.isBridge() || m.isSynthetic() || m.isAnnotationPresent(IGNORE_ANNOTATION) || Modifier.isPrivate(m.getModifiers()) || ReflectionUtils.isHiddenMethod(m)) continue;
            if (m.getParameterTypes().length != parameterTypes.length) {
                return true;
            }
            int i = 0;
            try {
                Map<TypeVariable<?>, Class<?>> typeArguments = ReflectionUtils.getTypeArguments(declaringClass, m.getDeclaringClass(), Collections.emptyMap());
                for (Type t : m.getGenericParameterTypes()) {
                    try {
                        Class<?> parameterErasure = ReflectionUtils.getParameterErasure(typeArguments, t);
                        if (parameterErasure == parameterTypes[i++]) continue;
                        return true;
                    }
                    catch (ClassNotFoundException x) {
                        return true;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find type arguments for " + declaringClass, e);
            }
        }
        return false;
    }

    private static boolean isHiddenMethod(Method m) {
        return m.getDeclaringClass() == Object.class && (m.getName().equals("finalize") || m.getName().equals("clone"));
    }

    private static Class<?> getParameterErasure(Map<TypeVariable<?>, Class<?>> typeArguments, Type t) throws ClassNotFoundException {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof TypeVariable) {
            Class<Object> parameterErasure = typeArguments.get(t);
            if (parameterErasure == null) {
                parameterErasure = Object.class;
            }
            return parameterErasure;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)t;
            Class<?> componentType = ReflectionUtils.getParameterErasure(typeArguments, gt.getGenericComponentType());
            ClassLoader classLoader = componentType.getClassLoader();
            String name = componentType.isArray() ? "[" + componentType.getName() : (componentType == Boolean.TYPE ? "[Z" : (componentType == Byte.TYPE ? "[B" : (componentType == Character.TYPE ? "[C" : (componentType == Double.TYPE ? "[D" : (componentType == Float.TYPE ? "[F" : (componentType == Integer.TYPE ? "[I" : (componentType == Long.TYPE ? "[J" : (componentType == Short.TYPE ? "[S" : "[L" + componentType.getName() + ";"))))))));
            return classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
        }
        throw new RuntimeException("Unknown parameter type: " + t);
    }

    private static Map<TypeVariable<?>, Class<?>> getTypeArguments(Class<?> base, Class<?> searchedSuperType, Map<TypeVariable<?>, Class<?>> baseTypeArguments) throws ClassNotFoundException {
        if (searchedSuperType.getTypeParameters().length == 0) {
            return Collections.emptyMap();
        }
        if (base.equals(searchedSuperType)) {
            return baseTypeArguments;
        }
        Map<TypeVariable<?>, Class<?>> ret = null;
        if (base.getSuperclass() != null) {
            Type superclass = base.getGenericSuperclass();
            ret = ReflectionUtils.getTypeArgumentsForSuperType(superclass, searchedSuperType, baseTypeArguments);
        }
        if (ret != null) {
            return ret;
        }
        if (searchedSuperType.isInterface()) {
            for (Type superinterface : base.getGenericInterfaces()) {
                ret = ReflectionUtils.getTypeArgumentsForSuperType(superinterface, searchedSuperType, baseTypeArguments);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private static Map<TypeVariable<?>, Class<?>> getTypeArgumentsForSuperType(Type superclass, Class<?> searchedSuperType, Map<TypeVariable<?>, Class<?>> baseTypeArguments) throws ClassNotFoundException {
        if (superclass instanceof Class) {
            Class sc = (Class)superclass;
            return ReflectionUtils.getTypeArguments(sc, searchedSuperType, ReflectionUtils.getTypeArguments(sc, Collections.emptyMap()));
        }
        if (superclass instanceof ParameterizedType) {
            Map<TypeVariable<?>, Class<?>> newTypeArgs = ReflectionUtils.getTypeArgumentsMap((ParameterizedType)superclass, baseTypeArguments);
            Class sc = (Class)((ParameterizedType)superclass).getRawType();
            return ReflectionUtils.getTypeArguments(sc, searchedSuperType, newTypeArgs);
        }
        throw new RuntimeException("Unknown superclass type: " + superclass);
    }

    private static Map<TypeVariable<?>, Class<?>> getTypeArgumentsMap(ParameterizedType pt, Map<TypeVariable<?>, Class<?>> baseTypeArguments) throws ClassNotFoundException {
        HashMap typeArgsMap = new HashMap();
        ReflectionUtils.addTypeArguments(pt, typeArgsMap, baseTypeArguments);
        while (pt.getOwnerType() instanceof ParameterizedType) {
            pt = (ParameterizedType)pt.getOwnerType();
            ReflectionUtils.addTypeArguments(pt, typeArgsMap, baseTypeArguments);
        }
        return typeArgsMap;
    }

    private static void addTypeArguments(ParameterizedType pt, Map<TypeVariable<?>, Class<?>> typeArgsMap, Map<TypeVariable<?>, Class<?>> baseTypeArguments) throws ClassNotFoundException {
        Class sc = (Class)pt.getRawType();
        Type[] typeArguments = pt.getActualTypeArguments();
        int i = 0;
        for (TypeVariable tv : sc.getTypeParameters()) {
            Type ta = typeArguments[i++];
            Class<?> erasedTa = ReflectionUtils.getParameterErasure(baseTypeArguments, ta);
            typeArgsMap.put(tv, erasedTa);
        }
    }

    private static Map<TypeVariable<?>, Class<?>> getTypeArguments(Class<?> base, Map<TypeVariable<?>, Class<?>> baseTypeArguments) {
        HashMap ret = new HashMap();
        for (TypeVariable<Class<?>> tv : base.getTypeParameters()) {
            Class<Object> typeArg = baseTypeArguments.get(tv);
            if (typeArg == null) {
                typeArg = Object.class;
            }
            ret.put(tv, typeArg);
        }
        return ret;
    }

    private static enum OverXing {
        Overloading,
        Overriding;

    }
}

