/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.model;

import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModule;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyModuleManager;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import java.util.List;

public abstract class ReflectionModuleManager
extends LazyModuleManager {
    private AbstractModelLoader modelLoader;

    @Override
    public void initCoreModules(Modules modules) {
        super.initCoreModules(modules);
        Module languageModule = modules.getLanguageModule();
        languageModule.setVersion("1.3.2");
    }

    @Override
    public AbstractModelLoader getModelLoader() {
        if (this.modelLoader == null) {
            this.modelLoader = this.createModelLoader(this.modules);
        }
        return this.modelLoader;
    }

    protected abstract AbstractModelLoader createModelLoader(Modules var1);

    @Override
    protected Module createModule(List<String> moduleName, String version2) {
        Module module = this.isModuleLoadedFromSource(JvmBackendUtil.getName(moduleName)) ? new Module() : new ReflectionModule(this);
        module.setName(moduleName);
        module.setVersion(version2);
        if (module instanceof ReflectionModule) {
            this.setupIfJDKModule((LazyModule)module);
        }
        return module;
    }

    @Override
    public void prepareForTypeChecking() {
        if (!this.isModuleLoadedFromSource("ceylon.language")) {
            this.loadStaticMetamodel();
            this.getModelLoader().loadStandardModules();
        }
        this.loadPackageDescriptors();
    }

    protected void loadPackageDescriptors() {
    }

    protected void loadStaticMetamodel() {
    }

    @Override
    public void modulesVisited() {
        if (this.isModuleLoadedFromSource("ceylon.language")) {
            this.getModelLoader().setupWithNoStandardModules();
        }
    }

    @Override
    public boolean shouldLoadTransitiveDependencies() {
        return true;
    }
}

