/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Constructor
extends TypeDeclaration
implements Functional {
    private ParameterList parameterList;
    private List<Declaration> overloads;
    private List<Declaration> members = new ArrayList<Declaration>(3);
    private List<Annotation> annotations = new ArrayList<Annotation>(4);
    private String typescriptEnum = null;

    @Override
    public boolean isValueConstructor() {
        return this.parameterList == null;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 0x1000L) != 0L;
    }

    public void setAbstract(boolean abstr) {
        this.flags = abstr ? (this.flags |= 0x1000L) : (this.flags &= 0xFFFFFFFFFFFFEFFFL);
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    @Override
    public ParameterList getFirstParameterList() {
        return this.getParameterList();
    }

    @Override
    public List<ParameterList> getParameterLists() {
        ParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parameterList);
    }

    @Override
    public void addParameterList(ParameterList pl) {
        this.parameterList = pl;
    }

    @Override
    public boolean isOverloaded() {
        return (this.flags & 0x2000L) != 0L;
    }

    public void setOverloaded(boolean overloaded) {
        this.flags = overloaded ? (this.flags |= 0x2000L) : (this.flags &= 0xFFFFFFFFFFFFDFFFL);
    }

    public void setAbstraction(boolean abstraction) {
        this.flags = abstraction ? (this.flags |= 0x4000L) : (this.flags &= 0xFFFFFFFFFFFFBFFFL);
    }

    @Override
    public boolean isAbstraction() {
        return (this.flags & 0x4000L) != 0L;
    }

    @Override
    public List<Declaration> getOverloads() {
        return this.overloads;
    }

    public void setOverloads(List<Declaration> overloads) {
        this.overloads = overloads;
    }

    public void initOverloads(Constructor ... initial) {
        this.overloads = new ArrayList<Declaration>(initial.length + 1);
        for (Constructor d : initial) {
            this.overloads.add(d);
        }
    }

    @Override
    public Parameter getParameter(String name) {
        for (Declaration d : this.getMembers()) {
            if (!d.isParameter() || !ModelUtil.isNamed(name, d)) continue;
            return ((FunctionOrValue)d).getInitializerParameter();
        }
        return null;
    }

    public String getTypescriptEnum() {
        return this.typescriptEnum;
    }

    public void setTypescriptEnum(String val) {
        if (val != null) {
            if (!this.isValueConstructor()) {
                throw new IllegalStateException("Only value constructors can be TypeScript enums");
            }
            if (!val.matches("[0-9.-]+") && !val.matches("[\\p{L}\\{Nl}$_][\\p{L}\\p{Nl}$_\u200c\u200d\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}]*")) {
                StringBuilder message = new StringBuilder("Illegal TypeScript enum name or value '");
                message.append(val);
                message.append("'");
                if (this.isMember()) {
                    message.append(" for member of '");
                    message.append(((ClassOrInterface)this.getContainer()).getName());
                    message.append("'");
                }
                throw new IllegalArgumentException(message.toString());
            }
        }
        this.typescriptEnum = val;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    public boolean isDeclaredVoid() {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    @Override
    public boolean isMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return DeclarationKind.CONSTRUCTOR;
    }

    @Override
    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean ellipsis) {
        return this.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration member) {
        if (member.getContainer().equals(this)) {
            return null;
        }
        if (this.getContainer() != null) {
            return this.getContainer().getInheritingDeclaration(member);
        }
        return null;
    }

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        Type et = this.getExtendedType();
        if (et != null) {
            et.getDeclaration().collectSupertypeDeclarations(results);
        }
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        Type et = this.getExtendedType();
        if (et != null) {
            return et.getDeclaration().inherits(dec);
        }
        return false;
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        Scope container = this.getContainer();
        ret = container instanceof Declaration ? 37 * ret + ((Declaration)((Object)container)).hashCodeForCache() : 37 * ret + container.hashCode();
        String qualifier = this.getQualifier();
        ret = 37 * ret + (qualifier == null ? 0 : qualifier.hashCode());
        ret = 37 * ret + Objects.hashCode(this.getName());
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == null || !(o instanceof Constructor)) {
            return false;
        }
        Constructor b = (Constructor)o;
        Scope container = this.getContainer();
        if (container instanceof Declaration ? !((Declaration)((Object)container)).equalsForCache(b.getContainer()) : !container.equals(b.getContainer())) {
            return false;
        }
        if (!Objects.equals(this.getQualifier(), b.getQualifier())) {
            return false;
        }
        return Objects.equals(this.getName(), b.getName());
    }

    @Override
    public String toString() {
        StringBuilder params = new StringBuilder();
        for (ParameterList pl : this.getParameterLists()) {
            params.append("(");
            boolean first = true;
            for (Parameter p : pl.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    params.append(", ");
                }
                if (p.getType() != null) {
                    params.append(p.getType().asString());
                    params.append(" ");
                }
                params.append(p.getName());
            }
            params.append(")");
        }
        return "new " + this.toStringName() + params;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

