/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TypeParameter
extends TypeDeclaration {
    private boolean covariant;
    private boolean contravariant;
    private Declaration declaration;
    private TypeDeclaration selfTypedDeclaration;
    private Type defaultTypeArgument;
    private boolean defaulted;
    private boolean constrained;
    private boolean typeConstructor;
    private Boolean hasNonErasedBounds;
    private List<Declaration> members = new ArrayList<Declaration>(0);
    private boolean captured;
    private List<TypeParameter> typeParameters = Collections.emptyList();
    private boolean reified = true;

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    public boolean isInvariant() {
        return !this.covariant && !this.contravariant;
    }

    public boolean isCovariant() {
        return this.covariant;
    }

    public void setCovariant(boolean covariant) {
        this.covariant = covariant;
    }

    public boolean isContravariant() {
        return this.contravariant;
    }

    public void setContravariant(boolean contravariant) {
        this.contravariant = contravariant;
    }

    public boolean isTypeConstructor() {
        return this.typeConstructor;
    }

    public void setTypeConstructor(boolean typeConstructor) {
        this.typeConstructor = typeConstructor;
    }

    public boolean isReified() {
        return this.reified && !this.getDeclaration().isJava();
    }

    public void setReified(boolean reified) {
        this.reified = reified;
    }

    @Override
    public boolean isOverloaded() {
        return false;
    }

    @Override
    public boolean isSelfType() {
        return this.selfTypedDeclaration != null;
    }

    public TypeDeclaration getSelfTypedDeclaration() {
        return this.selfTypedDeclaration;
    }

    public void setSelfTypedDeclaration(TypeDeclaration selfTypedDeclaration) {
        this.selfTypedDeclaration = selfTypedDeclaration;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(Declaration declaration) {
        this.declaration = declaration;
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return DeclarationKind.TYPE_PARAMETER;
    }

    @Override
    public String getQualifiedNameString() {
        return this.getName();
    }

    @Override
    public boolean isAbstraction() {
        return false;
    }

    @Override
    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public List<Declaration> getOverloads() {
        return null;
    }

    public Type getDefaultTypeArgument() {
        return this.defaultTypeArgument;
    }

    public void setDefaultTypeArgument(Type defaultTypeArgument) {
        this.defaultTypeArgument = defaultTypeArgument;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public void setDefaulted(boolean defaulted) {
        this.defaulted = defaulted;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public Boolean hasNonErasedBounds() {
        return this.hasNonErasedBounds;
    }

    public void setNonErasedBounds(boolean hasNonErasedBounds) {
        this.hasNonErasedBounds = hasNonErasedBounds;
    }

    @Override
    public boolean isEmptyType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isEmptyType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTupleType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isTupleType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSequenceType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isSequenceType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSequentialType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isSequentialType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getSatisfiedTypes() {
        List<Type> satisfiedTypes;
        List<Type> sts = satisfiedTypes = super.getSatisfiedTypes();
        int size = sts.size();
        for (int i = 0; i < size; ++i) {
            TypeDeclaration std;
            Type st = sts.get(i);
            if (st == null || (std = st.getDeclaration()) != this && !st.isTypeAlias()) continue;
            if (sts == satisfiedTypes) {
                sts = new ArrayList<Type>(sts);
            }
            sts.remove(i);
            --size;
            --i;
        }
        return sts;
    }

    @Override
    public List<Type> getCaseTypes() {
        List<Type> caseTypes = super.getCaseTypes();
        List<Type> cts = caseTypes;
        if (cts != null) {
            int size = cts.size();
            for (int i = 0; i < size; ++i) {
                TypeDeclaration ctd;
                Type ct = cts.get(i);
                if (ct == null || (ctd = ct.getDeclaration()) != this && !ct.isTypeAlias()) continue;
                if (cts == caseTypes) {
                    cts = new ArrayList<Type>(cts);
                }
                cts.remove(i);
                --i;
                --size;
            }
        }
        return cts;
    }

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        List<Type> stds = this.getSatisfiedTypes();
        int l = stds.size();
        for (int i = 0; i < l; ++i) {
            Type st = stds.get(i);
            st.getDeclaration().collectSupertypeDeclarations(results);
        }
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        int s = sts.size();
        for (int i = 0; i < s; ++i) {
            Type st = sts.get(i);
            if (!st.getDeclaration().inherits(dec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        ret = 37 * ret + this.getDeclaration().hashCodeForCache();
        ret = 37 * ret + Objects.hashCode(this.getName());
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof TypeParameter)) {
            return false;
        }
        TypeParameter b = (TypeParameter)o;
        return this.getDeclaration().equalsForCache(b.getDeclaration()) && Objects.equals(this.getName(), b.getName());
    }

    @Override
    public void clearProducedTypeCache() {
        ModelUtil.clearProducedTypeCache(this);
    }

    public void setCaptured(boolean captured) {
        this.captured = captured;
    }

    @Override
    public boolean isCaptured() {
        return this.captured;
    }

    @Override
    public String toString() {
        return "given " + this.toStringName();
    }
}

