/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.moduleloading;

import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.loader.BaseModuleLoaderImpl;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;

public class ToolModuleLoader
extends BaseModuleLoaderImpl {
    private ModuleLoadingTool tool;
    private ToolModuleLoaderContext context;
    private String[] artifactSuffixes;

    public ToolModuleLoader(ModuleLoadingTool tool, RepositoryManager repoManager, String[] artifactSuffixes) {
        super(repoManager, null);
        this.tool = tool;
        this.artifactSuffixes = artifactSuffixes;
        try {
            this.context = new ToolModuleLoaderContext(ModuleScope.RUNTIME);
        }
        catch (ModuleNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClassLoader loadModule(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        this.loadModuleForTool(name, version2, lookupScope);
        return null;
    }

    public boolean loadModuleForTool(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        return this.context.loadModule(name, version2);
    }

    @Override
    protected BaseModuleLoaderImpl.ModuleLoaderContext createModuleLoaderContext(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        return new ToolModuleLoaderContext(lookupScope);
    }

    public ArtifactResult getModuleArtifact(String name) {
        return this.context.getModuleArtifact(ModuleUtil.getModuleNameFromUri(name));
    }

    public SortedMap<String, SortedSet<String>> getDuplicateModules() {
        return this.context.getDuplicateModules();
    }

    public void visitModules(ModuleGraph.Visitor visitor) {
        this.context.visitModules(visitor);
    }

    public void resolve() throws ModuleNotFoundException {
        this.context.resolve();
    }

    public class ToolModuleLoaderContext
    extends BaseModuleLoaderImpl.ModuleLoaderContext {
        protected ToolModuleLoaderContext(ModuleScope lookupScope) throws ModuleNotFoundException {
            super(null, null, lookupScope);
        }

        @Override
        protected void initialise() throws ModuleNotFoundException {
        }

        @Override
        protected String[] getArtifactSuffixes() {
            return ToolModuleLoader.this.artifactSuffixes;
        }

        public boolean loadModule(String module, String version2) throws ModuleNotFoundException {
            try {
                return this.loadModule(ModuleUtil.getNamespaceFromUri(module), ModuleUtil.getModuleNameFromUri(module), version2, false, false, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void handleMissingModuleError(String name, String version2) throws ModuleNotFoundException {
            ToolModuleLoader.this.tool.handleMissingModuleError(name, version2);
        }

        public ArtifactResult getModuleArtifact(String name) {
            ModuleGraph.Module module = this.moduleGraph.findModule(name);
            return module != null ? module.artifact : null;
        }

        @Override
        protected boolean isExcluded(String name, String version2) {
            return ToolModuleLoader.this.tool.shouldExclude(name, version2);
        }

        @Override
        protected boolean includeOptional() {
            return ToolModuleLoader.this.tool.includeOptionalDependencies();
        }

        @Override
        public void cycleDetected(List<ModuleGraph.Module> path) {
            ToolModuleLoader.this.tool.cycleDetected(path);
        }

        @Override
        protected boolean selectDependencies(String name, String version2) {
            return !ToolModuleLoader.this.tool.isProvided(name, version2);
        }

        @Override
        public boolean selectDependency(ArtifactResult dep) {
            if (!super.selectDependency(dep)) {
                return false;
            }
            return !ToolModuleLoader.this.tool.skipDependency(dep);
        }

        public SortedMap<String, SortedSet<String>> getDuplicateModules() {
            return this.duplicateModules;
        }

        public void visitModules(ModuleGraph.Visitor visitor) {
            this.moduleGraph.visit(visitor);
        }

        public void resolve() throws ModuleNotFoundException {
            try {
                this.finishLoadingModules();
                Overrides overrides = ToolModuleLoader.this.repositoryManager.getOverrides();
                if (overrides == null) {
                    overrides = Overrides.create();
                    ToolModuleLoader.this.repositoryManager.setOverrides(overrides);
                }
                this.fillOverrides(overrides);
                this.reloadArtifactResults();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

