/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.ElementUtils;

public class Resolver {
    private final Resolve resolve;
    private final Names names;
    private final Trees trees;
    private final Log log;
    private static final Method FIND_METHOD;
    private static final Method FIND_VAR;
    private static final Method FIND_IDENT;
    private static final Method FIND_IDENT_IN_TYPE;
    private static final Method FIND_IDENT_IN_PACKAGE;
    private static final Method FIND_TYPE;
    private static final Class<?> ACCESSERROR;
    private static final Method ACCESSERROR_ACCESS;

    public Resolver(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.resolve = Resolve.instance(context);
        this.names = Names.instance(context);
        this.trees = Trees.instance(env);
        this.log = Log.instance(context);
    }

    public Env<AttrContext> getEnvForPath(TreePath path) {
        TreePath iter = path;
        JavacScope scope = null;
        while (scope == null && iter != null) {
            try {
                scope = (JavacScope)this.trees.getScope(iter);
            }
            catch (NullPointerException t2) {
                iter = iter.getParentPath();
            }
        }
        if (scope != null) {
            return scope.getEnv();
        }
        throw new BugInCF("Could not determine any possible scope for path: " + path.getLeaf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Symbol.PackageSymbol findPackage(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT, env, this.names.fromString(name), Kinds.KindSelector.PCK);
            if (res.getKind() == ElementKind.PACKAGE) {
                Symbol.PackageSymbol ps = (Symbol.PackageSymbol)res;
                Symbol.PackageSymbol packageSymbol = ps.exists() ? ps : null;
                return packageSymbol;
            }
            Symbol.PackageSymbol packageSymbol = null;
            return packageSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable VariableElement findField(String name, TypeMirror type, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_TYPE, env, type, this.names.fromString(name), Kinds.KindSelector.VAR);
            if (res.getKind().isField()) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            if (res.getKind() == ElementKind.OTHER && ACCESSERROR.isInstance(res)) {
                VariableElement variableElement = (VariableElement)((Object)this.wrapInvocation(res, ACCESSERROR_ACCESS, null, null));
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable VariableElement findLocalVariableOrParameter(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_VAR, env, this.names.fromString(name));
            if (res.getKind() == ElementKind.LOCAL_VARIABLE || res.getKind() == ElementKind.PARAMETER) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element findClass(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol symbol = this.wrapInvocationOnResolveInstance(FIND_TYPE, env, this.names.fromString(name));
            return symbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Symbol.ClassSymbol findClassInPackage(String name, Symbol.PackageSymbol pck, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_PACKAGE, env, pck, this.names.fromString(name), Kinds.KindSelector.TYP);
            if (ElementUtils.isTypeElement(res)) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)res;
                return classSymbol;
            }
            Symbol.ClassSymbol classSymbol = null;
            return classSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    public @Nullable ExecutableElement findMethod(String methodName, TypeMirror receiverType, TreePath path, java.util.List<TypeMirror> argumentTypes) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Type site = (Type)receiverType;
            Name name = this.names.fromString(methodName);
            List<Type> argtypes = List.nil();
            for (TypeMirror a : argumentTypes) {
                argtypes = argtypes.append((Type)a);
            }
            List typeargtypes = List.nil();
            boolean allowBoxing = true;
            boolean useVarargs = false;
            try {
                Object methodContext = this.buildMethodContext();
                Object oldContext = this.getField(this.resolve, "currentResolutionContext");
                this.setField(this.resolve, "currentResolutionContext", methodContext);
                Symbol result = this.wrapInvocationOnResolveInstance(FIND_METHOD, env, site, name, argtypes, typeargtypes, allowBoxing, useVarargs);
                this.setField(this.resolve, "currentResolutionContext", oldContext);
                if (result.getKind() == ElementKind.METHOD || result.getKind() == ElementKind.CONSTRUCTOR) {
                    ExecutableElement executableElement = (ExecutableElement)((Object)result);
                    return executableElement;
                }
                ExecutableElement executableElement = null;
                return executableElement;
            }
            catch (Throwable t2) {
                AssertionError err = new AssertionError((Object)String.format("Unexpected reflection error in findMethod(%s, %s, ..., %s)", methodName, receiverType, argumentTypes));
                ((Throwable)((Object)err)).initCause(t2);
                throw err;
            }
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Object buildMethodContext() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Class<?> methCtxClss = Class.forName("com.sun.tools.javac.comp.Resolve$MethodResolutionContext");
        Constructor<?> constructor = methCtxClss.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object methodContext = constructor.newInstance(this.resolve);
        this.setField(methodContext, "attrMode", (Object)DeferredAttr.AttrMode.CHECK);
        List phases = (List)this.getField(this.resolve, "methodResolutionSteps");
        assert (phases != null) : "@AssumeAssertion(nullness): assumption";
        this.setField(methodContext, "step", phases.get(1));
        return methodContext;
    }

    private void setField(Object receiver, String fieldName, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(receiver, value);
    }

    private @Nullable Object getField(Object receiver, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(receiver);
    }

    private Symbol wrapInvocationOnResolveInstance(Method method, Object ... args) {
        return this.wrapInvocation(this.resolve, method, args);
    }

    private Symbol wrapInvocation(Object receiver, Method method, Object ... args) {
        try {
            @NonNull Symbol res = (Symbol)method.invoke(receiver, args);
            return res;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new BugInCF(e, "Unexpected reflection error in wrapInvocation(%s, %s, %s)", receiver, method, Arrays.toString(args));
        }
    }

    static {
        try {
            Method findIdentInPackageMethod;
            Method findIdentInTypeMethod;
            Method findIdentMethod;
            FIND_METHOD = Resolve.class.getDeclaredMethod("findMethod", Env.class, Type.class, Name.class, List.class, List.class, Boolean.TYPE, Boolean.TYPE);
            FIND_METHOD.setAccessible(true);
            FIND_VAR = Resolve.class.getDeclaredMethod("findVar", Env.class, Name.class);
            FIND_VAR.setAccessible(true);
            try {
                findIdentMethod = Resolve.class.getDeclaredMethod("findIdent", Env.class, Name.class, Kinds.KindSelector.class);
            }
            catch (NoSuchMethodException e) {
                findIdentMethod = Resolve.class.getDeclaredMethod("findIdentInternal", Env.class, Name.class, Kinds.KindSelector.class);
            }
            FIND_IDENT = findIdentMethod;
            FIND_IDENT.setAccessible(true);
            try {
                findIdentInTypeMethod = Resolve.class.getDeclaredMethod("findIdentInType", Env.class, Type.class, Name.class, Kinds.KindSelector.class);
            }
            catch (NoSuchMethodException e) {
                findIdentInTypeMethod = Resolve.class.getDeclaredMethod("findIdentInTypeInternal", Env.class, Type.class, Name.class, Kinds.KindSelector.class);
            }
            FIND_IDENT_IN_TYPE = findIdentInTypeMethod;
            FIND_IDENT_IN_TYPE.setAccessible(true);
            try {
                findIdentInPackageMethod = Resolve.class.getDeclaredMethod("findIdentInPackage", Env.class, Symbol.TypeSymbol.class, Name.class, Kinds.KindSelector.class);
            }
            catch (NoSuchMethodException e) {
                findIdentInPackageMethod = Resolve.class.getDeclaredMethod("findIdentInPackageInternal", Env.class, Symbol.TypeSymbol.class, Name.class, Kinds.KindSelector.class);
            }
            FIND_IDENT_IN_PACKAGE = findIdentInPackageMethod;
            FIND_IDENT_IN_PACKAGE.setAccessible(true);
            FIND_TYPE = Resolve.class.getDeclaredMethod("findType", Env.class, Name.class);
            FIND_TYPE.setAccessible(true);
        }
        catch (Exception e) {
            AssertionError err = new AssertionError((Object)"Compiler 'Resolve' class doesn't contain required 'find' method");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        try {
            ACCESSERROR = Class.forName("com.sun.tools.javac.comp.Resolve$AccessError");
            ACCESSERROR_ACCESS = ACCESSERROR.getMethod("access", Name.class, Symbol.TypeSymbol.class);
            ACCESSERROR_ACCESS.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new BugInCF("Compiler 'Resolve$AccessError' class could not be retrieved.", e);
        }
        catch (NoSuchMethodException e) {
            throw new BugInCF("Compiler 'Resolve$AccessError' class doesn't contain required 'access' method", e);
        }
    }
}

