/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChromatticBuilder {
    public static final Option<String> INSTRUMENTOR_CLASSNAME = new Option("org.chromattic.api.Option.instrumentor.classname", "intrumentor");
    public static final Option<String> SESSION_PROVIDER_CLASSNAME = new Option("org.chromattic.api.Option.repository_provider.classname", "repository provider");
    public static final Option<String> OBJECT_NAME_FORMATTER_CLASSNAME = new Option("org.chromattic.api.Option.object_name_formatter.classname", "object name formatter");
    protected final Set<Class<?>> classes = new HashSet();
    protected final Map<String, OptionInstance<?>> options = new HashMap();

    public static ChromatticBuilder create() {
        String builderClassName = "org.chromattic.core.builder.ChromatticBuilderImpl";
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(builderClassName);
            if (ChromatticBuilder.class.isAssignableFrom(clazz)) {
                Class<ChromatticBuilder> builderClass = clazz.asSubclass(ChromatticBuilder.class);
                return builderClass.newInstance();
            }
            throw new BuilderException("Instrumentor class " + builderClassName + " does not extends the " + ChromatticBuilder.class.getName() + " class");
        }
        catch (InstantiationException e) {
            throw new BuilderException("Could not instanciate builder " + builderClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BuilderException("Could not instanciate builder " + builderClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException("Could not load builder class " + builderClassName, e);
        }
    }

    public <T> void setOption(Option<T> option, T value) {
        this.options.put(option.getName(), new OptionInstance(option, value));
    }

    public void add(Class<?> clazz) {
        this.classes.add(clazz);
    }

    public Chromattic build() throws Exception {
        return this.boot();
    }

    protected abstract Chromattic boot() throws Exception;

    protected abstract <T> void configure(OptionInstance<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OptionInstance<T> {
        private final Option<T> option;
        private final T value;

        private OptionInstance(Option<T> option, T value) {
            this.option = option;
            this.value = value;
        }

        public Option<T> getOption() {
            return this.option;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof OptionInstance) {
                OptionInstance that = (OptionInstance)obj;
                return ((Option)this.option).name.equals(((Option)that.option).name);
            }
            return false;
        }

        public int hashCode() {
            return ((Option)this.option).name.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option<T> {
        private final String name;
        private final String shortName;

        private Option(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

