/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCR {
    public static Iterator<Property> adapt(PropertyIterator iterator) {
        return iterator;
    }

    public static Iterator<Node> adapt(NodeIterator iterator) {
        return iterator;
    }

    public static boolean hasMixin(Node node, String mixinTypeName) throws RepositoryException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (mixinTypeName == null) {
            throw new NullPointerException();
        }
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(mixinTypeName)) continue;
            return true;
        }
        return false;
    }

    public static PropertyDefinition getPropertyDefinition(NodeType nodeType, String propertyName) throws RepositoryException {
        for (PropertyDefinition def : nodeType.getPropertyDefinitions()) {
            if (!def.getName().equals(propertyName)) continue;
            return def;
        }
        return null;
    }

    public static PropertyDefinition getPropertyDefinition(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDefinition();
        }
        NodeType primaryNodeType = node.getPrimaryNodeType();
        PropertyDefinition def = JCR.getPropertyDefinition(primaryNodeType, propertyName);
        if (def == null) {
            NodeType mixinNodeType;
            NodeType[] arr$ = node.getMixinNodeTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (def = JCR.getPropertyDefinition(mixinNodeType = arr$[i$], propertyName)) == null; ++i$) {
            }
        }
        return def;
    }

    public static void validateName(String name) {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("No empty name accepted");
        }
        int index = 0;
        if (name.charAt(0) == '{') {
            int curlyBraceIndex = name.indexOf(125);
            if (curlyBraceIndex == -1) {
                throw new IllegalArgumentException("Uri not closed in name value " + name);
            }
            String uri = name.substring(1, curlyBraceIndex);
            index = curlyBraceIndex + 1;
        } else {
            int colonIndex = name.indexOf(58);
            if (colonIndex != -1) {
                String prefix = name.substring(0, colonIndex);
                index = colonIndex + 1;
            }
        }
        int length = name.length();
        if (length - index == 1) {
            if (name.charAt(index) == '.') {
                throw new IllegalArgumentException("'.' is not a valid name");
            }
        } else if (length - index == 2 && name.charAt(index) == '.' && name.charAt(index + 1) == '.') {
            throw new IllegalArgumentException("'..' is not a valid name");
        }
        while (index < length) {
            char c;
            if ((c = name.charAt(index++)) == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                if (c != '/' && c != ':' && c != '[' && c != ']' && c != '|' && c != '*') continue;
                throw new IllegalArgumentException("Illegal path value " + name + "  (char " + c + " at position " + index + " not accepted)");
            }
            throw new IllegalArgumentException("Illegal path value " + name + "  (char " + c + " at position " + index + " not accepted)");
        }
    }
}

