/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.chromattic.common.ElementInsertion;
import org.chromattic.common.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingListIterator<E>
implements ListIterator<E> {
    private static final Object MARKER = new Object();
    private final ListModel<E> model;
    private final ArrayList<E> elements;
    private Iterator<E> iterator;
    private int offset;
    private Boolean forward;
    private E e;

    public BufferingListIterator(ListModel<E> model) {
        Object e = MARKER;
        this.model = model;
        this.iterator = model.iterator();
        this.elements = new ArrayList();
        this.offset = 0;
        this.e = e;
        this.forward = null;
    }

    @Override
    public boolean hasNext() {
        return this.offset > 0 || this.iterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.offset < this.elements.size();
    }

    @Override
    public E next() {
        if (this.offset == 0) {
            E next = this.iterator.next();
            this.elements.add(next);
            this.e = next;
            this.forward = true;
            return next;
        }
        --this.offset;
        int index = this.elements.size() - (this.offset + 1);
        E next = this.elements.get(index);
        this.e = next;
        this.forward = true;
        return next;
    }

    @Override
    public E previous() {
        int index = this.elements.size() - (this.offset + 1);
        if (index < 0) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        E previous = this.elements.get(index);
        this.e = previous;
        this.forward = false;
        return previous;
    }

    @Override
    public int nextIndex() {
        return this.elements.size() - this.offset;
    }

    @Override
    public int previousIndex() {
        return this.elements.size() - (this.offset + 1);
    }

    private E peekNext() {
        if (this.offset == 0) {
            if (this.iterator.hasNext()) {
                E next = this.iterator.next();
                this.elements.add(next);
                ++this.offset;
                return next;
            }
            throw new AssertionError((Object)"internal bug");
        }
        return this.elements.get(this.elements.size() - this.offset);
    }

    private E peekPrevious() {
        int index = this.elements.size() - (this.offset + 1);
        if (index < 0) {
            throw new AssertionError((Object)"internal bug");
        }
        return this.elements.get(index);
    }

    @Override
    public void remove() {
        if (this.e == MARKER) {
            throw new IllegalStateException();
        }
        int index = this.forward != false ? this.elements.size() - (this.offset + 1) : this.elements.size() - this.offset;
        this.model.remove(index, this.e);
        this.elements.remove(index);
        if (!this.forward.booleanValue()) {
            --this.offset;
        }
        Object tmp = MARKER;
        this.e = tmp;
        this.forward = null;
        this.iterator = this.model.iterator();
        int length = this.elements.size();
        while (length-- > 0) {
            this.iterator.next();
        }
    }

    @Override
    public void set(E e) {
        if (this.e == MARKER) {
            throw new IllegalStateException();
        }
        int index = this.forward != false ? this.elements.size() - (this.offset + 1) : this.elements.size() - this.offset;
        this.model.set(index, this.e, e);
        this.elements.set(index, e);
        this.iterator = this.model.iterator();
        int length = this.elements.size();
        while (length-- > 0) {
            this.iterator.next();
        }
    }

    @Override
    public void add(E e) {
        ElementInsertion position;
        int index = this.elements.size() - this.offset;
        if (this.hasPrevious()) {
            E previous = this.peekPrevious();
            if (this.hasNext()) {
                E next = this.peekNext();
                position = new ElementInsertion.Middle<E>(index, previous, e, next);
            } else {
                position = new ElementInsertion.Last<E>(index, previous, e);
            }
        } else if (this.hasNext()) {
            E next = this.peekNext();
            position = new ElementInsertion.First<E>(e, next);
        } else {
            position = new ElementInsertion.Singleton<E>(e);
        }
        this.model.add(position);
        this.elements.add(index, e);
        ++this.offset;
        Object tmp = MARKER;
        this.e = tmp;
        this.forward = null;
        this.iterator = this.model.iterator();
        int length = this.elements.size();
        while (length-- > 0) {
            this.iterator.next();
        }
    }
}

