/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.collection.delta;

import java.util.Iterator;
import org.chromattic.common.collection.delta.IteratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Segment<E> {
    abstract Segment<E> getNext();

    abstract void setNext(Segment<E> var1);

    abstract Segment<E> getPrevious();

    abstract void setPrevious(Segment<E> var1);

    protected abstract E localGet(int var1);

    protected abstract int localSize();

    protected abstract boolean localCanAdd(int var1);

    protected abstract void localAdd(int var1, E var2);

    protected abstract E localRemove(int var1);

    protected abstract Iterator<E> localIterator();

    public final E get(int index) {
        Segment<E> segment = this;
        while (true) {
            if (index < 0) {
                Segment<E> previous = segment.getPrevious();
                if (previous == null) {
                    throw new IndexOutOfBoundsException();
                }
                index += previous.localSize();
                segment = previous;
                continue;
            }
            int localSize = segment.localSize();
            if (index < localSize) break;
            Segment<E> next = segment.getNext();
            if (next == null) {
                throw new IndexOutOfBoundsException();
            }
            index -= localSize;
            segment = next;
        }
        return segment.localGet(index);
    }

    public final void add(int index, E e) {
        Segment<E> segment = this;
        while (true) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (segment.localCanAdd(index)) break;
            Segment<E> next = segment.getNext();
            if (next == null) {
                throw new IndexOutOfBoundsException();
            }
            index -= segment.localSize();
            segment = next;
        }
        segment.localAdd(index, e);
    }

    public final E remove(int index) {
        Segment<E> segment = this;
        while (true) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            int localSize = segment.localSize();
            if (index < localSize) {
                return segment.localRemove(index);
            }
            Segment<E> next = segment.getNext();
            if (next == null) {
                throw new IndexOutOfBoundsException();
            }
            index -= localSize;
            segment = next;
        }
    }

    public final int size() {
        int size = 0;
        for (Segment<E> segment = this; segment != null; segment = segment.getNext()) {
            size += segment.localSize();
        }
        return size;
    }

    public final Iterator<E> iterator() {
        return new IteratorImpl(this);
    }

    public final int complexity() {
        int complexity = 0;
        for (Segment<E> segment = this; segment != null; segment = segment.getNext()) {
            ++complexity;
        }
        return complexity;
    }

    final boolean hasNext() {
        return this.getNext() != null;
    }

    final Segment<E> addAfter(Segment<E> segment) {
        Segment<E> next = this.getNext();
        if (next != null) {
            segment.setNext(next);
            next.setPrevious(segment);
        }
        segment.setPrevious(this);
        this.setNext(segment);
        return segment;
    }

    protected abstract void format(StringBuilder var1);

    public String format() {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        for (Segment<E> segment = this; segment != null; segment = segment.getNext()) {
            if (count > 0) {
                builder.append(",");
            }
            segment.format(builder);
            ++count;
        }
        builder.append("]");
        return builder.toString();
    }
}

