/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.xml;

import java.lang.reflect.UndeclaredThrowableException;
import org.chromattic.common.xml.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementWriter
extends XMLWriter {
    private static final AttributesImpl EMPTY = new AttributesImpl();
    private static final int INITIAL = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private final String qName;
    private AttributesImpl attrs;
    private int status;
    private final ContentHandler handler;
    private ElementWriter currentChild;
    private XMLWriter parent;

    public ElementWriter(ContentHandler handler, XMLWriter parent, String qName) {
        this.handler = handler;
        this.qName = qName;
        this.status = 0;
        this.attrs = EMPTY;
        this.currentChild = null;
        this.parent = parent;
    }

    private void start() {
        try {
            this.handler.startElement("", "", this.qName, this.attrs);
        }
        catch (SAXException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void end() {
        try {
            this.handler.endElement("", "", this.qName);
        }
        catch (SAXException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void content(String data) {
        switch (this.status) {
            case 0: {
                this.start();
                this.status = 1;
                break;
            }
            case 1: {
                if (this.currentChild == null) break;
                this.currentChild.close();
                this.currentChild = null;
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
        }
        try {
            this.handler.characters(data.toCharArray(), 0, data.length());
        }
        catch (SAXException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public XMLWriter getParent() {
        return this.parent;
    }

    public ElementWriter element(String qName) {
        switch (this.status) {
            case 0: {
                this.start();
                this.status = 1;
                break;
            }
            case 1: {
                if (this.currentChild == null) break;
                this.currentChild.close();
                this.currentChild = null;
                break;
            }
            case 2: {
                throw new IllegalStateException("Element " + this.qName + " is already closed");
            }
        }
        this.currentChild = new ElementWriter(this.handler, this, qName);
        return this.currentChild;
    }

    void close() {
        switch (this.status) {
            case 0: {
                this.start();
                this.end();
                break;
            }
            case 1: {
                if (this.currentChild != null) {
                    this.currentChild.close();
                    this.currentChild = null;
                }
                this.end();
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
        }
        this.status = 2;
    }

    public ElementWriter withAttribute(String qName, String value) {
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        if (this.attrs == EMPTY) {
            this.attrs = new AttributesImpl();
        }
        this.attrs.addAttribute("", "", qName, "", value);
        return this;
    }
}

