/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.Status;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.ChildCollectionIterator;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.LifeCycleType;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.PersistentContextState;
import org.chromattic.core.ReferentCollectionIterator;
import org.chromattic.core.RemovedContextState;
import org.chromattic.core.TransientContextState;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.NodeDef;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.mapper.TypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DomainSessionImpl
extends DomainSession {
    final Domain domain;
    private final SessionWrapper sessionWrapper;
    private final Map<String, ObjectContext> contexts;
    private final Logger log = Logger.getLogger(DomainSession.class);

    public DomainSessionImpl(Domain domain, SessionWrapper sessionWrapper) {
        super(domain);
        this.domain = domain;
        this.sessionWrapper = sessionWrapper;
        this.contexts = new HashMap<String, ObjectContext>();
    }

    public Session getJCRSession() {
        return this.sessionWrapper.getSession();
    }

    @Override
    protected <O> O _findByPath(Object o, Class<O> clazz, String relPath) throws RepositoryException {
        Node origin;
        if (o != null) {
            ObjectContext ctx = this.unwrap(o);
            origin = ctx.state.getNode();
        } else {
            origin = this.sessionWrapper.getSession().getRootNode();
            this.nodeRead(origin);
        }
        try {
            Node node = origin.getNode(relPath);
            this.nodeRead(node);
            return this.findByNode(clazz, node);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    protected String _persist(ObjectContext ctx, String relPath) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException("No null object context accepted");
        }
        if (relPath == null) {
            throw new NullPointerException("No relative path specified");
        }
        if (ctx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to persist non transient object " + ctx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        NodeDef nodeDef = ctx.mapper.getNodeDef();
        this.log.trace("Setting context {} for insertion", (Object)ctx);
        this.log.trace("Adding node for context {} and node type {}", (Object)ctx, (Object)nodeDef);
        Node node = this.sessionWrapper.addNode(relPath, nodeDef);
        this.nodeAdded(node, ctx);
        String id = node.getUUID();
        this.log.trace("Added context {} for id {}", (Object)ctx, (Object)id);
        return id;
    }

    @Override
    protected String _persist(ObjectContext parentCtx, String relPath, ObjectContext childCtx) throws NullPointerException, IllegalArgumentException, IllegalStateException, RepositoryException {
        if (parentCtx == null) {
            String msg = "Cannot insert context " + childCtx + " as a child of a null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (childCtx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to insert transient context " + childCtx + " as child of " + parentCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        if (relPath == null) {
            String msg = "Attempt to insert context " + childCtx + " with no relative path to " + parentCtx;
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (parentCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to insert context " + childCtx + " as child of non persistent context " + parentCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        Node parentNode = parentCtx.state.getNode();
        if (parentNode.hasNode(relPath)) {
            String msg = "Attempt to insert context " + childCtx + " as an existing child with name " + relPath + " child of context " + parentCtx;
            this.log.error(msg);
            throw new DuplicateNameException(msg);
        }
        NodeDef nodeDef = childCtx.mapper.getNodeDef();
        this.log.trace("Setting context {} for insertion", (Object)childCtx);
        this.log.trace("Adding node for context {} and node type {} as child of context {}", new Object[]{childCtx, nodeDef, parentCtx});
        Node child = this.sessionWrapper.addNode(parentNode, relPath, nodeDef);
        this.nodeAdded(child, childCtx);
        String childId = child.getUUID();
        this.log.trace("Added context {} for id {}", (Object)childCtx, (Object)childId);
        return childId;
    }

    @Override
    protected <O> O _create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        TypeMapper typeMapper = this.domain.getTypeMapper(clazz);
        NodeType nodeType = this.sessionWrapper.getNodeType(typeMapper.getNodeDef().getPrimaryNodeTypeName());
        TransientContextState state = new TransientContextState(this, nodeType);
        ObjectContext ctx = new ObjectContext(typeMapper, state);
        if (name != null) {
            ctx.setName(name);
        }
        this.fireEvent(LifeCycleType.CREATED, ctx);
        return (O)ctx.getObject();
    }

    @Override
    protected <O> O _findById(Class<O> clazz, String id) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.contexts.get(id);
        if (ctx == null) {
            try {
                this.log.trace("About to load node with id {} and class {}", (Object)id, (Object)clazz.getName());
                Node node = this.sessionWrapper.getNodeByUUID(id);
                this.nodeRead(node);
                this.log.trace("Loaded node with id {}", (Object)id, (Object)clazz.getName());
                ctx = this.contexts.get(id);
                this.log.trace("Obtained context {} node for id {} and class {}", new Object[]{ctx, id, clazz.getName()});
            }
            catch (ItemNotFoundException e) {
                this.log.trace("Could not find node with id {}", (Object)id, (Object)clazz.getName());
                return null;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (ctx == null) {
            return null;
        }
        Object object = ctx.object;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        String msg = "Could not cast context " + ctx + " with class " + object.getClass().getName() + " to class " + clazz.getName();
        throw new ClassCastException(msg);
    }

    @Override
    protected void _save() throws RepositoryException {
        this.sessionWrapper.save();
    }

    @Override
    protected void _remove(Object o) throws RepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext context = this.unwrap(o);
        this._remove(context);
    }

    @Override
    protected void _remove(ObjectContext context) throws RepositoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        switch (context.state.getStatus()) {
            case TRANSIENT: {
                throw new IllegalStateException("Cannot remove transient node");
            }
            case PERSISTENT: {
                Node node = context.state.getNode();
                this.remove(node);
                break;
            }
            case REMOVED: {
                throw new IllegalStateException("Cannot remove removed node");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void remove(Node node) throws RepositoryException {
        Iterator<String> ids = this.sessionWrapper.remove(node);
        while (ids.hasNext()) {
            String id = ids.next();
            this.nodeRemoved(id);
        }
    }

    @Override
    protected Object _getReferenced(ObjectContext referentCtx, String name, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node referent = referentCtx.state.getNode();
        Node referenced = this.sessionWrapper.getReferenced(referent, name, linkType);
        if (referenced != null) {
            return this.findByNode(Object.class, referenced);
        }
        return null;
    }

    @Override
    protected boolean _setReferenced(ObjectContext referentCtx, String name, ObjectContext referencedCtx, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Cannot create a relationship with a non persisted context " + this);
        }
        Node referent = referentCtx.state.getNode();
        if (referencedCtx != null) {
            if (referencedCtx.getStatus() != Status.PERSISTENT) {
                throw new IllegalStateException();
            }
            Node referenced = referencedCtx.state.getNode();
            return referenced != this.sessionWrapper.setReferenced(referent, name, referenced, linkType);
        }
        return null != this.sessionWrapper.setReferenced(referent, name, null, linkType);
    }

    @Override
    protected <T> Iterator<T> _getReferents(ObjectContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws RepositoryException {
        Node referenced = referencedCtx.state.getNode();
        Iterator<Node> referents = this.sessionWrapper.getReferents(referenced, name, linkType);
        return new ReferentCollectionIterator<T>(this, referents, filterClass, name);
    }

    @Override
    protected void _removeChild(ObjectContext ctx, String name) throws RepositoryException {
        name = this.encodeName(name);
        Node node = ctx.state.getNode();
        if (node.hasNode(name)) {
            Node childNode = node.getNode(name);
            this.remove(childNode);
        }
    }

    @Override
    protected Object _getChild(ObjectContext ctx, String name) throws RepositoryException {
        name = this.encodeName(name);
        Node node = ctx.state.getNode();
        this.log.trace("About to load the name child {} of context {}", (Object)name, (Object)this);
        Node child = this.sessionWrapper.getChild(node, name);
        if (child != null) {
            this.log.trace("Loaded named child {} of context {} with id {}", new Object[]{name, this, child.getUUID()});
            return this.findByNode(Object.class, child);
        }
        this.log.trace("No child named {} to load for context {}", (Object)name, (Object)this);
        return null;
    }

    @Override
    protected <T> Iterator<T> _getChildren(ObjectContext ctx, Class<T> filterClass) throws RepositoryException {
        Node node = ctx.state.getNode();
        Iterator<Node> iterator = this.sessionWrapper.getChildren(node);
        return new ChildCollectionIterator<T>(this, iterator, filterClass);
    }

    @Override
    protected Object _getParent(ObjectContext ctx) throws RepositoryException {
        if (ctx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node node = ctx.state.getNode();
        Node parent = this.sessionWrapper.getParent(node);
        return this.findByNode(Object.class, parent);
    }

    public void nodeRead(Node node) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        TypeMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            String id = node.getUUID();
            ObjectContext ctx = this.contexts.get(id);
            if (ctx == null) {
                ctx = new ObjectContext(mapper);
                this.log.trace("Inserted context {} loaded from node id {}", (Object)ctx, (Object)id);
                this.contexts.put(id, ctx);
                ctx.state = new PersistentContextState(mapper, node, this);
                this.fireEvent(LifeCycleType.LOADED, ctx);
            } else {
                this.log.trace("Context {} is already present for id ", (Object)ctx, (Object)id);
            }
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    public void nodeAdded(Node node, ObjectContext ctx) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        TypeMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            String id = node.getUUID();
            if (this.contexts.containsKey(id)) {
                String msg = "Attempt to replace an existing context " + ctx + " with id " + id;
                this.log.error(msg);
                throw new AssertionError((Object)msg);
            }
            this.log.trace("Inserted context {} for id {}", (Object)ctx, (Object)id);
            this.contexts.put(id, ctx);
            ctx.state = new PersistentContextState(mapper, node, this);
            this.fireEvent(LifeCycleType.PERSISTED, ctx);
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    public void nodeRemoved(String nodeId) throws RepositoryException {
        this.log.trace("Removing context for id {}", (Object)nodeId);
        ObjectContext ctx = this.contexts.remove(nodeId);
        if (ctx != null) {
            ctx.state = new RemovedContextState(nodeId, ctx.state.getPrimaryNodeType());
            this.fireEvent(LifeCycleType.REMOVED, ctx);
            this.log.trace("Removed context {} for id {}", (Object)ctx, (Object)nodeId);
        } else {
            this.log.trace("Context absent for removal for id {}", (Object)ctx, (Object)nodeId);
        }
    }

    public void close() {
        this.sessionWrapper.close();
    }
}

