/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.builder;

import java.util.HashSet;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.format.DefaultObjectFormatter;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.Domain;
import org.chromattic.core.builder.ChromatticImpl;
import org.chromattic.core.mapping.TypeMapping;
import org.chromattic.core.mapping.TypeMappingBuilder;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.jcr.SessionLifeCycle;
import org.reflext.api.ClassTypeInfo;
import org.reflext.core.TypeDomain;
import org.reflext.jlr.JavaLangReflectMethodModel;
import org.reflext.jlr.JavaLangReflectTypeModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticBuilderImpl
extends ChromatticBuilder {
    private Instrumentor instrumentor;
    private SessionLifeCycle sessionProvider;
    private ObjectFormatter objectFormatter;

    public ChromatticBuilderImpl() {
        this.setOption(INSTRUMENTOR_CLASSNAME, "org.chromattic.apt.InstrumentorImpl");
        this.setOption(SESSION_PROVIDER_CLASSNAME, "org.chromattic.exo.ExoSessionLifeCycle");
        this.setOption(OBJECT_NAME_FORMATTER_CLASSNAME, DefaultObjectFormatter.class.getName());
    }

    private <T> T create(ChromatticBuilder.OptionInstance<String> optionInstance, Class<T> expectedClass) {
        ChromatticBuilder.Option option = optionInstance.getOption();
        String s = (String)optionInstance.getValue();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> instrumentorClass = classLoader.loadClass(s);
            if (expectedClass.isAssignableFrom(instrumentorClass)) {
                Class<T> ic2 = instrumentorClass.asSubclass(expectedClass);
                return ic2.newInstance();
            }
            throw new BuilderException("Class " + s + " does not implement the " + expectedClass.getName() + " interface");
        }
        catch (InstantiationException e) {
            throw new BuilderException("Could not instanciate " + option.getShortName() + " " + s, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuilderException("Could not instanciate " + option.getShortName(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException("Could not load " + option.getShortName() + " class " + s, (Throwable)e);
        }
    }

    protected <T> void configure(ChromatticBuilder.OptionInstance<T> optionInstance) {
        if (optionInstance.getOption() == INSTRUMENTOR_CLASSNAME) {
            this.instrumentor = this.create(optionInstance, Instrumentor.class);
        } else if (optionInstance.getOption() == SESSION_PROVIDER_CLASSNAME) {
            this.sessionProvider = this.create(optionInstance, SessionLifeCycle.class);
        } else if (optionInstance.getOption() == OBJECT_NAME_FORMATTER_CLASSNAME) {
            this.objectFormatter = this.create(optionInstance, ObjectFormatter.class);
        }
    }

    protected Chromattic boot() throws Exception {
        for (ChromatticBuilder.OptionInstance optionInstance : this.options.values()) {
            this.configure(optionInstance);
        }
        TypeDomain typeDomain = new TypeDomain((TypeModel)new JavaLangReflectTypeModel(), (MethodModel)new JavaLangReflectMethodModel());
        HashSet<TypeMapping> mappings = new HashSet<TypeMapping>();
        for (Class clazz : this.classes) {
            ClassTypeInfo typeInfo = (ClassTypeInfo)typeDomain.getType((Object)clazz);
            TypeMappingBuilder mappingBuilder = new TypeMappingBuilder(typeInfo);
            TypeMapping mapping = mappingBuilder.build();
            mappings.add(mapping);
        }
        Domain domain = new Domain(mappings, this.instrumentor, this.objectFormatter);
        return new ChromatticImpl(domain, this.sessionProvider);
    }
}

