/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.jcr.AbstractLinkManager;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.NodeDef;
import org.chromattic.core.jcr.PathLinkManager;
import org.chromattic.core.jcr.ReferenceLinkManager;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.spi.jcr.SessionLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionWrapperImpl
implements SessionWrapper {
    private final Logger log = Logger.getLogger(SessionWrapperImpl.class);
    private static final ConcurrentHashMap<Session, SessionWrapperImpl> sessionMapping = new ConcurrentHashMap();
    public final Session session;
    private AbstractLinkManager[] linkMgrs;
    private SessionLifeCycle sessionLifeCycle;

    public SessionWrapperImpl(SessionLifeCycle sessionLifeCycle, Session session) {
        this.sessionLifeCycle = sessionLifeCycle;
        this.session = session;
        this.linkMgrs = new AbstractLinkManager[]{new ReferenceLinkManager(session), new PathLinkManager(session)};
        sessionMapping.put(session, this);
    }

    @Override
    public NodeType getNodeType(String nodeTypeName) throws RepositoryException {
        NodeTypeManager mgr = this.session.getWorkspace().getNodeTypeManager();
        return mgr.getNodeType(nodeTypeName);
    }

    @Override
    public Node addNode(String relPath, NodeDef nodeType) throws RepositoryException {
        return this.addNode(this.session.getRootNode(), relPath, nodeType);
    }

    @Override
    public Node addNode(Node parentNode, String relPath, NodeDef nodeType) throws RepositoryException {
        Node childNode = parentNode.addNode(relPath, nodeType.getPrimaryNodeTypeName());
        for (String mixinName : nodeType.getMixinNames()) {
            childNode.addMixin(mixinName);
        }
        return childNode;
    }

    @Override
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.session.getNodeByUUID(uuid);
    }

    @Override
    public Node getParent(Node childNode) throws RepositoryException {
        return childNode.getParent();
    }

    @Override
    public Iterator<Node> getChildren(Node parentNode) throws RepositoryException {
        return parentNode.getNodes();
    }

    @Override
    public Node getChild(Node parentNode, String name) throws RepositoryException {
        if (parentNode.hasNode(name)) {
            return parentNode.getNode(name);
        }
        return null;
    }

    @Override
    public Iterator<String> remove(Node node) throws RepositoryException {
        LinkedList<String> ids = new LinkedList<String>();
        this.remove(node, ids);
        return ids.iterator();
    }

    public void remove(Node node, LinkedList<String> ids) throws RepositoryException {
        Property property;
        NodeIterator i = node.getNodes();
        while (i.hasNext()) {
            Node child = i.nextNode();
            this.remove(child, ids);
        }
        i = node.getReferences();
        while (i.hasNext()) {
            property = i.nextProperty();
            property.setValue((Node)null);
        }
        i = node.getProperties();
        while (i.hasNext()) {
            property = i.nextProperty();
            if (property.getType() == 9) {
                this.linkMgrs[LinkType.REFERENCE.index].setReferenced(node, property.getName(), null);
                continue;
            }
            if (property.getType() != 8) continue;
            this.linkMgrs[LinkType.PATH.index].setReferenced(node, property.getName(), null);
        }
        String id = node.getUUID();
        node.remove();
        ids.add(id);
    }

    @Override
    public void save() throws RepositoryException {
        this.sessionLifeCycle.save(this.session);
        for (AbstractLinkManager mgr : this.linkMgrs) {
            mgr.clear();
        }
    }

    @Override
    public Node getReferenced(Node referent, String propertyName, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].getReferenced(referent, propertyName);
    }

    @Override
    public Node setReferenced(Node referent, String propertyName, Node referenced, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].setReferenced(referent, propertyName, referenced);
    }

    @Override
    public Iterator<Node> getReferents(Node referenced, String propertyName, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].getReferents(referenced, propertyName);
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SessionWrapperImpl) {
            SessionWrapperImpl that = (SessionWrapperImpl)obj;
            return this.session == that.session;
        }
        return false;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        for (AbstractLinkManager mgr : this.linkMgrs) {
            mgr.clear();
        }
        this.sessionLifeCycle.close(this.session);
    }
}

