/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.EntityContext;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.SessionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainSession
implements ChromatticSession {
    protected final EventBroadcaster broadcaster;
    final Domain domain;
    protected final SessionWrapper sessionWrapper;

    protected DomainSession(Domain domain, SessionWrapper sessionWrapper) {
        this.domain = domain;
        this.broadcaster = new EventBroadcaster();
        this.sessionWrapper = sessionWrapper;
    }

    protected abstract void _setName(EntityContext var1, String var2) throws RepositoryException;

    protected abstract String _persist(EntityContext var1, String var2) throws RepositoryException;

    protected abstract String _persist(EntityContext var1, String var2, EntityContext var3) throws RepositoryException;

    protected abstract <O> O _create(Class<O> var1, String var2) throws NullPointerException, IllegalArgumentException, RepositoryException;

    protected abstract <O> O _findById(Class<O> var1, String var2) throws RepositoryException;

    protected abstract <O> O _findByNode(Class<O> var1, Node var2) throws RepositoryException;

    protected abstract void _save() throws RepositoryException;

    protected abstract void _remove(EntityContext var1) throws RepositoryException;

    protected abstract Object _getReferenced(EntityContext var1, String var2, LinkType var3) throws RepositoryException;

    protected abstract boolean _setReferenced(EntityContext var1, String var2, EntityContext var3, LinkType var4) throws RepositoryException;

    protected abstract <T> Iterator<T> _getReferents(EntityContext var1, String var2, Class<T> var3, LinkType var4) throws RepositoryException;

    protected abstract void _removeChild(EntityContext var1, String var2) throws RepositoryException;

    protected abstract Object _getChild(EntityContext var1, String var2) throws RepositoryException;

    protected abstract <T> Iterator<T> _getChildren(EntityContext var1, Class<T> var2) throws RepositoryException;

    protected abstract Object _getParent(EntityContext var1) throws RepositoryException;

    protected abstract <O> O _findByPath(EntityContext var1, Class<O> var2, String var3) throws RepositoryException;

    protected abstract void _orderBefore(EntityContext var1, EntityContext var2, EntityContext var3) throws RepositoryException;

    protected abstract Node _getRoot() throws RepositoryException;

    protected abstract void _move(EntityContext var1, EntityContext var2) throws RepositoryException;

    public final Domain getDomain() {
        return this.domain;
    }

    public final Session getJCRSession() {
        return this.sessionWrapper.getSession();
    }

    public final String getId(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        return ctx.getId();
    }

    public final String getName(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        return this.getName(ctx);
    }

    public final String getPath(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        return ctx.getPath();
    }

    public final <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException {
        return this.create(clazz, null);
    }

    public final <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException {
        try {
            return this._create(clazz, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O insert(Object parent, Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            EntityContext parentCtx = this.unwrap(parent);
            O child = this.create(clazz);
            EntityContext childtx = this.unwrap(child);
            this._persist(parentCtx, name, childtx);
            return child;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O insert(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        O child = this.create(clazz);
        this.persist(child, name);
        return child;
    }

    public final String persist(Object parent, Object child, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            EntityContext parentCtx = this.unwrap(parent);
            EntityContext childCtx = this.unwrap(child);
            return this._persist(parentCtx, name, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException();
        }
    }

    public final String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.unwrap(parent);
        EntityContext childCtx = this.unwrap(child);
        String name = childCtx.state.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + childCtx;
            throw new IllegalArgumentException(msg);
        }
        try {
            return this._persist(parentCtx, name, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            EntityContext ctx = this.unwrap(o);
            String name = ctx.state.getName();
            if (name == null) {
                String msg = "Attempt to persist non named object " + ctx;
                throw new IllegalArgumentException(msg);
            }
            return this._persist(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persist(Object o, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            EntityContext ctx = this.unwrap(o);
            return this._persist(ctx, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByNode(Class<O> clazz, Node node) throws UndeclaredRepositoryException {
        try {
            return this._findByNode(clazz, node);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findById(Class<O> clazz, String id) throws UndeclaredRepositoryException {
        try {
            return this._findById(clazz, id);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByPath(Object o, Class<O> clazz, String relPath) throws ChromatticException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        try {
            return this._findByPath(ctx, clazz, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByPath(Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        try {
            return this._findByPath(null, clazz, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void save() throws UndeclaredRepositoryException {
        try {
            this._save();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Status getStatus(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        return ctx.getStatus();
    }

    public final void remove(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        try {
            EntityContext context = this.unwrap(o);
            this._remove(context);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public QueryBuilder<?> createQueryBuilder() throws ChromatticException {
        return this.domain.queryManager.createQueryBuilder(this);
    }

    public final Node getNode(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.unwrap(o);
        return ctx.state.getNode();
    }

    public final String getName(EntityContext ctx) throws UndeclaredRepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        return ctx.getName();
    }

    public final void setName(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            this._setName(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void orderBefore(EntityContext parentCtx, EntityContext srcCtx, EntityContext dstCtx) {
        try {
            this._orderBefore(parentCtx, srcCtx, dstCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public void move(EntityContext srcCtx, EntityContext dstCtx) throws UndeclaredRepositoryException {
        try {
            this._move(srcCtx, dstCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void remove(EntityContext context) throws UndeclaredRepositoryException {
        try {
            this._remove(context);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getReferenced(EntityContext referentCtx, String name, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferenced(referentCtx, name, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final boolean setReferenced(EntityContext referentCtx, String name, EntityContext referencedCtx, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._setReferenced(referentCtx, name, referencedCtx, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void removeChild(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            this._removeChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getChild(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            return this._getChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getChildren(EntityContext ctx, Class<T> filterClass) throws UndeclaredRepositoryException {
        try {
            return this._getChildren(ctx, filterClass);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getParent(EntityContext ctx) throws UndeclaredRepositoryException {
        try {
            return this._getParent(ctx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getReferents(EntityContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferents(referencedCtx, name, filterClass, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final EntityContext unwrap(Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot unwrap null object");
        }
        return (EntityContext)this.domain.getInstrumentor().getInvoker(o);
    }

    public final String persist(EntityContext parentCtx, EntityContext childCtx, String name) throws UndeclaredRepositoryException {
        try {
            return this._persist(parentCtx, name, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Node getRoot() {
        try {
            return this._getRoot();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public SessionWrapper getSessionWrapper() {
        return this.sessionWrapper;
    }

    public void addEventListener(EventListener listener) {
        this.broadcaster.addLifeCycleListener(listener);
    }
}

