/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.chromattic.core;

import org.chromattic.api.Status;
import org.chromattic.core.bean.SimpleValueInfo;

import javax.jcr.Node;
import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
abstract class EntityContextState {

  abstract String getId();

  abstract String getName();

  abstract String getPath();

  abstract void setName(String name);

  abstract Node getNode();

  abstract DomainSession getSession();

  abstract Status getStatus();

  abstract <V> V getPropertyValue(String propertyName, SimpleValueInfo<V> svi);

  abstract <V> List<V> getPropertyValues(String propertyName, SimpleValueInfo<V> svi, ListType listType);

  abstract <V> void setPropertyValue(String propertyName, SimpleValueInfo<V> svi, V o);

  abstract <V> void setPropertyValues(String propertyName, SimpleValueInfo<V> svi, ListType listType, List<V> objects);

}
