/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.hierarchical;

import java.util.AbstractList;
import java.util.Iterator;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnyChildList<E>
extends AbstractList<E> {
    private final EntityContext parentCtx;
    private final Class<E> relatedClass;

    public AnyChildList(EntityContext parentCtx, Class<E> relatedClass) {
        this.relatedClass = relatedClass;
        this.parentCtx = parentCtx;
    }

    @Override
    public void add(int index, E addedElement) {
        Object nextElement;
        block11: {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (addedElement == null) {
                throw new NullPointerException("No null element can be inserted");
            }
            if (!this.relatedClass.isInstance(addedElement)) {
                throw new ClassCastException("Cannot cast object with class " + addedElement.getClass().getName() + " as child expected class " + this.relatedClass.getName());
            }
            Iterator<E> iterator = this.iterator();
            while (true) {
                if (index == 0) {
                    nextElement = iterator.hasNext() ? iterator.next() : null;
                    break block11;
                }
                if (!iterator.hasNext()) break;
                iterator.next();
                --index;
            }
            throw new IndexOutOfBoundsException();
        }
        DomainSession session = this.parentCtx.getSession();
        EntityContext addedCtx = session.unwrap(addedElement);
        switch (addedCtx.getStatus()) {
            case TRANSIENT: {
                this.parentCtx.addChild(addedCtx);
                break;
            }
            case PERSISTENT: {
                Object insertedParent = addedCtx.getParent();
                EntityContext addedParentCtx = session.unwrap(insertedParent);
                if (addedParentCtx == this.parentCtx) break;
                this.parentCtx.addChild(addedCtx);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot insert element with status " + addedCtx.getStatus());
            }
        }
        if (nextElement == null) {
            this.parentCtx.orderBefore(addedCtx, null);
        } else {
            EntityContext nextCtx = session.unwrap(nextElement);
            this.parentCtx.orderBefore(addedCtx, nextCtx);
        }
    }

    @Override
    public E set(int index, E addedElement) {
        if (addedElement == null) {
            throw new NullPointerException("No null element can be inserted");
        }
        if (!this.relatedClass.isInstance(addedElement)) {
            throw new ClassCastException("Cannot cast object with class " + addedElement.getClass().getName() + " as child expected class " + this.relatedClass.getName());
        }
        E removedElement = this.get(index);
        DomainSession session = this.parentCtx.getSession();
        EntityContext removedCtx = session.unwrap(removedElement);
        EntityContext addedCtx = session.unwrap(addedElement);
        switch (addedCtx.getStatus()) {
            case TRANSIENT: {
                this.parentCtx.addChild(addedCtx);
                break;
            }
            case PERSISTENT: {
                Object insertedParent = addedCtx.getParent();
                EntityContext addedParentCtx = session.unwrap(insertedParent);
                if (addedParentCtx == this.parentCtx) break;
                this.parentCtx.addChild(addedCtx);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot insert element with status " + addedCtx.getStatus());
            }
        }
        this.parentCtx.orderBefore(addedCtx, removedCtx);
        session.remove(removedCtx);
        return removedElement;
    }

    @Override
    public E remove(int index) {
        E removedElement = this.get(index);
        DomainSession session = this.parentCtx.getSession();
        EntityContext removedCtx = session.unwrap(removedElement);
        session.remove(removedCtx);
        return removedElement;
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (E o : this) {
            if (index == 0) {
                return o;
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.parentCtx.getChildren(this.relatedClass);
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }
}

