/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.reference;

import org.chromattic.core.ObjectContext;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.JCRNodePropertyMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRNamedReferentPropertyMapper<O extends ObjectContext>
extends JCRNodePropertyMapper<O> {
    private final String propertyName;
    private final LinkType linkType;

    public JCRNamedReferentPropertyMapper(Class<O> contextType, SingleValuedPropertyInfo<BeanValueInfo> info, String propertyName, LinkType linkType) throws ClassNotFoundException {
        super(contextType, info);
        this.propertyName = propertyName;
        this.linkType = linkType;
    }

    @Override
    public Object get(O context) throws Throwable {
        Class<?> relatedClass = this.getRelatedClass();
        Object related = ((ObjectContext)context).getEntity().getReferenced(this.propertyName, this.linkType);
        if (related == null) {
            return null;
        }
        if (relatedClass.isInstance(related)) {
            return related;
        }
        throw new ClassCastException("Related with class " + related.getClass().getName() + " is not of class " + relatedClass);
    }

    @Override
    public void set(O ctx, Object value) throws Throwable {
        ((ObjectContext)ctx).getEntity().setReferenced(this.propertyName, value, this.linkType);
    }
}

