/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.Status;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.ChildCollectionIterator;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.PersistentEntityContextState;
import org.chromattic.core.ReferentCollectionIterator;
import org.chromattic.core.RemovedEntityContextState;
import org.chromattic.core.TransientEntityContextState;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.jcr.info.MixinTypeInfo;
import org.chromattic.core.jcr.info.PrimaryTypeInfo;
import org.chromattic.core.mapper.NodeTypeKind;
import org.chromattic.core.mapper.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainSessionImpl
extends DomainSession {
    final Domain domain;
    private Map<String, EntityContext> contexts;
    private final Logger log = Logger.getLogger(ChromatticSessionImpl.class);

    public DomainSessionImpl(Domain domain, SessionWrapper sessionWrapper) {
        super(domain, sessionWrapper);
        this.domain = domain;
        this.contexts = new HashMap<String, EntityContext>();
    }

    @Override
    protected void _setName(EntityContext ctx, String name) {
        if (ctx == null) {
            throw new NullPointerException();
        }
        ctx.state.setName(name);
    }

    @Override
    protected String _getName(EntityContext ctx) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        switch (ctx.getStatus()) {
            default: {
                return ctx.state.getName();
            }
            case PERSISTENT: 
        }
        Node node = ctx.state.getNode();
        Node parentNode = node.getParent();
        return this.domain.decodeName(parentNode, node.getName(), NameKind.OBJECT);
    }

    protected <O> O _findByPath(EntityContext ctx, Class<O> clazz, String relPath) throws RepositoryException {
        Node origin;
        if (ctx != null) {
            origin = ctx.state.getNode();
        } else {
            origin = this._getRoot();
            this.nodeRead(origin);
        }
        try {
            Node node = origin.getNode(relPath);
            this.nodeRead(node);
            return this._findByNode(clazz, node);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    protected EntityContext _persist(EntityContext ctx, String name) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException("No null object context accepted");
        }
        if (name == null) {
            throw new NullPointerException("No relative path specified");
        }
        if (ctx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to persist non transient object " + ctx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.log.trace("Setting context {} for insertion", (Object)ctx);
        this.log.trace("Adding node for context {} and node type {}", (Object)ctx, ctx.mapper);
        return this._persist(this._getRoot(), name, ctx);
    }

    @Override
    protected EntityContext _persist(EntityContext srcCtx, String name, EntityContext dstCtx) throws NullPointerException, IllegalArgumentException, IllegalStateException, RepositoryException {
        if (srcCtx == null) {
            String msg = "Cannot insert context " + dstCtx + " as a child of a null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to insert non transient context " + dstCtx + " as child of " + srcCtx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (name == null) {
            String msg = "Attempt to insert context " + dstCtx + " with no relative path to " + srcCtx;
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to insert context " + dstCtx + " as child of non persistent context " + srcCtx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        Node parentNode = srcCtx.state.getNode();
        return this._persist(parentNode, name, dstCtx);
    }

    private EntityContext _persist(Node srcNode, String name, EntityContext dstCtx) throws RepositoryException {
        Node previousNode;
        ObjectMapper<EntityContext> mapper = dstCtx.mapper;
        Object parent = this._findByNode((Class)Object.class, srcNode);
        EntityContext parentCtx = parent != null ? this.unwrapEntity(parent) : null;
        name = this.domain.encodeName(parentCtx, name, NameKind.OBJECT);
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = srcNode.getPrimaryNodeType();
        ObjectMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(srcNode, name)) != null) {
            this.log.trace("Found existing child with same name {}", (Object)name);
            if (onDuplicate == NameConflictResolution.FAIL) {
                String msg = "Attempt to insert context " + dstCtx + " as an existing child with name " + name + " child of node " + srcNode.getPath();
                this.log.error(msg);
                throw new DuplicateNameException(msg);
            }
            this.log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
            this.remove(previousNode);
        }
        String primaryNodeTypeName = mapper.getNodeTypeName();
        this.log.trace("Setting context {} for insertion", (Object)dstCtx);
        this.log.trace("Adding node for context {} and node type {} as child of node {}", new Object[]{dstCtx, primaryNodeTypeName, srcNode.getPath()});
        Node dstNode = this.sessionWrapper.addNode(srcNode, name, primaryNodeTypeName, Collections.<String>emptyList());
        if (!this.domain.nodeInfoManager.isReferenceable(dstNode)) {
            dstNode.addMixin("mix:referenceable");
        }
        this.nodeAdded(dstNode, dstCtx);
        this.log.trace("Added context {} for path {}", new Object[]{dstCtx, dstCtx.getId(), dstNode.getPath()});
        return dstCtx;
    }

    @Override
    protected void _addMixin(EntityContext entityCtx, EmbeddedContext mixinCtx) throws RepositoryException {
        if (entityCtx == null) {
            throw new NullPointerException();
        }
        if (mixinCtx == null) {
            throw new NullPointerException();
        }
        if (mixinCtx.relatedEntity != null) {
            if (mixinCtx.relatedEntity != entityCtx) {
                throw new IllegalArgumentException();
            }
        } else {
            EmbeddedContext previousMixinCtx = entityCtx.embeddeds.get(mixinCtx.mapper);
            if (previousMixinCtx != null) {
                if (previousMixinCtx != mixinCtx) {
                    throw new IllegalStateException();
                }
            } else {
                String mixinTypeName = mixinCtx.mapper.getNodeTypeName();
                Node node = entityCtx.state.getNode();
                if (!this.sessionWrapper.canAddMixin(node, mixinTypeName)) {
                    throw new IllegalArgumentException("Cannot add mixin " + mixinCtx + " to context " + entityCtx);
                }
                this.sessionWrapper.addMixin(node, mixinTypeName);
                NodeType mixinType = this.sessionWrapper.getNodeType(mixinTypeName);
                MixinTypeInfo mixinTypeInfo = this.domain.nodeInfoManager.getMixinTypeInfo(mixinType);
                entityCtx.embeddeds.put(mixinCtx.mapper, mixinCtx);
                mixinCtx.relatedEntity = entityCtx;
                mixinCtx.typeInfo = mixinTypeInfo;
            }
        }
    }

    @Override
    protected EmbeddedContext _getEmbedded(EntityContext entityCtx, Class<?> embeddedClass) throws RepositoryException {
        if (entityCtx == null) {
            throw new NullPointerException();
        }
        if (embeddedClass == null) {
            throw new NullPointerException();
        }
        ObjectMapper mapper = this.domain.getTypeMapper(embeddedClass);
        EmbeddedContext embeddedCtx = null;
        if (mapper != null && (embeddedCtx = entityCtx.embeddeds.get(mapper)) == null) {
            Node node = entityCtx.state.getNode();
            if (mapper.getKind() == NodeTypeKind.MIXIN) {
                String mixinTypeName = mapper.getNodeTypeName();
                if (this.sessionWrapper.haxMixin(node, mixinTypeName)) {
                    NodeType mixinType = this.sessionWrapper.getNodeType(mixinTypeName);
                    MixinTypeInfo mixinTypeInfo = this.domain.nodeInfoManager.getMixinTypeInfo(mixinType);
                    embeddedCtx = new EmbeddedContext(mapper, this);
                    entityCtx.embeddeds.put(embeddedCtx.mapper, embeddedCtx);
                    embeddedCtx.relatedEntity = entityCtx;
                    embeddedCtx.typeInfo = mixinTypeInfo;
                }
            } else {
                PrimaryTypeInfo typeInfo = entityCtx.state.getTypeInfo();
                PrimaryTypeInfo superTI = (PrimaryTypeInfo)typeInfo.getSuperType(mapper.getNodeTypeName());
                if (superTI != null) {
                    embeddedCtx = new EmbeddedContext(mapper, this);
                    entityCtx.embeddeds.put(embeddedCtx.mapper, embeddedCtx);
                    embeddedCtx.relatedEntity = entityCtx;
                    embeddedCtx.typeInfo = superTI;
                }
            }
        }
        return embeddedCtx;
    }

    @Override
    protected void _move(EntityContext srcCtx, EntityContext dstCtx) throws RepositoryException {
        Node previousNode;
        if (srcCtx == null) {
            String msg = "Cannot move null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx == null) {
            String msg = "Cannot move to null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move non persistent context " + srcCtx + " as child of " + dstCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        if (dstCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move child " + srcCtx + " to a non persistent context " + dstCtx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        Node dstNode = dstCtx.state.getNode();
        Node srcNode = srcCtx.state.getNode();
        String name = srcNode.getName();
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = dstNode.getPrimaryNodeType();
        ObjectMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(dstNode, name)) != null) {
            this.log.trace("Found existing child with same name {}", (Object)name);
            if (onDuplicate == NameConflictResolution.FAIL) {
                String msg = "Attempt to move context " + dstCtx + " as an existing child with name " + name + " child of node " + dstNode.getPath();
                this.log.error(msg);
                throw new DuplicateNameException(msg);
            }
            this.log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
            throw new UnsupportedOperationException("Do that properly");
        }
        this.sessionWrapper.move(srcNode, dstNode);
    }

    @Override
    protected void _orderBefore(EntityContext parentCtx, EntityContext srcCtx, EntityContext dstCtx) throws RepositoryException {
        if (parentCtx == null) {
            throw new NullPointerException();
        }
        if (srcCtx == null) {
            throw new NullPointerException();
        }
        Node parentNode = parentCtx.state.getNode();
        Node srcNode = srcCtx.state.getNode();
        Node dstNode = dstCtx != null ? dstCtx.state.getNode() : null;
        this.sessionWrapper.orderBefore(parentNode, srcNode, dstNode);
    }

    @Override
    protected <O> O _create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, RepositoryException {
        ObjectContext octx;
        if (clazz == null) {
            throw new NullPointerException();
        }
        ObjectMapper typeMapper = this.domain.getTypeMapper(clazz);
        if (typeMapper == null) {
            throw new IllegalArgumentException("The type " + clazz.getName() + " is not mapped");
        }
        TransientEntityContextState state = new TransientEntityContextState(this);
        if (typeMapper.getKind() == NodeTypeKind.PRIMARY) {
            EntityContext ctx = new EntityContext(typeMapper, state);
            if (name != null) {
                ctx.setName(name);
            }
            this.broadcaster.created(ctx.getObject());
            octx = ctx;
        } else {
            if (name != null) {
                throw new IllegalArgumentException("Cannot create a mixin type with a name");
            }
            octx = new EmbeddedContext(typeMapper, this);
        }
        return clazz.cast(((ObjectContext)octx).getObject());
    }

    protected <O> O _findById(Class<O> clazz, String id) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        try {
            this.log.trace("About to load node with id {} and class {}", (Object)id, (Object)clazz.getName());
            Node node = this.sessionWrapper.getNodeByUUID(id);
            return this._findByNode(clazz, node);
        }
        catch (ItemNotFoundException e) {
            this.log.trace("Could not find node with id {}", (Object)id, (Object)clazz.getName());
            return null;
        }
    }

    protected <O> O _findByNode(Class<O> clazz, Node node) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this._findByNode(node);
        if (ctx == null) {
            return null;
        }
        Object object = ctx.object;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        String msg = "Could not cast context " + ctx + " with class " + object.getClass().getName() + " to class " + clazz.getName();
        throw new ClassCastException(msg);
    }

    private EntityContext _findByNode(Node node) throws RepositoryException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.domain.nodeInfoManager.isReferenceable(node)) {
            this.log.trace("Cannot map non referenceable node {} to a chromattic object", (Object)node.getPath());
            return null;
        }
        EntityContext ctx = this.contexts.get(node.getUUID());
        if (ctx == null) {
            try {
                this.log.trace("About to read node with path {}", (Object)node.getPath());
                this.nodeRead(node);
                this.log.trace("Loaded node with path {}", (Object)node.getPath());
                ctx = this.contexts.get(node.getUUID());
                this.log.trace("Obtained context {} node for path {}", (Object)ctx, (Object)node.getPath());
            }
            catch (ItemNotFoundException e) {
                this.log.trace("Could not find node with path {}", (Object)node.getPath());
                return null;
            }
        }
        return ctx;
    }

    @Override
    protected void _save() throws RepositoryException {
        this.sessionWrapper.save();
    }

    @Override
    protected void _remove(EntityContext context) throws RepositoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        switch (context.state.getStatus()) {
            case TRANSIENT: {
                throw new IllegalStateException("Cannot remove transient node");
            }
            case PERSISTENT: {
                Node node = context.state.getNode();
                this.remove(node);
                break;
            }
            case REMOVED: {
                throw new IllegalStateException("Cannot remove removed node");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void remove(Node node) throws RepositoryException {
        LinkedList<Removed> removeds = new LinkedList<Removed>();
        String pathToRemove = node.getPath();
        for (Map.Entry<String, EntityContext> ctxEntry : this.contexts.entrySet()) {
            EntityContext ctx = ctxEntry.getValue();
            Node ctxNode = ctx.state.getNode();
            if (!ctxNode.getPath().startsWith(pathToRemove)) continue;
            removeds.add(new Removed(ctx.getId(), ctx.getPath(), ctx.getName(), ctx));
        }
        this.sessionWrapper.remove(node);
        Collection<EntityContext> ctxs = this.contexts.values();
        for (Removed removed : removeds) {
            String path = removed.path;
            this.log.trace("Removing context for path {}", (Object)path);
            ((Removed)removed).ctx.state = new RemovedEntityContextState(path);
            ctxs.remove(removed.ctx);
            this.broadcaster.removed(removed.id, removed.path, removed.name, removed.ctx.getObject());
            this.log.trace("Removed context {} for path {}", (Object)removed.ctx, (Object)path);
        }
    }

    @Override
    protected EntityContext _getReferenced(EntityContext referentCtx, String name, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node referent = referentCtx.state.getNode();
        Node referenced = this.sessionWrapper.getReferenced(referent, name, linkType);
        if (referenced != null) {
            return this._findByNode(referenced);
        }
        return null;
    }

    @Override
    protected boolean _setReferenced(EntityContext referentCtx, String name, EntityContext referencedCtx, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Cannot create a relationship with a non persisted context " + this);
        }
        Node referent = referentCtx.state.getNode();
        if (referencedCtx != null) {
            if (referencedCtx.getStatus() != Status.PERSISTENT) {
                throw new IllegalStateException();
            }
            Node referenced = referencedCtx.state.getNode();
            return referenced != this.sessionWrapper.setReferenced(referent, name, referenced, linkType);
        }
        return null != this.sessionWrapper.setReferenced(referent, name, null, linkType);
    }

    @Override
    protected <T> Iterator<T> _getReferents(EntityContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws RepositoryException {
        Node referenced = referencedCtx.state.getNode();
        Iterator<Node> referents = this.sessionWrapper.getReferents(referenced, name, linkType);
        return new ReferentCollectionIterator<T>(this, referents, filterClass, name);
    }

    @Override
    protected void _removeChild(EntityContext ctx, String name) throws RepositoryException {
        name = this.domain.encodeName(ctx, name, NameKind.OBJECT);
        Node node = ctx.state.getNode();
        Node childNode = this.sessionWrapper.getNode(node, name);
        if (childNode != null) {
            this.remove(childNode);
        }
    }

    @Override
    protected EntityContext _getChild(EntityContext ctx, String name) throws RepositoryException {
        name = this.domain.encodeName(ctx, name, NameKind.OBJECT);
        Node node = ctx.state.getNode();
        this.log.trace("About to load the name child {} of context {}", (Object)name, (Object)this);
        Node child = this.sessionWrapper.getChild(node, name);
        if (child != null) {
            this.log.trace("Loaded named child {} of context {} with path {}", new Object[]{name, this, child.getPath()});
            return this._findByNode(child);
        }
        this.log.trace("No child named {} to load for context {}", (Object)name, (Object)this);
        return null;
    }

    @Override
    protected <T> Iterator<T> _getChildren(EntityContext ctx, Class<T> filterClass) throws RepositoryException {
        Node node = ctx.state.getNode();
        Iterator<Node> iterator = this.sessionWrapper.getChildren(node);
        return new ChildCollectionIterator<T>(this, iterator, filterClass);
    }

    @Override
    protected EntityContext _getParent(EntityContext ctx) throws RepositoryException {
        if (ctx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node node = ctx.state.getNode();
        Node parent = this.sessionWrapper.getParent(node);
        return this._findByNode(parent);
    }

    @Override
    protected Node _getRoot() throws RepositoryException {
        Session session = this.sessionWrapper.getSession();
        String path = this.domain.rootNodePath;
        if ("/".equals(path)) {
            return session.getRootNode();
        }
        if (session.itemExists(path)) {
            Item item = session.getItem(path);
            if (item instanceof Node) {
                return (Node)item;
            }
            throw new IllegalStateException("The chromattic root node path (" + path + ") points to an existing property");
        }
        Node current = session.getRootNode();
        for (String name : this.domain.rootNodePath.substring(1).split("/")) {
            current = current.hasNode(name) ? current.getNode(name) : current.addNode(name);
        }
        return current;
    }

    private void nodeRead(Node node) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        ObjectMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            EntityContext ctx = this.contexts.get(node.getUUID());
            if (ctx == null) {
                ctx = new EntityContext(mapper, new PersistentEntityContextState(node, this));
                this.log.trace("Inserted context {} loaded from node path {}", (Object)ctx, (Object)node.getPath());
                this.contexts.put(node.getUUID(), ctx);
                this.broadcaster.loaded(ctx, ctx.getObject());
            } else {
                this.log.trace("Context {} is already present for path ", (Object)ctx, (Object)node.getPath());
            }
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    private void nodeAdded(Node node, EntityContext ctx) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        ObjectMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            if (this.contexts.containsKey(node.getUUID())) {
                String msg = "Attempt to replace an existing context " + ctx + " with path " + node.getPath();
                this.log.error(msg);
                throw new AssertionError((Object)msg);
            }
            this.log.trace("Inserted context {} for path {}", (Object)ctx, (Object)node.getPath());
            this.contexts.put(node.getUUID(), ctx);
            ctx.state = new PersistentEntityContextState(node, this);
            this.broadcaster.added(ctx, ctx.getObject());
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    @Override
    public void _close() {
        this.sessionWrapper.close();
    }

    private static class Removed {
        private final String id;
        private final String path;
        private final String name;
        private final EntityContext ctx;

        private Removed(String id, String path, String name, EntityContext ctx) {
            this.id = id;
            this.path = path;
            this.name = name;
            this.ctx = ctx;
        }
    }
}

