/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import javax.jcr.Node;
import javax.jcr.Session;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChromatticSessionImpl
implements ChromatticSession {
    final DomainSession domainSession;

    public ChromatticSessionImpl(DomainSession domainSession) {
        this.domainSession = domainSession;
    }

    public final Domain getDomain() {
        return this.domainSession.getDomain();
    }

    public Session getJCRSession() {
        return this.domainSession.getJCRSession();
    }

    public String getId(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getId();
    }

    public String getName(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return this.domainSession.getName(ctx);
    }

    public String getPath(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getPath();
    }

    public <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException {
        return this.create(clazz, null);
    }

    public <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException {
        return this.domainSession.create(clazz, name);
    }

    public <O> O insert(Object parent, Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        O child = this.create(clazz);
        EntityContext childtx = this.domainSession.unwrapEntity(child);
        this.domainSession.persist(parentCtx, childtx, name);
        return child;
    }

    public <O> O insert(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        O child = this.create(clazz);
        this.persist(child, name);
        return child;
    }

    public String persist(Object parent, Object child, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        EntityContext childCtx = this.domainSession.unwrapEntity(child);
        return this.domainSession.persist(parentCtx, childCtx, name).getId();
    }

    public String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        EntityContext childCtx = this.domainSession.unwrapEntity(child);
        String name = childCtx.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + childCtx;
            throw new IllegalArgumentException(msg);
        }
        return this.domainSession.persist(parentCtx, childCtx, name).getId();
    }

    public String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        String name = ctx.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + ctx;
            throw new IllegalArgumentException(msg);
        }
        return this.domainSession.persist(ctx, name).getId();
    }

    public String persist(Object o, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return this.domainSession.persist(ctx, relPath).getId();
    }

    public <O> O findByNode(Class<O> clazz, Node node) throws UndeclaredRepositoryException {
        return this.domainSession.findByNode(clazz, node);
    }

    public <O> O findById(Class<O> clazz, String id) throws UndeclaredRepositoryException {
        return this.domainSession.findById(clazz, id);
    }

    public <O> O findByPath(Object origin, Class<O> clazz, String relPath) throws ChromatticException {
        if (origin == null) {
            throw new NullPointerException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(origin);
        return this.domainSession.findByPath(ctx, clazz, relPath);
    }

    public <O> O findByPath(Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        return this.domainSession.findByPath(null, clazz, relPath);
    }

    public void save() throws UndeclaredRepositoryException {
        this.domainSession.save();
    }

    public Status getStatus(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getStatus();
    }

    public void remove(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext context = this.domainSession.unwrapEntity(o);
        this.domainSession.remove(context);
    }

    public <E> E getEmbedded(Object o, Class<E> embeddedType) throws NullPointerException, IllegalArgumentException, ChromatticException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        EmbeddedContext embeddedCtx = ctx.getEmbedded(embeddedType);
        if (embeddedCtx != null) {
            return embeddedType.cast(embeddedCtx.getObject());
        }
        return null;
    }

    public <E> void setEmbedded(Object o, Class<E> embeddedType, E embedded) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (embeddedType == null) {
            throw new NullPointerException();
        }
        if (embedded == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        EmbeddedContext embeddedCtx = this.domainSession.unwrapMixin(embedded);
        ctx.addMixin(embeddedCtx);
    }

    public void close() {
        this.domainSession.close();
    }

    public <O> QueryBuilder<O> createQueryBuilder(Class<O> fromClass) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.domainSession.createQueryBuilder(fromClass);
    }

    public void addEventListener(EventListener listener) {
        this.domainSession.addEventListener(listener);
    }

    public Node getRoot() {
        return this.domainSession.getRoot();
    }

    public Node getNode(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getNode();
    }
}

