/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.mapper.NodeTypeKind;
import org.chromattic.core.mapper.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderImpl<O>
implements QueryBuilder<O> {
    private final String rootNodePath;
    private Class<O> fromClass;
    private String where;
    private ObjectMapper mapper;
    private DomainSession session;
    private static final Pattern JCR_LIKE_PATH = Pattern.compile("jcr:path[\\s]*[^\\s]+[\\s]*'[^']*'");

    QueryBuilderImpl(DomainSession session, Class<O> fromClass, String rootNodePath) throws NullPointerException, IllegalArgumentException {
        if (session == null) {
            throw new NullPointerException("No null domain session accepted");
        }
        if (fromClass == null) {
            throw new NullPointerException("No null from class accepted");
        }
        if (rootNodePath == null) {
            throw new NullPointerException("No null root node path accepted");
        }
        Domain domain = session.getDomain();
        ObjectMapper mapper = domain.getTypeMapper(fromClass);
        if (mapper == null) {
            throw new IllegalArgumentException("Class " + fromClass.getName() + " is not mapped");
        }
        if (mapper.getKind() != NodeTypeKind.PRIMARY) {
            throw new IllegalArgumentException("Class " + fromClass.getName() + " is mapped to a mixin type");
        }
        this.fromClass = fromClass;
        this.mapper = mapper;
        this.where = null;
        this.session = session;
        this.rootNodePath = rootNodePath;
    }

    public QueryBuilder<O> where(String whereStatement) {
        if (whereStatement == null) {
            throw new NullPointerException();
        }
        this.where = whereStatement;
        return this;
    }

    public QueryBuilder<O> orderBy(String orderBy) throws NullPointerException {
        throw new UnsupportedOperationException("todo");
    }

    public Query<O> get() {
        if (this.fromClass == null) {
            throw new IllegalStateException();
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        sb.append(this.mapper.getNodeTypeName());
        if (this.where != null) {
            Matcher matcher = JCR_LIKE_PATH.matcher(this.where);
            if (!matcher.find()) {
                sb.append(" WHERE jcr:path LIKE '").append(this.rootNodePath).append("/%'");
                sb.append(" AND ");
                sb.append(this.where);
            } else {
                sb.append(" WHERE ");
                sb.append(this.where);
            }
        } else {
            sb.append(" WHERE jcr:path LIKE '").append(this.rootNodePath).append("/%'");
        }
        return this.session.getDomain().getQueryManager().getObjectQuery(this.session, this.fromClass, sb.toString());
    }
}

