/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.RelationshipType;
import org.chromattic.common.SetMap;
import org.chromattic.core.bean.CollectionPropertyInfo;
import org.chromattic.core.bean.ListPropertyInfo;
import org.chromattic.core.bean.MapPropertyInfo;
import org.chromattic.core.bean.MultiValuedPropertyInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.NodeDef;
import org.chromattic.core.mapper.JCRNodePropertyMapper;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.mapper.RelatedPropertyMapper;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.mapper.nodeattribute.JCRNodeAttributePropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.AnyChildMultiValueMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildCollectionPropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildParentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRNamedReferentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRReferentCollectionPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyListPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyMapPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyPropertyMapper;
import org.chromattic.core.mapping.CreateMapping;
import org.chromattic.core.mapping.DestroyMapping;
import org.chromattic.core.mapping.FindByIdMapping;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.chromattic.core.mapping.TypeMapping;
import org.chromattic.core.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.core.mapping.jcr.JCRPropertyMapping;
import org.chromattic.core.mapping.value.ManyToOneMapping;
import org.chromattic.core.mapping.value.NamedManyToOneMapping;
import org.chromattic.core.mapping.value.NamedOneToManyMapping;
import org.chromattic.core.mapping.value.NamedOneToOneMapping;
import org.chromattic.core.mapping.value.OneToManyMapping;
import org.chromattic.core.mapping.value.PropertyMapMapping;
import org.chromattic.core.mapping.value.RelationshipMapping;
import org.chromattic.core.mapping.value.SimpleMapping;
import org.chromattic.spi.instrument.Instrumentor;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapperBuilder {
    private static final EnumMap<RelationshipType, LinkType> relationshipToLinkMapping;
    private final Set<TypeMapping> typeMappings;
    private final Instrumentor instrumentor;

    public TypeMapperBuilder(Set<TypeMapping> typeMappings, Instrumentor instrumentor) {
        this.typeMappings = typeMappings;
        this.instrumentor = instrumentor;
    }

    public Collection<TypeMapper> build() {
        try {
            return this._build();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<TypeMapper> _build() throws ClassNotFoundException {
        HashMap<String, TypeMapper> mappers = new HashMap<String, TypeMapper>();
        SetMap relatedProperties = new SetMap();
        SetMap relatedMethods = new SetMap();
        for (TypeMapping typeMapping : this.typeMappings) {
            HashSet<MethodMapper> methodMappers = new HashSet<MethodMapper>();
            HashSet<PropertyMapper> propertyMappers = new HashSet<PropertyMapper>();
            for (PropertyMapping pm : typeMapping.getPropertyMappings()) {
                LinkType linkType;
                RelationshipMapping pmhm;
                PropertyMapper bilto;
                JCRPropertyMapping jcrProperty;
                Object jcrMember;
                Object pmvm;
                if (pm.getInfo() instanceof SingleValuedPropertyInfo) {
                    NamedManyToOneMapping nmtovm;
                    pmvm = pm.getValueMapping();
                    if (pmvm instanceof SimpleMapping) {
                        SimpleMapping pmdm = (SimpleMapping)pmvm;
                        jcrMember = pmdm.getJCRMember();
                        if (jcrMember instanceof JCRPropertyMapping) {
                            jcrProperty = (JCRPropertyMapping)jcrMember;
                            bilto = new JCRPropertyPropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), jcrProperty.getName());
                            propertyMappers.add(bilto);
                        } else if (jcrMember instanceof JCRNodeAttributeMapping) {
                            JCRNodeAttributeMapping nam = (JCRNodeAttributeMapping)jcrMember;
                            propertyMappers.add(new JCRNodeAttributePropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), nam.getType()));
                        }
                    } else if (pmvm instanceof RelationshipMapping && (pmhm = (RelationshipMapping)pmvm).getType() == RelationshipType.HIERARCHIC) {
                        if (pmhm instanceof ManyToOneMapping) {
                            JCRAnyChildCollectionPropertyMapper bilto2 = new JCRAnyChildCollectionPropertyMapper((SingleValuedPropertyInfo)pm.getInfo());
                            relatedProperties.get((Object)pmhm.getRelatedType()).add(bilto2);
                            propertyMappers.add(bilto2);
                        }
                        if (pmhm instanceof NamedOneToOneMapping) {
                            JCRNodePropertyMapper bilto3;
                            NamedOneToOneMapping ncpmpm = (NamedOneToOneMapping)pmhm;
                            if (ncpmpm.isOwner()) {
                                bilto3 = new JCRNamedChildParentPropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), ncpmpm.getName());
                                relatedProperties.get((Object)pmhm.getRelatedType()).add(bilto3);
                                propertyMappers.add(bilto3);
                            } else {
                                bilto3 = new JCRNamedChildPropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), ncpmpm.getName());
                                relatedProperties.get((Object)ncpmpm.getRelatedType()).add(bilto3);
                                propertyMappers.add(bilto3);
                            }
                        }
                    }
                    if (!(pmvm instanceof ManyToOneMapping) || !(pmvm instanceof NamedManyToOneMapping) || (linkType = relationshipToLinkMapping.get((nmtovm = (NamedManyToOneMapping)pmvm).getType())) == null) continue;
                    JCRNamedReferentPropertyMapper blah = new JCRNamedReferentPropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), nmtovm.getRelatedName(), linkType);
                    propertyMappers.add(blah);
                    relatedProperties.get((Object)nmtovm.getRelatedType()).add(blah);
                    continue;
                }
                if (!(pm.getInfo() instanceof MultiValuedPropertyInfo)) continue;
                pmvm = pm.getValueMapping();
                if (pmvm instanceof RelationshipMapping) {
                    AnyChildMultiValueMapper valueMapper;
                    pmhm = (RelationshipMapping)pmvm;
                    if (!(pmhm instanceof OneToManyMapping)) continue;
                    if (pmhm instanceof NamedOneToManyMapping) {
                        linkType = relationshipToLinkMapping.get(pmhm.getType());
                        if (linkType == null) continue;
                        NamedOneToManyMapping fff = (NamedOneToManyMapping)pmhm;
                        bilto = new JCRReferentCollectionPropertyMapper((CollectionPropertyInfo)pm.getInfo(), fff.getName(), linkType);
                        relatedProperties.get((Object)pmhm.getRelatedType()).add(bilto);
                        propertyMappers.add(bilto);
                        continue;
                    }
                    if (pmhm.getType() != RelationshipType.HIERARCHIC) continue;
                    MultiValuedPropertyInfo mpi = (MultiValuedPropertyInfo)pm.getInfo();
                    if (mpi instanceof MapPropertyInfo) {
                        valueMapper = new AnyChildMultiValueMapper.Map();
                    } else if (mpi instanceof CollectionPropertyInfo) {
                        valueMapper = mpi instanceof ListPropertyInfo ? new AnyChildMultiValueMapper.List() : new AnyChildMultiValueMapper.Collection();
                    } else {
                        throw new IllegalStateException();
                    }
                    bilto = new JCRAnyChildParentPropertyMapper(mpi, valueMapper);
                    relatedProperties.get((Object)pmhm.getRelatedType()).add(bilto);
                    propertyMappers.add(bilto);
                    continue;
                }
                if (pmvm instanceof SimpleMapping) {
                    SimpleMapping sm = (SimpleMapping)pmvm;
                    jcrMember = sm.getJCRMember();
                    if (!(jcrMember instanceof JCRPropertyMapping)) continue;
                    jcrProperty = (JCRPropertyMapping)jcrMember;
                    bilto = new JCRPropertyListPropertyMapper((MultiValuedPropertyInfo)pm.getInfo(), jcrProperty.getName());
                    propertyMappers.add(bilto);
                    continue;
                }
                if (!(pmvm instanceof PropertyMapMapping)) continue;
                JCRPropertyMapPropertyMapper bilto4 = new JCRPropertyMapPropertyMapper((MapPropertyInfo)pm.getInfo());
                propertyMappers.add(bilto4);
            }
            for (MethodMapping methodMapping : typeMapping.getMethodMappings()) {
                if (methodMapping instanceof CreateMapping) {
                    CreateMapping createMapping = (CreateMapping)methodMapping;
                    MethodMapper.Create createMapper = new MethodMapper.Create((Method)createMapping.getMethod().getMethod());
                    methodMappers.add(createMapper);
                    Set alffl = relatedMethods.get((Object)createMapping.getType());
                    alffl.add(createMapper);
                    continue;
                }
                if (methodMapping instanceof DestroyMapping) {
                    MethodMapper.Destroy destroyMapper = new MethodMapper.Destroy((Method)methodMapping.getMethod().getMethod());
                    methodMappers.add(destroyMapper);
                    continue;
                }
                if (methodMapping instanceof FindByIdMapping) {
                    FindByIdMapping findMapping = (FindByIdMapping)methodMapping;
                    MethodMapper.FindById findMapper = new MethodMapper.FindById((Method)findMapping.getMethod().getMethod(), findMapping.getType());
                    methodMappers.add(findMapper);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            HashSet<String> mixinNames = new HashSet<String>();
            for (String mixinName : typeMapping.getMixinNames()) {
                mixinNames.add(mixinName);
            }
            NodeDef nodeDef = new NodeDef(typeMapping.getNodeTypeName(), mixinNames);
            TypeMapper mapper = new TypeMapper((Class)typeMapping.getObjectClass().getType(), propertyMappers, methodMappers, nodeDef, this.instrumentor);
            for (PropertyMapper pm : propertyMappers) {
                pm.mapper = mapper;
            }
            for (MethodMapper methodMapper : methodMappers) {
                methodMapper.mapper = mapper;
            }
            mappers.put(typeMapping.getObjectClass().getName(), mapper);
        }
        for (ClassTypeInfo relatedType : relatedProperties.keySet()) {
            Set properties = relatedProperties.get((Object)relatedType);
            HashSet<TypeMapper> relatedTypes = new HashSet<TypeMapper>();
            for (TypeMapper type : mappers.values()) {
                Class<?> relatedClass = Thread.currentThread().getContextClassLoader().loadClass(relatedType.getName());
                if (!relatedClass.isAssignableFrom(type.getObjectClass())) continue;
                relatedTypes.add(type);
            }
            for (RelatedPropertyMapper propertyMapper : properties) {
                propertyMapper.relatedTypes = relatedTypes;
            }
        }
        for (ClassTypeInfo relatedType : relatedMethods.keySet()) {
            Set methods = relatedMethods.get((Object)relatedType);
            TypeMapper relatedMapper = (TypeMapper)mappers.get(relatedType.getName());
            if (relatedMapper == null) {
                throw new IllegalStateException("Could not find mapper for " + relatedType.getName() + " referenced by " + methods);
            }
            for (MethodMapper.Create createMapper : methods) {
                createMapper.type = relatedMapper;
            }
        }
        return new ArrayList<TypeMapper>(mappers.values());
    }

    static {
        EnumMap<RelationshipType, LinkType> tmp = new EnumMap<RelationshipType, LinkType>(RelationshipType.class);
        tmp.put(RelationshipType.REFERENCE, LinkType.REFERENCE);
        tmp.put(RelationshipType.PATH, LinkType.PATH);
        relationshipToLinkMapping = tmp;
    }
}

