/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.reference;

import org.chromattic.core.ObjectContext;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.JCRNodePropertyMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRNamedReferentPropertyMapper
extends JCRNodePropertyMapper {
    private final String propertyName;
    private final LinkType linkType;

    public JCRNamedReferentPropertyMapper(SingleValuedPropertyInfo<BeanValueInfo> info, String propertyName, LinkType linkType) throws ClassNotFoundException {
        super(info);
        this.propertyName = propertyName;
        this.linkType = linkType;
    }

    @Override
    public Object get(ObjectContext context) throws Throwable {
        Class<?> relatedClass = this.getRelatedClass();
        Object related = context.getReferenced(this.propertyName, this.linkType);
        if (related == null) {
            return null;
        }
        if (relatedClass.isInstance(related)) {
            return related;
        }
        throw new ClassCastException("Related with class " + related.getClass().getName() + " is not of class " + relatedClass);
    }

    @Override
    public void set(ObjectContext ctx, Object value) throws Throwable {
        ctx.setReferenced(this.propertyName, value, this.linkType);
    }
}

