/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.chromattic.core.bean.SimpleType;

public class ValueMapper {
    public static final ValueMapper instance = new ValueMapper();

    private ValueMapper() {
    }

    public final Object get(Value value, SimpleType wantedType) throws RepositoryException {
        int propertyType = value.getType();
        if (wantedType != null) {
            switch (wantedType) {
                case BINARY: {
                    if (propertyType == 2) {
                        return value.getStream();
                    }
                    throw new ClassCastException();
                }
                case STRING: {
                    if (propertyType == 1 || propertyType == 7 || propertyType == 8) {
                        return value.getString();
                    }
                    throw new ClassCastException();
                }
                case PATH: {
                    if (propertyType == 8) {
                        return value.getString();
                    }
                    throw new ClassCastException();
                }
                case INT: {
                    if (propertyType == 3) {
                        return (int)value.getLong();
                    }
                    throw new ClassCastException();
                }
                case LONG: {
                    if (propertyType == 3) {
                        return value.getLong();
                    }
                    throw new ClassCastException();
                }
                case FLOAT: {
                    if (propertyType == 4) {
                        return Float.valueOf((float)value.getDouble());
                    }
                    throw new ClassCastException();
                }
                case DOUBLE: {
                    if (propertyType == 4) {
                        return value.getDouble();
                    }
                    throw new ClassCastException();
                }
                case BOOLEAN: {
                    if (propertyType == 6) {
                        return value.getBoolean();
                    }
                    throw new ClassCastException();
                }
                case DATE: {
                    if (propertyType == 5) {
                        return value.getDate().getTime();
                    }
                    throw new ClassCastException();
                }
            }
            throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
        }
        switch (propertyType) {
            case 6: {
                return value.getBoolean();
            }
            case 3: {
                return (int)value.getLong();
            }
            case 4: {
                return value.getDouble();
            }
            case 1: 
            case 7: 
            case 8: {
                return value.getString();
            }
            case 2: {
                return value.getStream();
            }
            case 5: {
                return value.getDate().getTime();
            }
        }
        throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
    }

    public final Value get(ValueFactory valueFactory, Object o, SimpleType type) throws ValueFormatException {
        if (type == null) {
            if (o instanceof String) {
                type = SimpleType.STRING;
            } else if (o instanceof Integer) {
                type = SimpleType.INT;
            } else if (o instanceof Long) {
                type = SimpleType.LONG;
            } else if (o instanceof Date) {
                type = SimpleType.DATE;
            } else if (o instanceof Double) {
                type = SimpleType.DOUBLE;
            } else if (o instanceof Float) {
                type = SimpleType.FLOAT;
            } else if (o instanceof InputStream) {
                type = SimpleType.BINARY;
            } else if (o instanceof Boolean) {
                type = SimpleType.BOOLEAN;
            } else {
                throw new UnsupportedOperationException("Type " + o.getClass().getName() + " is not accepted");
            }
        }
        switch (type) {
            case STRING: {
                return valueFactory.createValue((String)o);
            }
            case PATH: {
                return valueFactory.createValue((String)o, 8);
            }
            case LONG: {
                return valueFactory.createValue(((Long)o).longValue());
            }
            case INT: {
                return valueFactory.createValue((long)((Integer)o).intValue());
            }
            case DATE: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)o);
                return valueFactory.createValue(calendar);
            }
            case BINARY: {
                return valueFactory.createValue((InputStream)o);
            }
            case DOUBLE: {
                return valueFactory.createValue(((Double)o).doubleValue());
            }
            case FLOAT: {
                return valueFactory.createValue((double)((Float)o).floatValue());
            }
            case BOOLEAN: {
                return valueFactory.createValue(((Boolean)o).booleanValue());
            }
        }
        throw new UnsupportedOperationException("Simple type " + (Object)((Object)type) + " not accepted");
    }
}

